"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbToFargate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-solutions-constructs/core");
class AlbToFargate extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        defaults.CheckAlbProps(props);
        defaults.CheckFargateProps(props);
        // Obtain VPC for construct (existing or created)
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: props.publicApi ? {} : { enableDnsHostnames: true, enableDnsSupport: true }
        });
        // Set up the ALB
        this.loadBalancer = defaults.ObtainAlb(scope, `${id}-lb`, this.vpc, props.publicApi, props.existingLoadBalancerObj, props.loadBalancerProps, props.logAlbAccessLogs, props.albLoggingBucketProps);
        const newListener = this.loadBalancer.listeners.length === 0;
        // If there's no listener, then we add one here
        if (newListener) {
            this.listener = defaults.AddListener(this, id, this.loadBalancer, props.listenerProps);
        }
        else {
            this.listener = core_1.GetActiveListener(this.loadBalancer.listeners);
        }
        if (props.existingFargateServiceObject) {
            this.service = props.existingFargateServiceObject;
            // CheckFargateProps confirms that the container is provided
            this.container = props.existingContainerDefinitionObject;
        }
        else {
            [this.service, this.container] = defaults.CreateFargateService(scope, id, this.vpc, props.clusterProps, props.ecrRepositoryArn, props.ecrImageVersion, props.fargateTaskDefinitionProps, props.containerDefinitionProps, props.fargateServiceProps);
        }
        // Add the Fargate Service to the
        // to the ALB Listener we set up earlier
        const applicationTargetGroupProps = defaults.consolidateProps(defaults.DefaultApplicationTargetGroupProps(this.vpc), props.targetGroupProps);
        const newTargetGroup = defaults.AddFargateTarget(scope, `${id}-target`, this.listener, this.service, props.ruleProps, applicationTargetGroupProps);
        if (newListener && this.listener) {
            const levelOneListener = this.listener.node.defaultChild;
            const cfnTargetGroup = newTargetGroup.node.defaultChild;
            levelOneListener.addDependsOn(cfnTargetGroup);
        }
    }
}
exports.AlbToFargate = AlbToFargate;
_a = JSII_RTTI_SYMBOL_1;
AlbToFargate[_a] = { fqn: "@aws-solutions-constructs/aws-alb-fargate.AlbToFargate", version: "2.1.0" };
//# sourceMappingURL=data:application/json;base64,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