# Acc Lib

Accelerator physics library containing plotting tools and other useful methods to handle data from X-suite tracking and other beam dynamics software, in constant evolution along with my PhD projects.

Installation can be easily done via: 
```pip install acc_lib```

The class `plot_tools` contains several plotting methods to illustrate the turn-by-turn data generated by X-suite trackers, including centroid evolution, phase space distributions, Twiss parameters, simple FFT and tune footprint. 

The class `resonance_lines`, based upon the base class from Foteini Asvesta, contains methods to plot resonance lines of a given order in a given interval for tune plots. In particular, the method `plot_resonance_and_tune_footprint` allows to print the tune footprint from X-suite tracking together with the resonance lines of a given order. 

The class `particles` allows to display particle properties.

The class `madx_tools` contains methods to print errors from a crashed MAD-X process, print the elements neatly, plot the beam envelope, get the realistic apertures for both starting and end points of each element, and to plot the aperture together with the beam envelope.

The class `footprint`, inspired by [this X-suite example](https://github.com/xsuite/xtrack/blob/main/examples/spacecharge/footprint.py), allows for convenient plotting of footprints of coordinates in Cartesian/polar, but also of the tunes. 
