# -*- coding: utf-8 -*-
from __future__ import print_function, absolute_import, division
from builtins import map, range, object, zip, sorted
from past.builtins import basestring

from . import amplpython


class AMPLException(Exception):
    """
    Represent an exception generated by AMPL.
    """
    def __init__(self, _impl):
        self._impl = _impl
        self.what = self._impl.what()
        self.sourceName = _impl.getSourceName()
        self.lineNumber = _impl.getLineNumber()
        self.offset = _impl.getOffset()
        self.message = _impl.getMessage()

    def getSourceName(self):
        """
        Get the name of the file where the error was detected.
        """
        return self.sourceName

    def getLineNumber(self):
        """
        Get the row where the error is located.
        """
        return self.lineNumber

    def getOffset(self):
        """
        Get the offset where the error is located.
        """
        return self.offset

    def getMessage(self):
        """
        Get the error message.
        """
        return self.message

    def __str__(self):
        return self.what.lstrip('file: -').strip('\n')
