"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventsRuleToSqs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
const aws_eventbridge_sqs_1 = require("@aws-solutions-constructs/aws-eventbridge-sqs");
class EventsRuleToSqs extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the EventsRuleToSqs class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {EventsRuleToSqsProps} props - user provided props for the construct
     * @since 1.62.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        const convertedProps = { ...props };
        // W (for 'wrapped') is added to the id so that the id's of the constructs with the old and new names don't collide
        // If this character pushes you beyond the 64 character limit, just import the new named construct and instantiate
        // it in place of the older named version. They are functionally identical, aside from the types no other changes
        // will be required.  (eg - new EventbridgeToSqs instead of EventsRuleToSqs)
        const wrappedConstruct = new aws_eventbridge_sqs_1.EventbridgeToSqs(this, `${id}W`, convertedProps);
        this.sqsQueue = wrappedConstruct.sqsQueue;
        this.deadLetterQueue = wrappedConstruct.deadLetterQueue;
        this.eventsRule = wrappedConstruct.eventsRule;
        this.encryptionKey = wrappedConstruct.encryptionKey;
        this.eventBus = wrappedConstruct.eventBus;
    }
}
exports.EventsRuleToSqs = EventsRuleToSqs;
_a = JSII_RTTI_SYMBOL_1;
EventsRuleToSqs[_a] = { fqn: "@aws-solutions-constructs/aws-events-rule-sqs.EventsRuleToSqs", version: "1.141.0" };
//# sourceMappingURL=data:application/json;base64,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