attribution
===========

[![Generated by attribution][attribution-badge]][attribution-url]


v1.6.2
------

Bugfix release

- New: `log` command now accepts a version argument
- Fix: experimental `ignored_authors` now uses `--perl-regexp`
- Docs: clarified `USE_LIBPCRE` support for ignored authors

```text
$ git shortlog -s v1.6.1...v1.6.2
     3	Amethyst Reese
```


v1.6.1
------

Bugfix release

- Fix: don't pass `--invert-grep` if no ignored authors
- New: load tags for `debug` command
- Docs: mark `ignored_authors` as experimental

```text
$ git shortlog -s v1.6.0...v1.6.1
     6	Amethyst Reese
```


v1.6.0
------

Feature release

- Mark generated shortlogs as plaintext to reduce warnings (#107)
- Add "generated by attribution" badge to generated changelogs (#109)
- Add "generated by attribution" docstring to generated version files (#109)
- New `ignored_authors` configuration option (#117)
- New `log` command to list revisions since last tag (#118)
- New `debug` command to dump project configuration (#117)
- Documented all supported commands (#122)
- Dropped support for Python 3.6; added support for Python 3.10

```text
$ git shortlog -s v1.5.2...v1.6.0
    28	Amethyst Reese
     6	John Reese
     5	Samuel Giffard
    48	dependabot[bot]
     4	pyup.io bot
```


v1.5.2
------

Bugfix release:

* Fix shortlog for first tag in repo (#30)

```text
$ git shortlog -s v1.5.1...v1.5.2
     3	John Reese
     2	pyup.io bot
```


v1.5.1
------

Bugfix release

* Fix `attribution init` for projects with no version tags (#26)
* Better namespace guessing for projects with dashes in their names
* Improved pyproject.toml format from `attribution init`

```text
$ git shortlog -s v1.5.0...v1.5.1
     5	John Reese
     2	pyup.io bot
```


v1.5.0
------

Feature release

- New option "signed_tags" to choose between signed and annotated tags (#1)
- `tag` command will abort early if the requested tag already exists
- Improved config documentation

```text
$ git shortlog -s v1.4.0...v1.5.0
     4	John Reese
     1	pyup.io bot
```


v1.4.0
------

Feature release:

* New "init" command to setup pyproject.toml and create __version__.py
* Switches from toml to tomlkit

```text
$ git shortlog -s v1.3.1...v1.4.0
     6	John Reese
     1	pyup.io bot
```


v1.3.1
------

Bugfix release

* Fix writing __version__.py file when no [tool.attribution] table found (#16)
* More debug logging, send debug output to stderr

```text
$ git shortlog -s v1.3.0...v1.3.1
     5	John Reese
```


v1.3.0
------

Feature release

* Added `version_file` option in pyproject.toml to disable writing version.py (#12)
* Added sphinx documentation for the package
* Tested on Python 3.9a (#15)

```text
$ git shortlog -s v1.2.0...v1.3.0
    14	John Reese
     6	Mark Rofail
     5	pyup.io bot
```


v1.2.0
------

Feature release:

- Move to subcommands for CLI actions
- `attribution generate` will now generate the CHANGELOG content
- Can pull project name from pyproject.toml (`tool.attribution.name`)
- Added `tag` command to bump `__version__`, generate commit, changelog, and tag

```text
$ git shortlog -s v1.1...v1.2.0
    13	John Reese
```


v1.1
----

Bugfix release

- Fix install_requires to correctly list attrs and jinja2

```text
$ git shortlog -s v1.0...v1.1
     5	John Reese
```


v1.0
----

Initial release

- Generates changelog from git tags with hardcoded template and format

```text
$ git shortlog -s v0.0...v1.0
     1	John Reese
```


v0.0
----

Placeholder release

- Name claimed on Github!

```text
$ git shortlog -s v0.0
     5	John Reese
```

[attribution-badge]:
    https://img.shields.io/badge/generated%20by-attribution-informational
[attribution-url]: https://attribution.omnilib.dev
