# coding: utf-8

"""
    Ascend API

    Welcome to Ascend's API documentation!  # noqa: E501

    The version of the OpenAPI document: 2.0
    Contact: support@ascend.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AscendApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_component_group(self, data_service_id, dataflow_id, body, **kwargs):  # noqa: E501
        """create component group in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_component_group(data_service_id, dataflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param ApiComponentGroup body: Component group details. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentGroupResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_component_group_with_http_info(data_service_id, dataflow_id, body, **kwargs)  # noqa: E501

    def create_component_group_with_http_info(self, data_service_id, dataflow_id, body, **kwargs):  # noqa: E501
        """create component group in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_component_group_with_http_info(data_service_id, dataflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param ApiComponentGroup body: Component group details. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentGroupResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_component_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `create_component_group`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `create_component_group`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `create_component_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/groups', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentGroupResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_connection(self, data_service_id, body, **kwargs):  # noqa: E501
        """create connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_connection(data_service_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: (required)
        :param IoConnection body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiCreateConnectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_connection_with_http_info(data_service_id, body, **kwargs)  # noqa: E501

    def create_connection_with_http_info(self, data_service_id, body, **kwargs):  # noqa: E501
        """create connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_connection_with_http_info(data_service_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: (required)
        :param IoConnection body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiCreateConnectionResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_connection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `create_connection`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `create_connection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/connections', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiCreateConnectionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_data_feed(self, data_service_id, dataflow_id, body, **kwargs):  # noqa: E501
        """create data feed in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_data_feed(data_service_id, dataflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param ApiDataFeed body: Data feed details. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataFeedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_data_feed_with_http_info(data_service_id, dataflow_id, body, **kwargs)  # noqa: E501

    def create_data_feed_with_http_info(self, data_service_id, dataflow_id, body, **kwargs):  # noqa: E501
        """create data feed in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_data_feed_with_http_info(data_service_id, dataflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param ApiDataFeed body: Data feed details. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataFeedResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_data_feed" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `create_data_feed`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `create_data_feed`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `create_data_feed`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/pubs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataFeedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_data_feed_connector(self, data_service_id, dataflow_id, body, **kwargs):  # noqa: E501
        """create a data feed connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_data_feed_connector(data_service_id, dataflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param ApiDataFeedConnector body: Data feed connector details. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataFeedConnectorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_data_feed_connector_with_http_info(data_service_id, dataflow_id, body, **kwargs)  # noqa: E501

    def create_data_feed_connector_with_http_info(self, data_service_id, dataflow_id, body, **kwargs):  # noqa: E501
        """create a data feed connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_data_feed_connector_with_http_info(data_service_id, dataflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param ApiDataFeedConnector body: Data feed connector details. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataFeedConnectorResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_data_feed_connector" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `create_data_feed_connector`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `create_data_feed_connector`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `create_data_feed_connector`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/subs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataFeedConnectorResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_data_service(self, body, **kwargs):  # noqa: E501
        """create data service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_data_service(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ApiDataService body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataServiceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_data_service_with_http_info(body, **kwargs)  # noqa: E501

    def create_data_service_with_http_info(self, body, **kwargs):  # noqa: E501
        """create data service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_data_service_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ApiDataService body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataServiceResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_data_service" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `create_data_service`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataServiceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_data_service_credentials(self, data_service_id, body, **kwargs):  # noqa: E501
        """create data service credentials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_data_service_credentials(data_service_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param ApiCredentials body: Component credentials. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiCredentialsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_data_service_credentials_with_http_info(data_service_id, body, **kwargs)  # noqa: E501

    def create_data_service_credentials_with_http_info(self, data_service_id, body, **kwargs):  # noqa: E501
        """create data service credentials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_data_service_credentials_with_http_info(data_service_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param ApiCredentials body: Component credentials. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiCredentialsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_data_service_credentials" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `create_data_service_credentials`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `create_data_service_credentials`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/vault', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiCredentialsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_dataflow(self, data_service_id, body, **kwargs):  # noqa: E501
        """create dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_dataflow(data_service_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param ApiDataflow body: Dataflow details. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataflowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_dataflow_with_http_info(data_service_id, body, **kwargs)  # noqa: E501

    def create_dataflow_with_http_info(self, data_service_id, body, **kwargs):  # noqa: E501
        """create dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_dataflow_with_http_info(data_service_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param ApiDataflow body: Dataflow details. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataflowResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_dataflow" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `create_dataflow`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `create_dataflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataflowResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_read_connector(self, data_service_id, dataflow_id, body, **kwargs):  # noqa: E501
        """create read connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_read_connector(data_service_id, dataflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param ApiReadConnector body: Read connector to be created/updated. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiReadConnectorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_read_connector_with_http_info(data_service_id, dataflow_id, body, **kwargs)  # noqa: E501

    def create_read_connector_with_http_info(self, data_service_id, dataflow_id, body, **kwargs):  # noqa: E501
        """create read connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_read_connector_with_http_info(data_service_id, dataflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param ApiReadConnector body: Read connector to be created/updated. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiReadConnectorResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_read_connector" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `create_read_connector`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `create_read_connector`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `create_read_connector`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sources', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiReadConnectorResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_transform(self, data_service_id, dataflow_id, body, **kwargs):  # noqa: E501
        """create transform in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_transform(data_service_id, dataflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param ApiTransform body: Transform details. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiTransformResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_transform_with_http_info(data_service_id, dataflow_id, body, **kwargs)  # noqa: E501

    def create_transform_with_http_info(self, data_service_id, dataflow_id, body, **kwargs):  # noqa: E501
        """create transform in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_transform_with_http_info(data_service_id, dataflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param ApiTransform body: Transform details. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiTransformResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_transform" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `create_transform`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `create_transform`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `create_transform`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/views', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiTransformResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_write_connector(self, data_service_id, dataflow_id, body, **kwargs):  # noqa: E501
        """create write connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_write_connector(data_service_id, dataflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param ApiWriteConnector body: Write connector details. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiWriteConnectorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_write_connector_with_http_info(data_service_id, dataflow_id, body, **kwargs)  # noqa: E501

    def create_write_connector_with_http_info(self, data_service_id, dataflow_id, body, **kwargs):  # noqa: E501
        """create write connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_write_connector_with_http_info(data_service_id, dataflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param ApiWriteConnector body: Write connector details. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiWriteConnectorResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_write_connector" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `create_write_connector`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `create_write_connector`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `create_write_connector`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sinks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiWriteConnectorResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_component_group(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """delete component group in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_component_group(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_component_group_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def delete_component_group_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """delete component group in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_component_group_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDeleteResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_component_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `delete_component_group`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `delete_component_group`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_component_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/groups/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDeleteResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_connection(self, data_service_id, connection_id, **kwargs):  # noqa: E501
        """delete connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_connection(data_service_id, connection_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: (required)
        :param str connection_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_connection_with_http_info(data_service_id, connection_id, **kwargs)  # noqa: E501

    def delete_connection_with_http_info(self, data_service_id, connection_id, **kwargs):  # noqa: E501
        """delete connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_connection_with_http_info(data_service_id, connection_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: (required)
        :param str connection_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDeleteResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'connection_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_connection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `delete_connection`")  # noqa: E501
        # verify the required parameter 'connection_id' is set
        if self.api_client.client_side_validation and ('connection_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['connection_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `connection_id` when calling `delete_connection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'connection_id' in local_var_params:
            path_params['connection_id'] = local_var_params['connection_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/connections/{connection_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDeleteResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_data_feed(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """delete data feed in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_data_feed(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_data_feed_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def delete_data_feed_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """delete data feed in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_data_feed_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDeleteResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_data_feed" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `delete_data_feed`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `delete_data_feed`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_data_feed`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/pubs/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDeleteResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_data_feed_connector(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """delete data feed connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_data_feed_connector(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_data_feed_connector_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def delete_data_feed_connector_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """delete data feed connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_data_feed_connector_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDeleteResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_data_feed_connector" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `delete_data_feed_connector`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `delete_data_feed_connector`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_data_feed_connector`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/subs/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDeleteResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_data_service(self, data_service_id, **kwargs):  # noqa: E501
        """delete data service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_data_service(data_service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_data_service_with_http_info(data_service_id, **kwargs)  # noqa: E501

    def delete_data_service_with_http_info(self, data_service_id, **kwargs):  # noqa: E501
        """delete data service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_data_service_with_http_info(data_service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDeleteResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_data_service" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `delete_data_service`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDeleteResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_data_service_credentials(self, data_service_id, credential_id, **kwargs):  # noqa: E501
        """delete credentials by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_data_service_credentials(data_service_id, credential_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str credential_id: Credential id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDeleteCredentialsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_data_service_credentials_with_http_info(data_service_id, credential_id, **kwargs)  # noqa: E501

    def delete_data_service_credentials_with_http_info(self, data_service_id, credential_id, **kwargs):  # noqa: E501
        """delete credentials by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_data_service_credentials_with_http_info(data_service_id, credential_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str credential_id: Credential id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDeleteCredentialsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'credential_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_data_service_credentials" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `delete_data_service_credentials`")  # noqa: E501
        # verify the required parameter 'credential_id' is set
        if self.api_client.client_side_validation and ('credential_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['credential_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `credential_id` when calling `delete_data_service_credentials`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'credential_id' in local_var_params:
            path_params['credential_id'] = local_var_params['credential_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/vault/{credential_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDeleteCredentialsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_dataflow(self, data_service_id, dataflow_id, **kwargs):  # noqa: E501
        """delete dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dataflow(data_service_id, dataflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_dataflow_with_http_info(data_service_id, dataflow_id, **kwargs)  # noqa: E501

    def delete_dataflow_with_http_info(self, data_service_id, dataflow_id, **kwargs):  # noqa: E501
        """delete dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dataflow_with_http_info(data_service_id, dataflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDeleteResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dataflow" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `delete_dataflow`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `delete_dataflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDeleteResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_read_connector(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """delete read connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_read_connector(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_read_connector_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def delete_read_connector_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """delete read connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_read_connector_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDeleteResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_read_connector" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `delete_read_connector`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `delete_read_connector`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_read_connector`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sources/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDeleteResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_transform(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """delete transform in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_transform(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_transform_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def delete_transform_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """delete transform in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_transform_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDeleteResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_transform" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `delete_transform`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `delete_transform`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_transform`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/views/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDeleteResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_write_connector(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """delete write connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_write_connector(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_write_connector_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def delete_write_connector_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """delete write connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_write_connector_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDeleteResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_write_connector" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `delete_write_connector`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `delete_write_connector`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_write_connector`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sinks/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDeleteResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_logs(self, **kwargs):  # noqa: E501
        """download log archive for component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_logs(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str range_start: start time in nanoseconds.
        :param str range_end: end time in nanoseconds.
        :param str label: log label.
        :param bool backward: log search direction, set to true to get most recent logs first.
        :param str jwt: jwt for validation.
        :param int limit: max number of lines in result.
        :param str next_page_cursor: cursor to get next page.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StreamResultOfGoogleApiHttpBody
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.download_logs_with_http_info(**kwargs)  # noqa: E501

    def download_logs_with_http_info(self, **kwargs):  # noqa: E501
        """download log archive for component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_logs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str range_start: start time in nanoseconds.
        :param str range_end: end time in nanoseconds.
        :param str label: log label.
        :param bool backward: log search direction, set to true to get most recent logs first.
        :param str jwt: jwt for validation.
        :param int limit: max number of lines in result.
        :param str next_page_cursor: cursor to get next page.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StreamResultOfGoogleApiHttpBody, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'range_start',
            'range_end',
            'label',
            'backward',
            'jwt',
            'limit',
            'next_page_cursor'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_logs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'range_start' in local_var_params and local_var_params['range_start'] is not None:  # noqa: E501
            query_params.append(('range_start', local_var_params['range_start']))  # noqa: E501
        if 'range_end' in local_var_params and local_var_params['range_end'] is not None:  # noqa: E501
            query_params.append(('range_end', local_var_params['range_end']))  # noqa: E501
        if 'label' in local_var_params and local_var_params['label'] is not None:  # noqa: E501
            query_params.append(('label', local_var_params['label']))  # noqa: E501
        if 'backward' in local_var_params and local_var_params['backward'] is not None:  # noqa: E501
            query_params.append(('backward', local_var_params['backward']))  # noqa: E501
        if 'jwt' in local_var_params and local_var_params['jwt'] is not None:  # noqa: E501
            query_params.append(('jwt', local_var_params['jwt']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'next_page_cursor' in local_var_params and local_var_params['next_page_cursor'] is not None:  # noqa: E501
            query_params.append(('next_page_cursor', local_var_params['next_page_cursor']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/logs/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StreamResultOfGoogleApiHttpBody',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_component_group(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get component group in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_component_group(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentGroupResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_component_group_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_component_group_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get component group in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_component_group_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentGroupResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_component_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_component_group`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_component_group`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_component_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/groups/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentGroupResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_connection(self, data_service_id, connection_id, **kwargs):  # noqa: E501
        """get connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_connection(data_service_id, connection_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: (required)
        :param str connection_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiConnectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_connection_with_http_info(data_service_id, connection_id, **kwargs)  # noqa: E501

    def get_connection_with_http_info(self, data_service_id, connection_id, **kwargs):  # noqa: E501
        """get connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_connection_with_http_info(data_service_id, connection_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: (required)
        :param str connection_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiConnectionResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'connection_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_connection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_connection`")  # noqa: E501
        # verify the required parameter 'connection_id' is set
        if self.api_client.client_side_validation and ('connection_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['connection_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `connection_id` when calling `get_connection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'connection_id' in local_var_params:
            path_params['connection_id'] = local_var_params['connection_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/connections/{connection_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiConnectionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_connection_type(self, data_service_id, connection_type_id, **kwargs):  # noqa: E501
        """get connection type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_connection_type(data_service_id, connection_type_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: (required)
        :param str connection_type_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiConnectionTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_connection_type_with_http_info(data_service_id, connection_type_id, **kwargs)  # noqa: E501

    def get_connection_type_with_http_info(self, data_service_id, connection_type_id, **kwargs):  # noqa: E501
        """get connection type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_connection_type_with_http_info(data_service_id, connection_type_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: (required)
        :param str connection_type_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiConnectionTypeResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'connection_type_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_connection_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_connection_type`")  # noqa: E501
        # verify the required parameter 'connection_type_id' is set
        if self.api_client.client_side_validation and ('connection_type_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['connection_type_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `connection_type_id` when calling `get_connection_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'connection_type_id' in local_var_params:
            path_params['connection_type_id'] = local_var_params['connection_type_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/connection_types/{connection_type_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiConnectionTypeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_feed(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataFeedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_data_feed_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_data_feed_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataFeedResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_feed" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_data_feed`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_data_feed`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_data_feed`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/pubs/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataFeedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_feed_connector(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_connector(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataFeedConnectorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_data_feed_connector_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_data_feed_connector_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_connector_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataFeedConnectorResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_feed_connector" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_data_feed_connector`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_data_feed_connector`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_data_feed_connector`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/subs/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataFeedConnectorResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_feed_connector_partitions(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed connector partitions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_connector_partitions(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param int offset: Offset in partition metadata list.
        :param int limit: Upper limit of partition metadata results returned.
        :param str start_ts:
        :param str end_ts:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentPartitionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_data_feed_connector_partitions_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_data_feed_connector_partitions_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed connector partitions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_connector_partitions_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param int offset: Offset in partition metadata list.
        :param int limit: Upper limit of partition metadata results returned.
        :param str start_ts:
        :param str end_ts:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentPartitionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'stage',
            'stage_index',
            'offset',
            'limit',
            'start_ts',
            'end_ts'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_feed_connector_partitions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_data_feed_connector_partitions`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_data_feed_connector_partitions`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_data_feed_connector_partitions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'stage' in local_var_params and local_var_params['stage'] is not None:  # noqa: E501
            query_params.append(('stage', local_var_params['stage']))  # noqa: E501
        if 'stage_index' in local_var_params and local_var_params['stage_index'] is not None:  # noqa: E501
            query_params.append(('stage_index', local_var_params['stage_index']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'start_ts' in local_var_params and local_var_params['start_ts'] is not None:  # noqa: E501
            query_params.append(('start_ts', local_var_params['start_ts']))  # noqa: E501
        if 'end_ts' in local_var_params and local_var_params['end_ts'] is not None:  # noqa: E501
            query_params.append(('end_ts', local_var_params['end_ts']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/subs/{id}/partitions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentPartitionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_feed_connector_records(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed connector records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_connector_records(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param str offset: Record offset.
        :param str limit: Upper limit of number of records to be returned.
        :param str token:
        :param str format:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentRecordsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_data_feed_connector_records_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_data_feed_connector_records_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed connector records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_connector_records_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param str offset: Record offset.
        :param str limit: Upper limit of number of records to be returned.
        :param str token:
        :param str format:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentRecordsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'stage',
            'stage_index',
            'offset',
            'limit',
            'token',
            'format'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_feed_connector_records" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_data_feed_connector_records`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_data_feed_connector_records`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_data_feed_connector_records`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'stage' in local_var_params and local_var_params['stage'] is not None:  # noqa: E501
            query_params.append(('stage', local_var_params['stage']))  # noqa: E501
        if 'stage_index' in local_var_params and local_var_params['stage_index'] is not None:  # noqa: E501
            query_params.append(('stage_index', local_var_params['stage_index']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'token' in local_var_params and local_var_params['token'] is not None:  # noqa: E501
            query_params.append(('token', local_var_params['token']))  # noqa: E501
        if 'format' in local_var_params and local_var_params['format'] is not None:  # noqa: E501
            query_params.append(('format', local_var_params['format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/subs/{id}/records', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentRecordsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_feed_connector_schema(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed connector schema  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_connector_schema(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentSchemaResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_data_feed_connector_schema_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_data_feed_connector_schema_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed connector schema  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_connector_schema_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentSchemaResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_feed_connector_schema" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_data_feed_connector_schema`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_data_feed_connector_schema`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_data_feed_connector_schema`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/subs/{id}/schema', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentSchemaResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_feed_connector_state(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed connector state  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_connector_state(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentStateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_data_feed_connector_state_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_data_feed_connector_state_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed connector state  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_connector_state_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentStateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_feed_connector_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_data_feed_connector_state`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_data_feed_connector_state`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_data_feed_connector_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/subs/{id}/state', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentStateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_feed_connector_statistics(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed connector statistics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_connector_statistics(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentStatisticsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_data_feed_connector_statistics_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_data_feed_connector_statistics_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed connector statistics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_connector_statistics_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentStatisticsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'stage',
            'stage_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_feed_connector_statistics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_data_feed_connector_statistics`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_data_feed_connector_statistics`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_data_feed_connector_statistics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'stage' in local_var_params and local_var_params['stage'] is not None:  # noqa: E501
            query_params.append(('stage', local_var_params['stage']))  # noqa: E501
        if 'stage_index' in local_var_params and local_var_params['stage_index'] is not None:  # noqa: E501
            query_params.append(('stage_index', local_var_params['stage_index']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/subs/{id}/statistics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentStatisticsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_feed_for_data_feed_connector(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get input data feed for a data feed connector  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_for_data_feed_connector(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataFeedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_data_feed_for_data_feed_connector_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_data_feed_for_data_feed_connector_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get input data feed for a data feed connector  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_for_data_feed_connector_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataFeedResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_feed_for_data_feed_connector" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_data_feed_for_data_feed_connector`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_data_feed_for_data_feed_connector`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_data_feed_for_data_feed_connector`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/subs/{id}/pub', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataFeedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_feed_partitions(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed partitions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_partitions(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param int offset: Offset in partition metadata list.
        :param int limit: Upper limit of partition metadata results returned.
        :param str start_ts:
        :param str end_ts:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentPartitionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_data_feed_partitions_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_data_feed_partitions_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed partitions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_partitions_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param int offset: Offset in partition metadata list.
        :param int limit: Upper limit of partition metadata results returned.
        :param str start_ts:
        :param str end_ts:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentPartitionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'stage',
            'stage_index',
            'offset',
            'limit',
            'start_ts',
            'end_ts'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_feed_partitions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_data_feed_partitions`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_data_feed_partitions`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_data_feed_partitions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'stage' in local_var_params and local_var_params['stage'] is not None:  # noqa: E501
            query_params.append(('stage', local_var_params['stage']))  # noqa: E501
        if 'stage_index' in local_var_params and local_var_params['stage_index'] is not None:  # noqa: E501
            query_params.append(('stage_index', local_var_params['stage_index']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'start_ts' in local_var_params and local_var_params['start_ts'] is not None:  # noqa: E501
            query_params.append(('start_ts', local_var_params['start_ts']))  # noqa: E501
        if 'end_ts' in local_var_params and local_var_params['end_ts'] is not None:  # noqa: E501
            query_params.append(('end_ts', local_var_params['end_ts']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/pubs/{id}/partitions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentPartitionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_feed_records(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_records(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param str offset: Record offset.
        :param str limit: Upper limit of number of records to be returned.
        :param str token:
        :param str format:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentRecordsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_data_feed_records_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_data_feed_records_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_records_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param str offset: Record offset.
        :param str limit: Upper limit of number of records to be returned.
        :param str token:
        :param str format:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentRecordsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'stage',
            'stage_index',
            'offset',
            'limit',
            'token',
            'format'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_feed_records" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_data_feed_records`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_data_feed_records`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_data_feed_records`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'stage' in local_var_params and local_var_params['stage'] is not None:  # noqa: E501
            query_params.append(('stage', local_var_params['stage']))  # noqa: E501
        if 'stage_index' in local_var_params and local_var_params['stage_index'] is not None:  # noqa: E501
            query_params.append(('stage_index', local_var_params['stage_index']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'token' in local_var_params and local_var_params['token'] is not None:  # noqa: E501
            query_params.append(('token', local_var_params['token']))  # noqa: E501
        if 'format' in local_var_params and local_var_params['format'] is not None:  # noqa: E501
            query_params.append(('format', local_var_params['format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/pubs/{id}/records', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentRecordsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_feed_schema(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed schema  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_schema(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentSchemaResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_data_feed_schema_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_data_feed_schema_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed schema  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_schema_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentSchemaResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_feed_schema" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_data_feed_schema`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_data_feed_schema`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_data_feed_schema`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/pubs/{id}/schema', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentSchemaResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_feed_state(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed state  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_state(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentStateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_data_feed_state_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_data_feed_state_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed state  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_state_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentStateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_feed_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_data_feed_state`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_data_feed_state`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_data_feed_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/pubs/{id}/state', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentStateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_feed_statistics(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed statistics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_statistics(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentStatisticsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_data_feed_statistics_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_data_feed_statistics_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get data feed statistics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_feed_statistics_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentStatisticsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'stage',
            'stage_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_feed_statistics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_data_feed_statistics`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_data_feed_statistics`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_data_feed_statistics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'stage' in local_var_params and local_var_params['stage'] is not None:  # noqa: E501
            query_params.append(('stage', local_var_params['stage']))  # noqa: E501
        if 'stage_index' in local_var_params and local_var_params['stage_index'] is not None:  # noqa: E501
            query_params.append(('stage_index', local_var_params['stage_index']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/pubs/{id}/statistics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentStatisticsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_service(self, data_service_id, **kwargs):  # noqa: E501
        """get data service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_service(data_service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataServiceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_data_service_with_http_info(data_service_id, **kwargs)  # noqa: E501

    def get_data_service_with_http_info(self, data_service_id, **kwargs):  # noqa: E501
        """get data service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_service_with_http_info(data_service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataServiceResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_service" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_data_service`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataServiceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dataflow(self, data_service_id, dataflow_id, **kwargs):  # noqa: E501
        """get dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataflow(data_service_id, dataflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataflowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_dataflow_with_http_info(data_service_id, dataflow_id, **kwargs)  # noqa: E501

    def get_dataflow_with_http_info(self, data_service_id, dataflow_id, **kwargs):  # noqa: E501
        """get dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataflow_with_http_info(data_service_id, dataflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataflowResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dataflow" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_dataflow`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_dataflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataflowResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_logs(self, **kwargs):  # noqa: E501
        """get logs for component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_logs(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str range_start: start time in nanoseconds.
        :param str range_end: end time in nanoseconds.
        :param str label: log label.
        :param bool backward: log search direction, set to true to get most recent logs first.
        :param str jwt: jwt for validation.
        :param int limit: max number of lines in result.
        :param str next_page_cursor: cursor to get next page.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentLogsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_logs_with_http_info(**kwargs)  # noqa: E501

    def get_logs_with_http_info(self, **kwargs):  # noqa: E501
        """get logs for component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_logs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str range_start: start time in nanoseconds.
        :param str range_end: end time in nanoseconds.
        :param str label: log label.
        :param bool backward: log search direction, set to true to get most recent logs first.
        :param str jwt: jwt for validation.
        :param int limit: max number of lines in result.
        :param str next_page_cursor: cursor to get next page.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentLogsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'range_start',
            'range_end',
            'label',
            'backward',
            'jwt',
            'limit',
            'next_page_cursor'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_logs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'range_start' in local_var_params and local_var_params['range_start'] is not None:  # noqa: E501
            query_params.append(('range_start', local_var_params['range_start']))  # noqa: E501
        if 'range_end' in local_var_params and local_var_params['range_end'] is not None:  # noqa: E501
            query_params.append(('range_end', local_var_params['range_end']))  # noqa: E501
        if 'label' in local_var_params and local_var_params['label'] is not None:  # noqa: E501
            query_params.append(('label', local_var_params['label']))  # noqa: E501
        if 'backward' in local_var_params and local_var_params['backward'] is not None:  # noqa: E501
            query_params.append(('backward', local_var_params['backward']))  # noqa: E501
        if 'jwt' in local_var_params and local_var_params['jwt'] is not None:  # noqa: E501
            query_params.append(('jwt', local_var_params['jwt']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'next_page_cursor' in local_var_params and local_var_params['next_page_cursor'] is not None:  # noqa: E501
            query_params.append(('next_page_cursor', local_var_params['next_page_cursor']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentLogsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_read_connector(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get read connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_read_connector(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiReadConnectorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_read_connector_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_read_connector_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get read connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_read_connector_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiReadConnectorResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_read_connector" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_read_connector`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_read_connector`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_read_connector`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sources/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiReadConnectorResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_read_connector_errors(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get read connector errors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_read_connector_errors(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str offset: Offset in errors list.
        :param str limit: Upper limit of the number of errors returned.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentErrorsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_read_connector_errors_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_read_connector_errors_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get read connector errors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_read_connector_errors_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str offset: Offset in errors list.
        :param str limit: Upper limit of the number of errors returned.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentErrorsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'offset',
            'limit'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_read_connector_errors" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_read_connector_errors`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_read_connector_errors`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_read_connector_errors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sources/{id}/errors', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentErrorsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_read_connector_lineage(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get read connector lineage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_read_connector_lineage(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentLineageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_read_connector_lineage_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_read_connector_lineage_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get read connector lineage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_read_connector_lineage_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentLineageResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_read_connector_lineage" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_read_connector_lineage`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_read_connector_lineage`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_read_connector_lineage`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sources/{id}/lineage', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentLineageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_read_connector_partitions(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get read connector partitions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_read_connector_partitions(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param int offset: Offset in partition metadata list.
        :param int limit: Upper limit of partition metadata results returned.
        :param str start_ts:
        :param str end_ts:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentPartitionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_read_connector_partitions_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_read_connector_partitions_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get read connector partitions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_read_connector_partitions_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param int offset: Offset in partition metadata list.
        :param int limit: Upper limit of partition metadata results returned.
        :param str start_ts:
        :param str end_ts:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentPartitionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'stage',
            'stage_index',
            'offset',
            'limit',
            'start_ts',
            'end_ts'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_read_connector_partitions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_read_connector_partitions`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_read_connector_partitions`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_read_connector_partitions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'stage' in local_var_params and local_var_params['stage'] is not None:  # noqa: E501
            query_params.append(('stage', local_var_params['stage']))  # noqa: E501
        if 'stage_index' in local_var_params and local_var_params['stage_index'] is not None:  # noqa: E501
            query_params.append(('stage_index', local_var_params['stage_index']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'start_ts' in local_var_params and local_var_params['start_ts'] is not None:  # noqa: E501
            query_params.append(('start_ts', local_var_params['start_ts']))  # noqa: E501
        if 'end_ts' in local_var_params and local_var_params['end_ts'] is not None:  # noqa: E501
            query_params.append(('end_ts', local_var_params['end_ts']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sources/{id}/partitions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentPartitionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_read_connector_records(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get read connector records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_read_connector_records(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param str offset: Record offset.
        :param str limit: Upper limit of number of records to be returned.
        :param str token:
        :param str format:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentRecordsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_read_connector_records_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_read_connector_records_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get read connector records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_read_connector_records_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param str offset: Record offset.
        :param str limit: Upper limit of number of records to be returned.
        :param str token:
        :param str format:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentRecordsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'stage',
            'stage_index',
            'offset',
            'limit',
            'token',
            'format'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_read_connector_records" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_read_connector_records`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_read_connector_records`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_read_connector_records`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'stage' in local_var_params and local_var_params['stage'] is not None:  # noqa: E501
            query_params.append(('stage', local_var_params['stage']))  # noqa: E501
        if 'stage_index' in local_var_params and local_var_params['stage_index'] is not None:  # noqa: E501
            query_params.append(('stage_index', local_var_params['stage_index']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'token' in local_var_params and local_var_params['token'] is not None:  # noqa: E501
            query_params.append(('token', local_var_params['token']))  # noqa: E501
        if 'format' in local_var_params and local_var_params['format'] is not None:  # noqa: E501
            query_params.append(('format', local_var_params['format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sources/{id}/records', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentRecordsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_read_connector_schema(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get read connector schema  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_read_connector_schema(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentSchemaResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_read_connector_schema_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_read_connector_schema_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get read connector schema  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_read_connector_schema_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentSchemaResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_read_connector_schema" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_read_connector_schema`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_read_connector_schema`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_read_connector_schema`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sources/{id}/schema', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentSchemaResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_read_connector_state(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get read connector state  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_read_connector_state(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentStateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_read_connector_state_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_read_connector_state_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get read connector state  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_read_connector_state_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentStateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_read_connector_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_read_connector_state`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_read_connector_state`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_read_connector_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sources/{id}/state', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentStateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_read_connector_statistics(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get read connector statistics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_read_connector_statistics(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentStatisticsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_read_connector_statistics_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_read_connector_statistics_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get read connector statistics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_read_connector_statistics_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentStatisticsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'stage',
            'stage_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_read_connector_statistics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_read_connector_statistics`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_read_connector_statistics`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_read_connector_statistics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'stage' in local_var_params and local_var_params['stage'] is not None:  # noqa: E501
            query_params.append(('stage', local_var_params['stage']))  # noqa: E501
        if 'stage_index' in local_var_params and local_var_params['stage_index'] is not None:  # noqa: E501
            query_params.append(('stage_index', local_var_params['stage_index']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sources/{id}/statistics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentStatisticsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_read_connector_warnings(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get read connector warnings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_read_connector_warnings(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str offset: Offset in errors list.
        :param str limit: Upper limit of the number of errors returned.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentWarningsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_read_connector_warnings_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_read_connector_warnings_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get read connector warnings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_read_connector_warnings_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str offset: Offset in errors list.
        :param str limit: Upper limit of the number of errors returned.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentWarningsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'offset',
            'limit'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_read_connector_warnings" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_read_connector_warnings`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_read_connector_warnings`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_read_connector_warnings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sources/{id}/warnings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentWarningsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transform(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get transform in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transform(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiTransformResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_transform_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_transform_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get transform in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transform_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiTransformResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transform" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_transform`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_transform`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_transform`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/views/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiTransformResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transform_errors(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get transform errors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transform_errors(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str offset: Offset in errors list.
        :param str limit: Upper limit of the number of errors returned.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentErrorsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_transform_errors_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_transform_errors_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get transform errors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transform_errors_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str offset: Offset in errors list.
        :param str limit: Upper limit of the number of errors returned.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentErrorsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'offset',
            'limit'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transform_errors" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_transform_errors`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_transform_errors`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_transform_errors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/views/{id}/errors', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentErrorsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transform_lineage(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get transform lineage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transform_lineage(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentLineageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_transform_lineage_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_transform_lineage_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get transform lineage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transform_lineage_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentLineageResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transform_lineage" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_transform_lineage`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_transform_lineage`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_transform_lineage`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/views/{id}/lineage', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentLineageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transform_partitions(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get transform partitions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transform_partitions(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param int offset: Offset in partition metadata list.
        :param int limit: Upper limit of partition metadata results returned.
        :param str start_ts:
        :param str end_ts:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentPartitionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_transform_partitions_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_transform_partitions_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get transform partitions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transform_partitions_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param int offset: Offset in partition metadata list.
        :param int limit: Upper limit of partition metadata results returned.
        :param str start_ts:
        :param str end_ts:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentPartitionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'stage',
            'stage_index',
            'offset',
            'limit',
            'start_ts',
            'end_ts'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transform_partitions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_transform_partitions`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_transform_partitions`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_transform_partitions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'stage' in local_var_params and local_var_params['stage'] is not None:  # noqa: E501
            query_params.append(('stage', local_var_params['stage']))  # noqa: E501
        if 'stage_index' in local_var_params and local_var_params['stage_index'] is not None:  # noqa: E501
            query_params.append(('stage_index', local_var_params['stage_index']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'start_ts' in local_var_params and local_var_params['start_ts'] is not None:  # noqa: E501
            query_params.append(('start_ts', local_var_params['start_ts']))  # noqa: E501
        if 'end_ts' in local_var_params and local_var_params['end_ts'] is not None:  # noqa: E501
            query_params.append(('end_ts', local_var_params['end_ts']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/views/{id}/partitions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentPartitionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transform_records(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get transform records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transform_records(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param str offset: Record offset.
        :param str limit: Upper limit of number of records to be returned.
        :param str token:
        :param str format:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentRecordsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_transform_records_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_transform_records_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get transform records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transform_records_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param str offset: Record offset.
        :param str limit: Upper limit of number of records to be returned.
        :param str token:
        :param str format:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentRecordsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'stage',
            'stage_index',
            'offset',
            'limit',
            'token',
            'format'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transform_records" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_transform_records`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_transform_records`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_transform_records`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'stage' in local_var_params and local_var_params['stage'] is not None:  # noqa: E501
            query_params.append(('stage', local_var_params['stage']))  # noqa: E501
        if 'stage_index' in local_var_params and local_var_params['stage_index'] is not None:  # noqa: E501
            query_params.append(('stage_index', local_var_params['stage_index']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'token' in local_var_params and local_var_params['token'] is not None:  # noqa: E501
            query_params.append(('token', local_var_params['token']))  # noqa: E501
        if 'format' in local_var_params and local_var_params['format'] is not None:  # noqa: E501
            query_params.append(('format', local_var_params['format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/views/{id}/records', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentRecordsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transform_schema(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get transform schema  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transform_schema(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentSchemaResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_transform_schema_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_transform_schema_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get transform schema  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transform_schema_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentSchemaResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transform_schema" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_transform_schema`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_transform_schema`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_transform_schema`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/views/{id}/schema', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentSchemaResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transform_state(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get transform state  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transform_state(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentStateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_transform_state_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_transform_state_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get transform state  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transform_state_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentStateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transform_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_transform_state`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_transform_state`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_transform_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/views/{id}/state', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentStateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transform_statistics(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get transform statistics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transform_statistics(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentStatisticsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_transform_statistics_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_transform_statistics_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get transform statistics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transform_statistics_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentStatisticsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'stage',
            'stage_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transform_statistics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_transform_statistics`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_transform_statistics`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_transform_statistics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'stage' in local_var_params and local_var_params['stage'] is not None:  # noqa: E501
            query_params.append(('stage', local_var_params['stage']))  # noqa: E501
        if 'stage_index' in local_var_params and local_var_params['stage_index'] is not None:  # noqa: E501
            query_params.append(('stage_index', local_var_params['stage_index']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/views/{id}/statistics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentStatisticsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transform_warnings(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get transform warnings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transform_warnings(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str offset: Offset in errors list.
        :param str limit: Upper limit of the number of errors returned.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentWarningsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_transform_warnings_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_transform_warnings_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get transform warnings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transform_warnings_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str offset: Offset in errors list.
        :param str limit: Upper limit of the number of errors returned.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentWarningsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'offset',
            'limit'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transform_warnings" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_transform_warnings`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_transform_warnings`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_transform_warnings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/views/{id}/warnings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentWarningsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_write_connector(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get write connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_write_connector(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiWriteConnectorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_write_connector_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_write_connector_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get write connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_write_connector_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiWriteConnectorResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_write_connector" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_write_connector`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_write_connector`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_write_connector`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sinks/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiWriteConnectorResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_write_connector_errors(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get write connector errors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_write_connector_errors(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str offset: Offset in errors list.
        :param str limit: Upper limit of the number of errors returned.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentErrorsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_write_connector_errors_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_write_connector_errors_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get write connector errors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_write_connector_errors_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str offset: Offset in errors list.
        :param str limit: Upper limit of the number of errors returned.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentErrorsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'offset',
            'limit'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_write_connector_errors" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_write_connector_errors`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_write_connector_errors`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_write_connector_errors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sinks/{id}/errors', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentErrorsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_write_connector_lineage(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get write connector lineage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_write_connector_lineage(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentLineageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_write_connector_lineage_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_write_connector_lineage_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get write connector lineage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_write_connector_lineage_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentLineageResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_write_connector_lineage" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_write_connector_lineage`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_write_connector_lineage`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_write_connector_lineage`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sinks/{id}/lineage', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentLineageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_write_connector_partitions(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get write connector partitions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_write_connector_partitions(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param int offset: Offset in partition metadata list.
        :param int limit: Upper limit of partition metadata results returned.
        :param str start_ts:
        :param str end_ts:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentPartitionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_write_connector_partitions_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_write_connector_partitions_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get write connector partitions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_write_connector_partitions_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param int offset: Offset in partition metadata list.
        :param int limit: Upper limit of partition metadata results returned.
        :param str start_ts:
        :param str end_ts:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentPartitionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'stage',
            'stage_index',
            'offset',
            'limit',
            'start_ts',
            'end_ts'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_write_connector_partitions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_write_connector_partitions`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_write_connector_partitions`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_write_connector_partitions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'stage' in local_var_params and local_var_params['stage'] is not None:  # noqa: E501
            query_params.append(('stage', local_var_params['stage']))  # noqa: E501
        if 'stage_index' in local_var_params and local_var_params['stage_index'] is not None:  # noqa: E501
            query_params.append(('stage_index', local_var_params['stage_index']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'start_ts' in local_var_params and local_var_params['start_ts'] is not None:  # noqa: E501
            query_params.append(('start_ts', local_var_params['start_ts']))  # noqa: E501
        if 'end_ts' in local_var_params and local_var_params['end_ts'] is not None:  # noqa: E501
            query_params.append(('end_ts', local_var_params['end_ts']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sinks/{id}/partitions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentPartitionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_write_connector_state(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get write connector state  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_write_connector_state(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentStateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_write_connector_state_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_write_connector_state_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get write connector state  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_write_connector_state_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentStateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_write_connector_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_write_connector_state`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_write_connector_state`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_write_connector_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sinks/{id}/state', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentStateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_write_connector_statistics(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get write connector statistics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_write_connector_statistics(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentStatisticsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_write_connector_statistics_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_write_connector_statistics_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get write connector statistics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_write_connector_statistics_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str stage:
        :param int stage_index:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentStatisticsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'stage',
            'stage_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_write_connector_statistics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_write_connector_statistics`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_write_connector_statistics`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_write_connector_statistics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'stage' in local_var_params and local_var_params['stage'] is not None:  # noqa: E501
            query_params.append(('stage', local_var_params['stage']))  # noqa: E501
        if 'stage_index' in local_var_params and local_var_params['stage_index'] is not None:  # noqa: E501
            query_params.append(('stage_index', local_var_params['stage_index']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sinks/{id}/statistics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentStatisticsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_write_connector_warnings(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get write connector warnings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_write_connector_warnings(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str offset: Offset in errors list.
        :param str limit: Upper limit of the number of errors returned.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentWarningsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_write_connector_warnings_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def get_write_connector_warnings_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """get write connector warnings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_write_connector_warnings_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param str offset: Offset in errors list.
        :param str limit: Upper limit of the number of errors returned.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentWarningsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'offset',
            'limit'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_write_connector_warnings" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `get_write_connector_warnings`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `get_write_connector_warnings`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_write_connector_warnings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sinks/{id}/warnings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentWarningsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_component_groups(self, data_service_id, dataflow_id, **kwargs):  # noqa: E501
        """list component groups in a dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_component_groups(data_service_id, dataflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentGroupsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_component_groups_with_http_info(data_service_id, dataflow_id, **kwargs)  # noqa: E501

    def list_component_groups_with_http_info(self, data_service_id, dataflow_id, **kwargs):  # noqa: E501
        """list component groups in a dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_component_groups_with_http_info(data_service_id, dataflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentGroupsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_component_groups" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `list_component_groups`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `list_component_groups`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/groups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentGroupsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_connection_types(self, data_service_id, **kwargs):  # noqa: E501
        """List all connection types in a data service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_connection_types(data_service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiConnectionTypesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_connection_types_with_http_info(data_service_id, **kwargs)  # noqa: E501

    def list_connection_types_with_http_info(self, data_service_id, **kwargs):  # noqa: E501
        """List all connection types in a data service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_connection_types_with_http_info(data_service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiConnectionTypesResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_connection_types" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `list_connection_types`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/connection_types', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiConnectionTypesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_connections(self, data_service_id, **kwargs):  # noqa: E501
        """List all connections in a data service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_connections(data_service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiConnectionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_connections_with_http_info(data_service_id, **kwargs)  # noqa: E501

    def list_connections_with_http_info(self, data_service_id, **kwargs):  # noqa: E501
        """List all connections in a data service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_connections_with_http_info(data_service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiConnectionsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_connections" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `list_connections`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/connections', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiConnectionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_data_feed_connectors(self, data_service_id, dataflow_id, **kwargs):  # noqa: E501
        """list data feed connectors in a dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_data_feed_connectors(data_service_id, dataflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param bool deep: If set to true, populate the detailed source/view/sink fields in Component response, and not just top level Component fields.
        :param str state: Comma-separated list of component states to filter on - valid values are uptodate, running, outofdate, error.
        :param str kind: Comma-separated list of component types to filter on - valid values are source, view, sink, pub, sub, group. Note - these are legacy names for ReadConnector, Transform, WriteConnector, DataFeed, DataFeedConnector, ComponentGroup respectively.
        :param bool summary:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataFeedConnectorsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_data_feed_connectors_with_http_info(data_service_id, dataflow_id, **kwargs)  # noqa: E501

    def list_data_feed_connectors_with_http_info(self, data_service_id, dataflow_id, **kwargs):  # noqa: E501
        """list data feed connectors in a dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_data_feed_connectors_with_http_info(data_service_id, dataflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param bool deep: If set to true, populate the detailed source/view/sink fields in Component response, and not just top level Component fields.
        :param str state: Comma-separated list of component states to filter on - valid values are uptodate, running, outofdate, error.
        :param str kind: Comma-separated list of component types to filter on - valid values are source, view, sink, pub, sub, group. Note - these are legacy names for ReadConnector, Transform, WriteConnector, DataFeed, DataFeedConnector, ComponentGroup respectively.
        :param bool summary:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataFeedConnectorsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'deep',
            'state',
            'kind',
            'summary'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_data_feed_connectors" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `list_data_feed_connectors`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `list_data_feed_connectors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501

        query_params = []
        if 'deep' in local_var_params and local_var_params['deep'] is not None:  # noqa: E501
            query_params.append(('deep', local_var_params['deep']))  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501
        if 'kind' in local_var_params and local_var_params['kind'] is not None:  # noqa: E501
            query_params.append(('kind', local_var_params['kind']))  # noqa: E501
        if 'summary' in local_var_params and local_var_params['summary'] is not None:  # noqa: E501
            query_params.append(('summary', local_var_params['summary']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/subs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataFeedConnectorsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_data_feeds(self, data_service_id, dataflow_id, **kwargs):  # noqa: E501
        """list data feeds in a dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_data_feeds(data_service_id, dataflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param bool deep: If set to true, populate the detailed source/view/sink fields in Component response, and not just top level Component fields.
        :param str state: Comma-separated list of component states to filter on - valid values are uptodate, running, outofdate, error.
        :param str kind: Comma-separated list of component types to filter on - valid values are source, view, sink, pub, sub, group. Note - these are legacy names for ReadConnector, Transform, WriteConnector, DataFeed, DataFeedConnector, ComponentGroup respectively.
        :param bool summary:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataFeedsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_data_feeds_with_http_info(data_service_id, dataflow_id, **kwargs)  # noqa: E501

    def list_data_feeds_with_http_info(self, data_service_id, dataflow_id, **kwargs):  # noqa: E501
        """list data feeds in a dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_data_feeds_with_http_info(data_service_id, dataflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param bool deep: If set to true, populate the detailed source/view/sink fields in Component response, and not just top level Component fields.
        :param str state: Comma-separated list of component states to filter on - valid values are uptodate, running, outofdate, error.
        :param str kind: Comma-separated list of component types to filter on - valid values are source, view, sink, pub, sub, group. Note - these are legacy names for ReadConnector, Transform, WriteConnector, DataFeed, DataFeedConnector, ComponentGroup respectively.
        :param bool summary:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataFeedsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'deep',
            'state',
            'kind',
            'summary'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_data_feeds" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `list_data_feeds`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `list_data_feeds`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501

        query_params = []
        if 'deep' in local_var_params and local_var_params['deep'] is not None:  # noqa: E501
            query_params.append(('deep', local_var_params['deep']))  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501
        if 'kind' in local_var_params and local_var_params['kind'] is not None:  # noqa: E501
            query_params.append(('kind', local_var_params['kind']))  # noqa: E501
        if 'summary' in local_var_params and local_var_params['summary'] is not None:  # noqa: E501
            query_params.append(('summary', local_var_params['summary']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/pubs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataFeedsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_data_service_components(self, data_service_id, **kwargs):  # noqa: E501
        """get list of components in a data service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_data_service_components(data_service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param bool deep: If set to true, populate the detailed source/view/sink fields in Component response, and not just top level Component fields.
        :param str state: Comma-separated list of component states to filter on - valid values are uptodate, running, outofdate, error.
        :param str kind: Comma-separated list of component types to filter on - valid values are source, view, sink, pub, sub, group. Note - these are legacy names for ReadConnector, Transform, WriteConnector, DataFeed, DataFeedConnector, ComponentGroup respectively.
        :param bool summary:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_data_service_components_with_http_info(data_service_id, **kwargs)  # noqa: E501

    def list_data_service_components_with_http_info(self, data_service_id, **kwargs):  # noqa: E501
        """get list of components in a data service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_data_service_components_with_http_info(data_service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param bool deep: If set to true, populate the detailed source/view/sink fields in Component response, and not just top level Component fields.
        :param str state: Comma-separated list of component states to filter on - valid values are uptodate, running, outofdate, error.
        :param str kind: Comma-separated list of component types to filter on - valid values are source, view, sink, pub, sub, group. Note - these are legacy names for ReadConnector, Transform, WriteConnector, DataFeed, DataFeedConnector, ComponentGroup respectively.
        :param bool summary:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'deep',
            'state',
            'kind',
            'summary'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_data_service_components" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `list_data_service_components`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501

        query_params = []
        if 'deep' in local_var_params and local_var_params['deep'] is not None:  # noqa: E501
            query_params.append(('deep', local_var_params['deep']))  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501
        if 'kind' in local_var_params and local_var_params['kind'] is not None:  # noqa: E501
            query_params.append(('kind', local_var_params['kind']))  # noqa: E501
        if 'summary' in local_var_params and local_var_params['summary'] is not None:  # noqa: E501
            query_params.append(('summary', local_var_params['summary']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/components', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_data_service_credentials(self, data_service_id, **kwargs):  # noqa: E501
        """list data service credentials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_data_service_credentials(data_service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str component_hint:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiListCredentialsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_data_service_credentials_with_http_info(data_service_id, **kwargs)  # noqa: E501

    def list_data_service_credentials_with_http_info(self, data_service_id, **kwargs):  # noqa: E501
        """list data service credentials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_data_service_credentials_with_http_info(data_service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str component_hint:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiListCredentialsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'component_hint'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_data_service_credentials" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `list_data_service_credentials`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501

        query_params = []
        if 'component_hint' in local_var_params and local_var_params['component_hint'] is not None:  # noqa: E501
            query_params.append(('component_hint', local_var_params['component_hint']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/vault', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiListCredentialsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_data_service_roles(self, **kwargs):  # noqa: E501
        """List all Data Service roles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_data_service_roles(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataServiceRolesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_data_service_roles_with_http_info(**kwargs)  # noqa: E501

    def list_data_service_roles_with_http_info(self, **kwargs):  # noqa: E501
        """List all Data Service roles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_data_service_roles_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataServiceRolesResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_data_service_roles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/authz/v1/org_roles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataServiceRolesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_data_services(self, **kwargs):  # noqa: E501
        """List all Data Services  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_data_services(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataServicesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_data_services_with_http_info(**kwargs)  # noqa: E501

    def list_data_services_with_http_info(self, **kwargs):  # noqa: E501
        """List all Data Services  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_data_services_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataServicesResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_data_services" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataServicesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_dataflow_components(self, data_service_id, dataflow_id, **kwargs):  # noqa: E501
        """list components in a dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_dataflow_components(data_service_id, dataflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param bool deep: If set to true, populate the detailed source/view/sink fields in Component response, and not just top level Component fields.
        :param str state: Comma-separated list of component states to filter on - valid values are uptodate, running, outofdate, error.
        :param str kind: Comma-separated list of component types to filter on - valid values are source, view, sink, pub, sub, group. Note - these are legacy names for ReadConnector, Transform, WriteConnector, DataFeed, DataFeedConnector, ComponentGroup respectively.
        :param bool summary:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_dataflow_components_with_http_info(data_service_id, dataflow_id, **kwargs)  # noqa: E501

    def list_dataflow_components_with_http_info(self, data_service_id, dataflow_id, **kwargs):  # noqa: E501
        """list components in a dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_dataflow_components_with_http_info(data_service_id, dataflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param bool deep: If set to true, populate the detailed source/view/sink fields in Component response, and not just top level Component fields.
        :param str state: Comma-separated list of component states to filter on - valid values are uptodate, running, outofdate, error.
        :param str kind: Comma-separated list of component types to filter on - valid values are source, view, sink, pub, sub, group. Note - these are legacy names for ReadConnector, Transform, WriteConnector, DataFeed, DataFeedConnector, ComponentGroup respectively.
        :param bool summary:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'deep',
            'state',
            'kind',
            'summary'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_dataflow_components" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `list_dataflow_components`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `list_dataflow_components`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501

        query_params = []
        if 'deep' in local_var_params and local_var_params['deep'] is not None:  # noqa: E501
            query_params.append(('deep', local_var_params['deep']))  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501
        if 'kind' in local_var_params and local_var_params['kind'] is not None:  # noqa: E501
            query_params.append(('kind', local_var_params['kind']))  # noqa: E501
        if 'summary' in local_var_params and local_var_params['summary'] is not None:  # noqa: E501
            query_params.append(('summary', local_var_params['summary']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/components', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_dataflows(self, data_service_id, **kwargs):  # noqa: E501
        """List all dataflows in a data service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_dataflows(data_service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataflowsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_dataflows_with_http_info(data_service_id, **kwargs)  # noqa: E501

    def list_dataflows_with_http_info(self, data_service_id, **kwargs):  # noqa: E501
        """List all dataflows in a data service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_dataflows_with_http_info(data_service_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataflowsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_dataflows" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `list_dataflows`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataflowsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_read_connectors(self, data_service_id, dataflow_id, **kwargs):  # noqa: E501
        """list read connectors in a dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_read_connectors(data_service_id, dataflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param bool deep: If set to true, populate the detailed source/view/sink fields in Component response, and not just top level Component fields.
        :param str state: Comma-separated list of component states to filter on - valid values are uptodate, running, outofdate, error.
        :param str kind: Comma-separated list of component types to filter on - valid values are source, view, sink, pub, sub, group. Note - these are legacy names for ReadConnector, Transform, WriteConnector, DataFeed, DataFeedConnector, ComponentGroup respectively.
        :param bool summary:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiReadConnectorsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_read_connectors_with_http_info(data_service_id, dataflow_id, **kwargs)  # noqa: E501

    def list_read_connectors_with_http_info(self, data_service_id, dataflow_id, **kwargs):  # noqa: E501
        """list read connectors in a dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_read_connectors_with_http_info(data_service_id, dataflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param bool deep: If set to true, populate the detailed source/view/sink fields in Component response, and not just top level Component fields.
        :param str state: Comma-separated list of component states to filter on - valid values are uptodate, running, outofdate, error.
        :param str kind: Comma-separated list of component types to filter on - valid values are source, view, sink, pub, sub, group. Note - these are legacy names for ReadConnector, Transform, WriteConnector, DataFeed, DataFeedConnector, ComponentGroup respectively.
        :param bool summary:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiReadConnectorsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'deep',
            'state',
            'kind',
            'summary'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_read_connectors" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `list_read_connectors`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `list_read_connectors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501

        query_params = []
        if 'deep' in local_var_params and local_var_params['deep'] is not None:  # noqa: E501
            query_params.append(('deep', local_var_params['deep']))  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501
        if 'kind' in local_var_params and local_var_params['kind'] is not None:  # noqa: E501
            query_params.append(('kind', local_var_params['kind']))  # noqa: E501
        if 'summary' in local_var_params and local_var_params['summary'] is not None:  # noqa: E501
            query_params.append(('summary', local_var_params['summary']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sources', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiReadConnectorsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_transforms(self, data_service_id, dataflow_id, **kwargs):  # noqa: E501
        """list transforms in a dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_transforms(data_service_id, dataflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param bool deep: If set to true, populate the detailed source/view/sink fields in Component response, and not just top level Component fields.
        :param str state: Comma-separated list of component states to filter on - valid values are uptodate, running, outofdate, error.
        :param str kind: Comma-separated list of component types to filter on - valid values are source, view, sink, pub, sub, group. Note - these are legacy names for ReadConnector, Transform, WriteConnector, DataFeed, DataFeedConnector, ComponentGroup respectively.
        :param bool summary:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiTransformsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_transforms_with_http_info(data_service_id, dataflow_id, **kwargs)  # noqa: E501

    def list_transforms_with_http_info(self, data_service_id, dataflow_id, **kwargs):  # noqa: E501
        """list transforms in a dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_transforms_with_http_info(data_service_id, dataflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param bool deep: If set to true, populate the detailed source/view/sink fields in Component response, and not just top level Component fields.
        :param str state: Comma-separated list of component states to filter on - valid values are uptodate, running, outofdate, error.
        :param str kind: Comma-separated list of component types to filter on - valid values are source, view, sink, pub, sub, group. Note - these are legacy names for ReadConnector, Transform, WriteConnector, DataFeed, DataFeedConnector, ComponentGroup respectively.
        :param bool summary:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiTransformsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'deep',
            'state',
            'kind',
            'summary'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_transforms" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `list_transforms`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `list_transforms`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501

        query_params = []
        if 'deep' in local_var_params and local_var_params['deep'] is not None:  # noqa: E501
            query_params.append(('deep', local_var_params['deep']))  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501
        if 'kind' in local_var_params and local_var_params['kind'] is not None:  # noqa: E501
            query_params.append(('kind', local_var_params['kind']))  # noqa: E501
        if 'summary' in local_var_params and local_var_params['summary'] is not None:  # noqa: E501
            query_params.append(('summary', local_var_params['summary']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/views', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiTransformsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_write_connectors(self, data_service_id, dataflow_id, **kwargs):  # noqa: E501
        """list write connectors in a dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_write_connectors(data_service_id, dataflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param bool deep: If set to true, populate the detailed source/view/sink fields in Component response, and not just top level Component fields.
        :param str state: Comma-separated list of component states to filter on - valid values are uptodate, running, outofdate, error.
        :param str kind: Comma-separated list of component types to filter on - valid values are source, view, sink, pub, sub, group. Note - these are legacy names for ReadConnector, Transform, WriteConnector, DataFeed, DataFeedConnector, ComponentGroup respectively.
        :param bool summary:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiWriteConnectorsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_write_connectors_with_http_info(data_service_id, dataflow_id, **kwargs)  # noqa: E501

    def list_write_connectors_with_http_info(self, data_service_id, dataflow_id, **kwargs):  # noqa: E501
        """list write connectors in a dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_write_connectors_with_http_info(data_service_id, dataflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param bool deep: If set to true, populate the detailed source/view/sink fields in Component response, and not just top level Component fields.
        :param str state: Comma-separated list of component states to filter on - valid values are uptodate, running, outofdate, error.
        :param str kind: Comma-separated list of component types to filter on - valid values are source, view, sink, pub, sub, group. Note - these are legacy names for ReadConnector, Transform, WriteConnector, DataFeed, DataFeedConnector, ComponentGroup respectively.
        :param bool summary:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiWriteConnectorsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'deep',
            'state',
            'kind',
            'summary'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_write_connectors" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `list_write_connectors`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `list_write_connectors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501

        query_params = []
        if 'deep' in local_var_params and local_var_params['deep'] is not None:  # noqa: E501
            query_params.append(('deep', local_var_params['deep']))  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501
        if 'kind' in local_var_params and local_var_params['kind'] is not None:  # noqa: E501
            query_params.append(('kind', local_var_params['kind']))  # noqa: E501
        if 'summary' in local_var_params and local_var_params['summary'] is not None:  # noqa: E501
            query_params.append(('summary', local_var_params['summary']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sinks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiWriteConnectorsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def refresh_read_connector(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """refresh read connector  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refresh_read_connector(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiReadConnectorRefreshResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.refresh_read_connector_with_http_info(data_service_id, dataflow_id, id, **kwargs)  # noqa: E501

    def refresh_read_connector_with_http_info(self, data_service_id, dataflow_id, id, **kwargs):  # noqa: E501
        """refresh read connector  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refresh_read_connector_with_http_info(data_service_id, dataflow_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiReadConnectorRefreshResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method refresh_read_connector" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `refresh_read_connector`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `refresh_read_connector`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `refresh_read_connector`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sources/{id}/refresh', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiReadConnectorRefreshResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_dataflow_errors(self, data_service_id, dataflow_id, body, **kwargs):  # noqa: E501
        """reset dataflow errors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_dataflow_errors(data_service_id, dataflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param ApiDataflowErrorsResetRequestOptions body: Reset request options. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataflowErrorsResetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.reset_dataflow_errors_with_http_info(data_service_id, dataflow_id, body, **kwargs)  # noqa: E501

    def reset_dataflow_errors_with_http_info(self, data_service_id, dataflow_id, body, **kwargs):  # noqa: E501
        """reset dataflow errors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_dataflow_errors_with_http_info(data_service_id, dataflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param ApiDataflowErrorsResetRequestOptions body: Reset request options. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataflowErrorsResetResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_dataflow_errors" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `reset_dataflow_errors`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `reset_dataflow_errors`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `reset_dataflow_errors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/reset-errors', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataflowErrorsResetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_read_connector_errors(self, data_service_id, dataflow_id, id, body, **kwargs):  # noqa: E501
        """reset read connector errors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_read_connector_errors(data_service_id, dataflow_id, id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param ApiComponentErrorsResetRequestOptions body: Reset options. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentErrorsResetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.reset_read_connector_errors_with_http_info(data_service_id, dataflow_id, id, body, **kwargs)  # noqa: E501

    def reset_read_connector_errors_with_http_info(self, data_service_id, dataflow_id, id, body, **kwargs):  # noqa: E501
        """reset read connector errors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_read_connector_errors_with_http_info(data_service_id, dataflow_id, id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param ApiComponentErrorsResetRequestOptions body: Reset options. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentErrorsResetResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_read_connector_errors" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `reset_read_connector_errors`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `reset_read_connector_errors`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `reset_read_connector_errors`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `reset_read_connector_errors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sources/{id}/reset-errors', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentErrorsResetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_transform_errors(self, data_service_id, dataflow_id, id, body, **kwargs):  # noqa: E501
        """reset transform errors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_transform_errors(data_service_id, dataflow_id, id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param ApiComponentErrorsResetRequestOptions body: Reset options. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentErrorsResetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.reset_transform_errors_with_http_info(data_service_id, dataflow_id, id, body, **kwargs)  # noqa: E501

    def reset_transform_errors_with_http_info(self, data_service_id, dataflow_id, id, body, **kwargs):  # noqa: E501
        """reset transform errors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_transform_errors_with_http_info(data_service_id, dataflow_id, id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param ApiComponentErrorsResetRequestOptions body: Reset options. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentErrorsResetResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_transform_errors" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `reset_transform_errors`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `reset_transform_errors`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `reset_transform_errors`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `reset_transform_errors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/views/{id}/reset-errors', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentErrorsResetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_write_connector_errors(self, data_service_id, dataflow_id, id, body, **kwargs):  # noqa: E501
        """reset write connector errors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_write_connector_errors(data_service_id, dataflow_id, id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param ApiComponentErrorsResetRequestOptions body: Reset options. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentErrorsResetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.reset_write_connector_errors_with_http_info(data_service_id, dataflow_id, id, body, **kwargs)  # noqa: E501

    def reset_write_connector_errors_with_http_info(self, data_service_id, dataflow_id, id, body, **kwargs):  # noqa: E501
        """reset write connector errors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_write_connector_errors_with_http_info(data_service_id, dataflow_id, id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str id: Component id. (required)
        :param ApiComponentErrorsResetRequestOptions body: Reset options. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentErrorsResetResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_write_connector_errors" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `reset_write_connector_errors`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `reset_write_connector_errors`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `reset_write_connector_errors`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `reset_write_connector_errors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sinks/{id}/reset-errors', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentErrorsResetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_component_group(self, data_service_id, dataflow_id, component_group_id, body, **kwargs):  # noqa: E501
        """update component group in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_component_group(data_service_id, dataflow_id, component_group_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str component_group_id: The unique identifier of this component group. (required)
        :param ApiComponentGroup body: Component group details. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiComponentGroupResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_component_group_with_http_info(data_service_id, dataflow_id, component_group_id, body, **kwargs)  # noqa: E501

    def update_component_group_with_http_info(self, data_service_id, dataflow_id, component_group_id, body, **kwargs):  # noqa: E501
        """update component group in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_component_group_with_http_info(data_service_id, dataflow_id, component_group_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str component_group_id: The unique identifier of this component group. (required)
        :param ApiComponentGroup body: Component group details. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiComponentGroupResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'component_group_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_component_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `update_component_group`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `update_component_group`")  # noqa: E501
        # verify the required parameter 'component_group_id' is set
        if self.api_client.client_side_validation and ('component_group_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['component_group_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `component_group_id` when calling `update_component_group`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `update_component_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'component_group_id' in local_var_params:
            path_params['component_group.id'] = local_var_params['component_group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/groups/{component_group.id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiComponentGroupResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_connection(self, data_service_id, connection_id_value, body, **kwargs):  # noqa: E501
        """update connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_connection(data_service_id, connection_id_value, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: (required)
        :param str connection_id_value: (required)
        :param IoConnection body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiUpdateConnectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_connection_with_http_info(data_service_id, connection_id_value, body, **kwargs)  # noqa: E501

    def update_connection_with_http_info(self, data_service_id, connection_id_value, body, **kwargs):  # noqa: E501
        """update connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_connection_with_http_info(data_service_id, connection_id_value, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: (required)
        :param str connection_id_value: (required)
        :param IoConnection body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiUpdateConnectionResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'connection_id_value',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_connection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `update_connection`")  # noqa: E501
        # verify the required parameter 'connection_id_value' is set
        if self.api_client.client_side_validation and ('connection_id_value' not in local_var_params or  # noqa: E501
                                                        local_var_params['connection_id_value'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `connection_id_value` when calling `update_connection`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `update_connection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'connection_id_value' in local_var_params:
            path_params['connection.id.value'] = local_var_params['connection_id_value']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/connections/{connection.id.value}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiUpdateConnectionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_data_feed(self, data_service_id, dataflow_id, data_feed_id, body, **kwargs):  # noqa: E501
        """update data feed in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_data_feed(data_service_id, dataflow_id, data_feed_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str data_feed_id: The unique identifier of this data feed. (required)
        :param ApiDataFeed body: Data feed details. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataFeedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_data_feed_with_http_info(data_service_id, dataflow_id, data_feed_id, body, **kwargs)  # noqa: E501

    def update_data_feed_with_http_info(self, data_service_id, dataflow_id, data_feed_id, body, **kwargs):  # noqa: E501
        """update data feed in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_data_feed_with_http_info(data_service_id, dataflow_id, data_feed_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str data_feed_id: The unique identifier of this data feed. (required)
        :param ApiDataFeed body: Data feed details. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataFeedResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'data_feed_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_data_feed" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `update_data_feed`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `update_data_feed`")  # noqa: E501
        # verify the required parameter 'data_feed_id' is set
        if self.api_client.client_side_validation and ('data_feed_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_feed_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_feed_id` when calling `update_data_feed`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `update_data_feed`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'data_feed_id' in local_var_params:
            path_params['data_feed.id'] = local_var_params['data_feed_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/pubs/{data_feed.id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataFeedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_data_feed_connector(self, data_service_id, dataflow_id, data_feed_connector_id, body, **kwargs):  # noqa: E501
        """update data feed connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_data_feed_connector(data_service_id, dataflow_id, data_feed_connector_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str data_feed_connector_id: The unique identifier of this data feed connector. (required)
        :param ApiDataFeedConnector body: Data feed connector details. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataFeedConnectorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_data_feed_connector_with_http_info(data_service_id, dataflow_id, data_feed_connector_id, body, **kwargs)  # noqa: E501

    def update_data_feed_connector_with_http_info(self, data_service_id, dataflow_id, data_feed_connector_id, body, **kwargs):  # noqa: E501
        """update data feed connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_data_feed_connector_with_http_info(data_service_id, dataflow_id, data_feed_connector_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str data_feed_connector_id: The unique identifier of this data feed connector. (required)
        :param ApiDataFeedConnector body: Data feed connector details. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataFeedConnectorResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'data_feed_connector_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_data_feed_connector" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `update_data_feed_connector`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `update_data_feed_connector`")  # noqa: E501
        # verify the required parameter 'data_feed_connector_id' is set
        if self.api_client.client_side_validation and ('data_feed_connector_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_feed_connector_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_feed_connector_id` when calling `update_data_feed_connector`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `update_data_feed_connector`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'data_feed_connector_id' in local_var_params:
            path_params['data_feed_connector.id'] = local_var_params['data_feed_connector_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/subs/{data_feed_connector.id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataFeedConnectorResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_data_service(self, id, body, **kwargs):  # noqa: E501
        """update data service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_data_service(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The unique identifier of this data service. (required)
        :param ApiDataService body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataServiceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_data_service_with_http_info(id, body, **kwargs)  # noqa: E501

    def update_data_service_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update data service  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_data_service_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The unique identifier of this data service. (required)
        :param ApiDataService body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataServiceResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_data_service" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_data_service`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `update_data_service`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataServiceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_data_service_credentials(self, data_service_id, credential_id, body, **kwargs):  # noqa: E501
        """update data service credentials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_data_service_credentials(data_service_id, credential_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str credential_id: Credential id. (required)
        :param ApiCredentials body: Component credentials. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiCredentialsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_data_service_credentials_with_http_info(data_service_id, credential_id, body, **kwargs)  # noqa: E501

    def update_data_service_credentials_with_http_info(self, data_service_id, credential_id, body, **kwargs):  # noqa: E501
        """update data service credentials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_data_service_credentials_with_http_info(data_service_id, credential_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str credential_id: Credential id. (required)
        :param ApiCredentials body: Component credentials. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiCredentialsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'credential_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_data_service_credentials" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `update_data_service_credentials`")  # noqa: E501
        # verify the required parameter 'credential_id' is set
        if self.api_client.client_side_validation and ('credential_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['credential_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `credential_id` when calling `update_data_service_credentials`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `update_data_service_credentials`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'credential_id' in local_var_params:
            path_params['credential_id'] = local_var_params['credential_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/vault/{credential_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiCredentialsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_dataflow(self, data_service_id, dataflow_id, body, **kwargs):  # noqa: E501
        """update dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dataflow(data_service_id, dataflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: The unique identifier of this dataflow. (required)
        :param ApiDataflow body: Dataflow details. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiDataflowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_dataflow_with_http_info(data_service_id, dataflow_id, body, **kwargs)  # noqa: E501

    def update_dataflow_with_http_info(self, data_service_id, dataflow_id, body, **kwargs):  # noqa: E501
        """update dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dataflow_with_http_info(data_service_id, dataflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: The unique identifier of this dataflow. (required)
        :param ApiDataflow body: Dataflow details. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiDataflowResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_dataflow" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `update_dataflow`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `update_dataflow`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `update_dataflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow.id'] = local_var_params['dataflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow.id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDataflowResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_read_connector(self, data_service_id, dataflow_id, read_connector_id, body, **kwargs):  # noqa: E501
        """update read connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_read_connector(data_service_id, dataflow_id, read_connector_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str read_connector_id: The unique identifier of this read connector. (required)
        :param ApiReadConnector body: Read connector to be created/updated. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiReadConnectorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_read_connector_with_http_info(data_service_id, dataflow_id, read_connector_id, body, **kwargs)  # noqa: E501

    def update_read_connector_with_http_info(self, data_service_id, dataflow_id, read_connector_id, body, **kwargs):  # noqa: E501
        """update read connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_read_connector_with_http_info(data_service_id, dataflow_id, read_connector_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str read_connector_id: The unique identifier of this read connector. (required)
        :param ApiReadConnector body: Read connector to be created/updated. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiReadConnectorResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'read_connector_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_read_connector" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `update_read_connector`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `update_read_connector`")  # noqa: E501
        # verify the required parameter 'read_connector_id' is set
        if self.api_client.client_side_validation and ('read_connector_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['read_connector_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `read_connector_id` when calling `update_read_connector`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `update_read_connector`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'read_connector_id' in local_var_params:
            path_params['read_connector.id'] = local_var_params['read_connector_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sources/{read_connector.id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiReadConnectorResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_transform(self, data_service_id, dataflow_id, transform_id, body, **kwargs):  # noqa: E501
        """update transform in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_transform(data_service_id, dataflow_id, transform_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str transform_id: The unique identifier of this transform. (required)
        :param ApiTransform body: Transform details. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiTransformResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_transform_with_http_info(data_service_id, dataflow_id, transform_id, body, **kwargs)  # noqa: E501

    def update_transform_with_http_info(self, data_service_id, dataflow_id, transform_id, body, **kwargs):  # noqa: E501
        """update transform in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_transform_with_http_info(data_service_id, dataflow_id, transform_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str transform_id: The unique identifier of this transform. (required)
        :param ApiTransform body: Transform details. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiTransformResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'transform_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_transform" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `update_transform`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `update_transform`")  # noqa: E501
        # verify the required parameter 'transform_id' is set
        if self.api_client.client_side_validation and ('transform_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['transform_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `transform_id` when calling `update_transform`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `update_transform`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'transform_id' in local_var_params:
            path_params['transform.id'] = local_var_params['transform_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/views/{transform.id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiTransformResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_write_connector(self, data_service_id, dataflow_id, write_connector_id, body, **kwargs):  # noqa: E501
        """update write connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_write_connector(data_service_id, dataflow_id, write_connector_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str write_connector_id: The unique identifier of this write connector. (required)
        :param ApiWriteConnector body: Write connector details. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiWriteConnectorResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_write_connector_with_http_info(data_service_id, dataflow_id, write_connector_id, body, **kwargs)  # noqa: E501

    def update_write_connector_with_http_info(self, data_service_id, dataflow_id, write_connector_id, body, **kwargs):  # noqa: E501
        """update write connector in dataflow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_write_connector_with_http_info(data_service_id, dataflow_id, write_connector_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str data_service_id: Data service id. (required)
        :param str dataflow_id: Dataflow id. (required)
        :param str write_connector_id: The unique identifier of this write connector. (required)
        :param ApiWriteConnector body: Write connector details. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiWriteConnectorResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data_service_id',
            'dataflow_id',
            'write_connector_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_write_connector" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data_service_id' is set
        if self.api_client.client_side_validation and ('data_service_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['data_service_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data_service_id` when calling `update_write_connector`")  # noqa: E501
        # verify the required parameter 'dataflow_id' is set
        if self.api_client.client_side_validation and ('dataflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['dataflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dataflow_id` when calling `update_write_connector`")  # noqa: E501
        # verify the required parameter 'write_connector_id' is set
        if self.api_client.client_side_validation and ('write_connector_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['write_connector_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `write_connector_id` when calling `update_write_connector`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `update_write_connector`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_service_id' in local_var_params:
            path_params['data_service_id'] = local_var_params['data_service_id']  # noqa: E501
        if 'dataflow_id' in local_var_params:
            path_params['dataflow_id'] = local_var_params['dataflow_id']  # noqa: E501
        if 'write_connector_id' in local_var_params:
            path_params['write_connector.id'] = local_var_params['write_connector_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/organizations/{data_service_id}/projects/{dataflow_id}/sinks/{write_connector.id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiWriteConnectorResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
