package main

import (
	"context"
	"encoding/json"
	"fmt"
	"google.golang.org/grpc"
	"net/http"
	"os"
	"sync"
	"v2ray.com/core/app/proxyman/command"
	"v2ray.com/core/common/protocol"
	"v2ray.com/core/common/serial"
	"v2ray.com/core/proxy/vmess"
)

var (
	API_ADDRESS = "127.0.0.1"
	API_PORT    = 10085
	INBOUND_TAG = "uif_inbound"
)

type res struct {
	Status int
	User   string
	UUID   string
}

func addUser(c command.HandlerServiceClient, user_key string) string {
	// {{{

	if user_key == "" {
		return "missing user_key"
	}
	var resu res

	_, err := c.AlterInbound(context.Background(), &command.AlterInboundRequest{
		Tag: INBOUND_TAG,
		Operation: serial.ToTypedMessage(&command.AddUserOperation{
			User: &protocol.User{
				Level: 0,
				Email: user_key,
				Account: serial.ToTypedMessage(&vmess.Account{
					Id:               user_key,
					AlterId:          0,
					SecuritySettings: &protocol.SecurityConfig{Type: protocol.SecurityType_AUTO},
				}),
			},
		}),
	})

	resu.User = user_key
	if err == nil {
		resu.Status = 0
	} else {
		resu.Status = 1
		resu.User = err.Error()
	}
	ret, _ := json.Marshal(resu)
	return string(ret)
	// }}}
}

func removeUser(c command.HandlerServiceClient, user_key string) string {
	// {{{

	if user_key == "" {
		return "missing user_key"
	}

	_, err := c.AlterInbound(context.Background(), &command.AlterInboundRequest{
		Tag: INBOUND_TAG,
		Operation: serial.ToTypedMessage(&command.RemoveUserOperation{
			Email: user_key,
		}),
	})

	var resu res

	resu.User = user_key
	if err == nil {
		resu.Status = 0
	} else {
		resu.Status = 1
	}
	ret, _ := json.Marshal(resu)
	return string(ret)
	// }}}
}

var g_mutex sync.Mutex
var g_hsClient command.HandlerServiceClient

func HttpServer(w http.ResponseWriter, r *http.Request) {
	// {{{
	g_mutex.Lock()
	query := r.URL.Query()
	respon := ""
	fmt.Printf(r.URL.Path)
	if r.URL.Path == "/addUser" {
		respon = addUser(g_hsClient, query.Get("user_key"))
	}
	if r.URL.Path == "/removeUser" {
		respon = removeUser(g_hsClient, query.Get("user_key"))
	}
	if r.URL.Path == "/quit" {
		os.Exit(1)
	}
	fmt.Fprint(w, respon)
	g_mutex.Unlock()
	// }}}
}

func main() {
	// {{{
	cmdConn, err := grpc.Dial(fmt.Sprintf("%s:%d", API_ADDRESS, API_PORT), grpc.WithInsecure())
	if err != nil {
		panic(err)
	}
	g_hsClient = command.NewHandlerServiceClient(cmdConn)
	fmt.Println("runing")
	http.HandleFunc("/", HttpServer)                 //初始化
	err = http.ListenAndServe("127.0.0.1:9090", nil) //设置监听的端口
	if err != nil {
		fmt.Println("ListenAndServe: ", err)
	}
	// removeUser(hsClient)
	// }}}
}
