/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.core.impl;

import it.unibo.tuprolog.core.Constant;
import it.unibo.tuprolog.core.Numeric;
import it.unibo.tuprolog.core.Scope;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.TermVisitor;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.core.impl.TermImpl;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.gciatto.kt.math.BigDecimal;
import org.gciatto.kt.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J!\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\u0015\u001a\u00020\u00022\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H$J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H&J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u00a6\u0002J\b\u0010\u001b\u001a\u00020\u0002H&J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH&J\u0011\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0096\u0004R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lit/unibo/tuprolog/core/impl/NumericImpl;", "Lit/unibo/tuprolog/core/impl/TermImpl;", "Lit/unibo/tuprolog/core/Numeric;", "tags", "", "", "", "(Ljava/util/Map;)V", "decimalValue", "Lorg/gciatto/kt/math/BigDecimal;", "getDecimalValue", "()Lorg/gciatto/kt/math/BigDecimal;", "intValue", "Lorg/gciatto/kt/math/BigInteger;", "getIntValue", "()Lorg/gciatto/kt/math/BigInteger;", "accept", "T", "visitor", "Lit/unibo/tuprolog/core/TermVisitor;", "(Lit/unibo/tuprolog/core/TermVisitor;)Ljava/lang/Object;", "copyWithTags", "equals", "", "other", "Lit/unibo/tuprolog/core/Term;", "useVarCompleteName", "freshCopy", "scope", "Lit/unibo/tuprolog/core/Scope;", "structurallyEquals", "core"})
public abstract class NumericImpl
extends TermImpl
implements Numeric {
    public NumericImpl(@NotNull Map<String, ? extends Object> tags) {
        Intrinsics.checkNotNullParameter(tags, "tags");
        super(tags);
    }

    @Override
    public boolean structurallyEquals(@NotNull Term other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return other.isNumber() && this.getDecimalValue().compareTo(other.castToNumeric().getDecimalValue()) == 0;
    }

    @Override
    @NotNull
    public abstract BigDecimal getDecimalValue();

    @Override
    @NotNull
    public abstract BigInteger getIntValue();

    @Override
    public abstract boolean equals(@Nullable Object var1);

    @Override
    public abstract boolean equals(@NotNull Term var1, boolean var2);

    @Override
    @NotNull
    protected abstract Numeric copyWithTags(@NotNull Map<String, ? extends Object> var1);

    @Override
    @NotNull
    public abstract Numeric freshCopy();

    @Override
    @NotNull
    public abstract Numeric freshCopy(@NotNull Scope var1);

    @Override
    public <T> T accept(@NotNull TermVisitor<T> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitNumeric(this);
    }

    @Override
    public int compareValueTo(@NotNull Numeric other) {
        return Numeric.DefaultImpls.compareValueTo(this, other);
    }

    @Override
    public boolean isConstant() {
        return Numeric.DefaultImpls.isConstant(this);
    }

    @Override
    public boolean isNumber() {
        return Numeric.DefaultImpls.isNumber(this);
    }

    @Override
    @NotNull
    public Sequence<Var> getVariables() {
        return Numeric.DefaultImpls.getVariables(this);
    }

    @Override
    @NotNull
    public Constant asConstant() {
        return Numeric.DefaultImpls.asConstant(this);
    }

    @Override
    @NotNull
    public Numeric asNumeric() {
        return Numeric.DefaultImpls.asNumeric(this);
    }
}

