import { IVpc } from '@aws-cdk/aws-ec2';
import { Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IFirewallRuleGroup } from './firewall-rule-group';
/**
 * (experimental) Options for a Firewall Rule Group Association.
 *
 * @experimental
 */
export interface FirewallRuleGroupAssociationOptions {
    /**
     * (experimental) If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections.
     *
     * @default true
     * @experimental
     */
    readonly mutationProtection?: boolean;
    /**
     * (experimental) The name of the association.
     *
     * @default - a CloudFormation generated name
     * @experimental
     */
    readonly name?: string;
    /**
     * (experimental) The setting that determines the processing order of the rule group among the rule groups that are associated with a single VPC.
     *
     * DNS Firewall filters VPC
     * traffic starting from rule group with the lowest numeric priority setting.
     *
     * This value must be greater than 100 and less than 9,000
     *
     * @experimental
     */
    readonly priority: number;
    /**
     * (experimental) The VPC that to associate with the rule group.
     *
     * @experimental
     */
    readonly vpc: IVpc;
}
/**
 * (experimental) Properties for a Firewall Rule Group Association.
 *
 * @experimental
 */
export interface FirewallRuleGroupAssociationProps extends FirewallRuleGroupAssociationOptions {
    /**
     * (experimental) The firewall rule group which must be associated.
     *
     * @experimental
     */
    readonly firewallRuleGroup: IFirewallRuleGroup;
}
/**
 * (experimental) A Firewall Rule Group Association.
 *
 * @experimental
 */
export declare class FirewallRuleGroupAssociation extends Resource {
    /**
     * (experimental) The ARN (Amazon Resource Name) of the association.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallRuleGroupAssociationArn: string;
    /**
     * (experimental) The date and time that the association was created.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallRuleGroupAssociationCreationTime: string;
    /**
     * (experimental) The creator request ID.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallRuleGroupAssociationCreatorRequestId: string;
    /**
     * (experimental) The ID of the association.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallRuleGroupAssociationId: string;
    /**
     * (experimental) The owner of the association, used only for lists that are not managed by you.
     *
     * If you use AWS Firewall Manager to manage your firewallls from DNS Firewall,
     * then this reports Firewall Manager as the managed owner.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallRuleGroupAssociationManagedOwnerName: string;
    /**
     * (experimental) The date and time that the association was last modified.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallRuleGroupAssociationModificationTime: string;
    /**
     * (experimental) The status of the association.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallRuleGroupAssociationStatus: string;
    /**
     * (experimental) Additional information about the status of the association.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallRuleGroupAssociationStatusMessage: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: FirewallRuleGroupAssociationProps);
}
