"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findClosestPathContaining = exports.nodeMajorVersion = exports.parseStackTrace = void 0;
const fs = require("fs");
const path = require("path");
// From https://github.com/errwischt/stacktrace-parser/blob/master/src/stack-trace-parser.js
const STACK_RE = /^\s*at (?:((?:\[object object\])?[^\\/]+(?: \[as \S+\])?) )?\(?(.*?):(\d+)(?::(\d+))?\)?\s*$/i;
/**
 * Parses the stack trace of an error
 */
function parseStackTrace(error) {
    const err = error || new Error();
    if (!err.stack) {
        return [];
    }
    const lines = err.stack.split('\n');
    const stackTrace = [];
    for (const line of lines) {
        const results = STACK_RE.exec(line);
        if (results) {
            stackTrace.push({
                file: results[2],
                methodName: results[1],
                lineNumber: parseInt(results[3], 10),
                column: parseInt(results[4], 10),
            });
        }
    }
    return stackTrace;
}
exports.parseStackTrace = parseStackTrace;
/**
 * Returns the major version of node installation
 */
function nodeMajorVersion() {
    return parseInt(process.versions.node.split('.')[0], 10);
}
exports.nodeMajorVersion = nodeMajorVersion;
/**
 * Finds the closest path containg a path
 */
function findClosestPathContaining(p) {
    for (const nodeModulesPath of module.paths) {
        if (fs.existsSync(path.join(path.dirname(nodeModulesPath), p))) {
            return path.dirname(nodeModulesPath);
        }
    }
    return undefined;
}
exports.findClosestPathContaining = findClosestPathContaining;
//# sourceMappingURL=data:application/json;base64,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