# Astrologic. Автоматическая оптимизация кода на уровне АСТ


Пакет Astrologic содержит ряд инструментов, позволяющих "в рантайме" оптимизировать работу ваших функций или даже конструировать новые функции. Все это достигается за счет парсинга и преобразования [ACT](https://docs.python.org/3/library/ast.html) исходной функции. Парсинг происходит полностью "под капотом" и невидим для пользователя.


## Оглавление

- [**Быстрый старт**](#быстрый-старт)
- [**Включаем и отключаем блоки кода**](#включаем-и-отключаем-блоки-кода)
- [**Оптимизация хвостовой рекурсии**](#оптимизация-хвостовой-рекурсии)


## Быстрый старт

Установите Astrologic через [pip](https://pypi.org/project/astrologic/):

```
$ pip install astrologic
```

## Включаем и отключаем блоки кода

Простейшим из декораторов библиотеки Astrologic является ```@switcher```. Вот пример его использования:

```python
from astrologic import switcher


@switcher(a=False, b=True)
def function():
  print('begin')
  if a:
    print('block a')
  if b:
    print('block b')
  print('end')

function() # Что будет выведено? Проверьте сами!
```

```@switcher``` проходится по унарным условиям (условиям, в которых только один операнд). Если название переменной, которая фигурирует в данном условии, присутствует в именованных аргументах самого декоратора, он делает одну из двух вещей. Если именованный аргумент равен True, он достает данный блок кода из условия заменяет им само условие. Если аргумент равен False, он удаляет условие вместе с блоком кода. То есть функция из примера выше превращается в:

```python
# Тот код, который будет исполнен на машине. Блок кода "if a:" полностью вырезан, а блок "if b:" вытащен из проверки, в то время как сама проверка тоже вырезана.
def function():
  print('begin')
  print('block b')
  print('end')
```

Использовать данный декоратор вы можете, к примеру, чтобы избежать каких-то проверок в вашем коде, основанных на константах. При инициализации функций в начале работы интерпретатора вы указываете, какие блоки кода вам нужны. По сути, if'ы в данном случае служат не по прямому назначению, а работают разметкой кода.

Поскольку ```@switcher``` редактирует функции на уровне АСТ, в некоторых случаях применение декоратора может ускорить ваш код, полностью убрав ненужные операции из реально исполняемого машиной кода.

У ```@switcher``` есть ряд ограничений и правил использования, которые необходимо учитывать:

- Декоратор ```@switcher``` должен быть первым в списке декораторов, все остальные можно накладывать только поверх. Если не соблюсти это правило, декораторы, лежащие под ```@switcher```, могут просто исчезнуть, будто их не было.
- Никаких else или else if у блоков if, которыми вы управляете через декоратор! У прочих блоков if использовать else можно, поскольку они никаких не модифицируются.

## Оптимизация хвостовой рекурсии

Еще один крутой трюк с ACT - автоматическая оптимизация [хвостовой рекурсии](https://ru.wikipedia.org/wiki/%D0%A5%D0%B2%D0%BE%D1%81%D1%82%D0%BE%D0%B2%D0%B0%D1%8F_%D1%80%D0%B5%D0%BA%D1%83%D1%80%D1%81%D0%B8%D1%8F). Для этого нам понадобится декоратор ```@no_recursion```:


```python
from astrologic import no_recursion

counter = 0

@no_recursion
def recursion():
    global counter
    counter += 1
    if counter != 10000000:
        return recursion()
    return counter

print(recursion()) # Попробуйте выполнить это сами!
```

Как вы, вероятно, знаете, максимальная глубина рекурсии в Python ограничена, и обычно составляет около 1000. Однако код из этого примера отработает и вернет корректный результат, поскольку декоратор ```@no_recursion``` автоматически преобразовал рекурсивный код в итеративный.
