# The Anime API Project

The Anime API is a collection of wrappers for different types of free anime-related APIs.


## Why anime-api (and not others)?

There are several reasons why would you prefer using anime-api:
- **Intuitive**: anime-api is designed to be intuitive. Supports autocompletion everywhere.
- **Complete**: Every actively supported API has no feature left apart.
- **Simple**: Get all the anime information you want with a single line of code.
- **Legal**: I shouldn't need to say this, but all the APIs are legal. (no free streaming services/others)
- **Actively supported**: Get new releases (with new API wrappers) every now and then.


## Installation

Using Poetry:
```
poetry add anime-api
```

Using PyPi
```
pip install anime-api
```


## APIs

These are the currently supported and planned to add support for APIs:

| Name                        | API Documentation                                                      | Available |
|-----------------------------|------------------------------------------------------------------------|-----------|
| Anime Facts Rest API        | [Documentation](https://chandan-02.github.io/anime-facts-rest-api/)    | ✅        |
| Trace.moe                   | [Documentation](https://soruly.github.io/trace.moe-api/)               | ✅        |
| Animechan                   | [Documentation](https://animechan.vercel.app/guide)                    | ❌        |
| Jikan (MyAnimeList)         | [Documentation](https://jikan.docs.apiary.io/)                         | ❌        |
| Waifu Pics                  | [Documentation](https://waifu.pics/docs)                               | ❌        |
| Studio Ghibli API           | [Documentation](https://ghibliapi.herokuapp.com/)                      | ❌        |
| Kitsu                       | [Documentation](https://kitsu.docs.apiary.io/)                         | ❌        |
| AniList                     | [Documentation](https://anilist.gitbook.io/anilist-apiv2-docs/)        | ❌        |
| AniDB                       | [Documentation](https://wiki.anidb.net/w/API)                          | ❌        |
| Kyoko                       | [Documentation](https://github.com/Elliottophellia/kyoko)              | ❌        |
| Animu                       | [Documentation](https://docs.animu.ml/)                                | ❌        |
| Anisearch                   | [Documentation](https://anisearch.com/developers)                      | ❌        |
| Anime News Network          | [Documentation](https://www.animenewsnetwork.com/encyclopedia/api.php) | ❌        |
| Notify.moe (Anime Notifier) | [Documentation](https://notify.moe/api)                                | ❌        |
| Hmtai                       | [Documentation](https://hmtai.herokuapp.com/endpoints)                 | ❌        |
| Nekos.life                  | [Documentation](https://github.com/Nekos-life/nekos.py)                | ❌        |
| NekoBot                     | [Documentation](https://docs.nekobot.xyz/)                             | ❌        |
| Neko-Love                   | [Documentation](https://docs.neko-love.xyz/)                           | ❌        |
| Nekos.best                  | [Documentation](https://docs.nekos.best/)                              | ❌        |
| Nekos.moe                   | [Documentation](https://docs.nekos.moe/)                               | ❌        |
| Shikimori                   | [Documentation](https://shikimori.one/api/doc)                         | ❌        |
| MangaDex                    | [Documentation](https://api.mangadex.org/docs.html)                    | ❌        |
| Danbooru                    | [Documentation](https://danbooru.donmai.us/wiki_pages/help:api)        | ❌        |
| Yandere                     | [Documentation](https://yande.re/help/api)                             | ❌        |
| Konachan                    | [Documentation](https://konachan.com/help/api)                         | ❌        |
| Waifus.im                   | [Documentation](https://waifu.im/)                                     | ❌        |
| Catboys                     | [Documentation](https://catboys.com/api)                               | ❌        |

### APIs that will not be supported
- Illegal anime streaming services
- Non anime-related APIs
- APIs that are not APIs (i.e. web scrapping)


## Mantainers
<table>
  <tr>
    <td style="align:center;">
      <a href="https://github.com/Nekidev">
        <img src="https://avatars.githubusercontent.com/u/84998222?s=256&v=4" height="100" width="100" alt="Nekidev avatar" />
        <br>
        <span>Nekidev</span>
      </a>
    </td>
  </tr>
</table>
