/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.unify;

import it.unibo.tuprolog.core.Substitution;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.unify.Unificator;
import it.unibo.tuprolog.utils.Cache;
import it.unibo.tuprolog.utils.Optional;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u000fH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR,\u0010\f\u001a \u0012\u0016\u0012\u0014\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u0010\u0012\u0004\u0012\u00020\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lit/unibo/tuprolog/unify/CachedUnificator;", "Lit/unibo/tuprolog/unify/Unificator;", "decorated", "cacheCapacity", "", "(Lit/unibo/tuprolog/unify/Unificator;I)V", "context", "Lit/unibo/tuprolog/core/Substitution;", "getContext", "()Lit/unibo/tuprolog/core/Substitution;", "getDecorated", "()Lit/unibo/tuprolog/unify/Unificator;", "mguCache", "Lit/unibo/tuprolog/utils/Cache;", "Lkotlin/Triple;", "", "Lit/unibo/tuprolog/unify/MguRequest;", "merge", "substitution1", "substitution2", "occurCheckEnabled", "mgu", "term1", "Lit/unibo/tuprolog/core/Term;", "term2", "unify"})
public final class CachedUnificator
implements Unificator {
    @NotNull
    private final Unificator decorated;
    @NotNull
    private final Cache<Triple<?, ?, Boolean>, Substitution> mguCache;

    public CachedUnificator(@NotNull Unificator decorated, int cacheCapacity) {
        Intrinsics.checkNotNullParameter(decorated, "decorated");
        this.decorated = decorated;
        this.mguCache = Cache.Companion.simpleLru(cacheCapacity);
    }

    @NotNull
    public final Unificator getDecorated() {
        return this.decorated;
    }

    @Override
    @NotNull
    public Substitution getContext() {
        return this.decorated.getContext();
    }

    @Override
    @NotNull
    public Substitution mgu(@NotNull Term term1, @NotNull Term term2, boolean occurCheckEnabled) {
        Substitution substitution;
        Intrinsics.checkNotNullParameter(term1, "term1");
        Intrinsics.checkNotNullParameter(term2, "term2");
        Triple<Term, Term, Boolean> mguRequest = new Triple<Term, Term, Boolean>(term1, term2, occurCheckEnabled);
        Optional<Substitution> cached = this.mguCache.get(mguRequest);
        if (cached instanceof Optional.Some) {
            substitution = (Substitution)((Optional.Some)cached).getValue();
        } else {
            Substitution mguResult = this.decorated.mgu(term1, term2, occurCheckEnabled);
            this.mguCache.set(mguRequest, mguResult);
            substitution = mguResult;
        }
        return substitution;
    }

    @Override
    @NotNull
    public Substitution merge(@NotNull Substitution substitution1, @NotNull Substitution substitution2, boolean occurCheckEnabled) {
        Substitution substitution;
        Intrinsics.checkNotNullParameter(substitution1, "substitution1");
        Intrinsics.checkNotNullParameter(substitution2, "substitution2");
        Triple<Substitution, Substitution, Boolean> mguRequest = new Triple<Substitution, Substitution, Boolean>(substitution1, substitution2, occurCheckEnabled);
        Optional<Substitution> cached = this.mguCache.get(mguRequest);
        if (cached instanceof Optional.Some) {
            substitution = (Substitution)((Optional.Some)cached).getValue();
        } else {
            Substitution mguResult = this.decorated.merge(substitution1, substitution2, occurCheckEnabled);
            this.mguCache.set(mguRequest, mguResult);
            substitution = mguResult;
        }
        return substitution;
    }

    @Override
    public boolean match(@NotNull Term term1, @NotNull Term term2) {
        return Unificator.DefaultImpls.match(this, term1, term2);
    }

    @Override
    public boolean match(@NotNull Term term1, @NotNull Term term2, boolean occurCheckEnabled) {
        return Unificator.DefaultImpls.match(this, term1, term2, occurCheckEnabled);
    }

    @Override
    @NotNull
    public Substitution merge(@NotNull Substitution substitution1, @NotNull Substitution substitution2) {
        return Unificator.DefaultImpls.merge(this, substitution1, substitution2);
    }

    @Override
    @NotNull
    public Substitution mgu(@NotNull Term term1, @NotNull Term term2) {
        return Unificator.DefaultImpls.mgu(this, term1, term2);
    }

    @Override
    @Nullable
    public Term unify(@NotNull Term term1, @NotNull Term term2) {
        return Unificator.DefaultImpls.unify(this, term1, term2);
    }

    @Override
    @Nullable
    public Term unify(@NotNull Term term1, @NotNull Term term2, boolean occurCheckEnabled) {
        return Unificator.DefaultImpls.unify(this, term1, term2, occurCheckEnabled);
    }
}

