/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve.libs.oop.exceptions;

import it.unibo.tuprolog.core.Atom;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.solve.ExecutionContext;
import it.unibo.tuprolog.solve.Signature;
import it.unibo.tuprolog.solve.exception.LogicError;
import it.unibo.tuprolog.solve.exception.error.ExistenceError;
import it.unibo.tuprolog.solve.libs.oop.TypeUtilsJvmKt;
import it.unibo.tuprolog.solve.libs.oop.exceptions.OopException;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R!\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lit/unibo/tuprolog/solve/libs/oop/exceptions/ConstructorInvocationException;", "Lit/unibo/tuprolog/solve/libs/oop/exceptions/OopException;", "type", "Lkotlin/reflect/KClass;", "admissibleTypes", "", "", "(Lkotlin/reflect/KClass;Ljava/util/List;)V", "getAdmissibleTypes", "()Ljava/util/List;", "culprit", "Lit/unibo/tuprolog/core/Term;", "getCulprit", "()Lit/unibo/tuprolog/core/Term;", "getType", "()Lkotlin/reflect/KClass;", "toLogicError", "Lit/unibo/tuprolog/solve/exception/LogicError;", "context", "Lit/unibo/tuprolog/solve/ExecutionContext;", "signature", "Lit/unibo/tuprolog/solve/Signature;", "oop-lib"})
public final class ConstructorInvocationException
extends OopException {
    @NotNull
    private final KClass<?> type;
    @NotNull
    private final List<Set<KClass<?>>> admissibleTypes;

    public ConstructorInvocationException(@NotNull KClass<?> type2, @NotNull List<? extends Set<? extends KClass<?>>> admissibleTypes) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(admissibleTypes, "admissibleTypes");
        super("There is no constructor on type " + TypeUtilsJvmKt.getFullName(type2) + " which accepts [" + OopException.Companion.pretty$oop_lib(admissibleTypes) + "] as formal arguments", null, 2, null);
        this.type = type2;
        this.admissibleTypes = admissibleTypes;
    }

    @NotNull
    public final KClass<?> getType() {
        return this.type;
    }

    @NotNull
    public final List<Set<KClass<?>>> getAdmissibleTypes() {
        return this.admissibleTypes;
    }

    @Override
    @NotNull
    public LogicError toLogicError(@NotNull ExecutionContext context, @NotNull Signature signature2) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(signature2, "signature");
        String string2 = this.getMessage();
        return ExistenceError.Companion.of(context, ExistenceError.ObjectType.OOP_CONSTRUCTOR, this.getCulprit(), string2 == null ? "" : string2);
    }

    @Override
    @NotNull
    protected Term getCulprit() {
        return Atom.Companion.of(TypeUtilsJvmKt.getFullName(this.type) + "::(" + OopException.Companion.pretty$oop_lib(this.admissibleTypes) + ')');
    }
}

