/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.core.impl;

import it.unibo.tuprolog.core.Scope;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.TermVisitor;
import it.unibo.tuprolog.core.Tuple;
import it.unibo.tuprolog.core.TupleIterator;
import it.unibo.tuprolog.core.impl.RecursiveImpl;
import it.unibo.tuprolog.core.impl.TupleUnfolder;
import it.unibo.tuprolog.utils.Taggable;
import it.unibo.tuprolog.utils.TaggableExtensions;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ!\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001fH\u0016\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\u000fH\u0014J\u001c\u0010\"\u001a\u00020\u00022\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0014J\b\u0010#\u001a\u00020\u0002H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\bH\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019H\u0016R\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006("}, d2={"Lit/unibo/tuprolog/core/impl/TupleImpl;", "Lit/unibo/tuprolog/core/impl/RecursiveImpl;", "Lit/unibo/tuprolog/core/Tuple;", "left", "Lit/unibo/tuprolog/core/Term;", "right", "tags", "", "", "", "(Lit/unibo/tuprolog/core/Term;Lit/unibo/tuprolog/core/Term;Ljava/util/Map;)V", "functor", "getFunctor", "()Ljava/lang/String;", "isGround", "", "()Z", "getLeft", "()Lit/unibo/tuprolog/core/Term;", "getRight", "size", "", "getSize", "()I", "unfoldedSequence", "Lkotlin/sequences/Sequence;", "getUnfoldedSequence", "()Lkotlin/sequences/Sequence;", "accept", "T", "visitor", "Lit/unibo/tuprolog/core/TermVisitor;", "(Lit/unibo/tuprolog/core/TermVisitor;)Ljava/lang/Object;", "checkGroundness", "copyWithTags", "freshCopy", "scope", "Lit/unibo/tuprolog/core/Scope;", "toString", "unfold", "core"})
public final class TupleImpl
extends RecursiveImpl
implements Tuple {
    @NotNull
    private final Term left;
    @NotNull
    private final Term right;
    private final boolean isGround;
    @NotNull
    private final String functor;

    public TupleImpl(@NotNull Term left, @NotNull Term right, @NotNull Map<String, ? extends Object> tags) {
        Intrinsics.checkNotNullParameter(left, "left");
        Intrinsics.checkNotNullParameter(right, "right");
        Intrinsics.checkNotNullParameter(tags, "tags");
        Term[] termArray = new Term[]{left, right};
        super(",", CollectionsKt.listOf(termArray), tags);
        this.left = left;
        this.right = right;
        this.isGround = this.checkGroundness();
        this.functor = ",";
    }

    public /* synthetic */ TupleImpl(Term term, Term term2, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        this(term, term2, map);
    }

    @Override
    @NotNull
    public Term getLeft() {
        return this.left;
    }

    @Override
    @NotNull
    public Term getRight() {
        return this.right;
    }

    @Override
    public boolean isGround() {
        return this.isGround;
    }

    @Override
    protected boolean checkGroundness() {
        return this.getLeft().isGround() && this.getRight().isGround();
    }

    @Override
    @NotNull
    public Sequence<Term> getUnfoldedSequence() {
        boolean bl = false;
        return CollectionsKt.asSequence((Iterable)new Iterable<Term>(this){
            final /* synthetic */ TupleImpl this$0;
            {
                this.this$0 = tupleImpl;
            }

            @NotNull
            public Iterator<Term> iterator() {
                boolean bl = false;
                return new TupleIterator(this.this$0);
            }
        });
    }

    @Override
    public int getSize() {
        return this.getUnfoldedList().size();
    }

    @Override
    @NotNull
    public Sequence<Term> unfold() {
        boolean bl = false;
        return CollectionsKt.asSequence((Iterable)new Iterable<Term>(this){
            final /* synthetic */ TupleImpl this$0;
            {
                this.this$0 = tupleImpl;
            }

            @NotNull
            public Iterator<Term> iterator() {
                boolean bl = false;
                return new TupleUnfolder(this.this$0);
            }
        });
    }

    @Override
    @NotNull
    public String getFunctor() {
        return this.functor;
    }

    @Override
    @NotNull
    public String toString() {
        return SequencesKt.joinToString$default(this.getUnfoldedSequence(), ", ", "(", ")", 0, null, null, 56, null);
    }

    @Override
    @NotNull
    protected Tuple copyWithTags(@NotNull Map<String, ? extends Object> tags) {
        Intrinsics.checkNotNullParameter(tags, "tags");
        return new TupleImpl(this.getLeft(), this.getRight(), tags);
    }

    @Override
    @NotNull
    public Tuple freshCopy() {
        return super.freshCopy().castToTuple();
    }

    @Override
    @NotNull
    public Tuple freshCopy(@NotNull Scope scope2) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        return this.isGround() ? (Tuple)this : (Tuple)TaggableExtensions.setTags((Taggable)scope2.tupleOf(SequencesKt.map(this.getArgsSequence(), (Function1)new Function1<Term, Term>(scope2){
            final /* synthetic */ Scope $scope;
            {
                this.$scope = $scope;
                super(1);
            }

            @NotNull
            public final Term invoke(@NotNull Term it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.freshCopy(this.$scope);
            }
        })), this.getTags());
    }

    @Override
    public <T> T accept(@NotNull TermVisitor<T> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitTuple(this);
    }

    @Override
    @NotNull
    public Term[] toArray() {
        return Tuple.DefaultImpls.toArray(this);
    }

    @Override
    @NotNull
    public List<Term> toList() {
        return Tuple.DefaultImpls.toList(this);
    }

    @Override
    @NotNull
    public Sequence<Term> toSequence() {
        return Tuple.DefaultImpls.toSequence(this);
    }

    @Override
    public int getArity() {
        return Tuple.DefaultImpls.getArity(this);
    }

    @Override
    public boolean isTuple() {
        return Tuple.DefaultImpls.isTuple(this);
    }

    @Override
    @NotNull
    public Tuple asTuple() {
        return Tuple.DefaultImpls.asTuple(this);
    }
}

