/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.core.impl;

import it.unibo.tuprolog.core.Atom;
import it.unibo.tuprolog.core.Block;
import it.unibo.tuprolog.core.Clause;
import it.unibo.tuprolog.core.Cons;
import it.unibo.tuprolog.core.Constant;
import it.unibo.tuprolog.core.Directive;
import it.unibo.tuprolog.core.Empty;
import it.unibo.tuprolog.core.EmptyBlock;
import it.unibo.tuprolog.core.EmptyList;
import it.unibo.tuprolog.core.Fact;
import it.unibo.tuprolog.core.Indicator;
import it.unibo.tuprolog.core.Integer;
import it.unibo.tuprolog.core.List;
import it.unibo.tuprolog.core.Numeric;
import it.unibo.tuprolog.core.Real;
import it.unibo.tuprolog.core.Recursive;
import it.unibo.tuprolog.core.Rule;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.TermFormatter;
import it.unibo.tuprolog.core.Truth;
import it.unibo.tuprolog.core.Tuple;
import it.unibo.tuprolog.core.Var;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.gciatto.kt.math.BigInteger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000 52\u00020\u0001:\u00015B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0001H\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0001H\u0014J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J3\u0010.\u001a\u00020\r\"\b\b\u0000\u0010/*\u00020\u00112\u0006\u0010\u000e\u001a\u0002H/2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u0002H/\u0012\u0004\u0012\u00020\r01H\u0002\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020\r2\u0006\u0010\u000e\u001a\u000204H\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u00066"}, d2={"Lit/unibo/tuprolog/core/impl/AbstractTermFormatter;", "Lit/unibo/tuprolog/core/TermFormatter;", "quoted", "", "numberVars", "ignoreOps", "(ZZZ)V", "getIgnoreOps", "()Z", "getNumberVars", "getQuoted", "childFormatter", "defaultValue", "", "term", "Lit/unibo/tuprolog/core/Term;", "formatFunctor", "Lit/unibo/tuprolog/core/Struct;", "isNumberedVar", "itemFormatter", "numberedVar", "integer", "Lit/unibo/tuprolog/core/Integer;", "visitAtom", "Lit/unibo/tuprolog/core/Atom;", "visitBlock", "Lit/unibo/tuprolog/core/Block;", "visitClause", "Lit/unibo/tuprolog/core/Clause;", "visitCollection", "Lit/unibo/tuprolog/core/Recursive;", "visitCons", "Lit/unibo/tuprolog/core/Cons;", "visitDirective", "Lit/unibo/tuprolog/core/Directive;", "visitEmptyList", "Lit/unibo/tuprolog/core/EmptyList;", "visitFact", "Lit/unibo/tuprolog/core/Fact;", "visitIndicator", "Lit/unibo/tuprolog/core/Indicator;", "visitList", "Lit/unibo/tuprolog/core/List;", "visitRule", "Lit/unibo/tuprolog/core/Rule;", "visitStruct", "visitStructImpl", "T", "actualVisit", "Lkotlin/Function1;", "(Lit/unibo/tuprolog/core/Struct;Lkotlin/jvm/functions/Function1;)Ljava/lang/String;", "visitTuple", "Lit/unibo/tuprolog/core/Tuple;", "Companion", "core"})
public abstract class AbstractTermFormatter
implements TermFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean quoted;
    private final boolean numberVars;
    private final boolean ignoreOps;
    @NotNull
    private static final BigInteger TWENTY_SIX = BigInteger.Companion.of(26);
    private static final int A_INDEX = 65;

    public AbstractTermFormatter(boolean quoted, boolean numberVars, boolean ignoreOps) {
        this.quoted = quoted;
        this.numberVars = numberVars;
        this.ignoreOps = ignoreOps;
    }

    public /* synthetic */ AbstractTermFormatter(boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        this(bl, bl2, bl3);
    }

    protected final boolean getQuoted() {
        return this.quoted;
    }

    protected final boolean getNumberVars() {
        return this.numberVars;
    }

    protected final boolean getIgnoreOps() {
        return this.ignoreOps;
    }

    @Override
    @NotNull
    public String defaultValue(@NotNull Term term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return term.toString();
    }

    @Override
    @NotNull
    public String visitAtom(@NotNull Atom term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return this.formatFunctor(term);
    }

    @Override
    @NotNull
    public String visitStruct(@NotNull Struct term) {
        Intrinsics.checkNotNullParameter(term, "term");
        if (this.numberVars && this.isNumberedVar(term)) {
            return this.numberedVar(term.get(0).castToInteger());
        }
        String functor = this.formatFunctor(term);
        String args2 = SequencesKt.joinToString$default(SequencesKt.map(term.getArgsSequence(), (Function1)new Function1<Term, String>(this){
            final /* synthetic */ AbstractTermFormatter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull Term it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return (String)it.accept(this.this$0.childFormatter());
            }
        }), ", ", "(", ")", 0, null, null, 56, null);
        return Intrinsics.stringPlus(functor, args2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNumberedVar(Struct term) {
        if (!Intrinsics.areEqual(term.getFunctor(), "$VAR")) return false;
        if (term.getArity() != 1) return false;
        Term term2 = term.get(0);
        boolean bl = false;
        boolean bl2 = false;
        Term it = term2;
        boolean bl3 = false;
        if (!it.isInteger()) return false;
        if (it.castToInteger().getValue().compareTo(BigInteger.Companion.getZERO()) < 0) return false;
        return true;
    }

    private final String numberedVar(Integer integer) {
        int letterIndex = integer.getValue().rem(TWENTY_SIX).toInt() + 65;
        BigInteger varNumber = integer.getValue().div(TWENTY_SIX);
        return "" + (char)letterIndex + varNumber;
    }

    private final String formatFunctor(Struct term) {
        return this.quoted ? Struct.Companion.enquoteFunctorIfNecessary(Struct.Companion.escapeFunctorIfNecessary$default(Struct.Companion, term.getFunctor(), false, false, 6, null)) : term.getFunctor();
    }

    private final <T extends Struct> String visitStructImpl(T term, Function1<? super T, String> actualVisit) {
        return this.ignoreOps ? this.visitStruct(term) : actualVisit.invoke(term);
    }

    @Override
    @NotNull
    public String visitCollection(@NotNull Recursive term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return this.visitStructImpl((Struct)term, (Function1)new Function1<Recursive, String>(this, term){
            final /* synthetic */ AbstractTermFormatter this$0;
            final /* synthetic */ Recursive $term;
            {
                this.this$0 = $receiver;
                this.$term = $term;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull Recursive it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.this$0.defaultValue(this.$term);
            }
        });
    }

    @Override
    @NotNull
    public String visitList(@NotNull List term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return this.visitCollection(term);
    }

    @Override
    @NotNull
    public String visitEmptyList(@NotNull EmptyList term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return this.defaultValue(term);
    }

    @Override
    @NotNull
    public String visitCons(@NotNull Cons term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return this.visitStructImpl((Struct)term, (Function1)new Function1<Cons, String>(term, this){
            final /* synthetic */ Cons $term;
            final /* synthetic */ AbstractTermFormatter this$0;
            {
                this.$term = $term;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull Cons it) {
                Intrinsics.checkNotNullParameter(it, "it");
                java.util.List<Term> list = this.$term.getUnfoldedList();
                AbstractTermFormatter abstractTermFormatter = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                java.util.List<Term> $this$invoke_u24lambda_u2d0 = list;
                boolean bl3 = false;
                Term last2 = CollectionsKt.last($this$invoke_u24lambda_u2d0);
                String base2 = CollectionsKt.joinToString$default($this$invoke_u24lambda_u2d0.subList(0, CollectionsKt.getLastIndex($this$invoke_u24lambda_u2d0)), ", ", "[", "", 0, null, new Function1<Term, CharSequence>(abstractTermFormatter){
                    final /* synthetic */ AbstractTermFormatter this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull Term it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return (CharSequence)it.accept(this.this$0.itemFormatter());
                    }
                }, 24, null);
                String lastString = last2.isEmptyList() ? "]" : " | " + (String)last2.accept(abstractTermFormatter.itemFormatter()) + ']';
                return Intrinsics.stringPlus(base2, lastString);
            }
        });
    }

    @Override
    @NotNull
    public String visitBlock(@NotNull Block term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return this.visitStructImpl((Struct)term, (Function1)new Function1<Block, String>(term, this){
            final /* synthetic */ Block $term;
            final /* synthetic */ AbstractTermFormatter this$0;
            {
                this.$term = $term;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull Block it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return SequencesKt.joinToString$default(this.$term.getUnfoldedSequence(), ", ", "{", "}", 0, null, new Function1<Term, CharSequence>(this.this$0){
                    final /* synthetic */ AbstractTermFormatter this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull Term it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return (CharSequence)it.accept(this.this$0.childFormatter());
                    }
                }, 24, null);
            }
        });
    }

    @Override
    @NotNull
    public String visitTuple(@NotNull Tuple term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return this.visitStructImpl((Struct)term, (Function1)new Function1<Tuple, String>(term, this){
            final /* synthetic */ Tuple $term;
            final /* synthetic */ AbstractTermFormatter this$0;
            {
                this.$term = $term;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull Tuple it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return SequencesKt.joinToString$default(this.$term.getUnfoldedSequence(), ", ", "(", ")", 0, null, new Function1<Term, CharSequence>(this.this$0){
                    final /* synthetic */ AbstractTermFormatter this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull Term it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return (CharSequence)it.accept(this.this$0.childFormatter());
                    }
                }, 24, null);
            }
        });
    }

    @Override
    @NotNull
    public String visitClause(@NotNull Clause term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return this.visitStructImpl((Struct)term, (Function1)new Function1<Clause, String>(term, this){
            final /* synthetic */ Clause $term;
            final /* synthetic */ AbstractTermFormatter this$0;
            {
                this.$term = $term;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull Clause it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return (String)this.$term.accept(this.this$0);
            }
        });
    }

    @Override
    @NotNull
    public String visitRule(@NotNull Rule term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return this.visitStruct(term);
    }

    @Override
    @NotNull
    public String visitFact(@NotNull Fact term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return this.visitRule(term);
    }

    @Override
    @NotNull
    public String visitDirective(@NotNull Directive term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return this.visitStruct(term);
    }

    @NotNull
    protected TermFormatter itemFormatter() {
        return this;
    }

    @NotNull
    protected TermFormatter childFormatter() {
        return this;
    }

    @Override
    @NotNull
    public String visitIndicator(@NotNull Indicator term) {
        Intrinsics.checkNotNullParameter(term, "term");
        return this.visitStruct(term);
    }

    @Override
    @NotNull
    public String visitConstant(@NotNull Constant term) {
        return TermFormatter.DefaultImpls.visitConstant(this, term);
    }

    @Override
    @NotNull
    public String visitEmpty(@NotNull Empty term) {
        return TermFormatter.DefaultImpls.visitEmpty(this, term);
    }

    @Override
    @NotNull
    public String visitEmptyBlock(@NotNull EmptyBlock term) {
        return TermFormatter.DefaultImpls.visitEmptyBlock(this, term);
    }

    @Override
    @NotNull
    public String visitInteger(@NotNull Integer term) {
        return TermFormatter.DefaultImpls.visitInteger(this, term);
    }

    @Override
    @NotNull
    public String visitNumeric(@NotNull Numeric term) {
        return TermFormatter.DefaultImpls.visitNumeric(this, term);
    }

    @Override
    @NotNull
    public String visitReal(@NotNull Real term) {
        return TermFormatter.DefaultImpls.visitReal(this, term);
    }

    @Override
    @NotNull
    public String visitTerm(@NotNull Term term) {
        return TermFormatter.DefaultImpls.visitTerm(this, term);
    }

    @Override
    @NotNull
    public String visitTruth(@NotNull Truth term) {
        return TermFormatter.DefaultImpls.visitTruth(this, term);
    }

    @Override
    @NotNull
    public String visitVar(@NotNull Var term) {
        return TermFormatter.DefaultImpls.visitVar(this, term);
    }

    @Override
    @NotNull
    public String format(@NotNull Term value) {
        return TermFormatter.DefaultImpls.format(this, value);
    }

    public AbstractTermFormatter() {
        this(false, false, false, 7, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lit/unibo/tuprolog/core/impl/AbstractTermFormatter$Companion;", "", "()V", "A_INDEX", "", "TWENTY_SIX", "Lorg/gciatto/kt/math/BigInteger;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

