"use strict";
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.AmazonMQMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class AmazonMQMetrics {
    static cpuUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/AmazonMQ',
            metricName: 'CpuUtilization',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static currentConnectionsCountSum(dimensions) {
        return {
            namespace: 'AWS/AmazonMQ',
            metricName: 'CurrentConnectionsCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static cpuCreditBalanceHeapUsageMaximum(dimensions) {
        return {
            namespace: 'AWS/AmazonMQ',
            metricName: 'CpuCreditBalanceHeapUsage',
            dimensionsMap: dimensions,
            statistic: 'Maximum',
        };
    }
    static networkInSum(dimensions) {
        return {
            namespace: 'AWS/AmazonMQ',
            metricName: 'NetworkIn',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static networkOutSum(dimensions) {
        return {
            namespace: 'AWS/AmazonMQ',
            metricName: 'NetworkOut',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static totalConsumerCountSum(dimensions) {
        return {
            namespace: 'AWS/AmazonMQ',
            metricName: 'TotalConsumerCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static totalMessageCountSum(dimensions) {
        return {
            namespace: 'AWS/AmazonMQ',
            metricName: 'TotalMessageCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static totalProducerCountSum(dimensions) {
        return {
            namespace: 'AWS/AmazonMQ',
            metricName: 'TotalProducerCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
}
exports.AmazonMQMetrics = AmazonMQMetrics;
//# sourceMappingURL=data:application/json;base64,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