/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.unify;

import it.unibo.tuprolog.core.Substitution;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.unify.AbstractUnificator;
import it.unibo.tuprolog.unify.Equation;
import it.unibo.tuprolog.unify.UnificationUtils;
import it.unibo.tuprolog.unify.Unificator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H$J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J \u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u000fH\u0016J \u0010!\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000fH\u0016J\u001e\u0010!\u001a\u00020\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010 \u001a\u00020\u000fH\u0002J\"\u0010\"\u001a\b\u0012\u0004\u0012\u0002H#0\u0012\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0\u001aH\u0002J\u0018\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0017H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006)"}, d2={"Lit/unibo/tuprolog/unify/AbstractUnificator;", "Lit/unibo/tuprolog/unify/Unificator;", "context", "Lit/unibo/tuprolog/core/Substitution;", "(Lit/unibo/tuprolog/core/Substitution;)V", "getContext", "()Lit/unibo/tuprolog/core/Substitution;", "contextEquations", "", "Lit/unibo/tuprolog/unify/Equation;", "getContextEquations", "()Ljava/lang/Iterable;", "contextEquations$delegate", "Lkotlin/Lazy;", "applySubstitutionToEquations", "", "substitution", "equations", "", "exceptIndex", "", "checkTermsEquality", "first", "Lit/unibo/tuprolog/core/Term;", "second", "equationsFor", "Lkotlin/sequences/Sequence;", "substitution1", "substitution2", "term1", "term2", "merge", "occurCheckEnabled", "mgu", "newDeque", "T", "items", "occurrenceCheck", "variable", "Lit/unibo/tuprolog/core/Var;", "term", "unify"})
public abstract class AbstractUnificator
implements Unificator {
    @NotNull
    private final Substitution context;
    @NotNull
    private final Lazy contextEquations$delegate;

    @JvmOverloads
    public AbstractUnificator(@NotNull Substitution context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        this.contextEquations$delegate = LazyKt.lazy((Function0)new Function0<List<? extends Equation>>(this){
            final /* synthetic */ AbstractUnificator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<Equation> invoke() {
                return UnificationUtils.toEquations(this.this$0.getContext());
            }
        });
    }

    public /* synthetic */ AbstractUnificator(Substitution substitution, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            substitution = Substitution.Companion.empty();
        }
        this(substitution);
    }

    @Override
    @NotNull
    public Substitution getContext() {
        return this.context;
    }

    private final Iterable<Equation> getContextEquations() {
        Lazy lazy = this.contextEquations$delegate;
        boolean bl = false;
        return (Iterable)lazy.getValue();
    }

    protected abstract boolean checkTermsEquality(@NotNull Term var1, @NotNull Term var2);

    private final boolean occurrenceCheck(Var variable, Term term) {
        boolean bl;
        block5: {
            if (term.isVar()) {
                bl = this.checkTermsEquality(variable, term);
            } else if (term.isStruct()) {
                Sequence<Var> $this$any$iv = term.getVariables();
                boolean $i$f$any = false;
                Iterator<Var> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Var element$iv;
                    Var it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!this.occurrenceCheck(variable, it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final Sequence<Equation> equationsFor(Term term1, Term term2) {
        return Equation.Companion.allOf(term1, term2, (Function2<? super Term, ? super Term, Boolean>)new Function2<Term, Term, Boolean>(this){

            public final boolean invoke(@NotNull Term p0, @NotNull Term p1) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                return ((AbstractUnificator)this.receiver).checkTermsEquality(p0, p1);
            }
        });
    }

    private final Sequence<Equation> equationsFor(Substitution substitution1, Substitution substitution2) {
        return Equation.Companion.from$default(Equation.Companion, SequencesKt.map(SequencesKt.plus(MapsKt.asSequence(substitution1), MapsKt.asSequence(substitution2)), equationsFor.2.INSTANCE), null, 2, null);
    }

    private final boolean applySubstitutionToEquations(Substitution substitution, List<Equation> equations, int exceptIndex) {
        int n;
        Ref.BooleanRef changed = new Ref.BooleanRef();
        int n2 = 0;
        if (n2 < exceptIndex) {
            do {
                int i = n2++;
                AbstractUnificator.applySubstitutionToEquations$handleIndex(equations, substitution, this, changed, i);
            } while (n2 < exceptIndex);
        }
        if ((n2 = exceptIndex + 1) < (n = equations.size())) {
            do {
                int i = n2++;
                AbstractUnificator.applySubstitutionToEquations$handleIndex(equations, substitution, this, changed, i);
            } while (n2 < n);
        }
        return changed.element;
    }

    /*
     * WARNING - void declaration
     */
    private final Substitution mgu(List<Equation> equations, boolean occurCheckEnabled) {
        void $this$filterTo$iv$iv;
        Iterator<Equation> assignment;
        boolean changed = true;
        while (changed) {
            changed = false;
            ListIterator<Equation> eqIterator = equations.listIterator();
            while (eqIterator.hasNext()) {
                Equation eq = eqIterator.next();
                if (eq.isContradiction()) {
                    return Substitution.Companion.failed();
                }
                if (eq.isIdentity()) {
                    eqIterator.remove();
                    changed = true;
                    continue;
                }
                if (eq.isAssignment()) {
                    assignment = eq.castToAssignment();
                    if (occurCheckEnabled && this.occurrenceCheck(((Equation.Assignment)((Object)assignment)).getLhs(), eq.getRhs())) {
                        return Substitution.Companion.failed();
                    }
                    changed = changed || this.applySubstitutionToEquations(((Equation.Assignment)((Object)assignment)).toSubstitution(), equations, eqIterator.previousIndex());
                    continue;
                }
                if (!eq.isComparison()) continue;
                eqIterator.remove();
                assignment = this.equationsFor(eq.getLhs(), eq.getRhs()).iterator();
                while (assignment.hasNext()) {
                    Equation it = assignment.next();
                    if (it.isIdentity()) continue;
                    if (it.isContradiction()) {
                        return Substitution.Companion.failed();
                    }
                    eqIterator.add(it);
                }
                changed = true;
            }
        }
        Iterable $this$filter$iv = equations;
        boolean $i$f$filter = false;
        assignment = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Equation it = (Equation)element$iv$iv;
            boolean bl = false;
            if (!it.isAssignment()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return UnificationUtils.toSubstitution((List)destination$iv$iv);
    }

    @Override
    @NotNull
    public Substitution mgu(@NotNull Term term1, @NotNull Term term2, boolean occurCheckEnabled) {
        Intrinsics.checkNotNullParameter(term1, "term1");
        Intrinsics.checkNotNullParameter(term2, "term2");
        if (this.getContext().isFailed()) {
            return Substitution.Companion.failed();
        }
        List<Equation> equations = this.newDeque(SequencesKt.plus(CollectionsKt.asSequence(this.getContextEquations()), this.equationsFor(term1, term2)));
        return this.mgu(equations, occurCheckEnabled);
    }

    @Override
    @NotNull
    public Substitution merge(@NotNull Substitution substitution1, @NotNull Substitution substitution2, boolean occurCheckEnabled) {
        Intrinsics.checkNotNullParameter(substitution1, "substitution1");
        Intrinsics.checkNotNullParameter(substitution2, "substitution2");
        if (this.getContext().isFailed()) {
            return Substitution.Companion.failed();
        }
        List<Equation> equations = this.newDeque(SequencesKt.plus(CollectionsKt.asSequence(this.getContextEquations()), this.equationsFor(substitution1, substitution2)));
        return this.mgu(equations, occurCheckEnabled);
    }

    private final <T> List<T> newDeque(Sequence<? extends T> items2) {
        boolean bl = false;
        return (List)SequencesKt.toCollection(items2, (Collection)new ArrayList());
    }

    @Override
    public boolean match(@NotNull Term term1, @NotNull Term term2) {
        return Unificator.DefaultImpls.match(this, term1, term2);
    }

    @Override
    public boolean match(@NotNull Term term1, @NotNull Term term2, boolean occurCheckEnabled) {
        return Unificator.DefaultImpls.match(this, term1, term2, occurCheckEnabled);
    }

    @Override
    @NotNull
    public Substitution merge(@NotNull Substitution substitution1, @NotNull Substitution substitution2) {
        return Unificator.DefaultImpls.merge(this, substitution1, substitution2);
    }

    @Override
    @NotNull
    public Substitution mgu(@NotNull Term term1, @NotNull Term term2) {
        return Unificator.DefaultImpls.mgu(this, term1, term2);
    }

    @Override
    @Nullable
    public Term unify(@NotNull Term term1, @NotNull Term term2) {
        return Unificator.DefaultImpls.unify(this, term1, term2);
    }

    @Override
    @Nullable
    public Term unify(@NotNull Term term1, @NotNull Term term2, boolean occurCheckEnabled) {
        return Unificator.DefaultImpls.unify(this, term1, term2, occurCheckEnabled);
    }

    @JvmOverloads
    public AbstractUnificator() {
        this(null, 1, null);
    }

    private static final void applySubstitutionToEquations$handleIndex(List<Equation> $equations, Substitution $substitution, AbstractUnificator this$0, Ref.BooleanRef changed, int i) {
        if ($equations.get(i).isContradiction() || $equations.get(i).isIdentity()) {
            return;
        }
        Equation currentEq = $equations.get(i);
        Pair<Term, Term> pair2 = Equation.apply$default(currentEq, $substitution, null, 2, null).toPair();
        Term newLhs = pair2.component1();
        Term newRhs = pair2.component2();
        if (!Intrinsics.areEqual(currentEq.getLhs(), newLhs) || !Intrinsics.areEqual(currentEq.getRhs(), newRhs)) {
            $equations.set(i, Equation.Companion.of(newLhs, newRhs, (Function2<? super Term, ? super Term, Boolean>)new Function2<Term, Term, Boolean>(this$0){

                public final boolean invoke(@NotNull Term p0, @NotNull Term p1) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    Intrinsics.checkNotNullParameter(p1, "p1");
                    return ((AbstractUnificator)this.receiver).checkTermsEquality(p0, p1);
                }
            }));
            changed.element = true;
        }
    }
}

