/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.ui.repl;

import com.github.ajalt.clikt.core.ProgramResult;
import com.github.ajalt.clikt.output.CliktConsoleJVMKt;
import com.github.ajalt.clikt.output.TermUi;
import it.unibo.tuprolog.core.FormatterExtensions;
import it.unibo.tuprolog.core.operators.OperatorSet;
import it.unibo.tuprolog.core.parsing.ParseException;
import it.unibo.tuprolog.solve.Solution;
import it.unibo.tuprolog.solve.SolutionFormatter;
import it.unibo.tuprolog.solve.exception.HaltException;
import it.unibo.tuprolog.solve.exception.ResolutionException;
import it.unibo.tuprolog.ui.repl.NullInputException;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\f\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0016\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002\u00a8\u0006\u001d"}, d2={"Lit/unibo/tuprolog/ui/repl/TuPrologUtils;", "", "()V", "printEndOfSolutions", "", "printHaltSolution", "sol", "Lit/unibo/tuprolog/solve/Solution$Halt;", "operatorSet", "Lit/unibo/tuprolog/core/operators/OperatorSet;", "printNoSolution", "Lit/unibo/tuprolog/solve/Solution$No;", "printNumSolutions", "solutions", "", "Lit/unibo/tuprolog/solve/Solution;", "maxSolutions", "", "printParseException", "e", "Lit/unibo/tuprolog/core/parsing/ParseException;", "printSolution", "printSolutions", "printYesSolution", "Lit/unibo/tuprolog/solve/Solution$Yes;", "readQuery", "", "readQueryMultiline", "query", "repl"})
public final class TuPrologUtils {
    @NotNull
    public static final TuPrologUtils INSTANCE = new TuPrologUtils();

    private TuPrologUtils() {
    }

    private final void printSolution(Solution sol, OperatorSet operatorSet2) {
        Solution solution = sol;
        if (solution instanceof Solution.Yes) {
            this.printYesSolution((Solution.Yes)sol, operatorSet2);
        } else if (solution instanceof Solution.No) {
            this.printNoSolution((Solution.No)sol, operatorSet2);
        } else if (solution instanceof Solution.Halt) {
            this.printHaltSolution((Solution.Halt)sol, operatorSet2);
        }
    }

    private final void printYesSolution(Solution.Yes sol, OperatorSet operatorSet2) {
        TermUi.echo$default(TermUi.INSTANCE, FormatterExtensions.format(sol, SolutionFormatter.Companion.withOperators(operatorSet2)), false, false, null, null, 30, null);
    }

    private final void printHaltSolution(Solution.Halt sol, OperatorSet operatorSet2) {
        ResolutionException ex = sol.getException();
        if (ex instanceof HaltException) {
            TermUi.echo$default(TermUi.INSTANCE, "goodbye.", false, false, null, null, 30, null);
            throw new ProgramResult(((HaltException)ex).getExitStatus());
        }
        TermUi.echo$default(TermUi.INSTANCE, FormatterExtensions.format(sol, SolutionFormatter.Companion.withOperators(operatorSet2)), false, false, null, null, 30, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void printParseException(@NotNull ParseException e) {
        String string2;
        Intrinsics.checkNotNullParameter(e, "e");
        TermUi termUi = TermUi.INSTANCE;
        String string3 = "# ";
        String string4 = e.getMessage();
        if (string4 == null) {
            string2 = null;
        } else {
            String string5 = string4;
            boolean bl = false;
            CharSequence charSequence = string5;
            int n = 0;
            if (charSequence.length() > 0) {
                void it;
                char c = string5.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                String string6 = string3;
                TermUi termUi2 = termUi;
                boolean bl2 = false;
                void var9_12 = it;
                boolean bl3 = false;
                String string7 = Character.isLowerCase((char)var9_12) ? CharsKt.titlecase((char)it) : String.valueOf((char)it);
                termUi = termUi2;
                string3 = string6;
                StringBuilder stringBuilder2 = stringBuilder.append(string7.toString());
                charSequence = string5;
                n = 1;
                c = '\u0000';
                String string8 = ((String)charSequence).substring(n);
                Intrinsics.checkNotNullExpressionValue(string8, "(this as java.lang.String).substring(startIndex)");
                string2 = stringBuilder2.append(string8).toString();
            } else {
                string2 = string5;
            }
        }
        TermUi.echo$default(termUi, Intrinsics.stringPlus(string3, string2), false, true, null, null, 26, null);
    }

    private final void printEndOfSolutions() {
    }

    @NotNull
    public final String readQuery() {
        String query2 = TermUi.prompt$default(TermUi.INSTANCE, "?-", null, false, false, null, " ", false, 94, null);
        if (query2 == null) {
            throw new NullInputException("The standard input has been close unexpectedly");
        }
        String string2 = query2;
        boolean bl = false;
        return StringsKt.endsWith$default((CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString(), '.', false, 2, null) ? query2 : this.readQueryMultiline(query2);
    }

    private final String readQueryMultiline(String query2) {
        String string2;
        StringBuilder longQuery = new StringBuilder(query2);
        String lastRead = query2;
        while (true) {
            string2 = lastRead;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            if (StringsKt.endsWith$default((CharSequence)((Object)StringsKt.trim((CharSequence)string3)).toString(), '.', false, 2, null)) break;
            string2 = TermUi.prompt$default(TermUi.INSTANCE, ">", null, false, false, null, " ", false, 94, null);
            if (string2 == null) {
                throw new NullInputException("The standard input has been closed unexpectedly");
            }
            lastRead = string2;
            longQuery.append(lastRead);
        }
        string2 = longQuery.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "longQuery.toString()");
        return string2;
    }

    private final void printNoSolution(Solution.No sol, OperatorSet operatorSet2) {
        TermUi.echo$default(TermUi.INSTANCE, FormatterExtensions.format(sol, SolutionFormatter.Companion.withOperators(operatorSet2)), false, false, null, null, 30, null);
    }

    public final void printSolutions(@NotNull Iterator<? extends Solution> solutions2, @NotNull OperatorSet operatorSet2) {
        Intrinsics.checkNotNullParameter(solutions2, "solutions");
        Intrinsics.checkNotNullParameter(operatorSet2, "operatorSet");
        boolean first = true;
        while (solutions2.hasNext()) {
            if (!first) {
                String cmd;
                String string2;
                String string3 = CliktConsoleJVMKt.defaultCliktConsole().promptForLine("", false);
                if (string3 == null) {
                    string2 = null;
                } else {
                    String string4 = string3;
                    boolean bl = false;
                    string2 = cmd = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                }
                if (!Intrinsics.areEqual(cmd, ";")) {
                    break;
                }
            } else {
                first = false;
            }
            this.printSolution(solutions2.next(), operatorSet2);
        }
        this.printEndOfSolutions();
    }

    public final void printNumSolutions(@NotNull Iterator<? extends Solution> solutions2, int maxSolutions, @NotNull OperatorSet operatorSet2) {
        Intrinsics.checkNotNullParameter(solutions2, "solutions");
        Intrinsics.checkNotNullParameter(operatorSet2, "operatorSet");
        int i = 0;
        while (i < maxSolutions && solutions2.hasNext()) {
            int n = i;
            i = n + 1;
            this.printSolution(solutions2.next(), operatorSet2);
        }
        this.printEndOfSolutions();
    }
}

