/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.core.impl;

import it.unibo.tuprolog.core.Block;
import it.unibo.tuprolog.core.BlockIterator;
import it.unibo.tuprolog.core.Scope;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.TermVisitor;
import it.unibo.tuprolog.core.impl.BlockUnfolder;
import it.unibo.tuprolog.core.impl.RecursiveImpl;
import it.unibo.tuprolog.utils.Taggable;
import it.unibo.tuprolog.utils.TaggableExtensions;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ!\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u000eH\u0014J\u001c\u0010\u001e\u001a\u00020\u00022\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0014J\b\u0010\u001f\u001a\u00020\u0002H\u0016J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0007H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u0016R\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000fR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lit/unibo/tuprolog/core/impl/BlockImpl;", "Lit/unibo/tuprolog/core/impl/RecursiveImpl;", "Lit/unibo/tuprolog/core/Block;", "item", "Lit/unibo/tuprolog/core/Term;", "tags", "", "", "", "(Lit/unibo/tuprolog/core/Term;Ljava/util/Map;)V", "functor", "getFunctor", "()Ljava/lang/String;", "isGround", "", "()Z", "size", "", "getSize", "()I", "unfoldedSequence", "Lkotlin/sequences/Sequence;", "getUnfoldedSequence", "()Lkotlin/sequences/Sequence;", "accept", "T", "visitor", "Lit/unibo/tuprolog/core/TermVisitor;", "(Lit/unibo/tuprolog/core/TermVisitor;)Ljava/lang/Object;", "checkGroundness", "copyWithTags", "freshCopy", "scope", "Lit/unibo/tuprolog/core/Scope;", "toString", "unfold", "core"})
public class BlockImpl
extends RecursiveImpl
implements Block {
    @Nullable
    private final Term item;
    private final boolean isGround;
    @NotNull
    private final String functor;

    public BlockImpl(@Nullable Term item, @NotNull Map<String, ? extends Object> tags) {
        Intrinsics.checkNotNullParameter(tags, "tags");
        super("{}", CollectionsKt.listOfNotNull(item), tags);
        this.item = item;
        this.isGround = this.checkGroundness();
        this.functor = Block.DefaultImpls.getFunctor(this);
    }

    public /* synthetic */ BlockImpl(Term term, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(term, map);
    }

    @Override
    public boolean isGround() {
        return this.isGround;
    }

    @Override
    protected boolean checkGroundness() {
        boolean bl;
        Term term = this.item;
        return term == null ? true : (bl = term.isGround());
    }

    @Override
    @NotNull
    public String getFunctor() {
        return this.functor;
    }

    @Override
    @NotNull
    public Sequence<Term> getUnfoldedSequence() {
        boolean bl = false;
        return CollectionsKt.asSequence((Iterable)new Iterable<Term>(this){
            final /* synthetic */ BlockImpl this$0;
            {
                this.this$0 = blockImpl;
            }

            @NotNull
            public Iterator<Term> iterator() {
                boolean bl = false;
                return new BlockIterator(this.this$0);
            }
        });
    }

    @Override
    public int getSize() {
        return this.getUnfoldedList().size();
    }

    @Override
    @NotNull
    public Sequence<Term> unfold() {
        boolean bl = false;
        return CollectionsKt.asSequence((Iterable)new Iterable<Term>(this){
            final /* synthetic */ BlockImpl this$0;
            {
                this.this$0 = blockImpl;
            }

            @NotNull
            public Iterator<Term> iterator() {
                boolean bl = false;
                return new BlockUnfolder(this.this$0);
            }
        });
    }

    @Override
    @NotNull
    public String toString() {
        return SequencesKt.joinToString$default(this.getUnfoldedSequence(), ", ", "{", "}", 0, null, null, 56, null);
    }

    @Override
    @NotNull
    protected Block copyWithTags(@NotNull Map<String, ? extends Object> tags) {
        Intrinsics.checkNotNullParameter(tags, "tags");
        return new BlockImpl(this.item, tags);
    }

    @Override
    @NotNull
    public Block freshCopy() {
        return super.freshCopy().castToBlock();
    }

    @Override
    @NotNull
    public Block freshCopy(@NotNull Scope scope2) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        return this.isGround() ? (Block)this : (Block)TaggableExtensions.setTags((Taggable)scope2.blockOf(SequencesKt.map(this.getArgsSequence(), (Function1)new Function1<Term, Term>(scope2){
            final /* synthetic */ Scope $scope;
            {
                this.$scope = $scope;
                super(1);
            }

            @NotNull
            public final Term invoke(@NotNull Term it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.freshCopy(this.$scope);
            }
        })), this.getTags());
    }

    @Override
    public <T> T accept(@NotNull TermVisitor<T> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitBlock(this);
    }

    @Override
    @NotNull
    public Term[] toArray() {
        return Block.DefaultImpls.toArray(this);
    }

    @Override
    @NotNull
    public List<Term> toList() {
        return Block.DefaultImpls.toList(this);
    }

    @Override
    @NotNull
    public Sequence<Term> toSequence() {
        return Block.DefaultImpls.toSequence(this);
    }

    @Override
    public boolean isBlock() {
        return Block.DefaultImpls.isBlock(this);
    }

    @Override
    public boolean isEmptyBlock() {
        return Block.DefaultImpls.isEmptyBlock(this);
    }

    @Override
    @NotNull
    public Block asBlock() {
        return Block.DefaultImpls.asBlock(this);
    }
}

