"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineDeployStackAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cfn = require("@aws-cdk/aws-cloudformation");
const cpactions = require("@aws-cdk/aws-codepipeline-actions");
const cxschema = require("@aws-cdk/cloud-assembly-schema");
const cdk = require("@aws-cdk/core");
/**
 * (deprecated) A class to deploy a stack that is part of a CDK App, using CodePipeline.
 *
 * This composite Action takes care of preparing and executing a CloudFormation ChangeSet.
 *
 * It currently does *not* support stacks that make use of ``Asset``s, and
 * requires the deployed stack is in the same account and region where the
 * CodePipeline is hosted.
 *
 * @deprecated
 */
class PipelineDeployStackAction {
    /**
     * @deprecated
     */
    constructor(props) {
        var _b, _c;
        jsiiDeprecationWarnings.print("@aws-cdk/app-delivery.PipelineDeployStackAction", "");
        jsiiDeprecationWarnings._aws_cdk_app_delivery_PipelineDeployStackActionProps(props);
        this.stack = props.stack;
        const assets = this.stack.node.metadata.filter(md => md.type === cxschema.ArtifactMetadataEntryType.ASSET);
        if (assets.length > 0) {
            // FIXME: Implement the necessary actions to publish assets
            throw new Error(`Cannot deploy the stack ${this.stack.stackName} because it references ${assets.length} asset(s)`);
        }
        const createChangeSetRunOrder = props.createChangeSetRunOrder || 1;
        const executeChangeSetRunOrder = props.executeChangeSetRunOrder || (createChangeSetRunOrder + 1);
        if (createChangeSetRunOrder >= executeChangeSetRunOrder) {
            throw new Error(`createChangeSetRunOrder (${createChangeSetRunOrder}) must be < executeChangeSetRunOrder (${executeChangeSetRunOrder})`);
        }
        const changeSetName = props.changeSetName || 'CDK-CodePipeline-ChangeSet';
        const capabilities = cfnCapabilities(props.adminPermissions, props.capabilities);
        this.prepareChangeSetAction = new cpactions.CloudFormationCreateReplaceChangeSetAction({
            actionName: (_b = props.createChangeSetActionName) !== null && _b !== void 0 ? _b : 'ChangeSet',
            changeSetName,
            runOrder: createChangeSetRunOrder,
            stackName: props.stack.stackName,
            templatePath: props.input.atPath(props.stack.templateFile),
            adminPermissions: props.adminPermissions,
            deploymentRole: props.role,
            capabilities,
        });
        this.executeChangeSetAction = new cpactions.CloudFormationExecuteChangeSetAction({
            actionName: (_c = props.executeChangeSetActionName) !== null && _c !== void 0 ? _c : 'Execute',
            changeSetName,
            runOrder: executeChangeSetRunOrder,
            stackName: this.stack.stackName,
        });
    }
    /**
     * (deprecated) The callback invoked when this Action is added to a Pipeline.
     *
     * @deprecated
     */
    bind(scope, stage, options) {
        jsiiDeprecationWarnings.print("@aws-cdk/app-delivery.PipelineDeployStackAction#bind", "");
        if (this.stack.environment !== cdk.Stack.of(scope).environment) {
            // FIXME: Add the necessary to extend to stacks in a different account
            throw new Error('Cross-environment deployment is not supported');
        }
        stage.addAction(this.prepareChangeSetAction);
        this._deploymentRole = this.prepareChangeSetAction.deploymentRole;
        return this.executeChangeSetAction.bind(scope, stage, options);
    }
    /**
     * @deprecated
     */
    get deploymentRole() {
        jsiiDeprecationWarnings.print("@aws-cdk/app-delivery.PipelineDeployStackAction#deploymentRole", "");
        if (!this._deploymentRole) {
            throw new Error('Use this action in a pipeline first before accessing \'deploymentRole\'');
        }
        return this._deploymentRole;
    }
    /**
     * (deprecated) Add policy statements to the role deploying the stack.
     *
     * This role is passed to CloudFormation and must have the IAM permissions
     * necessary to deploy the stack or you can grant this role `adminPermissions`
     * by using that option during creation. If you do not grant
     * `adminPermissions` you need to identify the proper statements to add to
     * this role based on the CloudFormation Resources in your stack.
     *
     * @deprecated
     */
    addToDeploymentRolePolicy(statement) {
        jsiiDeprecationWarnings.print("@aws-cdk/app-delivery.PipelineDeployStackAction#addToDeploymentRolePolicy", "");
        this.deploymentRole.addToPolicy(statement);
    }
    /**
     * (deprecated) Creates an Event that will be triggered whenever the state of this Action changes.
     *
     * @deprecated
     */
    onStateChange(name, target, options) {
        jsiiDeprecationWarnings.print("@aws-cdk/app-delivery.PipelineDeployStackAction#onStateChange", "");
        return this.executeChangeSetAction.onStateChange(name, target, options);
    }
    /**
     * (deprecated) The simple properties of the Action, like its Owner, name, etc.
     *
     * Note that this accessor will be called before the {@link bind} callback.
     *
     * @deprecated
     */
    get actionProperties() {
        jsiiDeprecationWarnings.print("@aws-cdk/app-delivery.PipelineDeployStackAction#actionProperties", "");
        return this.executeChangeSetAction.actionProperties;
    }
}
exports.PipelineDeployStackAction = PipelineDeployStackAction;
_a = JSII_RTTI_SYMBOL_1;
PipelineDeployStackAction[_a] = { fqn: "@aws-cdk/app-delivery.PipelineDeployStackAction", version: "1.144.0" };
function cfnCapabilities(adminPermissions, capabilities) {
    if (adminPermissions && capabilities === undefined) {
        // admin true default capability to NamedIAM and AutoExpand
        return [cfn.CloudFormationCapabilities.NAMED_IAM, cfn.CloudFormationCapabilities.AUTO_EXPAND];
    }
    else if (capabilities === undefined) {
        // else capabilities are undefined set AnonymousIAM and AutoExpand
        return [cfn.CloudFormationCapabilities.ANONYMOUS_IAM, cfn.CloudFormationCapabilities.AUTO_EXPAND];
    }
    else {
        // else capabilities are defined use them
        return capabilities;
    }
}
//# sourceMappingURL=data:application/json;base64,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