import os
import re
from pathlib import Path

from setuptools import setup, find_packages #type: ignore

HERE = Path(__file__).parent
_version_file_contents = (HERE / "approvaltests" / "version.py").read_text()
matched = re.search(r'"(.*)"', _version_file_contents)
VERSION = matched.group(1) if matched is not None else "UNKNOWN VERSION"

with open(HERE / 'requirements.prod.required.txt') as f:
    required = f.read().splitlines()

setup(
    name="approvaltests-minimal",
    version=VERSION,
    description="Assertion/verification library to aid testing with the minimal required dependencies + the ability to opt in for the others ",
    author="ApprovalTests Contributors",
    author_email="llewellyn.falco@gmail.com",
    url="https://github.com/approvals/ApprovalTests.Python",
    python_requires=">=3.6.1",
    packages=find_packages(exclude=["tests*"]),
    package_data={"approvaltests": ["reporters/reporters.json"]},
    install_requires=required,
    extras_require={
        "ClipboardReporter": ["pyperclip"],
        "verify_html": ["beautifulsoup4"],
        "PairwiseCombinations": ["allpairspy"]
    },
    long_description=(HERE / "README.md").read_text(),
    long_description_content_type="text/markdown",
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: Apache Software License",
        "Operating System :: POSIX",
        "Operating System :: Microsoft :: Windows",
        "Operating System :: MacOS :: MacOS X",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Topic :: Software Development :: Libraries",
        "Topic :: Software Development :: Testing",
        "Topic :: Utilities",
    ],
)
