# Generated by Django 2.2.16 on 2020-11-01 19:35

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AmigoSecretoState',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('activated', models.BooleanField(default=False)),
                ('start_date', models.DateTimeField(null=True)),
                ('end_date', models.DateTimeField(null=True)),
                ('premio_minimo', models.BigIntegerField(null=True)),
                ('premio_maximo', models.BigIntegerField(null=True)),
            ],
            options={
                'db_table': 'amigosecretostate',
            },
        ),
        migrations.CreateModel(
            name='DisabledCommand',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.TextField(unique=True, verbose_name='Nome')),
            ],
            options={
                'db_table': 'disabled_command',
            },
        ),
        migrations.CreateModel(
            name='DiscordUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('updated', models.DateTimeField(default=django.utils.timezone.now)),
                ('warning_date', models.DateTimeField(blank=True, null=True)),
                ('disabled', models.BooleanField(default=False)),
                ('ingame_name', models.TextField(unique=True)),
                ('discord_id', models.TextField()),
                ('discord_name', models.TextField()),
            ],
            options={
                'db_table': 'user',
            },
        ),
        migrations.CreateModel(
            name='Doacao',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('doador_name', models.TextField(max_length=12)),
                ('date', models.DateTimeField(default=django.utils.timezone.now)),
                ('ammount', models.BigIntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='DoacaoGoal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('goal', models.BigIntegerField()),
                ('active', models.BooleanField(default=False)),
                ('name', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='RaidsState',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('notifications', models.BooleanField(default=False, verbose_name='Notificações')),
                ('time_to_next_message', models.TextField(null=True, verbose_name='Próxima Mensagem')),
            ],
            options={
                'db_table': 'raidsstate',
            },
        ),
        migrations.CreateModel(
            name='DiscordIngameName',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.TextField(verbose_name='Nome RuneScape')),
                ('created_date', models.DateTimeField(default=django.utils.timezone.now)),
                ('user', models.ForeignKey(db_column='user', on_delete=django.db.models.deletion.CASCADE, related_name='ingame_names', to='atlantisbot_api.DiscordUser', verbose_name='Usuário')),
            ],
            options={
                'db_table': 'ingame_name',
            },
        ),
        migrations.CreateModel(
            name='AmigoSecretoPerson',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('receiving', models.BooleanField(default=False)),
                ('giving_to_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='giving_to_discord_user', to='atlantisbot_api.DiscordUser', verbose_name='Presenteando')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='discord_user', to='atlantisbot_api.DiscordUser', verbose_name='Usuário')),
            ],
            options={
                'db_table': 'amigosecreto',
            },
        ),
    ]
