"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Resolver = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const aws_appsync_1 = require("aws-cdk-lib/aws-appsync");
const caching_key_1 = require("./caching-key");
/**
 * (experimental) An AppSync resolver.
 *
 * @experimental
 */
class Resolver extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_ResolverProps(props);
        const pipelineConfig = props.pipelineConfig && props.pipelineConfig.length ?
            { functions: props.pipelineConfig.map((func) => func.functionId) }
            : undefined;
        if (pipelineConfig && props.dataSource) {
            throw new Error(`Pipeline Resolver cannot have data source. Received: ${props.dataSource.name}`);
        }
        if (((_b = props.cachingConfig) === null || _b === void 0 ? void 0 : _b.ttl) && (props.cachingConfig.ttl.toSeconds() < 1 || props.cachingConfig.ttl.toSeconds() > 3600)) {
            throw new Error(`Caching config TTL must be between 1 and 3600 seconds. Received: ${props.cachingConfig.ttl.toSeconds()}`);
        }
        if ((_c = props.cachingConfig) === null || _c === void 0 ? void 0 : _c.cachingKeys) {
            if (props.cachingConfig.cachingKeys.find(cachingKey => !aws_cdk_lib_1.Token.isUnresolved(cachingKey) && !caching_key_1.BASE_CACHING_KEYS.find(baseCachingKey => cachingKey.startsWith(baseCachingKey)))) {
                throw new Error(`Caching config keys must begin with $context.arguments, $context.source or $context.identity. Received: ${props.cachingConfig.cachingKeys}`);
            }
        }
        this.resolver = new aws_appsync_1.CfnResolver(this, 'Resource', {
            apiId: props.api.apiId,
            typeName: props.typeName,
            fieldName: props.fieldName,
            dataSourceName: props.dataSource ? props.dataSource.name : undefined,
            kind: pipelineConfig ? 'PIPELINE' : 'UNIT',
            pipelineConfig: pipelineConfig,
            requestMappingTemplate: props.requestMappingTemplate ? props.requestMappingTemplate.renderTemplate() : undefined,
            responseMappingTemplate: props.responseMappingTemplate ? props.responseMappingTemplate.renderTemplate() : undefined,
            cachingConfig: this.createCachingConfig(props.cachingConfig),
        });
        props.api.addSchemaDependency(this.resolver);
        if (props.dataSource) {
            this.resolver.addDependsOn(props.dataSource.ds);
        }
        this.arn = this.resolver.attrResolverArn;
    }
    createCachingConfig(config) {
        var _b;
        return config ? {
            cachingKeys: config.cachingKeys,
            ttl: (_b = config.ttl) === null || _b === void 0 ? void 0 : _b.toSeconds(),
        } : undefined;
    }
}
exports.Resolver = Resolver;
_a = JSII_RTTI_SYMBOL_1;
Resolver[_a] = { fqn: "@aws-cdk/aws-appsync-alpha.Resolver", version: "2.2.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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