"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MappingTemplate = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
/**
 * (experimental) MappingTemplates for AppSync resolvers.
 *
 * @experimental
 */
class MappingTemplate {
    /**
     * (experimental) Create a mapping template from the given string.
     *
     * @experimental
     */
    static fromString(template) {
        return new StringMappingTemplate(template);
    }
    /**
     * (experimental) Create a mapping template from the given file.
     *
     * @experimental
     */
    static fromFile(fileName) {
        return new StringMappingTemplate(fs_1.readFileSync(fileName).toString('utf-8'));
    }
    /**
     * (experimental) Mapping template for a result list from DynamoDB.
     *
     * @experimental
     */
    static dynamoDbResultList() {
        return this.fromString('$util.toJson($ctx.result.items)');
    }
    /**
     * (experimental) Mapping template for a single result item from DynamoDB.
     *
     * @experimental
     */
    static dynamoDbResultItem() {
        return this.fromString('$util.toJson($ctx.result)');
    }
    /**
     * (experimental) Mapping template to scan a DynamoDB table to fetch all entries.
     *
     * @experimental
     */
    static dynamoDbScanTable() {
        return this.fromString('{"version" : "2017-02-28", "operation" : "Scan"}');
    }
    /**
     * (experimental) Mapping template to query a set of items from a DynamoDB table.
     *
     * @param cond the key condition for the query.
     * @experimental
     */
    static dynamoDbQuery(cond, indexName) {
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_KeyCondition(cond);
        return this.fromString(`{"version" : "2017-02-28", "operation" : "Query", ${indexName ? `"index" : "${indexName}", ` : ''}${cond.renderTemplate()}}`);
    }
    /**
     * (experimental) Mapping template to get a single item from a DynamoDB table.
     *
     * @param keyName the name of the hash key field.
     * @param idArg the name of the Query argument.
     * @experimental
     */
    static dynamoDbGetItem(keyName, idArg) {
        return this.fromString(`{"version": "2017-02-28", "operation": "GetItem", "key": {"${keyName}": $util.dynamodb.toDynamoDBJson($ctx.args.${idArg})}}`);
    }
    /**
     * (experimental) Mapping template to delete a single item from a DynamoDB table.
     *
     * @param keyName the name of the hash key field.
     * @param idArg the name of the Mutation argument.
     * @experimental
     */
    static dynamoDbDeleteItem(keyName, idArg) {
        return this.fromString(`{"version": "2017-02-28", "operation": "DeleteItem", "key": {"${keyName}": $util.dynamodb.toDynamoDBJson($ctx.args.${idArg})}}`);
    }
    /**
     * (experimental) Mapping template to save a single item to a DynamoDB table.
     *
     * @param key the assigment of Mutation values to the primary key.
     * @param values the assignment of Mutation values to the table attributes.
     * @experimental
     */
    static dynamoDbPutItem(key, values) {
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_PrimaryKey(key);
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_AttributeValues(values);
        return this.fromString(`
      ${values.renderVariables()}
      {
        "version": "2017-02-28",
        "operation": "PutItem",
        ${key.renderTemplate()},
        ${values.renderTemplate()}
      }`);
    }
    /**
     * (experimental) Mapping template to invoke a Lambda function.
     *
     * @param payload the VTL template snippet of the payload to send to the lambda.
     * @param operation the type of operation AppSync should perform on the data source.
     * @experimental
     */
    static lambdaRequest(payload = '$util.toJson($ctx)', operation = 'Invoke') {
        return this.fromString(`{"version": "2017-02-28", "operation": "${operation}", "payload": ${payload}}`);
    }
    /**
     * (experimental) Mapping template to return the Lambda result to the caller.
     *
     * @experimental
     */
    static lambdaResult() {
        return this.fromString('$util.toJson($ctx.result)');
    }
}
exports.MappingTemplate = MappingTemplate;
_a = JSII_RTTI_SYMBOL_1;
MappingTemplate[_a] = { fqn: "@aws-cdk/aws-appsync-alpha.MappingTemplate", version: "2.2.0-alpha.0" };
class StringMappingTemplate extends MappingTemplate {
    constructor(template) {
        super();
        this.template = template;
    }
    renderTemplate() {
        return this.template;
    }
}
//# sourceMappingURL=data:application/json;base64,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