"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Values = exports.AttributeValuesStep = exports.AttributeValues = exports.PartitionKey = exports.PrimaryKey = exports.SortKeyStep = exports.PartitionKeyStep = exports.Assign = exports.KeyCondition = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const private_1 = require("./private");
/**
 * (experimental) Factory class for DynamoDB key conditions.
 *
 * @experimental
 */
class KeyCondition {
    constructor(cond) {
        this.cond = cond;
    }
    /**
     * (experimental) Condition k = arg, true if the key attribute k is equal to the Query argument.
     *
     * @experimental
     */
    static eq(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '=', arg));
    }
    /**
     * (experimental) Condition k < arg, true if the key attribute k is less than the Query argument.
     *
     * @experimental
     */
    static lt(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '<', arg));
    }
    /**
     * (experimental) Condition k <= arg, true if the key attribute k is less than or equal to the Query argument.
     *
     * @experimental
     */
    static le(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '<=', arg));
    }
    /**
     * (experimental) Condition k > arg, true if the key attribute k is greater than the the Query argument.
     *
     * @experimental
     */
    static gt(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '>', arg));
    }
    /**
     * (experimental) Condition k >= arg, true if the key attribute k is greater or equal to the Query argument.
     *
     * @experimental
     */
    static ge(keyName, arg) {
        return new KeyCondition(new private_1.BinaryCondition(keyName, '>=', arg));
    }
    /**
     * (experimental) Condition (k, arg).
     *
     * True if the key attribute k begins with the Query argument.
     *
     * @experimental
     */
    static beginsWith(keyName, arg) {
        return new KeyCondition(new private_1.BeginsWith(keyName, arg));
    }
    /**
     * (experimental) Condition k BETWEEN arg1 AND arg2, true if k >= arg1 and k <= arg2.
     *
     * @experimental
     */
    static between(keyName, arg1, arg2) {
        return new KeyCondition(new private_1.Between(keyName, arg1, arg2));
    }
    /**
     * (experimental) Conjunction between two conditions.
     *
     * @experimental
     */
    and(keyCond) {
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_KeyCondition(keyCond);
        return new KeyCondition(this.cond.and(keyCond.cond));
    }
    /**
     * (experimental) Renders the key condition to a VTL string.
     *
     * @experimental
     */
    renderTemplate() {
        return `"query" : {
              "expression" : "${this.cond.renderCondition()}",
              "expressionNames" : {
                ${this.cond.renderExpressionNames()}
              },
              "expressionValues" : {
                ${this.cond.renderExpressionValues()}
              }
            }`;
    }
}
exports.KeyCondition = KeyCondition;
_a = JSII_RTTI_SYMBOL_1;
KeyCondition[_a] = { fqn: "@aws-cdk/aws-appsync-alpha.KeyCondition", version: "2.2.0-alpha.0" };
/**
 * (experimental) Utility class representing the assigment of a value to an attribute.
 *
 * @experimental
 */
class Assign {
    /**
     * @experimental
     */
    constructor(attr, arg) {
        this.attr = attr;
        this.arg = arg;
    }
    /**
     * (experimental) Renders the assignment as a VTL string.
     *
     * @experimental
     */
    renderAsAssignment() {
        return `"${this.attr}" : $util.dynamodb.toDynamoDBJson(${this.arg})`;
    }
    /**
     * (experimental) Renders the assignment as a map element.
     *
     * @experimental
     */
    putInMap(map) {
        return `$util.qr($${map}.put("${this.attr}", ${this.arg}))`;
    }
}
exports.Assign = Assign;
_b = JSII_RTTI_SYMBOL_1;
Assign[_b] = { fqn: "@aws-cdk/aws-appsync-alpha.Assign", version: "2.2.0-alpha.0" };
/**
 * (experimental) Utility class to allow assigning a value or an auto-generated id to a partition key.
 *
 * @experimental
 */
class PartitionKeyStep {
    /**
     * @experimental
     */
    constructor(key) {
        this.key = key;
    }
    /**
     * (experimental) Assign an auto-generated value to the partition key.
     *
     * @experimental
     */
    is(val) {
        return new PartitionKey(new Assign(this.key, `$ctx.args.${val}`));
    }
    /**
     * (experimental) Assign an auto-generated value to the partition key.
     *
     * @experimental
     */
    auto() {
        return new PartitionKey(new Assign(this.key, '$util.autoId()'));
    }
}
exports.PartitionKeyStep = PartitionKeyStep;
_c = JSII_RTTI_SYMBOL_1;
PartitionKeyStep[_c] = { fqn: "@aws-cdk/aws-appsync-alpha.PartitionKeyStep", version: "2.2.0-alpha.0" };
/**
 * (experimental) Utility class to allow assigning a value or an auto-generated id to a sort key.
 *
 * @experimental
 */
class SortKeyStep {
    /**
     * @experimental
     */
    constructor(pkey, skey) {
        this.pkey = pkey;
        this.skey = skey;
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_Assign(pkey);
    }
    /**
     * (experimental) Assign an auto-generated value to the sort key.
     *
     * @experimental
     */
    is(val) {
        return new PrimaryKey(this.pkey, new Assign(this.skey, `$ctx.args.${val}`));
    }
    /**
     * (experimental) Assign an auto-generated value to the sort key.
     *
     * @experimental
     */
    auto() {
        return new PrimaryKey(this.pkey, new Assign(this.skey, '$util.autoId()'));
    }
}
exports.SortKeyStep = SortKeyStep;
_d = JSII_RTTI_SYMBOL_1;
SortKeyStep[_d] = { fqn: "@aws-cdk/aws-appsync-alpha.SortKeyStep", version: "2.2.0-alpha.0" };
/**
 * (experimental) Specifies the assignment to the primary key.
 *
 * It either
 * contains the full primary key or only the partition key.
 *
 * @experimental
 */
class PrimaryKey {
    /**
     * @experimental
     */
    constructor(pkey, skey) {
        this.pkey = pkey;
        this.skey = skey;
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_Assign(pkey);
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_Assign(skey);
    }
    /**
     * (experimental) Allows assigning a value to the partition key.
     *
     * @experimental
     */
    static partition(key) {
        return new PartitionKeyStep(key);
    }
    /**
     * (experimental) Renders the key assignment to a VTL string.
     *
     * @experimental
     */
    renderTemplate() {
        const assignments = [this.pkey.renderAsAssignment()];
        if (this.skey) {
            assignments.push(this.skey.renderAsAssignment());
        }
        return `"key" : {
      ${assignments.join(',')}
    }`;
    }
}
exports.PrimaryKey = PrimaryKey;
_e = JSII_RTTI_SYMBOL_1;
PrimaryKey[_e] = { fqn: "@aws-cdk/aws-appsync-alpha.PrimaryKey", version: "2.2.0-alpha.0" };
/**
 * (experimental) Specifies the assignment to the partition key.
 *
 * It can be
 * enhanced with the assignment of the sort key.
 *
 * @experimental
 */
class PartitionKey extends PrimaryKey {
    /**
     * @experimental
     */
    constructor(pkey) {
        super(pkey);
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_Assign(pkey);
    }
    /**
     * (experimental) Allows assigning a value to the sort key.
     *
     * @experimental
     */
    sort(key) {
        return new SortKeyStep(this.pkey, key);
    }
}
exports.PartitionKey = PartitionKey;
_f = JSII_RTTI_SYMBOL_1;
PartitionKey[_f] = { fqn: "@aws-cdk/aws-appsync-alpha.PartitionKey", version: "2.2.0-alpha.0" };
/**
 * (experimental) Specifies the attribute value assignments.
 *
 * @experimental
 */
class AttributeValues {
    /**
     * @experimental
     */
    constructor(container, assignments = []) {
        this.container = container;
        this.assignments = assignments;
    }
    /**
     * (experimental) Allows assigning a value to the specified attribute.
     *
     * @experimental
     */
    attribute(attr) {
        return new AttributeValuesStep(attr, this.container, this.assignments);
    }
    /**
     * (experimental) Renders the variables required for `renderTemplate`.
     *
     * @experimental
     */
    renderVariables() {
        return `#set($input = ${this.container})
      ${this.assignments.map(a => a.putInMap('input')).join('\n')}`;
    }
    /**
     * (experimental) Renders the attribute value assingments to a VTL string.
     *
     * @experimental
     */
    renderTemplate() {
        return '"attributeValues": $util.dynamodb.toMapValuesJson($input)';
    }
}
exports.AttributeValues = AttributeValues;
_g = JSII_RTTI_SYMBOL_1;
AttributeValues[_g] = { fqn: "@aws-cdk/aws-appsync-alpha.AttributeValues", version: "2.2.0-alpha.0" };
/**
 * (experimental) Utility class to allow assigning a value to an attribute.
 *
 * @experimental
 */
class AttributeValuesStep {
    /**
     * @experimental
     */
    constructor(attr, container, assignments) {
        this.attr = attr;
        this.container = container;
        this.assignments = assignments;
    }
    /**
     * (experimental) Assign the value to the current attribute.
     *
     * @experimental
     */
    is(val) {
        this.assignments.push(new Assign(this.attr, val));
        return new AttributeValues(this.container, this.assignments);
    }
}
exports.AttributeValuesStep = AttributeValuesStep;
_h = JSII_RTTI_SYMBOL_1;
AttributeValuesStep[_h] = { fqn: "@aws-cdk/aws-appsync-alpha.AttributeValuesStep", version: "2.2.0-alpha.0" };
/**
 * (experimental) Factory class for attribute value assignments.
 *
 * @experimental
 */
class Values {
    /**
     * (experimental) Treats the specified object as a map of assignments, where the property names represent attribute names.
     *
     * It’s opinionated about how it represents
     * some of the nested objects: e.g., it will use lists (“L”) rather than sets
     * (“SS”, “NS”, “BS”). By default it projects the argument container ("$ctx.args").
     *
     * @experimental
     */
    static projecting(arg) {
        return new AttributeValues('$ctx.args' + (arg ? `.${arg}` : ''));
    }
    /**
     * (experimental) Allows assigning a value to the specified attribute.
     *
     * @experimental
     */
    static attribute(attr) {
        return new AttributeValues('{}').attribute(attr);
    }
}
exports.Values = Values;
_j = JSII_RTTI_SYMBOL_1;
Values[_j] = { fqn: "@aws-cdk/aws-appsync-alpha.Values", version: "2.2.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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