# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.0.6257, generator: {generator})
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any

from azure.core import PipelineClient
from msrest import Deserializer, Serializer

from ._configuration import SearchServiceClientConfiguration
from .operations import DataSourcesOperations
from .operations import IndexersOperations
from .operations import SkillsetsOperations
from .operations import SynonymMapsOperations
from .operations import IndexesOperations
from .operations import SearchServiceClientOperationsMixin
from . import models


class SearchServiceClient(SearchServiceClientOperationsMixin):
    """Client that can be used to manage and query indexes and documents, as well as manage other resources, on a search service.

    :ivar data_sources: DataSourcesOperations operations
    :vartype data_sources: search_service_client.operations.DataSourcesOperations
    :ivar indexers: IndexersOperations operations
    :vartype indexers: search_service_client.operations.IndexersOperations
    :ivar skillsets: SkillsetsOperations operations
    :vartype skillsets: search_service_client.operations.SkillsetsOperations
    :ivar synonym_maps: SynonymMapsOperations operations
    :vartype synonym_maps: search_service_client.operations.SynonymMapsOperations
    :ivar indexes: IndexesOperations operations
    :vartype indexes: search_service_client.operations.IndexesOperations
    :param endpoint: The endpoint URL of the search service.
    :type endpoint: str
    """

    def __init__(
        self,
        endpoint,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        base_url = '{endpoint}'
        self._config = SearchServiceClientConfiguration(endpoint, **kwargs)
        self._client = PipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.data_sources = DataSourcesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.indexers = IndexersOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.skillsets = SkillsetsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.synonym_maps = SynonymMapsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.indexes = IndexesOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> SearchServiceClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
