/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffParser;

public class EPSReader
extends FormatReader {
    private int start;
    private boolean binary;
    private boolean isTiff;
    private IFDList ifds;
    private int[] map;

    public EPSReader() {
        super("Encapsulated PostScript", new String[]{"eps", "epsi", "ps"});
        this.domains = new String[]{"Graphics"};
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            if (this.isTiff) {
                return (int)((IFD)this.ifds.get(0)).getTileWidth();
            }
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile width", e);
        }
        return super.getOptimalTileWidth();
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            if (this.isTiff) {
                return (int)((IFD)this.ifds.get(0)).getTileLength();
            }
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile height", e);
        }
        return super.getOptimalTileHeight();
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        if (this.isTiff) {
            long[] offsets = ((IFD)this.ifds.get(0)).getStripOffsets();
            long[] byteCounts = ((IFD)this.ifds.get(0)).getStripByteCounts();
            this.in.seek(offsets[0]);
            if (this.map == null) {
                this.readPlane(this.in, x, y, w, h2, buf);
                return buf;
            }
            byte[] b = new byte[w * h2];
            int bpp = (int)(byteCounts[0] / (long)(this.getSizeX() * this.getSizeY()));
            this.in.skipBytes(bpp * y * this.getSizeX());
            for (int row = 0; row < h2; ++row) {
                this.in.skipBytes(x * bpp);
                for (int col = 0; col < w; ++col) {
                    if (bpp == 1) {
                        b[row * w + col] = this.in.readByte();
                        continue;
                    }
                    if (bpp != 2) continue;
                    b[row * w + col] = (byte)(this.in.readShort() & 0xFF);
                }
                this.in.skipBytes(bpp * (this.getSizeX() - w - x));
            }
            for (int i = 0; i < b.length; ++i) {
                int ndx = b[i] & 0xFF;
                for (int j = 0; j < this.getSizeC(); ++j) {
                    if (j < 3) {
                        buf[i * this.getSizeC() + j] = (byte)(this.map[ndx + j * 256] >> 8 & 0xFF);
                        continue;
                    }
                    boolean zero = this.map[ndx] == 0 && this.map[ndx + 256] == 0 && this.map[ndx + 512] == 0;
                    buf[i * this.getSizeC() + j] = zero ? 0 : -1;
                }
            }
            return buf;
        }
        if (this.start == 0) {
            throw new FormatException("Vector data not supported.");
        }
        this.in.seek(0L);
        for (int line = 0; line <= this.start; ++line) {
            this.readLine();
        }
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        if (this.binary) {
            this.readPlane(this.in, x, y, w, h2, buf);
        } else {
            String pix = this.in.readString((int)(this.in.length() - this.in.getFilePointer()));
            pix = pix.replaceAll("\n", "");
            pix = pix.replaceAll("\r", "");
            int ndx = this.getSizeC() * y * bytes * this.getSizeX();
            int destNdx = 0;
            for (int row = 0; row < h2; ++row) {
                ndx += x * this.getSizeC() * bytes;
                for (int col = 0; col < w * this.getSizeC() * bytes; ++col) {
                    buf[destNdx++] = (byte)Integer.parseInt(pix.substring(2 * ndx, 2 * (ndx + 1)), 16);
                    ++ndx;
                }
                ndx += this.getSizeC() * bytes * (this.getSizeX() - w - x);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.start = 0;
            this.isTiff = false;
            this.binary = false;
            this.ifds = null;
            this.map = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        LOGGER.info("Verifying EPS format");
        String line = this.readLine();
        if (!line.trim().startsWith("%!PS")) {
            this.isTiff = true;
            this.in.order(true);
            this.in.seek(20L);
            int offset = this.in.readInt();
            int len = this.in.readInt();
            byte[] b = new byte[len];
            this.in.seek(offset);
            this.in.read(b);
            this.in.close();
            this.in = new RandomAccessInputStream(b);
            TiffParser tp = new TiffParser(this.in);
            this.ifds = tp.getMainIFDs();
            IFD firstIFD = (IFD)this.ifds.get(0);
            this.map = tp.getColorMap(firstIFD);
            m3.sizeX = (int)firstIFD.getImageWidth();
            m3.sizeY = (int)firstIFD.getImageLength();
            m3.sizeZ = 1;
            m3.sizeT = 1;
            m3.sizeC = firstIFD.getSamplesPerPixel();
            if (this.map != null && this.getSizeC() == 1) {
                m3.sizeC = 3;
            }
            if (this.getSizeC() == 2) {
                m3.sizeC = 4;
            }
            m3.littleEndian = firstIFD.isLittleEndian();
            m3.interleaved = true;
            m3.rgb = this.getSizeC() > 1;
            m3.pixelType = firstIFD.getPixelType();
            m3.imageCount = 1;
            m3.dimensionOrder = "XYCZT";
            m3.metadataComplete = true;
            m3.indexed = false;
            m3.falseColor = false;
            MetadataStore store = this.makeFilterMetadata();
            MetadataTools.populatePixels(store, this);
            return;
        }
        LOGGER.info("Finding image data");
        this.binary = false;
        String image = "image";
        int lineNum = 1;
        line = this.readLine().trim();
        while (line != null && !line.equals("%%EOF")) {
            block16: {
                block14: {
                    block15: {
                        if (line.endsWith(image)) {
                            if (line.startsWith(image)) break;
                            if (line.indexOf("colorimage") != -1) {
                                m3.sizeC = 3;
                            }
                            String[] t = line.split(" ");
                            try {
                                int newX = Integer.parseInt(t[0]);
                                int newY = Integer.parseInt(t[1]);
                                if (t.length <= 2 || Integer.parseInt(t[2]) < 8) break;
                                m3.sizeX = newX;
                                m3.sizeY = newY;
                                this.start = lineNum;
                            }
                            catch (NumberFormatException exc) {
                                LOGGER.debug("Could not parse image dimensions", exc);
                                if (t.length <= 3) break;
                                m3.sizeC = Integer.parseInt(t[3]);
                            }
                            break;
                        }
                        if (!line.startsWith("%%")) break block14;
                        if (line.startsWith("%%BoundingBox:")) {
                            line = line.substring(14).trim();
                            String[] t = line.split(" ");
                            try {
                                int originX = Integer.parseInt(t[0].trim());
                                int originY = Integer.parseInt(t[1].trim());
                                m3.sizeX = Integer.parseInt(t[2].trim()) - originX;
                                m3.sizeY = Integer.parseInt(t[3].trim()) - originY;
                                this.addGlobalMeta("X-coordinate of origin", originX);
                                this.addGlobalMeta("Y-coordinate of origin", originY);
                            }
                            catch (NumberFormatException e) {
                                throw new FormatException("Files without image data are not supported.");
                            }
                        }
                        if (!line.startsWith("%%BeginBinary")) break block15;
                        this.binary = true;
                        break block16;
                    }
                    int ndx = line.indexOf(58);
                    if (ndx == -1) break block16;
                    String key = line.substring(0, ndx);
                    String value = line.substring(ndx + 1);
                    this.addGlobalMeta(key, value);
                    break block16;
                }
                if (line.startsWith("%ImageData:")) {
                    line = line.substring(11);
                    String[] t = line.split(" ");
                    m3.sizeX = Integer.parseInt(t[0]);
                    m3.sizeY = Integer.parseInt(t[1]);
                    m3.sizeC = Integer.parseInt(t[3]);
                    for (int i = 4; i < t.length; ++i) {
                        image = t[i].trim();
                        if (image.length() <= 1) continue;
                        image = image.substring(1, image.length() - 1);
                    }
                }
            }
            ++lineNum;
            line = this.readLine().trim();
        }
        LOGGER.info("Populating metadata");
        if (this.getSizeC() == 0) {
            m3.sizeC = 1;
        }
        m3.sizeZ = 1;
        m3.sizeT = 1;
        m3.dimensionOrder = "XYCZT";
        m3.pixelType = 1;
        m3.rgb = this.getSizeC() == 3;
        m3.interleaved = true;
        m3.littleEndian = true;
        m3.imageCount = 1;
        MetadataStore store = this.getMetadataStore();
        MetadataTools.populatePixels(store, this);
    }

    private String readLine() throws IOException {
        String s2 = this.in.findString("\r", "\n");
        return s2.length() == 0 ? null : s2;
    }
}

