/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class CanonRawReader
extends FormatReader {
    private static final int FILE_LENGTH = 18653760;
    private static final int[] COLOR_MAP = new int[]{1, 0, 2, 1};
    private short[] pix;
    private byte[] plane;

    public CanonRawReader() {
        super("Canon RAW", new String[]{"cr2", "crw", "jpg", "thm", "wav"});
        this.domains = new String[]{"Graphics"};
        this.suffixNecessary = false;
        this.suffixSufficient = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return stream.length() == 18653760L;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        if (this.plane == null) {
            this.plane = new byte[FormatTools.getPlaneSize(this)];
            ImageTools.interpolate(this.pix, this.plane, COLOR_MAP, this.getSizeX(), this.getSizeY(), this.isLittleEndian());
        }
        try (RandomAccessInputStream s2 = new RandomAccessInputStream(this.plane);){
            this.readPlane(s2, x, y, w, h2, buf);
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.plane = null;
            this.pix = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        byte[] pixBuffer = new byte[18653760];
        this.in.read(pixBuffer);
        for (int i = 0; i < pixBuffer.length; i += 2) {
            byte v = pixBuffer[i];
            pixBuffer[i] = pixBuffer[i + 1];
            pixBuffer[i + 1] = v;
        }
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        m3.sizeX = 4080;
        m3.sizeY = 3048;
        m3.sizeC = 3;
        m3.sizeZ = 1;
        m3.sizeT = 1;
        m3.imageCount = this.getSizeZ() * this.getSizeT();
        m3.indexed = false;
        m3.littleEndian = true;
        m3.dimensionOrder = "XYCZT";
        m3.pixelType = 3;
        m3.bitsPerPixel = 12;
        m3.rgb = true;
        m3.interleaved = true;
        this.pix = new short[this.getSizeX() * this.getSizeY() * 3];
        int nextByte = 0;
        boolean even = true;
        int plane = this.getSizeX() * this.getSizeY();
        for (int row = 0; row < this.getSizeY(); ++row) {
            int rowOffset = row * this.getSizeX();
            block7: for (int col = 0; col < this.getSizeX(); ++col) {
                int v = 0;
                v = even ? (pixBuffer[nextByte++] & 0xFF) << 4 | (pixBuffer[nextByte] & 0xF0) >> 4 : (pixBuffer[nextByte++] & 0xF) << 8 | pixBuffer[nextByte++] & 0xFF;
                short val = (short)(v & 0xFFFF);
                even = !even;
                int mapIndex = row % 2 * 2 + col % 2;
                switch (COLOR_MAP[mapIndex]) {
                    case 0: {
                        this.pix[rowOffset + col] = val;
                        continue block7;
                    }
                    case 1: {
                        this.pix[plane + rowOffset + col] = val;
                        continue block7;
                    }
                    case 2: {
                        this.pix[2 * plane + rowOffset + col] = val;
                    }
                }
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

