# Generated by Django 4.0.8 on 2022-12-07 06:26

from decimal import Decimal

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('eveuniverse', '0007_evetype_description'),
        ('marketmanager', '0040_rename_supplyconfigmodels'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='general',
            options={'default_permissions': (), 'managed': False, 'permissions': (('basic_market_browser', 'Can access the Standard Market Browser'), ('basic_market_watches', 'Can view all SupplyConfigs and their status'), ('order_highlight_user', "Market orders owned by the user's characters may be highlighted in the standard/basic Market Browser"), ('order_highlight_corporation', 'Market orders owned by any corporation a user is a member of may be highlighted in the standard/basic Market Browser WARNING: This has no checks for Corporation Roles.'), ('advanced_market_browser', 'Can access the Avanced Market Browser'), ('can_add_token_character', 'Can add a Character Token with required scopes'), ('can_add_token_corporation', 'Can add a Corpration Token with required scopes'))},
        ),
        migrations.RenameField(
            model_name='supplyconfig',
            old_name='managed_watch_config',
            new_name='managed_supply_config',
        ),
        migrations.RemoveField(
            model_name='supplyconfig',
            name='config_type',
        ),
        migrations.AlterField(
            model_name='managedsupplyconfig',
            name='managed_app',
            field=models.CharField(blank=True, default='', help_text='The App managing this SupplyConfig', max_length=50, verbose_name='Managed By App'),
        ),
        migrations.AlterField(
            model_name='managedsupplyconfig',
            name='managed_app_identifier',
            field=models.CharField(blank=True, default='', help_text='An identifier relevant to the App managing this SupplyConfig', max_length=50, verbose_name='Managed App-Identifier'),
        ),
        migrations.AlterField(
            model_name='managedsupplyconfig',
            name='managed_app_reason',
            field=models.CharField(blank=True, default='', help_text='User Facing reason for this Managed SupplyConfig', max_length=50, verbose_name='Managed App Reason'),
        ),
        migrations.AlterField(
            model_name='managedsupplyconfig',
            name='managed_debug_channels',
            field=models.ManyToManyField(blank=True, help_text='Primarily for Testing/Debugging Purposes. This webhook will receive updates on SupplyConfigs that _dont_ notify. Because their Configs didnt Meet/Breach.', related_name='+', to='marketmanager.channel', verbose_name='Debug Channels'),
        ),
        migrations.AlterField(
            model_name='managedsupplyconfig',
            name='managed_debug_webhooks',
            field=models.ManyToManyField(blank=True, help_text='Primarily for Testing/Debugging Purposes. This webhook will receive updates on Supplyonfigs that _dont_ notify. Because their Configs didnt Meet/Breach.', related_name='+', to='marketmanager.webhook', verbose_name='Debug Webhook'),
        ),
        migrations.AlterField(
            model_name='managedsupplyconfig',
            name='managed_structure_type',
            field=models.ManyToManyField(blank=True, help_text='Filter by structure Type/Size/Docking (ie, forts/keeps for cap fuel)', to='eveuniverse.evetype', verbose_name='Structure Type Filter'),
        ),
        migrations.AlterField(
            model_name='supplyconfig',
            name='debug_channels',
            field=models.ManyToManyField(blank=True, help_text='Primarily for Testing/Debugging Purposes. This webhook will receive updates on SupplyConfigs that _dont_ notify. Because their Configs didnt Meet/Breach.', related_name='+', to='marketmanager.channel', verbose_name='Debug Channels'),
        ),
        migrations.AlterField(
            model_name='supplyconfig',
            name='debug_webhooks',
            field=models.ManyToManyField(blank=True, help_text='Primarily for Testing/Debugging Purposes. This webhook will receive updates on SupplyConfigs that _dont_ notify. Because their Configs didnt Meet/Breach.', related_name='+', to='marketmanager.webhook', verbose_name='Debug Webhook'),
        ),
        migrations.AlterField(
            model_name='supplyconfig',
            name='structure_type',
            field=models.ManyToManyField(blank=True, help_text='Filter by structure Type/Size/Docking (ie, forts/keeps for cap fuel)', related_name='+', to='eveuniverse.evetype', verbose_name='Structure Type Filter'),
        ),
        migrations.CreateModel(
            name='PriceConfig',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('buy_order', models.BooleanField(verbose_name='Buy Order')),
                ('scalp', models.BooleanField(help_text='True for Scalp, False for Bargain', verbose_name='Scalp Finder?')),
                ('price', models.DecimalField(decimal_places=2, default=Decimal('0'), max_digits=15, verbose_name='Price')),
                ('jita_compare_percent', models.DecimalField(decimal_places=0, default=Decimal('0'), help_text='If set ignores Flat price value', max_digits=4, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1000)], verbose_name='Jita Comparison %')),
                ('last_run', models.DateTimeField(blank=True, null=True, verbose_name='Last Task Runtime')),
                ('channels', models.ManyToManyField(blank=True, to='marketmanager.channel', verbose_name='Channels')),
                ('debug_channels', models.ManyToManyField(blank=True, help_text='Primarily for Testing/Debugging Purposes. This webhook will receive updates on PriceConfigs that _dont_ notify. Because their Configs didnt Meet/Breach.', related_name='+', to='marketmanager.channel', verbose_name='Debug Channels')),
                ('debug_webhooks', models.ManyToManyField(blank=True, help_text='Primarily for Testing/Debugging Purposes. This webhook will receive updates on PriceConfigs that _dont_ notify. Because their Configs didnt Meet/Breach.', related_name='+', to='marketmanager.webhook', verbose_name='Debug Webhook')),
                ('eve_group', models.ManyToManyField(to='eveuniverse.evegroup', verbose_name='EVE Inventory Group')),
                ('eve_type', models.ManyToManyField(to='eveuniverse.evetype', verbose_name='EVE Type')),
                ('region', models.ManyToManyField(blank=True, to='eveuniverse.everegion', verbose_name='Region')),
                ('solar_system', models.ManyToManyField(blank=True, to='eveuniverse.evesolarsystem', verbose_name='Solar System')),
                ('structure', models.ManyToManyField(blank=True, to='marketmanager.structure', verbose_name='Structure')),
                ('structure_type', models.ManyToManyField(blank=True, help_text='Filter by structure Type/Size/Docking (ie, forts/keeps for cap fuel)', related_name='+', to='eveuniverse.evetype', verbose_name='Structure Type Filter')),
                ('webhooks', models.ManyToManyField(blank=True, to='marketmanager.webhook', verbose_name='Webhooks')),
            ],
            options={
                'default_permissions': (),
            },
        ),
    ]
