/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.value;

import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import org.reactfx.Subscription;
import org.reactfx.value.Val;
import org.reactfx.value.ValBase;

class MappedVal<T, U>
extends ValBase<U> {
    private final ObservableValue<T> src;
    private final Function<? super T, ? extends U> f;

    MappedVal(ObservableValue<T> src, Function<? super T, ? extends U> f) {
        this.src = src;
        this.f = f;
    }

    @Override
    protected U computeValue() {
        T baseVal = this.src.getValue();
        return baseVal != null ? (U)this.f.apply((T)baseVal) : null;
    }

    @Override
    protected Subscription connect() {
        return Val.observeInvalidations(this.src, obs -> this.invalidate());
    }
}

