/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.reactfx.util.BiIndex;
import org.reactfx.util.Either;
import org.reactfx.util.LL;
import org.reactfx.util.Lists;
import org.reactfx.util.TetraFunction;
import org.reactfx.util.ToSemigroup;
import org.reactfx.util.TriFunction;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuple3;
import org.reactfx.util.Tuples;

public abstract class FingerTree<T, S> {
    final ToSemigroup<? super T, S> semigroup;

    public static <T, S> FingerTree<T, S> empty(ToSemigroup<? super T, S> statisticsProvider) {
        return new Empty<T, S>(statisticsProvider);
    }

    public static <T> FingerTree<T, Void> mkTree(List<? extends T> items2) {
        return FingerTree.mkTree(items2, new ToSemigroup<T, Void>(){

            @Override
            public Void apply(T t) {
                return null;
            }

            @Override
            public Void reduce(Void left, Void right) {
                return null;
            }
        });
    }

    public static <T, S> FingerTree<T, S> mkTree(List<? extends T> items2, ToSemigroup<? super T, S> summaryProvider) {
        if (items2.isEmpty()) {
            return new Empty<T, S>(summaryProvider);
        }
        ArrayList<NonEmptyFingerTree> trees = new ArrayList<NonEmptyFingerTree>(items2.size());
        for (T item : items2) {
            trees.add(new Leaf<T, S>(summaryProvider, item));
        }
        while (trees.size() > 1) {
            int n = trees.size();
            int src = 0;
            int tgt = 0;
            while (src < n) {
                NonEmptyFingerTree t2;
                NonEmptyFingerTree t1;
                if (n - src >= 5 || n - src == 3) {
                    t1 = (NonEmptyFingerTree)trees.get(src++);
                    t2 = (NonEmptyFingerTree)trees.get(src++);
                    NonEmptyFingerTree t3 = (NonEmptyFingerTree)trees.get(src++);
                    Branch<T, S> t = FingerTree.branch(t1, t2, t3);
                    trees.set(tgt++, t);
                    continue;
                }
                t1 = (NonEmptyFingerTree)trees.get(src++);
                t2 = (NonEmptyFingerTree)trees.get(src++);
                Branch<T, S> t = FingerTree.branch(t1, t2);
                trees.set(tgt++, t);
            }
            trees.subList(tgt, n).clear();
        }
        return (FingerTree)trees.get(0);
    }

    private static <T, S> Branch<T, S> branch(NonEmptyFingerTree<T, S> left, NonEmptyFingerTree<T, S> right) {
        return FingerTree.branch(LL.of(left, right));
    }

    private static <T, S> Branch<T, S> branch(NonEmptyFingerTree<T, S> left, NonEmptyFingerTree<T, S> middle, NonEmptyFingerTree<T, S> right) {
        return FingerTree.branch(LL.of(left, middle, right));
    }

    private static <T, S> Branch<T, S> branch(LL.Cons<NonEmptyFingerTree<T, S>> children) {
        return new Branch(children);
    }

    private static <T, S> FingerTree<T, S> concat(LL.Cons<? extends FingerTree<T, S>> nodes) {
        FingerTree<T, S> head2 = nodes.head();
        return nodes.tail().fold(head2, FingerTree::join);
    }

    private FingerTree(ToSemigroup<? super T, S> semigroup) {
        this.semigroup = semigroup;
    }

    public abstract int getDepth();

    public abstract int getLeafCount();

    public abstract Optional<S> getSummaryOpt();

    public abstract Either<FingerTree<T, S>, NonEmptyFingerTree<T, S>> caseEmpty();

    public final boolean isEmpty() {
        return this.getDepth() == 0;
    }

    public S getSummary(S whenEmpty) {
        return this.getSummaryOpt().orElse(whenEmpty);
    }

    public T getLeaf(int index) {
        Lists.checkIndex(index, this.getLeafCount());
        return this.getLeaf0(index);
    }

    abstract T getLeaf0(int var1);

    public Tuple2<T, BiIndex> get(ToIntFunction<? super S> metric, int index) {
        return this.caseEmpty().unify(emptyTree -> {
            throw new IndexOutOfBoundsException("empty tree");
        }, neTree -> {
            int size = metric.applyAsInt((S)neTree.getSummary());
            Lists.checkIndex(index, size);
            BiIndex location = this.locateProgressively(metric, index);
            return Tuples.t(this.getLeaf(location.major), location);
        });
    }

    public <E> E get(ToIntFunction<? super S> metric, int index, BiFunction<? super T, Integer, ? extends E> leafAccessor) {
        return (E)this.locateProgressively(metric, index).map((major, minor) -> leafAccessor.apply((T)this.getLeaf((int)major), (Integer)minor));
    }

    public NonEmptyFingerTree<T, S> updateLeaf(int index, T data2) {
        Lists.checkIndex(index, this.getLeafCount());
        return this.updateLeaf0(index, data2);
    }

    abstract NonEmptyFingerTree<T, S> updateLeaf0(int var1, T var2);

    public BiIndex locate(BiFunction<? super S, Integer, Either<Integer, Integer>> navigate, int position) {
        return this.caseEmpty().unify(emptyTree -> {
            throw new IndexOutOfBoundsException("no leafs to locate in");
        }, neTree -> {
            throw new AssertionError((Object)"This method must be overridden in non-empty tree");
        });
    }

    public BiIndex locateProgressively(ToIntFunction<? super S> metric, int position) {
        return this.caseEmpty().unify(emptyTree -> {
            throw new IndexOutOfBoundsException("no leafs to locate in");
        }, neTree -> {
            throw new AssertionError((Object)"This method must be overridden in non-empty tree");
        });
    }

    public BiIndex locateRegressively(ToIntFunction<? super S> metric, int position) {
        return this.caseEmpty().unify(emptyTree -> {
            throw new IndexOutOfBoundsException("no leafs to locate in");
        }, neTree -> {
            throw new AssertionError((Object)"This method must be overridden in non-empty tree");
        });
    }

    public abstract <R> R fold(R var1, BiFunction<? super R, ? super T, ? extends R> var2);

    public <R> R foldBetween(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, int startLeaf, int endLeaf) {
        Lists.checkRange(startLeaf, endLeaf, this.getLeafCount());
        if (startLeaf == endLeaf) {
            return acc;
        }
        return this.foldBetween0(acc, reduction, startLeaf, endLeaf);
    }

    abstract <R> R foldBetween0(R var1, BiFunction<? super R, ? super T, ? extends R> var2, int var3, int var4);

    public <R> R foldBetween(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, ToIntFunction<? super S> metric, int startPosition, int endPosition, TetraFunction<? super R, ? super T, Integer, Integer, ? extends R> rangeReduction) {
        Lists.checkRange(startPosition, endPosition, this.measure(metric));
        if (startPosition == endPosition) {
            return acc;
        }
        return this.foldBetween0(acc, reduction, metric, startPosition, endPosition, rangeReduction);
    }

    abstract <R> R foldBetween0(R var1, BiFunction<? super R, ? super T, ? extends R> var2, ToIntFunction<? super S> var3, int var4, int var5, TetraFunction<? super R, ? super T, Integer, Integer, ? extends R> var6);

    public Optional<S> getSummaryBetween(int startLeaf, int endLeaf) {
        Lists.checkRange(startLeaf, endLeaf, this.getLeafCount());
        return startLeaf == endLeaf ? Optional.empty() : Optional.of(this.getSummaryBetween0(startLeaf, endLeaf));
    }

    abstract S getSummaryBetween0(int var1, int var2);

    public Optional<S> getSummaryBetween(ToIntFunction<? super S> metric, int startPosition, int endPosition, TriFunction<? super T, Integer, Integer, ? extends S> subSummary) {
        Lists.checkRange(startPosition, endPosition, this.measure(metric));
        return startPosition == endPosition ? Optional.empty() : Optional.of(this.getSummaryBetween0(metric, startPosition, endPosition, subSummary));
    }

    abstract S getSummaryBetween0(ToIntFunction<? super S> var1, int var2, int var3, TriFunction<? super T, Integer, Integer, ? extends S> var4);

    public Tuple2<FingerTree<T, S>, FingerTree<T, S>> split(int beforeLeaf) {
        Lists.checkPosition(beforeLeaf, this.getLeafCount());
        return this.split0(beforeLeaf);
    }

    abstract Tuple2<FingerTree<T, S>, FingerTree<T, S>> split0(int var1);

    public FingerTree<T, S> removeLeafs(int fromLeaf, int toLeaf) {
        Lists.checkRange(fromLeaf, toLeaf, this.getLeafCount());
        if (fromLeaf == toLeaf) {
            return this;
        }
        if (fromLeaf == 0 && toLeaf == this.getLeafCount()) {
            return this.empty();
        }
        FingerTree left = (FingerTree)this.split0((int)fromLeaf)._1;
        FingerTree right = (FingerTree)this.split0((int)toLeaf)._2;
        return left.join(right);
    }

    public FingerTree<T, S> insertLeaf(int position, T data2) {
        Lists.checkPosition(position, this.getLeafCount());
        return this.split0(position).map((l, r) -> l.join(this.leaf(data2)).join((FingerTree<Object, S>)r));
    }

    public abstract FingerTree<T, S> join(FingerTree<T, S> var1);

    public NonEmptyFingerTree<T, S> append(T data2) {
        return this.leaf(data2).prependTree(this);
    }

    public NonEmptyFingerTree<T, S> prepend(T data2) {
        return this.leaf(data2).appendTree(this);
    }

    public abstract List<T> asList();

    abstract T getData();

    Empty<T, S> empty() {
        return new Empty<T, S>(this.semigroup);
    }

    Leaf<T, S> leaf(T data2) {
        return new Leaf<T, S>(this.semigroup, data2);
    }

    final int measure(ToIntFunction<? super S> metric) {
        return this.getSummaryOpt().map(metric::applyAsInt).orElse(0);
    }

    private static final class Branch<T, S>
    extends NonEmptyFingerTree<T, S> {
        private final LL.Cons<NonEmptyFingerTree<T, S>> children;
        private final int depth;
        private final int leafCount;
        private final S summary;

        private Branch(LL.Cons<NonEmptyFingerTree<T, S>> children) {
            super(children.head().semigroup);
            assert (children.size() == 2 || children.size() == 3);
            FingerTree head2 = children.head();
            int headDepth = head2.getDepth();
            assert (children.all(n -> n.getDepth() == headDepth));
            this.children = children;
            this.depth = 1 + headDepth;
            this.leafCount = children.fold(0, (s, n) -> s + n.getLeafCount());
            this.summary = children.mapReduce1(NonEmptyFingerTree::getSummary, this.semigroup::reduce);
        }

        public String toString() {
            return "Branch" + this.children;
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public int getLeafCount() {
            return this.leafCount;
        }

        @Override
        public List<T> asList() {
            return this.subList0(0, this.leafCount);
        }

        private List<T> subList(int from2, int to) {
            int len = to - from2;
            if (2 * len >= this.getLeafCount()) {
                return this.subList0(from2, to);
            }
            FingerTree tree = this;
            if (2 * (this.getLeafCount() - to) > len) {
                tree = (FingerTree)tree.split((int)to)._1;
            }
            if (2 * from2 > len) {
                tree = (FingerTree)tree.split((int)from2)._2;
                to -= from2;
                from2 = 0;
            }
            return tree.asList().subList(from2, to);
        }

        private List<T> subList0(final int from2, final int to) {
            return new AbstractList<T>(){

                @Override
                public T get(int index) {
                    Lists.checkIndex(index, to - from2);
                    return this.getLeaf(from2 + index);
                }

                @Override
                public int size() {
                    return to - from2;
                }

                @Override
                public List<T> subList(int start2, int end) {
                    Lists.checkRange(start2, end, to - from2);
                    return this.subList(from2 + start2, from2 + end);
                }

                @Override
                public Iterator<T> iterator() {
                    return this.listIterator(0);
                }

                @Override
                public ListIterator<T> listIterator(final int pos) {
                    int dd = 3;
                    Lists.checkPosition(pos, this.size());
                    return new ListIterator<T>(){
                        private int position;
                        private int topOffset;
                        private Stack<NonEmptyFingerTree<T, S>> stack;
                        {
                            this.position = from2 + pos;
                            this.topOffset = 0;
                            this.stack = new Stack();
                            this.stack.push(this);
                        }

                        @Override
                        public boolean hasNext() {
                            return this.position < to;
                        }

                        @Override
                        public boolean hasPrevious() {
                            return this.position > from2;
                        }

                        @Override
                        public int nextIndex() {
                            return this.position - from2;
                        }

                        @Override
                        public int previousIndex() {
                            return this.position - from2 - 1;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public void set(T e) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public void add(T e) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public T next() {
                            if (this.position == this.topOffset + this.stack.peek().getLeafCount()) {
                                this.up();
                                return this.next();
                            }
                            if (this.stack.peek().getDepth() <= 3) {
                                return this.stack.peek().getLeaf(this.position++ - this.topOffset);
                            }
                            this.downR();
                            return this.next();
                        }

                        @Override
                        public T previous() {
                            if (this.position == this.topOffset) {
                                this.up();
                                return this.previous();
                            }
                            if (this.stack.peek().getDepth() <= 3) {
                                return this.stack.peek().getLeaf(--this.position - this.topOffset);
                            }
                            this.downL();
                            return this.previous();
                        }

                        private void up() {
                            NonEmptyFingerTree child2 = this.stack.pop();
                            Branch top = (Branch)this.stack.peek();
                            int chOffsetInParent = 0;
                            LL children = top.children;
                            while (((LL)children).head() != child2) {
                                chOffsetInParent += ((NonEmptyFingerTree)((LL)children).head()).getLeafCount();
                                children = ((LL)children).tail();
                            }
                            this.topOffset -= chOffsetInParent;
                        }

                        private void downR() {
                            this.downR(((Branch)this.stack.peek()).children);
                        }

                        private void downR(LL<? extends NonEmptyFingerTree<T, S>> children) {
                            NonEmptyFingerTree head2 = children.head();
                            if (this.position - this.topOffset < head2.getLeafCount()) {
                                this.stack.push(head2);
                            } else {
                                this.topOffset += head2.getLeafCount();
                                this.downR(children.tail());
                            }
                        }

                        private void downL() {
                            this.downL(((Branch)this.stack.peek()).children);
                        }

                        private void downL(LL<? extends NonEmptyFingerTree<T, S>> children) {
                            NonEmptyFingerTree head2 = children.head();
                            if (this.position - this.topOffset <= head2.getLeafCount()) {
                                this.stack.push(head2);
                            } else {
                                this.topOffset += head2.getLeafCount();
                                this.downL(children.tail());
                            }
                        }
                    };
                }
            };
        }

        @Override
        final T getData() {
            throw new UnsupportedOperationException("Only leaf nodes hold data");
        }

        @Override
        final T getLeaf0(int index) {
            assert (Lists.isValidIndex(index, this.getLeafCount()));
            return this.getLeaf0(index, this.children);
        }

        private T getLeaf0(int index, LL<? extends FingerTree<T, S>> nodes) {
            FingerTree<T, S> head2 = nodes.head();
            int headSize = head2.getLeafCount();
            if (index < headSize) {
                return head2.getLeaf0(index);
            }
            return this.getLeaf0(index - headSize, nodes.tail());
        }

        @Override
        NonEmptyFingerTree<T, S> updateLeaf0(int index, T data2) {
            assert (Lists.isValidIndex(index, this.getLeafCount()));
            return FingerTree.branch(this.updateLeaf0(index, data2, this.children));
        }

        private LL.Cons<NonEmptyFingerTree<T, S>> updateLeaf0(int index, T data2, LL<? extends NonEmptyFingerTree<T, S>> nodes) {
            NonEmptyFingerTree<T, S> head2 = nodes.head();
            int headSize = head2.getLeafCount();
            if (index < headSize) {
                return LL.cons(head2.updateLeaf0(index, data2), nodes.tail());
            }
            return LL.cons(head2, this.updateLeaf0(index - headSize, data2, nodes.tail()));
        }

        @Override
        final BiIndex locateProgressively0(ToIntFunction<? super S> metric, int position) {
            assert (Lists.isValidPosition(position, this.measure(metric)));
            return this.locateProgressively0(metric, position, this.children);
        }

        private BiIndex locateProgressively0(ToIntFunction<? super S> metric, int position, LL<? extends NonEmptyFingerTree<T, S>> nodes) {
            NonEmptyFingerTree<T, Object> head2 = nodes.head();
            int headLen = head2.measure(metric);
            if (position < headLen || position == headLen && nodes.tail().isEmpty()) {
                return head2.locateProgressively0(metric, position);
            }
            return this.locateProgressively0(metric, position - headLen, nodes.tail()).adjustMajor(head2.getLeafCount());
        }

        @Override
        final BiIndex locateRegressively0(ToIntFunction<? super S> metric, int position) {
            assert (Lists.isValidPosition(position, this.measure(metric)));
            return this.locateRegressively0(metric, position, this.children);
        }

        private BiIndex locateRegressively0(ToIntFunction<? super S> metric, int position, LL<? extends NonEmptyFingerTree<T, S>> nodes) {
            NonEmptyFingerTree<T, Object> head2 = nodes.head();
            int headLen = head2.measure(metric);
            if (position <= headLen) {
                return head2.locateRegressively0(metric, position);
            }
            return this.locateRegressively0(metric, position - headLen, nodes.tail()).adjustMajor(head2.getLeafCount());
        }

        @Override
        public final <R> R fold(R acc, BiFunction<? super R, ? super T, ? extends R> reduction) {
            return (R)this.children.fold(acc, (r, n) -> n.fold(r, reduction));
        }

        @Override
        final <R> R foldBetween0(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, int startLeaf, int endLeaf) {
            assert (Lists.isNonEmptyRange(startLeaf, endLeaf, this.getLeafCount()));
            return this.foldBetween0(acc, reduction, startLeaf, endLeaf, this.children);
        }

        private <R> R foldBetween0(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, int startLeaf, int endLeaf, LL<? extends FingerTree<T, S>> nodes) {
            FingerTree<? super T, S> head2 = nodes.head();
            int headSize = head2.getLeafCount();
            int headTo = Math.min(endLeaf, headSize);
            int tailFrom = Math.max(startLeaf - headSize, 0);
            int tailTo = endLeaf - headSize;
            if (startLeaf < headTo) {
                acc = head2.foldBetween0(acc, reduction, startLeaf, headTo);
            }
            if (tailFrom < tailTo) {
                acc = this.foldBetween0(acc, reduction, tailFrom, tailTo, nodes.tail());
            }
            return acc;
        }

        @Override
        final <R> R foldBetween0(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, ToIntFunction<? super S> metric, int startPosition, int endPosition, TetraFunction<? super R, ? super T, Integer, Integer, ? extends R> rangeReduction) {
            assert (Lists.isNonEmptyRange(startPosition, endPosition, this.measure(metric)));
            return this.foldBetween0(acc, reduction, metric, startPosition, endPosition, rangeReduction, this.children);
        }

        private <R> R foldBetween0(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, ToIntFunction<? super S> metric, int startPosition, int endPosition, TetraFunction<? super R, ? super T, Integer, Integer, ? extends R> rangeReduction, LL<? extends FingerTree<T, S>> nodes) {
            FingerTree<? super T, Object> head2 = nodes.head();
            int headLen = head2.measure(metric);
            int headTo = Math.min(endPosition, headLen);
            int tailFrom = Math.max(startPosition - headLen, 0);
            int tailTo = endPosition - headLen;
            if (startPosition < headTo) {
                acc = head2.foldBetween0(acc, reduction, metric, startPosition, headTo, rangeReduction);
            }
            if (tailFrom < tailTo) {
                acc = this.foldBetween0(acc, reduction, metric, tailFrom, tailTo, rangeReduction, nodes.tail());
            }
            return acc;
        }

        @Override
        public S getSummary() {
            return this.summary;
        }

        @Override
        public Optional<S> getSummaryOpt() {
            return Optional.of(this.summary);
        }

        @Override
        final S getSummaryBetween0(int startLeaf, int endLeaf) {
            assert (Lists.isNonEmptyRange(startLeaf, endLeaf, this.getLeafCount()));
            if (startLeaf == 0 && endLeaf == this.getLeafCount()) {
                return this.summary;
            }
            return this.getSummaryBetween0(startLeaf, endLeaf, this.children);
        }

        private S getSummaryBetween0(int startLeaf, int endLeaf, LL<? extends FingerTree<T, S>> nodes) {
            FingerTree<T, S> head2 = nodes.head();
            int headSize = head2.getLeafCount();
            int headTo = Math.min(endLeaf, headSize);
            int tailFrom = Math.max(startLeaf - headSize, 0);
            int tailTo = endLeaf - headSize;
            if (startLeaf < headTo && tailFrom < tailTo) {
                return this.semigroup.reduce(head2.getSummaryBetween0(startLeaf, headTo), this.getSummaryBetween0(tailFrom, tailTo, nodes.tail()));
            }
            if (startLeaf < headTo) {
                return head2.getSummaryBetween0(startLeaf, headTo);
            }
            if (tailFrom < tailTo) {
                return this.getSummaryBetween0(tailFrom, tailTo, nodes.tail());
            }
            throw new AssertionError((Object)("Didn't expect empty range: [" + startLeaf + ", " + endLeaf + ")"));
        }

        @Override
        final S getSummaryBetween0(ToIntFunction<? super S> metric, int startPosition, int endPosition, TriFunction<? super T, Integer, Integer, ? extends S> subSummary) {
            int len = this.measure(metric);
            assert (Lists.isNonEmptyRange(startPosition, endPosition, len));
            if (startPosition == 0 && endPosition == len) {
                return this.getSummary();
            }
            return this.getSummaryBetween0(metric, startPosition, endPosition, subSummary, this.children);
        }

        private S getSummaryBetween0(ToIntFunction<? super S> metric, int startPosition, int endPosition, TriFunction<? super T, Integer, Integer, ? extends S> subSummary, LL<? extends FingerTree<T, S>> nodes) {
            FingerTree<Object, Object> head2 = nodes.head();
            int headLen = head2.measure(metric);
            int headTo = Math.min(endPosition, headLen);
            int tailFrom = Math.max(startPosition - headLen, 0);
            int tailTo = endPosition - headLen;
            if (startPosition < headTo && tailFrom < tailTo) {
                return this.semigroup.reduce(head2.getSummaryBetween0(metric, startPosition, headTo, subSummary), this.getSummaryBetween0(metric, tailFrom, tailTo, subSummary, nodes.tail()));
            }
            if (startPosition < headTo) {
                return head2.getSummaryBetween0(metric, startPosition, headTo, subSummary);
            }
            if (tailFrom < tailTo) {
                return this.getSummaryBetween0(metric, tailFrom, tailTo, subSummary, nodes.tail());
            }
            throw new AssertionError((Object)("Didn't expect empty range: [" + startPosition + ", " + endPosition + ")"));
        }

        @Override
        Either<Branch<T, S>, Tuple2<NonEmptyFingerTree<T, S>, NonEmptyFingerTree<T, S>>> appendLte(FingerTree<T, S> suffix) {
            assert (suffix.getDepth() <= this.getDepth());
            if (suffix.getDepth() == this.getDepth()) {
                return Either.right(Tuples.t(this, (NonEmptyFingerTree)suffix));
            }
            if (this.children.size() == 2) {
                return this.children.mapFirst2((left, right) -> right.appendLte(suffix).unify(r -> Either.left(FingerTree.branch(left, r)), mr -> Either.left(mr.map((m, r) -> FingerTree.branch(left, m, r)))));
            }
            assert (this.children.size() == 3);
            return this.children.mapFirst3((left, middle, right) -> right.appendLte(suffix).mapLeft(r -> FingerTree.branch(left, middle, r)).mapRight(mr -> Tuples.t(FingerTree.branch(left, middle), mr.map((x$0, x$1) -> FingerTree.branch(x$0, x$1)))));
        }

        @Override
        Either<Branch<T, S>, Tuple2<NonEmptyFingerTree<T, S>, NonEmptyFingerTree<T, S>>> prependLte(FingerTree<T, S> prefix) {
            assert (prefix.getDepth() <= this.getDepth());
            if (prefix.getDepth() == this.getDepth()) {
                return Either.right(Tuples.t((NonEmptyFingerTree)prefix, this));
            }
            if (this.children.size() == 2) {
                return this.children.mapFirst2((left, right) -> left.prependLte(prefix).unify(l -> Either.left(FingerTree.branch(l, right)), lm -> Either.left(lm.map((l, m) -> FingerTree.branch(l, m, right)))));
            }
            assert (this.children.size() == 3);
            return this.children.mapFirst3((left, middle, right) -> left.prependLte(prefix).mapLeft(l -> FingerTree.branch(l, middle, right)).mapRight(lm -> Tuples.t(lm.map((x$0, x$1) -> FingerTree.branch(x$0, x$1)), FingerTree.branch(middle, right))));
        }

        @Override
        Tuple2<FingerTree<T, S>, FingerTree<T, S>> split0(int beforeLeaf) {
            assert (Lists.isValidPosition(beforeLeaf, this.getLeafCount()));
            if (beforeLeaf == 0) {
                return Tuples.t(this.empty(), this);
            }
            return this.split0(beforeLeaf, this.children);
        }

        private Tuple2<FingerTree<T, S>, FingerTree<T, S>> split0(int beforeLeaf, LL<? extends FingerTree<T, S>> nodes) {
            assert (beforeLeaf > 0);
            FingerTree head2 = nodes.head();
            int headSize = head2.getLeafCount();
            if (beforeLeaf <= headSize) {
                return head2.split0(beforeLeaf).map((l, r) -> Tuples.t(l, FingerTree.concat(LL.cons(r, nodes.tail()))));
            }
            return this.split0(beforeLeaf - headSize, nodes.tail()).map((l, r) -> Tuples.t(head2.join((FingerTree)l), r));
        }

        @Override
        BiIndex locate0(BiFunction<? super S, Integer, Either<Integer, Integer>> navigate, int position) {
            assert (navigate.apply(this.summary, position).isLeft());
            return this.locate0(navigate, position, this.children);
        }

        private BiIndex locate0(BiFunction<? super S, Integer, Either<Integer, Integer>> navigate, int position, LL<? extends NonEmptyFingerTree<T, S>> nodes) {
            NonEmptyFingerTree head2 = nodes.head();
            return navigate.apply(head2.getSummary(), position).unify(posInl -> head2.locate0(navigate, (int)posInl), posInr -> this.locate0((BiFunction<? super S, Integer, Either<Integer, Integer>>)navigate, (int)posInr, nodes.tail()).adjustMajor(head2.getLeafCount()));
        }
    }

    private static class Leaf<T, S>
    extends NonEmptyFingerTree<T, S> {
        private final T data;
        private final S summary;

        Leaf(ToSemigroup<? super T, S> semigroup, T data2) {
            super(semigroup);
            this.data = data2;
            this.summary = semigroup.apply(data2);
        }

        public String toString() {
            return "Leaf(" + this.data + ")";
        }

        @Override
        public int getDepth() {
            return 1;
        }

        @Override
        public int getLeafCount() {
            return 1;
        }

        @Override
        public List<T> asList() {
            return Collections.singletonList(this.data);
        }

        @Override
        T getLeaf0(int index) {
            assert (index == 0);
            return this.data;
        }

        @Override
        NonEmptyFingerTree<T, S> updateLeaf0(int index, T data2) {
            assert (index == 0);
            return this.leaf(data2);
        }

        @Override
        T getData() {
            return this.data;
        }

        @Override
        public S getSummary() {
            return this.summary;
        }

        @Override
        public Optional<S> getSummaryOpt() {
            return Optional.of(this.summary);
        }

        @Override
        BiIndex locateProgressively0(ToIntFunction<? super S> metric, int position) {
            assert (Lists.isValidPosition(position, this.measure(metric)));
            return new BiIndex(0, position);
        }

        @Override
        BiIndex locateRegressively0(ToIntFunction<? super S> metric, int position) {
            assert (Lists.isValidPosition(position, this.measure(metric)));
            return new BiIndex(0, position);
        }

        @Override
        public <R> R fold(R acc, BiFunction<? super R, ? super T, ? extends R> reduction) {
            return reduction.apply(acc, this.data);
        }

        @Override
        <R> R foldBetween0(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, int startLeaf, int endLeaf) {
            assert (0 <= startLeaf);
            assert (endLeaf <= 1);
            if (startLeaf < endLeaf) {
                return reduction.apply(acc, this.data);
            }
            return acc;
        }

        @Override
        <R> R foldBetween0(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, ToIntFunction<? super S> metric, int startPosition, int endPosition, TetraFunction<? super R, ? super T, Integer, Integer, ? extends R> rangeReduction) {
            assert (Lists.isValidRange(startPosition, endPosition, this.measure(metric)));
            return rangeReduction.apply(acc, this.data, startPosition, endPosition);
        }

        @Override
        S getSummaryBetween0(int startLeaf, int endLeaf) {
            assert (startLeaf == 0 && endLeaf == 1);
            return this.summary;
        }

        @Override
        S getSummaryBetween0(ToIntFunction<? super S> metric, int startPosition, int endPosition, TriFunction<? super T, Integer, Integer, ? extends S> subSummary) {
            assert (Lists.isNonEmptyRange(startPosition, endPosition, this.measure(metric))) : "Didn't expect empty range [" + startPosition + ", " + endPosition + ")";
            if (startPosition == 0 && endPosition == this.measure(metric)) {
                return this.summary;
            }
            return subSummary.apply(this.data, startPosition, endPosition);
        }

        @Override
        Either<Leaf<T, S>, Tuple2<NonEmptyFingerTree<T, S>, NonEmptyFingerTree<T, S>>> appendLte(FingerTree<T, S> right) {
            assert (right.getDepth() <= this.getDepth());
            return right.caseEmpty().mapLeft(emptyRight -> this).mapRight(nonEmptyRight -> Tuples.t(this, nonEmptyRight));
        }

        @Override
        Either<Leaf<T, S>, Tuple2<NonEmptyFingerTree<T, S>, NonEmptyFingerTree<T, S>>> prependLte(FingerTree<T, S> left) {
            assert (left.getDepth() <= this.getDepth());
            return left.caseEmpty().mapLeft(emptyLeft -> this).mapRight(nonEmptyLeft -> Tuples.t(nonEmptyLeft, this));
        }

        @Override
        Tuple2<FingerTree<T, S>, FingerTree<T, S>> split0(int beforeLeaf) {
            assert (Lists.isValidPosition(beforeLeaf, 1));
            if (beforeLeaf == 0) {
                return Tuples.t(this.empty(), this);
            }
            return Tuples.t(this, this.empty());
        }

        @Override
        BiIndex locate0(BiFunction<? super S, Integer, Either<Integer, Integer>> navigate, int position) {
            return navigate.apply(this.summary, position).unify(inl -> new BiIndex(0, (int)inl), inr -> {
                throw new AssertionError((Object)"Unreachable code");
            });
        }
    }

    private static final class Empty<T, S>
    extends FingerTree<T, S> {
        Empty(ToSemigroup<? super T, S> semigroup) {
            super(semigroup);
        }

        public String toString() {
            return "<emtpy tree>";
        }

        @Override
        public Either<FingerTree<T, S>, NonEmptyFingerTree<T, S>> caseEmpty() {
            return Either.left(this);
        }

        @Override
        public int getDepth() {
            return 0;
        }

        @Override
        public int getLeafCount() {
            return 0;
        }

        @Override
        public FingerTree<T, S> join(FingerTree<T, S> rightTree) {
            return rightTree;
        }

        @Override
        public List<T> asList() {
            return Collections.emptyList();
        }

        @Override
        T getLeaf0(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        NonEmptyFingerTree<T, S> updateLeaf0(int index, T data2) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        T getData() {
            throw new NoSuchElementException();
        }

        @Override
        public Optional<S> getSummaryOpt() {
            return Optional.empty();
        }

        @Override
        public <R> R fold(R acc, BiFunction<? super R, ? super T, ? extends R> reduction) {
            return acc;
        }

        @Override
        <R> R foldBetween0(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, int startLeaf, int endLeaf) {
            assert (Lists.isValidRange(startLeaf, endLeaf, 0));
            return acc;
        }

        @Override
        <R> R foldBetween0(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, ToIntFunction<? super S> metric, int startPosition, int endPosition, TetraFunction<? super R, ? super T, Integer, Integer, ? extends R> rangeReduction) {
            assert (Lists.isValidRange(startPosition, endPosition, 0));
            return acc;
        }

        @Override
        S getSummaryBetween0(int startLeaf, int endLeaf) {
            throw new AssertionError((Object)"Unreachable code");
        }

        @Override
        S getSummaryBetween0(ToIntFunction<? super S> metric, int startPosition, int endPosition, TriFunction<? super T, Integer, Integer, ? extends S> subSummary) {
            throw new AssertionError((Object)"Unreachable code");
        }

        @Override
        Tuple2<FingerTree<T, S>, FingerTree<T, S>> split0(int beforeLeaf) {
            assert (beforeLeaf == 0);
            return Tuples.t(this, this);
        }
    }

    public static abstract class NonEmptyFingerTree<T, S>
    extends FingerTree<T, S> {
        private NonEmptyFingerTree(ToSemigroup<? super T, S> semigroup) {
            super(semigroup);
        }

        @Override
        public Either<FingerTree<T, S>, NonEmptyFingerTree<T, S>> caseEmpty() {
            return Either.right(this);
        }

        public abstract S getSummary();

        @Override
        public BiIndex locate(BiFunction<? super S, Integer, Either<Integer, Integer>> navigate, int position) {
            if (navigate.apply(this.getSummary(), position).isRight()) {
                throw new IndexOutOfBoundsException("Position " + position + " is out of bounds");
            }
            return this.locate0(navigate, position);
        }

        @Override
        public BiIndex locateProgressively(ToIntFunction<? super S> metric, int position) {
            Lists.checkPosition(position, this.measure(metric));
            return this.locateProgressively0(metric, position);
        }

        @Override
        public BiIndex locateRegressively(ToIntFunction<? super S> metric, int position) {
            Lists.checkPosition(position, this.measure(metric));
            return this.locateRegressively0(metric, position);
        }

        public Tuple3<FingerTree<T, S>, T, FingerTree<T, S>> splitAt(int leaf) {
            Lists.checkIndex(leaf, this.getLeafCount());
            return this.split0(leaf).map((l, r0) -> r0.split0(1).map((m, r) -> Tuples.t(l, m.getLeaf0(0), r)));
        }

        public Tuple3<FingerTree<T, S>, Tuple2<T, Integer>, FingerTree<T, S>> split(ToIntFunction<? super S> metric, int position) {
            Lists.checkPosition(position, this.measure(metric));
            return this.split((? super S s, Integer i) -> {
                int n = metric.applyAsInt((Object)s);
                return i <= n ? Either.left(i) : Either.right(i - n);
            }, position);
        }

        public Tuple3<FingerTree<T, S>, Tuple2<T, Integer>, FingerTree<T, S>> split(BiFunction<? super S, Integer, Either<Integer, Integer>> navigate, int position) {
            if (navigate.apply(this.getSummary(), position).isRight()) {
                throw new IndexOutOfBoundsException("Position " + position + " is out of bounds");
            }
            BiIndex loc = this.locate0(navigate, position);
            return this.splitAt(loc.major).map((l, m, r) -> Tuples.t(l, Tuples.t(m, loc.minor), r));
        }

        @Override
        public NonEmptyFingerTree<T, S> join(FingerTree<T, S> rightTree) {
            return this.appendTree(rightTree);
        }

        final NonEmptyFingerTree<T, S> appendTree(FingerTree<T, S> right) {
            if (this.getDepth() >= right.getDepth()) {
                return this.appendLte(right).unify(Function.identity(), two -> two.map((x$0, x$1) -> FingerTree.branch(x$0, x$1)));
            }
            return ((NonEmptyFingerTree)right).prependTree(this);
        }

        final NonEmptyFingerTree<T, S> prependTree(FingerTree<T, S> left) {
            if (this.getDepth() >= left.getDepth()) {
                return this.prependLte(left).unify(Function.identity(), two -> two.map((x$0, x$1) -> FingerTree.branch(x$0, x$1)));
            }
            return ((NonEmptyFingerTree)left).appendTree(this);
        }

        abstract BiIndex locate0(BiFunction<? super S, Integer, Either<Integer, Integer>> var1, int var2);

        abstract BiIndex locateProgressively0(ToIntFunction<? super S> var1, int var2);

        abstract BiIndex locateRegressively0(ToIntFunction<? super S> var1, int var2);

        abstract Either<? extends NonEmptyFingerTree<T, S>, Tuple2<NonEmptyFingerTree<T, S>, NonEmptyFingerTree<T, S>>> appendLte(FingerTree<T, S> var1);

        abstract Either<? extends NonEmptyFingerTree<T, S>, Tuple2<NonEmptyFingerTree<T, S>, NonEmptyFingerTree<T, S>>> prependLte(FingerTree<T, S> var1);
    }
}

