/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.function.BiFunction;
import java.util.function.Function;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableBooleanValue;
import org.reactfx.AwaitingEventStream;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.Subscription;
import org.reactfx.util.Timer;

class SuccessionReducingStream<I, O>
extends EventStreamBase<O>
implements AwaitingEventStream<O> {
    private final EventStream<I> input;
    private final Function<? super I, ? extends O> initial;
    private final BiFunction<? super O, ? super I, ? extends O> reduction;
    private final Timer timer;
    private boolean hasEvent = false;
    private BooleanBinding pending = null;
    private O event = null;

    public SuccessionReducingStream(EventStream<I> input, Function<? super I, ? extends O> initial, BiFunction<? super O, ? super I, ? extends O> reduction, Function<Runnable, Timer> timerFactory) {
        this.input = input;
        this.initial = initial;
        this.reduction = reduction;
        this.timer = timerFactory.apply(this::handleTimeout);
    }

    @Override
    public ObservableBooleanValue pendingProperty() {
        if (this.pending == null) {
            this.pending = new BooleanBinding(){

                @Override
                protected boolean computeValue() {
                    return SuccessionReducingStream.this.hasEvent;
                }
            };
        }
        return this.pending;
    }

    @Override
    public boolean isPending() {
        return this.pending != null ? this.pending.get() : this.hasEvent;
    }

    @Override
    protected final Subscription observeInputs() {
        return this.input.subscribe(this::handleEvent);
    }

    private void handleEvent(I i) {
        if (this.hasEvent) {
            this.event = this.reduction.apply(this.event, i);
        } else {
            assert (this.event == null);
            this.event = this.initial.apply(i);
            this.hasEvent = true;
            this.invalidatePending();
        }
        this.timer.restart();
    }

    private void handleTimeout() {
        assert (this.hasEvent);
        this.hasEvent = false;
        O toEmit = this.event;
        this.event = null;
        this.emit(toEmit);
        this.invalidatePending();
    }

    private void invalidatePending() {
        if (this.pending != null) {
            this.pending.invalidate();
        }
    }
}

