/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.reactfx.EmissionBuilder;
import org.reactfx.EventStreamBase;
import org.reactfx.InputHandler;
import org.reactfx.Subscription;
import org.reactfx.TransitionBuilder;
import org.reactfx.TransmissionBuilder;
import org.reactfx.util.LL;
import org.reactfx.util.Tuple2;

class StatefulStream<S, O>
extends EventStreamBase<O> {
    private final List<InputHandler> inputHandlers;
    private S state;

    StatefulStream(S initialState, LL<TransitionBuilder<S>> transitions, LL<EmissionBuilder<S, O>> emissions, LL<TransmissionBuilder<S, O>> transmissions) {
        this.state = initialState;
        this.inputHandlers = new ArrayList<InputHandler>(transitions.size() + emissions.size() + transmissions.size());
        for (TransitionBuilder transitionBuilder : transitions) {
            this.inputHandlers.add(transitionBuilder.build(this::handleTransition));
        }
        for (EmissionBuilder emissionBuilder : emissions) {
            this.inputHandlers.add(emissionBuilder.build(this::handleEmission));
        }
        for (TransmissionBuilder transmissionBuilder : transmissions) {
            this.inputHandlers.add(transmissionBuilder.build(this::handleTransmission));
        }
    }

    @Override
    protected Subscription observeInputs() {
        return Subscription.multi(InputHandler::subscribeToInput, this.inputHandlers);
    }

    private void handleTransition(Function<S, S> transition) {
        this.state = transition.apply(this.state);
    }

    private void handleEmission(Function<S, Optional<O>> emission) {
        emission.apply(this.state).ifPresent(this::emit);
    }

    private void handleTransmission(Function<S, Tuple2<S, Optional<O>>> transmission) {
        Tuple2<S, Optional<O>> pair2 = transmission.apply(this.state);
        this.state = pair2._1;
        ((Optional)pair2._2).ifPresent(this::emit);
    }
}

