/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.function.Consumer;
import org.reactfx.EventStream;
import org.reactfx.Subscription;

class LimitedInvocationSubscriber<T>
implements Consumer<T> {
    private final Consumer<? super T> subscriber;
    private int remainingInvocations;
    private Subscription subscription = null;

    LimitedInvocationSubscriber(int limit2, Consumer<? super T> subscriber) {
        if (limit2 <= 0) {
            throw new IllegalArgumentException("Number of invocations must be positive. Was " + limit2);
        }
        this.subscriber = subscriber;
        this.remainingInvocations = limit2;
    }

    Subscription subscribeTo(EventStream<? extends T> stream) {
        assert (this.subscription == null);
        this.subscription = stream.subscribe(this);
        if (this.remainingInvocations == 0) {
            this.subscription.unsubscribe();
        }
        return this.subscription;
    }

    @Override
    public void accept(T t) {
        if (this.remainingInvocations != 0) {
            --this.remainingInvocations;
            if (this.remainingInvocations == 0 && this.subscription != null) {
                this.subscription.unsubscribe();
            }
            this.subscriber.accept(t);
        }
    }
}

