/*
 * Decompiled with CFR 0.152.
 */
package org.gciatto.kt.math;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gciatto.kt.math.BigDecimal;
import org.gciatto.kt.math.BigInteger;
import org.gciatto.kt.math.SignedMutableBigInteger;
import org.gciatto.kt.math.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\bD\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0010\u0018\u0000 }2\u00020\u0001:\u0001}B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0000J\u0018\u0010%\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u00002\u0006\u0010&\u001a\u00020\u0004J\u0016\u0010'\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0004J\u0016\u0010(\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0004J\u0010\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0000H\u0002J\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020#J\u000e\u0010.\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0000J\u000e\u0010/\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0000J\u0018\u00100\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0004H\u0002J\u000e\u00102\u001a\u00020#2\u0006\u0010\u0003\u001a\u00020\u0006J\u000e\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020\u0000J\u0010\u00104\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0000H\u0002J \u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J(\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0016\u0010;\u001a\u00020,2\u0006\u0010*\u001a\u00020,2\u0006\u0010<\u001a\u00020\u0000J\"\u0010;\u001a\u0004\u0018\u00010\u00002\u0006\u0010\b\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u00002\b\b\u0002\u0010=\u001a\u00020\u0011J\u001a\u0010>\u001a\u0004\u0018\u00010\u00002\u0006\u0010\b\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0000H\u0002J\u0018\u0010?\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0000H\u0002J\u0016\u0010@\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0000J\"\u0010A\u001a\u0004\u0018\u00010\u00002\u0006\u0010\b\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u00002\b\b\u0002\u0010=\u001a\u00020\u0011J\u0018\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020,2\u0006\u0010<\u001a\u00020\u0000H\u0002J\"\u0010D\u001a\u0004\u0018\u00010\u00002\u0006\u0010E\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u0011H\u0002J\u0016\u0010F\u001a\u00020\u00042\u0006\u0010G\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u0000J\u0010\u0010H\u001a\u00020#2\u0006\u0010I\u001a\u00020\u0004H\u0002J\u000e\u0010J\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u0004J \u0010L\u001a\u00020\u00002\u0006\u0010M\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u00042\u0006\u0010O\u001a\u00020\u0004H\u0002J\u0010\u0010P\u001a\u00020\u00042\u0006\u0010M\u001a\u00020\u0004H\u0002J\u0010\u0010Q\u001a\u00020,2\u0006\u0010M\u001a\u00020\u0004H\u0002J\u0010\u0010R\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0010\u0010S\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0000J\u0010\u0010T\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0004H\u0002J\u000e\u0010U\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0004J\u0010\u0010V\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u0000H\u0002J\u000e\u0010X\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u0004J\u0016\u0010Y\u001a\u00020#2\u0006\u0010Z\u001a\u00020\u00042\u0006\u0010[\u001a\u00020\u0000J0\u0010\\\u001a\u00020\u00042\u0006\u0010]\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u00062\u0006\u0010^\u001a\u00020\u00042\u0006\u0010I\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J0\u0010_\u001a\u00020\u00042\u0006\u0010]\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u00062\u0006\u0010^\u001a\u00020\u00042\u0006\u0010I\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J0\u0010`\u001a\u00020\u00042\u0006\u0010]\u001a\u00020\u00062\u0006\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020\u00042\u0006\u0010^\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0016\u0010a\u001a\u00020#2\u0006\u0010Z\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u0000J\u0010\u0010b\u001a\u0004\u0018\u00010\u00002\u0006\u0010c\u001a\u00020\u0000J\u0006\u0010d\u001a\u00020#J\u0010\u0010e\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0010\u0010f\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0010\u0010g\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0006\u0010h\u001a\u00020#J\u000e\u0010i\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0004J\u000e\u0010j\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0004J\u000e\u0010k\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0004J\u0016\u0010l\u001a\u00020#2\u0006\u0010M\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010!\u001a\u00020#2\u0006\u0010\u0003\u001a\u00020\u00062\u0006\u0010m\u001a\u00020\u0004J\u0006\u0010n\u001a\u00020\u0000J\u000e\u0010o\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0000J\u0016\u0010p\u001a\u00020q2\u0006\u0010r\u001a\u00020\u00042\u0006\u0010s\u001a\u00020\u0004J\u0006\u0010t\u001a\u00020\tJ\u000e\u0010t\u001a\u00020\t2\u0006\u0010r\u001a\u00020\u0004J\u000e\u0010u\u001a\u00020,2\u0006\u0010r\u001a\u00020\u0004J\u0006\u0010v\u001a\u00020\u0006J\b\u0010w\u001a\u00020,H\u0002J\b\u0010x\u001a\u00020yH\u0016J\u0018\u0010z\u001a\u00020\u00112\u0006\u0010{\u001a\u00020,2\u0006\u0010|\u001a\u00020,H\u0002R\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0005R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0016\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0017\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u0014\u0010\u0019\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000e\"\u0004\b\u001e\u0010\u0005R\u001a\u0010\u001f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001b\"\u0004\b!\u0010\u0007\u00a8\u0006~"}, d2={"Lorg/gciatto/kt/math/MutableBigInteger;", "", "()V", "val", "", "(I)V", "", "([I)V", "b", "Lorg/gciatto/kt/math/BigInteger;", "(Lorg/gciatto/kt/math/BigInteger;)V", "(Lorg/gciatto/kt/math/MutableBigInteger;)V", "intLen", "getIntLen", "()I", "setIntLen", "isEven", "", "()Z", "isNormal", "isOdd", "isOne", "isZero", "lowestSetBit", "getLowestSetBit", "magnitudeArray", "getMagnitudeArray", "()[I", "offset", "getOffset", "setOffset", "value", "getValue", "setValue", "add", "", "addend", "addDisjoint", "n", "addLower", "addShifted", "binaryGCD", "v", "bitLength", "", "clear", "compare", "compareHalf", "compareShifted", "ints", "copyValue", "src", "difference", "divadd", "a", "result", "divaddLong", "dh", "dl", "divide", "quotient", "needRemainder", "divide2n1n", "divide3n2n", "divideAndRemainderBurnikelZiegler", "divideKnuth", "divideLongMagnitude", "ldivisor", "divideMagnitude", "div", "divideOneWord", "divisor", "ensureCapacity", "len", "euclidModInverse", "k", "getBlock", "index", "numBlocks", "blockLength", "getInt", "getLong", "getLower", "hybridGCD", "keepLower", "leftShift", "modInverse", "mod", "modInverseMP2", "mul", "y", "z", "mulsub", "q", "x", "mulsubBorrow", "mulsubLong", "multiply", "mutableModInverse", "p", "normalize", "ones", "primitiveLeftShift", "primitiveRightShift", "reset", "rightShift", "safeLeftShift", "safeRightShift", "setInt", "length", "sqrt", "subtract", "toBigDecimal", "Lorg/gciatto/kt/math/BigDecimal;", "sign", "scale", "toBigInteger", "toCompactValue", "toIntArray", "toLong", "toString", "", "unsignedLongCompare", "one", "two", "Companion", "kt-math"})
public class MutableBigInteger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private int[] value;
    private int intLen;
    private int offset;
    @NotNull
    private static final MutableBigInteger ONE = new MutableBigInteger(1);
    private static final int KNUTH_POW2_THRESH_LEN = 6;
    private static final int KNUTH_POW2_THRESH_ZEROS = 3;

    @NotNull
    public final int[] getValue() {
        return this.value;
    }

    public final void setValue(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter(nArray, "<set-?>");
        this.value = nArray;
    }

    public final int getIntLen() {
        return this.intLen;
    }

    public final void setIntLen(int n) {
        this.intLen = n;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    private final int[] getMagnitudeArray() {
        int[] nArray;
        if (this.offset > 0 || this.value.length != this.intLen) {
            int[] nArray2 = this.value;
            int n = this.offset;
            int n2 = this.offset + this.intLen;
            boolean bl = false;
            nArray = ArraysKt.copyOfRange(nArray2, n, n2);
        } else {
            nArray = this.value;
        }
        return nArray;
    }

    private final int getLowestSetBit() {
        if (this.intLen == 0) {
            return -1;
        }
        int j = 0;
        int b = 0;
        j = this.intLen - 1;
        while (j > 0 && this.value[j + this.offset] == 0) {
            int n = j;
            j = n + -1;
        }
        b = this.value[j + this.offset];
        return b == 0 ? -1 : (this.intLen - 1 - j << 5) + Utils.numberOfTrailingZeros(b);
    }

    public final boolean isOne() {
        return this.intLen == 1 && this.value[this.offset] == 1;
    }

    public final boolean isZero() {
        return this.intLen == 0;
    }

    public final boolean isEven() {
        return this.intLen == 0 || (this.value[this.offset + this.intLen - 1] & 1) == 0;
    }

    public final boolean isOdd() {
        return this.isZero() ? false : (this.value[this.offset + this.intLen - 1] & 1) == 1;
    }

    public final boolean isNormal() {
        if (this.intLen + this.offset > this.value.length) {
            return false;
        }
        return this.intLen == 0 ? true : this.value[this.offset] != 0;
    }

    public MutableBigInteger() {
        this.value = new int[1];
        this.intLen = 0;
    }

    public MutableBigInteger(int val) {
        this.value = new int[1];
        this.intLen = 1;
        this.value[0] = val;
    }

    public MutableBigInteger(@NotNull int[] val) {
        Intrinsics.checkNotNullParameter(val, "val");
        this.value = val;
        this.intLen = val.length;
    }

    public MutableBigInteger(@NotNull BigInteger b) {
        Intrinsics.checkNotNullParameter(b, "b");
        this.intLen = b.get_mag$kt_math().length;
        int[] nArray = b.get_mag$kt_math();
        int n = this.intLen;
        boolean bl = false;
        int[] nArray2 = Arrays.copyOf(nArray, n);
        Intrinsics.checkNotNullExpressionValue(nArray2, "java.util.Arrays.copyOf(this, newSize)");
        this.value = nArray2;
    }

    public MutableBigInteger(@NotNull MutableBigInteger val) {
        Intrinsics.checkNotNullParameter(val, "val");
        this.intLen = val.intLen;
        int[] nArray = val.value;
        int n = val.offset;
        int n2 = val.offset + this.intLen;
        boolean bl = false;
        this.value = ArraysKt.copyOfRange(nArray, n, n2);
    }

    private final void ones(int n) {
        if (n > this.value.length) {
            this.value = new int[n];
        }
        Utils.fill(this.value, -1);
        this.offset = 0;
        this.intLen = n;
    }

    private final long toLong() {
        boolean bl = this.intLen <= 2;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "this MutableBigInteger exceeds the range of long";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        if (this.intLen == 0) {
            return 0L;
        }
        long d = (long)this.value[this.offset] & 0xFFFFFFFFL;
        return this.intLen == 2 ? d << 32 | (long)this.value[this.offset + 1] & 0xFFFFFFFFL : d;
    }

    @NotNull
    public final BigInteger toBigInteger(int sign) {
        return this.intLen == 0 || sign == 0 ? BigInteger.ZERO : new BigInteger(this.getMagnitudeArray(), sign);
    }

    @NotNull
    public final BigInteger toBigInteger() {
        this.normalize();
        return this.toBigInteger(this.isZero() ? 0 : 1);
    }

    @NotNull
    public final BigDecimal toBigDecimal(int sign, int scale) {
        if (this.intLen == 0 || sign == 0) {
            return BigDecimal.Companion.zeroValueOf$kt_math(scale);
        }
        int[] mag = this.getMagnitudeArray();
        int len = mag.length;
        int d = mag[0];
        if (len > 2 || d < 0 && len == 2) {
            return new BigDecimal(new BigInteger(mag, sign), Long.MIN_VALUE, scale, 0);
        }
        long v = len == 2 ? (long)mag[1] & 0xFFFFFFFFL | ((long)d & 0xFFFFFFFFL) << 32 : (long)d & 0xFFFFFFFFL;
        return BigDecimal.Companion.of(sign == -1 ? -v : v, scale);
    }

    public final long toCompactValue(int sign) {
        if (this.intLen == 0 || sign == 0) {
            return 0L;
        }
        int[] mag = this.getMagnitudeArray();
        int len = mag.length;
        int d = mag[0];
        if (len > 2 || d < 0 && len == 2) {
            return Long.MIN_VALUE;
        }
        long v = len == 2 ? (long)mag[1] & 0xFFFFFFFFL | ((long)d & 0xFFFFFFFFL) << 32 : (long)d & 0xFFFFFFFFL;
        return sign == -1 ? -v : v;
    }

    public final void clear() {
        this.offset = this.intLen = 0;
        int index = 0;
        int n = this.value.length;
        while (index < n) {
            this.value[index] = 0;
            int n2 = index;
            index = n2 + 1;
        }
    }

    public final void reset() {
        this.offset = this.intLen = 0;
    }

    public final int compare(@NotNull MutableBigInteger b) {
        Intrinsics.checkNotNullParameter(b, "b");
        int blen = b.intLen;
        if (this.intLen < blen) {
            return -1;
        }
        if (this.intLen > blen) {
            return 1;
        }
        int[] bval = b.value;
        int i = this.offset;
        int j = b.offset;
        while (i < this.intLen + this.offset) {
            int b1 = this.value[i] + Integer.MIN_VALUE;
            int b2 = bval[j] + Integer.MIN_VALUE;
            if (b1 < b2) {
                return -1;
            }
            if (b1 > b2) {
                return 1;
            }
            int n = i;
            i = n + 1;
            n = j;
            j = n + 1;
        }
        return 0;
    }

    private final int compareShifted(MutableBigInteger b, int ints) {
        int alen = this.intLen - ints;
        int blen = b.intLen;
        if (alen < blen) {
            return -1;
        }
        if (alen > blen) {
            return 1;
        }
        int[] bval = b.value;
        int i = this.offset;
        int j = b.offset;
        while (i < alen + this.offset) {
            int b1 = this.value[i] + Integer.MIN_VALUE;
            int b2 = bval[j] + Integer.MIN_VALUE;
            if (b1 < b2) {
                return -1;
            }
            if (b1 > b2) {
                return 1;
            }
            int n = i;
            i = n + 1;
            n = j;
            j = n + 1;
        }
        return 0;
    }

    public final int compareHalf(@NotNull MutableBigInteger b) {
        Intrinsics.checkNotNullParameter(b, "b");
        int blen = b.intLen;
        int len = this.intLen;
        if (len <= 0) {
            return blen <= 0 ? 0 : -1;
        }
        if (len > blen) {
            return 1;
        }
        if (len < blen - 1) {
            return -1;
        }
        int[] bval = b.value;
        int bstart = 0;
        int carry = 0;
        if (len != blen) {
            if (bval[bstart] == 1) {
                ++bstart;
                carry = Integer.MIN_VALUE;
            } else {
                return -1;
            }
        }
        int[] val = this.value;
        int i = this.offset;
        int j = bstart;
        while (i < len + this.offset) {
            int n = j;
            j = n + 1;
            int bv = bval[n];
            long hb = (long)(bv >>> 1) + (long)carry & 0xFFFFFFFFL;
            int n2 = i;
            i = n2 + 1;
            long v = (long)val[n2] & 0xFFFFFFFFL;
            if (v != hb) {
                return v < hb ? -1 : 1;
            }
            carry = (bv & 1) << 31;
        }
        return carry == 0 ? 0 : -1;
    }

    private final int getInt(int index) {
        return this.value[this.offset + index];
    }

    private final long getLong(int index) {
        return (long)this.value[this.offset + index] & 0xFFFFFFFFL;
    }

    public final void normalize() {
        int n;
        if (this.intLen == 0) {
            this.offset = 0;
            return;
        }
        int index = this.offset;
        if (this.value[index] != 0) {
            return;
        }
        int indexBound = index + this.intLen;
        while ((index = (n = index) + 1) < indexBound && this.value[index] == 0) {
        }
        int numZeros = index - this.offset;
        MutableBigInteger mutableBigInteger = this;
        mutableBigInteger.intLen -= numZeros;
        this.offset = this.intLen == 0 ? 0 : this.offset + numZeros;
    }

    private final void ensureCapacity(int len) {
        if (this.value.length < len) {
            this.value = new int[len];
            this.offset = 0;
            this.intLen = len;
        }
    }

    @NotNull
    public final int[] toIntArray() {
        int[] result2 = new int[this.intLen];
        int n = 0;
        int n2 = this.intLen;
        if (n < n2) {
            do {
                int i = n++;
                result2[i] = this.value[this.offset + i];
            } while (n < n2);
        }
        return result2;
    }

    public final void setInt(int index, int val) {
        this.value[this.offset + index] = val;
    }

    public final void setValue(@NotNull int[] val, int length) {
        Intrinsics.checkNotNullParameter(val, "val");
        this.value = val;
        this.intLen = length;
        this.offset = 0;
    }

    public final void copyValue(@NotNull MutableBigInteger src) {
        Intrinsics.checkNotNullParameter(src, "src");
        int len = src.intLen;
        if (this.value.length < len) {
            this.value = new int[len];
        }
        Utils.arrayCopy(src.value, src.offset, this.value, 0, len);
        this.intLen = len;
        this.offset = 0;
    }

    public final void copyValue(@NotNull int[] val) {
        Intrinsics.checkNotNullParameter(val, "val");
        int len = val.length;
        if (this.value.length < len) {
            this.value = new int[len];
        }
        Utils.arrayCopy(val, 0, this.value, 0, len);
        this.intLen = len;
        this.offset = 0;
    }

    @NotNull
    public String toString() {
        BigInteger b = this.toBigInteger(1);
        return b.toString();
    }

    public final void safeRightShift(int n) {
        if (n / 32 >= this.intLen) {
            this.reset();
        } else {
            this.rightShift(n);
        }
    }

    public final void rightShift(int n) {
        if (this.intLen == 0) {
            return;
        }
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        MutableBigInteger mutableBigInteger = this;
        mutableBigInteger.intLen -= nInts;
        if (nBits == 0) {
            return;
        }
        int bitsInHighWord = BigInteger.Companion.bitLengthForInt$kt_math(this.value[this.offset]);
        if (nBits >= bitsInHighWord) {
            this.primitiveLeftShift(32 - nBits);
            MutableBigInteger mutableBigInteger2 = this;
            int n2 = mutableBigInteger2.intLen;
            mutableBigInteger2.intLen = n2 + -1;
        } else {
            this.primitiveRightShift(nBits);
        }
    }

    public final void safeLeftShift(int n) {
        if (n > 0) {
            this.leftShift(n);
        }
    }

    public final void leftShift(int n) {
        int n2;
        if (this.intLen == 0) {
            return;
        }
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        int bitsInHighWord = BigInteger.Companion.bitLengthForInt$kt_math(this.value[this.offset]);
        if (n <= 32 - bitsInHighWord) {
            this.primitiveLeftShift(nBits);
            return;
        }
        int newLen = this.intLen + nInts + 1;
        if (nBits <= 32 - bitsInHighWord) {
            n2 = newLen;
            newLen = n2 + -1;
        }
        if (this.value.length < newLen) {
            int[] result2 = new int[newLen];
            int n3 = 0;
            int n4 = this.intLen;
            if (n3 < n4) {
                do {
                    int i = n3++;
                    result2[i] = this.value[this.offset + i];
                } while (n3 < n4);
            }
            this.setValue(result2, newLen);
        } else if (this.value.length - this.offset >= newLen) {
            n2 = 0;
            int n5 = newLen - this.intLen;
            if (n2 < n5) {
                do {
                    int i = n2++;
                    this.value[this.offset + this.intLen + i] = 0;
                } while (n2 < n5);
            }
        } else {
            n2 = 0;
            int n6 = this.intLen;
            if (n2 < n6) {
                do {
                    int i = n2++;
                    this.value[i] = this.value[this.offset + i];
                } while (n2 < n6);
            }
            if ((n2 = this.intLen) < newLen) {
                do {
                    int i = n2++;
                    this.value[i] = 0;
                } while (n2 < newLen);
            }
            this.offset = 0;
        }
        this.intLen = newLen;
        if (nBits == 0) {
            return;
        }
        if (nBits <= 32 - bitsInHighWord) {
            this.primitiveLeftShift(nBits);
        } else {
            this.primitiveRightShift(32 - nBits);
        }
    }

    private final int divadd(int[] a, int[] result2, int offset) {
        long carry = 0L;
        int n = a.length + -1;
        if (0 <= n) {
            do {
                int j = n--;
                long sum = ((long)a[j] & 0xFFFFFFFFL) + ((long)result2[j + offset] & 0xFFFFFFFFL) + carry;
                result2[j + offset] = (int)sum;
                carry = sum >>> 32;
            } while (0 <= n);
        }
        return (int)carry;
    }

    private final int mulsub(int[] q, int[] a, int x, int len, int offset) {
        int offset2 = offset;
        long xLong = (long)x & 0xFFFFFFFFL;
        long carry = 0L;
        offset2 += len;
        int n = len - 1;
        if (0 <= n) {
            do {
                int j = n--;
                long product2 = ((long)a[j] & 0xFFFFFFFFL) * xLong + carry;
                long difference = (long)q[offset2] - product2;
                int n2 = offset2;
                offset2 = n2 + -1;
                q[n2] = (int)difference;
                carry = (product2 >>> 32) + (long)((difference & 0xFFFFFFFFL) > ((long)(~((int)product2)) & 0xFFFFFFFFL) ? 1 : 0);
            } while (0 <= n);
        }
        return (int)carry;
    }

    private final int mulsubBorrow(int[] q, int[] a, int x, int len, int offset) {
        int offset2 = offset;
        long xLong = (long)x & 0xFFFFFFFFL;
        long carry = 0L;
        offset2 += len;
        int n = len - 1;
        if (0 <= n) {
            do {
                int j = n--;
                long product2 = ((long)a[j] & 0xFFFFFFFFL) * xLong + carry;
                int n2 = offset2;
                offset2 = n2 + -1;
                long difference = (long)q[n2] - product2;
                carry = (product2 >>> 32) + (long)((difference & 0xFFFFFFFFL) > ((long)(~((int)product2)) & 0xFFFFFFFFL) ? 1 : 0);
            } while (0 <= n);
        }
        return (int)carry;
    }

    private final void primitiveRightShift(int n) {
        int[] val = this.value;
        int n2 = 32 - n;
        int i = this.offset + this.intLen - 1;
        int c = val[i];
        while (i > this.offset) {
            int b = c;
            c = val[i - 1];
            val[i] = c << n2 | b >>> n;
            int n3 = i;
            i = n3 + -1;
        }
        val[this.offset] = val[this.offset] >>> n;
    }

    private final void primitiveLeftShift(int n) {
        int[] val = this.value;
        int n2 = 32 - n;
        int i = this.offset;
        int c = val[i];
        int m = i + this.intLen - 1;
        while (i < m) {
            int b = c;
            c = val[i + 1];
            val[i] = b << n | c >>> n2;
            int n3 = i;
            i = n3 + 1;
        }
        val[this.offset + this.intLen - 1] = val[this.offset + this.intLen - 1] << n;
    }

    private final BigInteger getLower(int n) {
        if (this.isZero()) {
            return BigInteger.ZERO;
        }
        if (this.intLen < n) {
            return this.toBigInteger(1);
        }
        int len = n;
        while (len > 0 && this.value[this.offset + this.intLen - len] == 0) {
            int n2 = len;
            len = n2 + -1;
        }
        int sign = len > 0 ? 1 : 0;
        int[] nArray = this.value;
        int n3 = this.offset + this.intLen - len;
        int n4 = this.offset + this.intLen;
        boolean bl = false;
        return new BigInteger(ArraysKt.copyOfRange(nArray, n3, n4), sign);
    }

    private final void keepLower(int n) {
        if (this.intLen >= n) {
            MutableBigInteger mutableBigInteger = this;
            mutableBigInteger.offset += this.intLen - n;
            this.intLen = n;
        }
    }

    public final void add(@NotNull MutableBigInteger addend) {
        int n;
        Intrinsics.checkNotNullParameter(addend, "addend");
        int x = this.intLen;
        int y = addend.intLen;
        int resultLen = this.intLen > addend.intLen ? this.intLen : addend.intLen;
        int[] result2 = this.value.length < resultLen ? new int[resultLen] : this.value;
        int rstart = result2.length - 1;
        long sum = 0L;
        long carry = 0L;
        while (x > 0 && y > 0) {
            n = x;
            x = n + -1;
            n = y;
            y = n + -1;
            sum = ((long)this.value[x + this.offset] & 0xFFFFFFFFL) + ((long)addend.value[y + addend.offset] & 0xFFFFFFFFL) + carry;
            n = rstart;
            rstart = n + -1;
            result2[n] = (int)sum;
            carry = sum >>> 32;
        }
        while (x > 0) {
            n = x;
            x = n + -1;
            if (carry == 0L && Intrinsics.areEqual(result2, this.value) && rstart == x + this.offset) {
                return;
            }
            sum = ((long)this.value[x + this.offset] & 0xFFFFFFFFL) + carry;
            n = rstart;
            rstart = n + -1;
            result2[n] = (int)sum;
            carry = sum >>> 32;
        }
        while (y > 0) {
            n = y;
            y = n + -1;
            sum = ((long)addend.value[y + addend.offset] & 0xFFFFFFFFL) + carry;
            n = rstart;
            rstart = n + -1;
            result2[n] = (int)sum;
            carry = sum >>> 32;
        }
        if (carry > 0L) {
            n = resultLen;
            if (result2.length < (resultLen = n + 1)) {
                int[] temp = new int[resultLen];
                Utils.arrayCopy(result2, 0, temp, 1, result2.length);
                temp[0] = 1;
                result2 = temp;
            } else {
                n = rstart;
                rstart = n + -1;
                result2[n] = 1;
            }
        }
        this.value = result2;
        this.intLen = resultLen;
        this.offset = result2.length - resultLen;
    }

    public final void addShifted(@NotNull MutableBigInteger addend, int n) {
        int n2;
        int bval;
        int n3;
        Intrinsics.checkNotNullParameter(addend, "addend");
        if (addend.isZero()) {
            return;
        }
        int x = this.intLen;
        int y = addend.intLen + n;
        int resultLen = this.intLen > y ? this.intLen : y;
        int[] result2 = this.value.length < resultLen ? new int[resultLen] : this.value;
        int rstart = result2.length - 1;
        long sum = 0L;
        long carry = 0L;
        while (x > 0 && y > 0) {
            n3 = x;
            x = n3 + -1;
            n3 = y;
            bval = (y = n3 + -1) + addend.offset < addend.value.length ? addend.value[y + addend.offset] : 0;
            sum = ((long)this.value[x + this.offset] & 0xFFFFFFFFL) + ((long)bval & 0xFFFFFFFFL) + carry;
            n2 = rstart;
            rstart = n2 + -1;
            result2[n2] = (int)sum;
            carry = sum >>> 32;
        }
        while (x > 0) {
            bval = x;
            x = bval + -1;
            if (carry == 0L && Intrinsics.areEqual(result2, this.value) && rstart == x + this.offset) {
                return;
            }
            sum = ((long)this.value[x + this.offset] & 0xFFFFFFFFL) + carry;
            bval = rstart;
            rstart = bval + -1;
            result2[bval] = (int)sum;
            carry = sum >>> 32;
        }
        while (y > 0) {
            bval = y;
            bval = (y = bval + -1) + addend.offset < addend.value.length ? addend.value[y + addend.offset] : 0;
            sum = ((long)bval & 0xFFFFFFFFL) + carry;
            n2 = rstart;
            rstart = n2 + -1;
            result2[n2] = (int)sum;
            carry = sum >>> 32;
        }
        if (carry > 0L) {
            bval = resultLen;
            if (result2.length < (resultLen = bval + 1)) {
                int[] temp = new int[resultLen];
                Utils.arrayCopy(result2, 0, temp, 1, result2.length);
                temp[0] = 1;
                result2 = temp;
            } else {
                n3 = rstart;
                rstart = n3 + -1;
                result2[n3] = 1;
            }
        }
        this.value = result2;
        this.intLen = resultLen;
        this.offset = result2.length - resultLen;
    }

    public final void addDisjoint(@Nullable MutableBigInteger addend, int n) {
        MutableBigInteger mutableBigInteger = addend;
        Intrinsics.checkNotNull(mutableBigInteger);
        if (mutableBigInteger.isZero()) {
            return;
        }
        int x = this.intLen;
        int y = addend.intLen + n;
        int resultLen = this.intLen > y ? this.intLen : y;
        int[] result2 = null;
        if (this.value.length < resultLen) {
            result2 = new int[resultLen];
        } else {
            result2 = this.value;
            Utils.fill(this.value, this.offset + this.intLen, this.value.length, 0);
        }
        int rstart = result2.length - 1;
        Utils.arrayCopy(this.value, this.offset, result2, rstart + 1 - x, x);
        int n2 = addend.value.length - addend.offset;
        int n3 = 0;
        int len = Math.min(y -= x, n2);
        Utils.arrayCopy(addend.value, addend.offset, result2, (rstart -= x) + 1 - y, len);
        n2 = rstart + 1 - y + len;
        n3 = rstart + 1;
        if (n2 < n3) {
            do {
                int i = n2++;
                result2[i] = 0;
            } while (n2 < n3);
        }
        this.value = result2;
        this.intLen = resultLen;
        this.offset = result2.length - resultLen;
    }

    public final void addLower(@NotNull MutableBigInteger addend, int n) {
        Intrinsics.checkNotNullParameter(addend, "addend");
        MutableBigInteger a = new MutableBigInteger(addend);
        if (a.offset + a.intLen >= n) {
            a.offset = a.offset + a.intLen - n;
            a.intLen = n;
        }
        a.normalize();
        this.add(a);
    }

    public final int subtract(@NotNull MutableBigInteger b) {
        int n;
        int resultLen;
        Intrinsics.checkNotNullParameter(b, "b");
        MutableBigInteger b2 = b;
        MutableBigInteger a = this;
        int[] result2 = this.value;
        int sign = a.compare(b2);
        if (sign == 0) {
            this.reset();
            return 0;
        }
        if (sign < 0) {
            MutableBigInteger tmp = a;
            a = b2;
            b2 = tmp;
        }
        if (result2.length < (resultLen = a.intLen)) {
            result2 = new int[resultLen];
        }
        long diff = 0L;
        int x = a.intLen;
        int y = b2.intLen;
        int rstart = result2.length - 1;
        while (y > 0) {
            n = x;
            x = n + -1;
            n = y;
            y = n + -1;
            diff = ((long)a.value[x + a.offset] & 0xFFFFFFFFL) - ((long)b2.value[y + b2.offset] & 0xFFFFFFFFL) - (long)((int)(-(diff >> 32)));
            n = rstart;
            rstart = n + -1;
            result2[n] = (int)diff;
        }
        while (x > 0) {
            n = x;
            x = n + -1;
            diff = ((long)a.value[x + a.offset] & 0xFFFFFFFFL) - (long)((int)(-(diff >> 32)));
            n = rstart;
            rstart = n + -1;
            result2[n] = (int)diff;
        }
        this.value = result2;
        this.intLen = resultLen;
        this.offset = this.value.length - resultLen;
        this.normalize();
        return sign;
    }

    private final int difference(MutableBigInteger b) {
        int n;
        MutableBigInteger a = this;
        MutableBigInteger b2 = b;
        int sign = a.compare(b2);
        if (sign == 0) {
            return 0;
        }
        if (sign < 0) {
            MutableBigInteger tmp = a;
            a = b2;
            b2 = tmp;
        }
        long diff = 0L;
        int x = a.intLen;
        int y = b2.intLen;
        while (y > 0) {
            n = x;
            x = n + -1;
            n = y;
            y = n + -1;
            diff = ((long)a.value[a.offset + x] & 0xFFFFFFFFL) - ((long)b2.value[b2.offset + y] & 0xFFFFFFFFL) - (long)((int)(-(diff >> 32)));
            a.value[a.offset + x] = (int)diff;
        }
        while (x > 0) {
            n = x;
            x = n + -1;
            diff = ((long)a.value[a.offset + x] & 0xFFFFFFFFL) - (long)((int)(-(diff >> 32)));
            a.value[a.offset + x] = (int)diff;
        }
        a.normalize();
        return sign;
    }

    public final void multiply(@NotNull MutableBigInteger y, @NotNull MutableBigInteger z) {
        Intrinsics.checkNotNullParameter(y, "y");
        Intrinsics.checkNotNullParameter(z, "z");
        int xLen = this.intLen;
        int yLen = y.intLen;
        int newLen = xLen + yLen;
        if (z.value.length < newLen) {
            z.value = new int[newLen];
        }
        z.offset = 0;
        z.intLen = newLen;
        long carry = 0L;
        MutableBigInteger mutableBigInteger = this;
        boolean bl = false;
        boolean bl2 = false;
        MutableBigInteger $this$multiply_u24lambda_u2d1 = mutableBigInteger;
        boolean bl3 = false;
        int j = yLen - 1;
        int k = yLen + xLen - 1;
        while (j >= 0) {
            long product2 = ((long)y.getValue()[j + y.getOffset()] & 0xFFFFFFFFL) * ((long)$this$multiply_u24lambda_u2d1.getValue()[xLen - 1 + $this$multiply_u24lambda_u2d1.getOffset()] & 0xFFFFFFFFL) + carry;
            z.getValue()[k] = (int)product2;
            carry = product2 >>> 32;
            int n = j;
            j = n + -1;
            n = k;
            k = n + -1;
        }
        z.value[xLen - 1] = (int)carry;
        int n = xLen - 2;
        if (0 <= n) {
            do {
                int i = n--;
                carry = 0L;
                int j2 = yLen - 1;
                int k2 = yLen + i;
                while (j2 >= 0) {
                    long product3 = ((long)y.value[j2 + y.offset] & 0xFFFFFFFFL) * ((long)this.value[i + this.offset] & 0xFFFFFFFFL) + ((long)z.value[k2] & 0xFFFFFFFFL) + carry;
                    z.value[k2] = (int)product3;
                    carry = product3 >>> 32;
                    int n2 = j2;
                    j2 = n2 + -1;
                    n2 = k2;
                    k2 = n2 + -1;
                }
                z.value[i] = (int)carry;
            } while (0 <= n);
        }
        z.normalize();
    }

    public final void mul(int y, @NotNull MutableBigInteger z) {
        Intrinsics.checkNotNullParameter(z, "z");
        if (y == 1) {
            z.copyValue(this);
            return;
        }
        if (y == 0) {
            z.clear();
            return;
        }
        long ylong = (long)y & 0xFFFFFFFFL;
        int[] zval = z.value.length < this.intLen + 1 ? new int[this.intLen + 1] : z.value;
        long carry = 0L;
        int n = this.intLen - 1;
        if (0 <= n) {
            do {
                int i = n--;
                long product2 = ylong * ((long)this.value[i + this.offset] & 0xFFFFFFFFL) + carry;
                zval[i + 1] = (int)product2;
                carry = product2 >>> 32;
            } while (0 <= n);
        }
        if (carry == 0L) {
            z.offset = 1;
            z.intLen = this.intLen;
        } else {
            z.offset = 0;
            z.intLen = this.intLen + 1;
            zval[0] = (int)carry;
        }
        z.value = zval;
    }

    public final int divideOneWord(int divisor, @NotNull MutableBigInteger quotient) {
        Intrinsics.checkNotNullParameter(quotient, "quotient");
        long divisorLong = (long)divisor & 0xFFFFFFFFL;
        if (this.intLen == 1) {
            long dividendValue = (long)this.value[this.offset] & 0xFFFFFFFFL;
            int q = (int)(dividendValue / divisorLong);
            int r = (int)(dividendValue - (long)q * divisorLong);
            quotient.value[0] = q;
            quotient.intLen = q == 0 ? 0 : 1;
            quotient.offset = 0;
            return r;
        }
        if (quotient.value.length < this.intLen) {
            quotient.value = new int[this.intLen];
        }
        quotient.offset = 0;
        quotient.intLen = this.intLen;
        int shift = Utils.numberOfLeadingZeros(divisor);
        int rem = this.value[this.offset];
        long remLong = (long)rem & 0xFFFFFFFFL;
        if (remLong < divisorLong) {
            quotient.value[0] = 0;
        } else {
            quotient.value[0] = (int)(remLong / divisorLong);
            rem = (int)(remLong - (long)quotient.value[0] * divisorLong);
            remLong = (long)rem & 0xFFFFFFFFL;
        }
        int xlen = this.intLen;
        while (--xlen > 0) {
            long dividendEstimate = remLong << 32 | (long)this.value[this.offset + this.intLen - xlen] & 0xFFFFFFFFL;
            int q = 0;
            if (dividendEstimate >= 0L) {
                q = (int)(dividendEstimate / divisorLong);
                rem = (int)(dividendEstimate - (long)q * divisorLong);
            } else {
                long tmp = Companion.divWord(dividendEstimate, divisor);
                q = (int)(tmp & 0xFFFFFFFFL);
                rem = (int)(tmp >>> 32);
            }
            quotient.value[this.intLen - xlen] = q;
            remLong = (long)rem & 0xFFFFFFFFL;
        }
        quotient.normalize();
        return shift > 0 ? rem % divisor : rem;
    }

    @Nullable
    public final MutableBigInteger divide(@NotNull MutableBigInteger b, @NotNull MutableBigInteger quotient, boolean needRemainder) {
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(quotient, "quotient");
        return b.intLen < 80 || this.intLen - b.intLen < 40 ? this.divideKnuth(b, quotient, needRemainder) : this.divideAndRemainderBurnikelZiegler(b, quotient);
    }

    public static /* synthetic */ MutableBigInteger divide$default(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2, MutableBigInteger mutableBigInteger3, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: divide");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return mutableBigInteger.divide(mutableBigInteger2, mutableBigInteger3, bl);
    }

    @Nullable
    public final MutableBigInteger divideKnuth(@NotNull MutableBigInteger b, @NotNull MutableBigInteger quotient, boolean needRemainder) {
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(quotient, "quotient");
        MutableBigInteger b2 = b;
        if (b2.intLen == 0) {
            throw new ArithmeticException("BigInteger div by zero");
        }
        if (this.intLen == 0) {
            quotient.intLen = quotient.offset = 0;
            return needRemainder ? new MutableBigInteger() : null;
        }
        int cmp = this.compare(b2);
        if (cmp < 0) {
            quotient.intLen = quotient.offset = 0;
            return needRemainder ? new MutableBigInteger(this) : null;
        }
        if (cmp == 0) {
            quotient.value[0] = quotient.intLen = 1;
            quotient.offset = 0;
            return needRemainder ? new MutableBigInteger() : null;
        }
        quotient.clear();
        if (b2.intLen == 1) {
            int r = this.divideOneWord(b2.value[b2.offset], quotient);
            return needRemainder ? (r == 0 ? new MutableBigInteger() : new MutableBigInteger(r)) : (MutableBigInteger)null;
        }
        if (this.intLen >= KNUTH_POW2_THRESH_LEN) {
            int n = this.getLowestSetBit();
            int n2 = b2.getLowestSetBit();
            boolean bl = false;
            int trailingZeroBits = Math.min(n, n2);
            if (trailingZeroBits >= KNUTH_POW2_THRESH_ZEROS * 32) {
                MutableBigInteger r;
                MutableBigInteger a = new MutableBigInteger(this);
                b2 = new MutableBigInteger(b2);
                a.rightShift(trailingZeroBits);
                b2.rightShift(trailingZeroBits);
                MutableBigInteger mutableBigInteger = r = MutableBigInteger.divideKnuth$default(a, b2, quotient, false, 4, null);
                Intrinsics.checkNotNull(mutableBigInteger);
                mutableBigInteger.leftShift(trailingZeroBits);
                return r;
            }
        }
        return this.divideMagnitude(b2, quotient, needRemainder);
    }

    public static /* synthetic */ MutableBigInteger divideKnuth$default(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2, MutableBigInteger mutableBigInteger3, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: divideKnuth");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return mutableBigInteger.divideKnuth(mutableBigInteger2, mutableBigInteger3, bl);
    }

    @NotNull
    public final MutableBigInteger divideAndRemainderBurnikelZiegler(@NotNull MutableBigInteger b, @NotNull MutableBigInteger quotient) {
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(quotient, "quotient");
        int r = this.intLen;
        int s = b.intLen;
        quotient.offset = quotient.intLen = 0;
        if (r < s) {
            return this;
        }
        int m = 1 << 32 - Utils.numberOfLeadingZeros(s / 80);
        int j = (s + m - 1) / m;
        int n = j * m;
        long n32 = 32L * (long)n;
        long l = 0L;
        long l2 = n32 - b.bitLength();
        boolean bl = false;
        int sigma = (int)Math.max(l, l2);
        MutableBigInteger bShifted = new MutableBigInteger(b);
        bShifted.safeLeftShift(sigma);
        MutableBigInteger aShifted = new MutableBigInteger(this);
        aShifted.safeLeftShift(sigma);
        int t = (int)((aShifted.bitLength() + n32) / n32);
        if (t < 2) {
            t = 2;
        }
        MutableBigInteger a1 = aShifted.getBlock(t - 1, t, n);
        MutableBigInteger z = aShifted.getBlock(t - 2, t, n);
        z.addDisjoint(a1, n);
        MutableBigInteger qi = new MutableBigInteger();
        MutableBigInteger ri = null;
        int n2 = t - 2;
        if (1 <= n2) {
            do {
                int i = n2--;
                ri = z.divide2n1n(bShifted, qi);
                z = aShifted.getBlock(i - 1, t, n);
                z.addDisjoint(ri, n);
                quotient.addShifted(qi, i * n);
            } while (1 <= n2);
        }
        ri = z.divide2n1n(bShifted, qi);
        quotient.add(qi);
        MutableBigInteger mutableBigInteger = ri;
        Intrinsics.checkNotNull(mutableBigInteger);
        mutableBigInteger.rightShift(sigma);
        return ri;
    }

    private final MutableBigInteger divide2n1n(MutableBigInteger b, MutableBigInteger quotient) {
        int n = b.intLen;
        if (n % 2 != 0 || n < 80) {
            return MutableBigInteger.divideKnuth$default(this, b, quotient, false, 4, null);
        }
        MutableBigInteger aUpper = new MutableBigInteger(this);
        aUpper.safeRightShift(32 * (n / 2));
        this.keepLower(n / 2);
        MutableBigInteger q1 = new MutableBigInteger();
        MutableBigInteger r1 = aUpper.divide3n2n(b, q1);
        this.addDisjoint(r1, n / 2);
        MutableBigInteger r2 = this.divide3n2n(b, quotient);
        quotient.addDisjoint(q1, n / 2);
        return r2;
    }

    private final MutableBigInteger divide3n2n(MutableBigInteger b, MutableBigInteger quotient) {
        int n = b.intLen / 2;
        MutableBigInteger a12 = new MutableBigInteger(this);
        a12.safeRightShift(32 * n);
        MutableBigInteger b1 = new MutableBigInteger(b);
        b1.safeRightShift(n * 32);
        BigInteger b2 = b.getLower(n);
        MutableBigInteger r = null;
        MutableBigInteger d = null;
        if (this.compareShifted(b, n) < 0) {
            r = a12.divide2n1n(b1, quotient);
            d = new MutableBigInteger(quotient.toBigInteger().times(b2));
        } else {
            quotient.ones(n);
            a12.add(b1);
            b1.leftShift(32 * n);
            a12.subtract(b1);
            r = a12;
            d = new MutableBigInteger(b2);
            d.leftShift(32 * n);
            d.subtract(new MutableBigInteger(b2));
        }
        MutableBigInteger mutableBigInteger = r;
        Intrinsics.checkNotNull(mutableBigInteger);
        mutableBigInteger.leftShift(32 * n);
        r.addLower(this, n);
        while (r.compare(d) < 0) {
            r.add(b);
            quotient.subtract(ONE);
        }
        r.subtract(d);
        return r;
    }

    private final MutableBigInteger getBlock(int index, int numBlocks, int blockLength) {
        int blockStart = index * blockLength;
        if (blockStart >= this.intLen) {
            return new MutableBigInteger();
        }
        int blockEnd = 0;
        blockEnd = index == numBlocks - 1 ? this.intLen : (index + 1) * blockLength;
        if (blockEnd > this.intLen) {
            return new MutableBigInteger();
        }
        int[] nArray = this.value;
        int n = this.offset + this.intLen - blockEnd;
        int n2 = this.offset + this.intLen - blockStart;
        boolean bl = false;
        int[] newVal = ArraysKt.copyOfRange(nArray, n, n2);
        return new MutableBigInteger(newVal);
    }

    public final long bitLength() {
        return this.intLen == 0 ? 0L : (long)this.intLen * 32L - (long)Utils.numberOfLeadingZeros(this.value[this.offset]);
    }

    public final long divide(long v, @NotNull MutableBigInteger quotient) {
        Intrinsics.checkNotNullParameter(quotient, "quotient");
        long v2 = v;
        if (v2 == 0L) {
            throw new ArithmeticException("BigInteger div by zero");
        }
        if (this.intLen == 0) {
            quotient.intLen = quotient.offset = 0;
            return 0L;
        }
        if (v2 < 0L) {
            v2 = -v2;
        }
        int d = (int)(v2 >>> 32);
        quotient.clear();
        return d == 0 ? (long)this.divideOneWord((int)v2, quotient) & 0xFFFFFFFFL : this.divideLongMagnitude(v2, quotient).toLong();
    }

    private final MutableBigInteger divideMagnitude(MutableBigInteger div, MutableBigInteger quotient, boolean needRemainder) {
        int i;
        int n22;
        int c;
        int rFrom;
        int[] remarr;
        int shift = Utils.numberOfLeadingZeros(div.value[div.offset]);
        int dlen = div.intLen;
        int[] divisor = null;
        MutableBigInteger rem = null;
        if (shift > 0) {
            divisor = new int[dlen];
            MutableBigInteger.Companion.copyAndShift(div.value, div.offset, dlen, divisor, 0, shift);
            if (Utils.numberOfLeadingZeros(this.value[this.offset]) >= shift) {
                remarr = new int[this.intLen + 1];
                rem = new MutableBigInteger(remarr);
                rem.intLen = this.intLen;
                rem.offset = 1;
                MutableBigInteger.Companion.copyAndShift(this.value, this.offset, this.intLen, remarr, 1, shift);
            } else {
                remarr = new int[this.intLen + 2];
                rem = new MutableBigInteger(remarr);
                rem.intLen = this.intLen + 1;
                rem.offset = 1;
                rFrom = this.offset;
                c = 0;
                n22 = 32 - shift;
                i = 1;
                while (i < this.intLen + 1) {
                    int b = c;
                    c = this.value[rFrom];
                    remarr[i] = b << shift | c >>> n22;
                    int n = i;
                    i = n + 1;
                    n = rFrom;
                    rFrom = n + 1;
                }
                remarr[this.intLen + 1] = c << shift;
            }
        } else {
            remarr = div.value;
            rFrom = div.offset;
            c = div.offset + div.intLen;
            n22 = 0;
            divisor = ArraysKt.copyOfRange(remarr, rFrom, c);
            rem = new MutableBigInteger(new int[this.intLen + 1]);
            Utils.arrayCopy(this.value, this.offset, rem.value, 1, this.intLen);
            rem.intLen = this.intLen;
            rem.offset = 1;
        }
        int nlen = rem.intLen;
        int limit2 = nlen - dlen + 1;
        if (quotient.value.length < limit2) {
            quotient.value = new int[limit2];
            quotient.offset = 0;
        }
        quotient.intLen = limit2;
        int[] q = quotient.value;
        if (rem.intLen == nlen) {
            rem.offset = 0;
            rem.value[0] = 0;
            MutableBigInteger n22 = rem;
            i = n22.intLen;
            n22.intLen = i + 1;
        }
        int dh = divisor[0];
        long dhLong = (long)dh & 0xFFFFFFFFL;
        int dl = divisor[1];
        int n = 0;
        int n3 = limit2 - 1;
        if (n < n3) {
            do {
                long nl;
                long rs;
                long estProduct;
                int j = n++;
                int qhat = 0;
                int qrem = 0;
                boolean skipCorrection = false;
                int nh = rem.value[j + rem.offset];
                int nh2 = nh + Integer.MIN_VALUE;
                int nm = rem.value[j + 1 + rem.offset];
                if (nh == dh) {
                    qhat = -1;
                    qrem = nh + nm;
                    skipCorrection = qrem + Integer.MIN_VALUE < nh2;
                } else {
                    long nChunk = (long)nh << 32 | (long)nm & 0xFFFFFFFFL;
                    if (nChunk >= 0L) {
                        qhat = (int)(nChunk / dhLong);
                        qrem = (int)(nChunk - (long)qhat * dhLong);
                    } else {
                        long tmp = Companion.divWord(nChunk, dh);
                        qhat = (int)(tmp & 0xFFFFFFFFL);
                        qrem = (int)(tmp >>> 32);
                    }
                }
                if (qhat == 0) continue;
                if (!skipCorrection && this.unsignedLongCompare(estProduct = ((long)dl & 0xFFFFFFFFL) * ((long)qhat & 0xFFFFFFFFL), rs = ((long)qrem & 0xFFFFFFFFL) << 32 | (nl = (long)rem.value[j + 2 + rem.offset] & 0xFFFFFFFFL))) {
                    int n4 = qhat;
                    qhat = n4 + -1;
                    if (((long)(qrem = (int)(((long)qrem & 0xFFFFFFFFL) + dhLong)) & 0xFFFFFFFFL) >= dhLong && this.unsignedLongCompare(estProduct -= (long)dl & 0xFFFFFFFFL, rs = ((long)qrem & 0xFFFFFFFFL) << 32 | nl)) {
                        n4 = qhat;
                        qhat = n4 + -1;
                    }
                }
                rem.value[j + rem.offset] = 0;
                int borrow = this.mulsub(rem.value, divisor, qhat, dlen, j + rem.offset);
                if (borrow + Integer.MIN_VALUE > nh2) {
                    this.divadd(divisor, rem.value, j + 1 + rem.offset);
                    int n5 = qhat;
                    qhat = n5 + -1;
                }
                q[j] = qhat;
            } while (n < n3);
        }
        int qhat = 0;
        int qrem = 0;
        boolean skipCorrection = false;
        int nh = rem.value[limit2 - 1 + rem.offset];
        int nh2 = nh + Integer.MIN_VALUE;
        int nm = rem.value[limit2 + rem.offset];
        if (nh == dh) {
            qhat = -1;
            qrem = nh + nm;
            skipCorrection = qrem + Integer.MIN_VALUE < nh2;
        } else {
            long nChunk = (long)nh << 32 | (long)nm & 0xFFFFFFFFL;
            if (nChunk >= 0L) {
                qhat = (int)(nChunk / dhLong);
                qrem = (int)(nChunk - (long)qhat * dhLong);
            } else {
                long tmp = Companion.divWord(nChunk, dh);
                qhat = (int)(tmp & 0xFFFFFFFFL);
                qrem = (int)(tmp >>> 32);
            }
        }
        if (qhat != 0) {
            long nl;
            long rs;
            long estProduct;
            if (!skipCorrection && this.unsignedLongCompare(estProduct = ((long)dl & 0xFFFFFFFFL) * ((long)qhat & 0xFFFFFFFFL), rs = ((long)qrem & 0xFFFFFFFFL) << 32 | (nl = (long)rem.value[limit2 + 1 + rem.offset] & 0xFFFFFFFFL))) {
                int n6 = qhat;
                qhat = n6 + -1;
                if (((long)(qrem = (int)(((long)qrem & 0xFFFFFFFFL) + dhLong)) & 0xFFFFFFFFL) >= dhLong && this.unsignedLongCompare(estProduct -= (long)dl & 0xFFFFFFFFL, rs = ((long)qrem & 0xFFFFFFFFL) << 32 | nl)) {
                    n6 = qhat;
                    qhat = n6 + -1;
                }
            }
            int borrow = 0;
            rem.value[limit2 - 1 + rem.offset] = 0;
            borrow = needRemainder ? this.mulsub(rem.value, divisor, qhat, dlen, limit2 - 1 + rem.offset) : this.mulsubBorrow(rem.value, divisor, qhat, dlen, limit2 - 1 + rem.offset);
            if (borrow + Integer.MIN_VALUE > nh2) {
                if (needRemainder) {
                    this.divadd(divisor, rem.value, limit2 - 1 + 1 + rem.offset);
                }
                int n7 = qhat;
                qhat = n7 + -1;
            }
            q[limit2 - 1] = qhat;
        }
        if (needRemainder) {
            if (shift > 0) {
                rem.rightShift(shift);
            }
            rem.normalize();
        }
        quotient.normalize();
        return needRemainder ? rem : null;
    }

    private final MutableBigInteger divideLongMagnitude(long ldivisor, MutableBigInteger quotient) {
        long ldivisor2 = ldivisor;
        MutableBigInteger rem = new MutableBigInteger(new int[this.intLen + 1]);
        Utils.arrayCopy(this.value, this.offset, rem.value, 1, this.intLen);
        rem.intLen = this.intLen;
        rem.offset = 1;
        int nlen = rem.intLen;
        int limit2 = nlen - 2 + 1;
        if (quotient.value.length < limit2) {
            quotient.value = new int[limit2];
            quotient.offset = 0;
        }
        quotient.intLen = limit2;
        int[] q = quotient.value;
        int shift = Utils.numberOfLeadingZeros(ldivisor2);
        if (shift > 0) {
            ldivisor2 <<= shift;
            rem.leftShift(shift);
        }
        if (rem.intLen == nlen) {
            rem.offset = 0;
            rem.value[0] = 0;
            MutableBigInteger mutableBigInteger = rem;
            int n = mutableBigInteger.intLen;
            mutableBigInteger.intLen = n + 1;
        }
        int dh = (int)(ldivisor2 >>> 32);
        long dhLong = (long)dh & 0xFFFFFFFFL;
        int dl = (int)(ldivisor2 & 0xFFFFFFFFL);
        int n = 0;
        if (n < limit2) {
            do {
                long nl;
                long rs;
                long estProduct;
                int j = n++;
                int qhat = 0;
                int qrem = 0;
                boolean skipCorrection = false;
                int nh = rem.value[j + rem.offset];
                int nh2 = nh + Integer.MIN_VALUE;
                int nm = rem.value[j + 1 + rem.offset];
                if (nh == dh) {
                    qhat = -1;
                    qrem = nh + nm;
                    skipCorrection = qrem + Integer.MIN_VALUE < nh2;
                } else {
                    long nChunk = (long)nh << 32 | (long)nm & 0xFFFFFFFFL;
                    if (nChunk >= 0L) {
                        qhat = (int)(nChunk / dhLong);
                        qrem = (int)(nChunk - (long)qhat * dhLong);
                    } else {
                        long tmp = Companion.divWord(nChunk, dh);
                        qhat = (int)(tmp & 0xFFFFFFFFL);
                        qrem = (int)(tmp >>> 32);
                    }
                }
                if (qhat == 0) continue;
                if (!skipCorrection && this.unsignedLongCompare(estProduct = ((long)dl & 0xFFFFFFFFL) * ((long)qhat & 0xFFFFFFFFL), rs = ((long)qrem & 0xFFFFFFFFL) << 32 | (nl = (long)rem.value[j + 2 + rem.offset] & 0xFFFFFFFFL))) {
                    int n2 = qhat;
                    qhat = n2 + -1;
                    if (((long)(qrem = (int)(((long)qrem & 0xFFFFFFFFL) + dhLong)) & 0xFFFFFFFFL) >= dhLong && this.unsignedLongCompare(estProduct -= (long)dl & 0xFFFFFFFFL, rs = ((long)qrem & 0xFFFFFFFFL) << 32 | nl)) {
                        n2 = qhat;
                        qhat = n2 + -1;
                    }
                }
                rem.value[j + rem.offset] = 0;
                int borrow = this.mulsubLong(rem.value, dh, dl, qhat, j + rem.offset);
                if (borrow + Integer.MIN_VALUE > nh2) {
                    this.divaddLong(dh, dl, rem.value, j + 1 + rem.offset);
                    int n3 = qhat;
                    qhat = n3 + -1;
                }
                q[j] = qhat;
            } while (n < limit2);
        }
        if (shift > 0) {
            rem.rightShift(shift);
        }
        quotient.normalize();
        rem.normalize();
        return rem;
    }

    private final int divaddLong(int dh, int dl, int[] result2, int offset) {
        long carry = 0L;
        long sum = ((long)dl & 0xFFFFFFFFL) + ((long)result2[1 + offset] & 0xFFFFFFFFL);
        result2[1 + offset] = (int)sum;
        sum = ((long)dh & 0xFFFFFFFFL) + ((long)result2[offset] & 0xFFFFFFFFL) + carry;
        result2[offset] = (int)sum;
        carry = sum >>> 32;
        return (int)carry;
    }

    private final int mulsubLong(int[] q, int dh, int dl, int x, int offset) {
        int offset2 = offset;
        long xLong = (long)x & 0xFFFFFFFFL;
        long product2 = ((long)dl & 0xFFFFFFFFL) * xLong;
        long difference = (long)q[offset2 += 2] - product2;
        int n = offset2;
        offset2 = n + -1;
        q[n] = (int)difference;
        long carry = (product2 >>> 32) + (long)((difference & 0xFFFFFFFFL) > ((product2 ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL) ? 1 : 0);
        product2 = ((long)dh & 0xFFFFFFFFL) * xLong + carry;
        difference = (long)q[offset2] - product2;
        int n2 = offset2;
        offset2 = n2 + -1;
        q[n2] = (int)difference;
        carry = (product2 >>> 32) + (long)((difference & 0xFFFFFFFFL) > ((product2 ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL) ? 1 : 0);
        return (int)carry;
    }

    private final boolean unsignedLongCompare(long one, long two) {
        return one + Long.MIN_VALUE > two + Long.MIN_VALUE;
    }

    @NotNull
    public final MutableBigInteger sqrt() {
        if (this.isZero()) {
            return new MutableBigInteger(0);
        }
        if (this.value.length == 1 && ((long)this.value[0] & 0xFFFFFFFFL) < 4L) {
            return ONE;
        }
        if (this.bitLength() <= 63L) {
            long v = new BigInteger(this.value, 1).toLongExact();
            double d = v;
            boolean bl = false;
            d = Math.sqrt(d);
            bl = false;
            long xk = (long)Math.floor(d);
            while (true) {
                long xk1;
                if ((xk1 = (xk + v / xk) / (long)2) >= xk) {
                    int[] nArray = new int[]{(int)(xk >>> 32), (int)(xk & 0xFFFFFFFFL)};
                    return new MutableBigInteger(nArray);
                }
                xk = xk1;
            }
        }
        int bitLength = (int)this.bitLength();
        if ((long)bitLength != this.bitLength()) {
            throw new ArithmeticException("bitLength() integer overflow");
        }
        int shift = bitLength - 63;
        if (shift % 2 == 1) {
            int xk = shift;
            shift = xk + 1;
        }
        MutableBigInteger xk = new MutableBigInteger(this);
        xk.rightShift(shift);
        xk.normalize();
        double d = new BigInteger(xk.value, 1).toDouble();
        boolean bl = false;
        double d2 = Math.sqrt(d);
        boolean bl2 = false;
        BigInteger bi = BigInteger.Companion.of((long)Math.ceil(d2));
        xk = new MutableBigInteger(bi.get_mag$kt_math());
        xk.leftShift(shift / 2);
        MutableBigInteger xk1 = new MutableBigInteger();
        while (true) {
            this.divide(xk, xk1, false);
            xk1.add(xk);
            xk1.rightShift(1);
            if (xk1.compare(xk) >= 0) {
                return xk;
            }
            xk.copyValue(xk1);
            xk1.reset();
        }
    }

    @NotNull
    public final MutableBigInteger hybridGCD(@Nullable MutableBigInteger b) {
        MutableBigInteger b2 = b;
        MutableBigInteger a = this;
        MutableBigInteger q = new MutableBigInteger();
        while (true) {
            MutableBigInteger mutableBigInteger = b2;
            Intrinsics.checkNotNull(mutableBigInteger);
            if (mutableBigInteger.intLen == 0) break;
            int n = a.intLen - b2.intLen;
            boolean bl = false;
            if (Math.abs(n) < 2) {
                return a.binaryGCD(b2);
            }
            MutableBigInteger r = MutableBigInteger.divide$default(a, b2, q, false, 4, null);
            a = b2;
            b2 = r;
        }
        return a;
    }

    private final MutableBigInteger binaryGCD(MutableBigInteger v) {
        int s2;
        int k;
        MutableBigInteger v2 = v;
        MutableBigInteger u = this;
        MutableBigInteger r = new MutableBigInteger();
        int s1 = u.getLowestSetBit();
        int n = k = s1 < (s2 = v2.getLowestSetBit()) ? s1 : s2;
        if (k != 0) {
            u.rightShift(k);
            v2.rightShift(k);
        }
        boolean uOdd = k == s1;
        MutableBigInteger t = uOdd ? v2 : u;
        int tsign = uOdd ? -1 : 1;
        int lb = t.getLowestSetBit();
        while (lb >= 0) {
            t.rightShift(lb);
            if (tsign > 0) {
                u = t;
            } else {
                v2 = t;
            }
            if (u.intLen < 2 && v2.intLen < 2) {
                int x = u.value[u.offset];
                int y = v2.value[v2.offset];
                r.value[0] = x = Companion.binaryGcd(x, y);
                r.intLen = 1;
                r.offset = 0;
                if (k > 0) {
                    r.leftShift(k);
                }
                return r;
            }
            tsign = u.difference(v2);
            if (tsign == 0) {
                lb = t.getLowestSetBit();
                break;
            }
            t = tsign >= 0 ? u : v2;
            lb = t.getLowestSetBit();
        }
        if (k > 0) {
            u.leftShift(k);
        }
        return u;
    }

    @Nullable
    public final MutableBigInteger mutableModInverse(@NotNull MutableBigInteger p) {
        Intrinsics.checkNotNullParameter(p, "p");
        if (p.isOdd()) {
            return this.modInverse(p);
        }
        if (this.isEven()) {
            throw new ArithmeticException("BigInteger not invertible.");
        }
        int powersOf2 = p.getLowestSetBit();
        MutableBigInteger oddMod = new MutableBigInteger(p);
        oddMod.rightShift(powersOf2);
        if (oddMod.isOne()) {
            return this.modInverseMP2(powersOf2);
        }
        MutableBigInteger oddPart = this.modInverse(oddMod);
        MutableBigInteger evenPart = this.modInverseMP2(powersOf2);
        MutableBigInteger y1 = Companion.modInverseBP2(oddMod, powersOf2);
        MutableBigInteger y2 = oddMod.modInverseMP2(powersOf2);
        MutableBigInteger temp1 = new MutableBigInteger();
        MutableBigInteger temp2 = new MutableBigInteger();
        MutableBigInteger result2 = new MutableBigInteger();
        oddPart.leftShift(powersOf2);
        oddPart.multiply(y1, result2);
        evenPart.multiply(oddMod, temp1);
        temp1.multiply(y2, temp2);
        result2.add(temp2);
        return MutableBigInteger.divide$default(result2, p, temp1, false, 4, null);
    }

    @NotNull
    public final MutableBigInteger modInverseMP2(int k) {
        if (this.isEven()) {
            throw new ArithmeticException("Non-invertible. (GCD != 1)");
        }
        if (k > 64) {
            return this.euclidModInverse(k);
        }
        int t = Companion.inverseMod32(this.value[this.offset + this.intLen - 1]);
        if (k < 33) {
            t = k == 32 ? t : t & (1 << k) - 1;
            return new MutableBigInteger(t);
        }
        long pLong = (long)this.value[this.offset + this.intLen - 1] & 0xFFFFFFFFL;
        if (this.intLen > 1) {
            pLong |= (long)this.value[this.offset + this.intLen - 2] << 32;
        }
        long tLong = (long)t & 0xFFFFFFFFL;
        tLong *= (long)2 - pLong * tLong;
        tLong = k == 64 ? tLong : tLong & (1L << k) - 1L;
        MutableBigInteger result2 = new MutableBigInteger(new int[2]);
        result2.value[0] = (int)(tLong >>> 32);
        result2.value[1] = (int)tLong;
        result2.intLen = 2;
        result2.normalize();
        return result2;
    }

    private final MutableBigInteger modInverse(MutableBigInteger mod) {
        int trailingZeros;
        MutableBigInteger p = new MutableBigInteger(mod);
        MutableBigInteger f = new MutableBigInteger(this);
        MutableBigInteger g = new MutableBigInteger(p);
        SignedMutableBigInteger c = new SignedMutableBigInteger(1);
        SignedMutableBigInteger d = new SignedMutableBigInteger();
        MutableBigInteger temp = null;
        SignedMutableBigInteger sTemp = null;
        int k = 0;
        if (f.isEven()) {
            trailingZeros = f.getLowestSetBit();
            f.rightShift(trailingZeros);
            d.leftShift(trailingZeros);
            k = trailingZeros;
        }
        while (!f.isOne()) {
            if (f.isZero()) {
                throw new ArithmeticException("BigInteger not invertible.");
            }
            if (f.compare(g) < 0) {
                temp = f;
                f = g;
                g = temp;
                sTemp = d;
                d = c;
                c = sTemp;
            }
            if (((f.value[f.offset + f.intLen - 1] ^ g.value[g.offset + g.intLen - 1]) & 3) == 0) {
                f.subtract(g);
                c.signedSubtract(d);
            } else {
                f.add(g);
                c.signedAdd(d);
            }
            trailingZeros = f.getLowestSetBit();
            f.rightShift(trailingZeros);
            d.leftShift(trailingZeros);
            k += trailingZeros;
        }
        while (c.getSign() < 0) {
            c.signedAdd(p);
        }
        return Companion.fixup(c, p, k);
    }

    @NotNull
    public final MutableBigInteger euclidModInverse(int k) {
        MutableBigInteger b = new MutableBigInteger(1);
        b.leftShift(k);
        MutableBigInteger mod = new MutableBigInteger(b);
        MutableBigInteger a = new MutableBigInteger(this);
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger r = MutableBigInteger.divide$default(b, a, q, false, 4, null);
        MutableBigInteger swapper = b;
        b = r;
        r = swapper;
        MutableBigInteger t1 = new MutableBigInteger(q);
        MutableBigInteger t0 = new MutableBigInteger(1);
        MutableBigInteger temp = new MutableBigInteger();
        while (true) {
            MutableBigInteger mutableBigInteger = b;
            Intrinsics.checkNotNull(mutableBigInteger);
            if (mutableBigInteger.isOne()) break;
            MutableBigInteger mutableBigInteger2 = r = MutableBigInteger.divide$default(a, b, q, false, 4, null);
            Intrinsics.checkNotNull(mutableBigInteger2);
            if (mutableBigInteger2.intLen == 0) {
                throw new ArithmeticException("BigInteger not invertible.");
            }
            a = swapper = r;
            if (q.intLen == 1) {
                t1.mul(q.value[q.offset], temp);
            } else {
                q.multiply(t1, temp);
            }
            swapper = q;
            q = temp;
            temp = swapper;
            t0.add(q);
            if (a.isOne()) {
                return t0;
            }
            MutableBigInteger mutableBigInteger3 = r = MutableBigInteger.divide$default(b, a, q, false, 4, null);
            Intrinsics.checkNotNull(mutableBigInteger3);
            if (mutableBigInteger3.intLen == 0) {
                throw new ArithmeticException("BigInteger not invertible.");
            }
            swapper = b;
            b = r;
            if (q.intLen == 1) {
                t0.mul(q.value[q.offset], temp);
            } else {
                q.multiply(t0, temp);
            }
            swapper = q;
            q = temp;
            temp = swapper;
            t1.add(q);
        }
        mod.subtract(t1);
        return mod;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0004J\u001e\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004J\u000e\u0010#\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001aJ\u0016\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006&"}, d2={"Lorg/gciatto/kt/math/MutableBigInteger$Companion;", "", "()V", "KNUTH_POW2_THRESH_LEN", "", "getKNUTH_POW2_THRESH_LEN", "()I", "KNUTH_POW2_THRESH_ZEROS", "getKNUTH_POW2_THRESH_ZEROS", "ONE", "Lorg/gciatto/kt/math/MutableBigInteger;", "getONE", "()Lorg/gciatto/kt/math/MutableBigInteger;", "binaryGcd", "a", "b", "copyAndShift", "", "src", "", "srcFrom", "srcLen", "dst", "dstFrom", "shift", "divWord", "", "n", "d", "fixup", "c", "p", "k", "inverseMod32", "val", "inverseMod64", "modInverseBP2", "mod", "kt-math"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MutableBigInteger getONE() {
            return ONE;
        }

        public final int getKNUTH_POW2_THRESH_LEN() {
            return KNUTH_POW2_THRESH_LEN;
        }

        public final int getKNUTH_POW2_THRESH_ZEROS() {
            return KNUTH_POW2_THRESH_ZEROS;
        }

        private final void copyAndShift(int[] src, int srcFrom, int srcLen, int[] dst, int dstFrom, int shift) {
            int srcFrom2 = srcFrom;
            int n2 = 32 - shift;
            int c = src[srcFrom2];
            int n = 0;
            int n3 = srcLen - 1;
            if (n < n3) {
                do {
                    int i = n++;
                    int b = c;
                    c = src[++srcFrom2];
                    dst[dstFrom + i] = b << shift | c >>> n2;
                } while (n < n3);
            }
            dst[dstFrom + srcLen - 1] = c << shift;
        }

        public final long divWord(long n, int d) {
            long l;
            long dLong = (long)d & 0xFFFFFFFFL;
            long r = 0L;
            long q = 0L;
            if (dLong == 1L) {
                q = (int)n;
                r = 0L;
                return r << 32 | q & 0xFFFFFFFFL;
            }
            q = (n >>> 1) / (dLong >>> 1);
            for (r = n - q * dLong; r < 0L; r += dLong) {
                l = q;
                q = l + -1L;
            }
            while (r >= dLong) {
                r -= dLong;
                l = q;
                q = l + 1L;
            }
            return r << 32 | q & 0xFFFFFFFFL;
        }

        public final int binaryGcd(int a, int b) {
            int t;
            int a2 = a;
            int b2 = b;
            if (b2 == 0) {
                return a2;
            }
            if (a2 == 0) {
                return b2;
            }
            int aZeros = Utils.numberOfTrailingZeros(a2);
            int bZeros = Utils.numberOfTrailingZeros(b2);
            a2 >>>= aZeros;
            b2 >>>= bZeros;
            int n = t = aZeros < bZeros ? aZeros : bZeros;
            while (a2 != b2) {
                if (a2 + Integer.MIN_VALUE > b2 + Integer.MIN_VALUE) {
                    a2 -= b2;
                    a2 >>>= Utils.numberOfTrailingZeros(a2);
                    continue;
                }
                b2 -= a2;
                b2 >>>= Utils.numberOfTrailingZeros(b2);
            }
            return a2 << t;
        }

        public final int inverseMod32(int val) {
            int t = val;
            t *= 2 - val * t;
            t *= 2 - val * t;
            t *= 2 - val * t;
            t *= 2 - val * t;
            return t;
        }

        public final long inverseMod64(long val) {
            long t = val;
            t *= (long)2 - val * t;
            t *= (long)2 - val * t;
            t *= (long)2 - val * t;
            t *= (long)2 - val * t;
            boolean bl = (t *= (long)2 - val * t) * val == 1L;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            return t;
        }

        @NotNull
        public final MutableBigInteger modInverseBP2(@NotNull MutableBigInteger mod, int k) {
            Intrinsics.checkNotNullParameter(mod, "mod");
            return this.fixup(new MutableBigInteger(1), new MutableBigInteger(mod), k);
        }

        @NotNull
        public final MutableBigInteger fixup(@NotNull MutableBigInteger c, @NotNull MutableBigInteger p, int k) {
            Intrinsics.checkNotNullParameter(c, "c");
            Intrinsics.checkNotNullParameter(p, "p");
            MutableBigInteger temp = new MutableBigInteger();
            int r = -this.inverseMod32(p.getValue()[p.getOffset() + p.getIntLen() - 1]);
            int i = 0;
            int numWords = k >> 5;
            while (i < numWords) {
                int v = r * c.getValue()[c.getOffset() + c.getIntLen() - 1];
                p.mul(v, temp);
                c.add(temp);
                MutableBigInteger mutableBigInteger = c;
                int n = mutableBigInteger.getIntLen();
                mutableBigInteger.setIntLen(n + -1);
                int n2 = i;
                i = n2 + 1;
            }
            int numBits = k & 0x1F;
            if (numBits != 0) {
                int v = r * c.getValue()[c.getOffset() + c.getIntLen() - 1];
                p.mul(v &= (1 << numBits) - 1, temp);
                c.add(temp);
                c.rightShift(numBits);
            }
            while (c.compare(p) >= 0) {
                c.subtract(p);
            }
            return c;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

