/*
 * Decompiled with CFR 0.152.
 */
package org.gciatto.kt.math;

import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.gciatto.kt.math.BigInteger;
import org.gciatto.kt.math.MathContext;
import org.gciatto.kt.math.MutableBigInteger;
import org.gciatto.kt.math.RoundingMode;
import org.gciatto.kt.math.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0010\n\u0002\u0010\u0011\n\u0002\b\u0012\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\n\n\u0002\b\t\u0018\u0000 ~2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0004~\u007f\u0080\u0001B)\b\u0010\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tB-\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u0007\u0012\b\b\u0002\u0010\r\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B\u0017\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0011B\u000f\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013B\u0017\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0012\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0014B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0016B\u000f\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0017B\u0017\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0018B\u0017\b\u0010\u0012\u0006\u0010\u0019\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001aB!\b\u0010\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u001bB\u000f\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001cB\u0017\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u001dB\u000f\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u001eB\u0017\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u001fJ\u0012\u0010%\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0005H\u0002J\b\u00107\u001a\u00020\u0000H\u0002J\u0010\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0007H\u0002J\u0010\u0010:\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010;\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0000H\u0002J\u0011\u0010<\u001a\u00020\u00072\u0006\u0010=\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u0000H\u0087\u0002J\u0018\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0007H\u0003J \u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u0007H\u0003J \u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010@\u001a\u00020AH\u0002J\u001a\u0010>\u001a\u0004\u0018\u00010\u00002\u0006\u0010?\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020AH\u0002J\u001c\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000C2\u0006\u0010?\u001a\u00020\u0000H\u0007J$\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000C2\u0006\u0010?\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010D\u001a\u0004\u0018\u00010\u00002\u0006\u0010?\u001a\u00020\u0000H\u0007J\u001a\u0010D\u001a\u0004\u0018\u00010\u00002\u0006\u0010?\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0013\u0010E\u001a\u00020)2\b\u0010=\u001a\u0004\u0018\u00010FH\u0096\u0002J \u0010G\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u00072\u0006\u0010H\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010I\u001a\u00020\u0007H\u0016J\b\u0010J\u001a\u00020\u0003H\u0002J\u0010\u0010K\u001a\u00020\u00122\u0006\u0010L\u001a\u00020)H\u0002J\u0010\u0010M\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0000H\u0007J\u0010\u0010N\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0000H\u0007J\u0011\u0010O\u001a\u00020\u00002\u0006\u0010P\u001a\u00020\u0000H\u0087\u0002J\u0018\u0010O\u001a\u00020\u00002\u0006\u0010P\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010Q\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0007H\u0007J\u0010\u0010R\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0007H\u0007J\u0013\u0010S\u001a\u00020\u00002\b\u0010T\u001a\u0004\u0018\u00010\u0000H\u0087\u0002J\u001a\u0010S\u001a\u00020\u00002\b\u0010T\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0011\u0010U\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0007H\u0087\u0004J\u001a\u0010U\u001a\u0004\u0018\u00010\u00002\u0006\u00109\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J3\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00000W2\u0006\u0010X\u001a\u00020\u00002\u0006\u0010T\u001a\u00020\u00002\u0006\u0010Y\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010ZJ\u0011\u0010[\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u0000H\u0087\u0002J\u0018\u0010[\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\\\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010]\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0007H\u0007J\u0010\u0010^\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\u0007H\u0007J\u0018\u0010^\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u0007H\u0003J\u0018\u0010^\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\u00072\u0006\u0010@\u001a\u00020AH\u0007J\u0012\u0010`\u001a\u00020\u00002\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010a\u001a\u00020)2\u0006\u0010b\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010c\u001a\u00020)2\u0006\u0010b\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010d\u001a\u00020\u0000H\u0007J\u0018\u0010e\u001a\u00020\u00002\u0006\u0010f\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0013\u0010e\u001a\u00020\u00002\b\u0010f\u001a\u0004\u0018\u00010\u0000H\u0087\u0002J\b\u0010g\u001a\u00020\u0003H\u0007J\b\u0010h\u001a\u00020\u0003H\u0007J\b\u0010i\u001a\u00020jH\u0007J\b\u0010k\u001a\u00020jH\u0007J\b\u0010l\u001a\u00020mH\u0007J\b\u0010n\u001a\u00020\u0015H\u0007J\b\u0010o\u001a\u00020\u0012H\u0007J\b\u0010p\u001a\u00020qH\u0007J\b\u0010r\u001a\u00020\u0007H\u0007J\b\u0010s\u001a\u00020\u0007H\u0007J\b\u0010t\u001a\u00020\u0005H\u0007J\b\u0010u\u001a\u00020\u0005H\u0007J\b\u0010v\u001a\u00020\u0012H\u0007J\b\u0010w\u001a\u00020xH\u0007J\b\u0010y\u001a\u00020xH\u0007J\b\u0010z\u001a\u00020\u0012H\u0016J\b\u0010{\u001a\u00020\u0000H\u0007J\t\u0010|\u001a\u00020\u0000H\u0087\u0002J\u0012\u0010|\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\t\u0010}\u001a\u00020\u0000H\u0087\u0002J\u0012\u0010}\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010 \u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010*R\u0011\u0010+\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b.\u0010-R\u0011\u0010/\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b0\u0010-R\u0011\u00101\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u0006\u0081\u0001"}, d2={"Lorg/gciatto/kt/math/BigDecimal;", "", "intVal", "Lorg/gciatto/kt/math/BigInteger;", "val", "", "scale", "", "prec", "(Lorg/gciatto/kt/math/BigInteger;JII)V", "in", "", "offset", "len", "mc", "Lorg/gciatto/kt/math/MathContext;", "([CIILorg/gciatto/kt/math/MathContext;)V", "([CLorg/gciatto/kt/math/MathContext;)V", "", "(Ljava/lang/String;)V", "(Ljava/lang/String;Lorg/gciatto/kt/math/MathContext;)V", "", "(DLorg/gciatto/kt/math/MathContext;)V", "(Lorg/gciatto/kt/math/BigInteger;)V", "(Lorg/gciatto/kt/math/BigInteger;Lorg/gciatto/kt/math/MathContext;)V", "unscaledVal", "(Lorg/gciatto/kt/math/BigInteger;I)V", "(Lorg/gciatto/kt/math/BigInteger;ILorg/gciatto/kt/math/MathContext;)V", "(I)V", "(ILorg/gciatto/kt/math/MathContext;)V", "(J)V", "(JLorg/gciatto/kt/math/MathContext;)V", "_intCompact", "_intVal", "_precision", "_scale", "_stringCache", "absoluteValue", "getAbsoluteValue", "()Lorg/gciatto/kt/math/BigDecimal;", "isPowerOfTen", "", "()Z", "precision", "getPrecision", "()I", "getScale", "signum", "getSignum", "unscaledValue", "getUnscaledValue", "()Lorg/gciatto/kt/math/BigInteger;", "adjustScale", "scl", "exp", "audit", "bigMultiplyPowerTen", "n", "checkScale", "compareMagnitude", "compareTo", "other", "div", "divisor", "roundingMode", "Lorg/gciatto/kt/math/RoundingMode;", "divideAndRemainder", "Lkotlin/Pair;", "divideToIntegralValue", "equals", "", "getValueString", "intString", "hashCode", "inflated", "layoutChars", "sci", "max", "min", "minus", "subtrahend", "movePointLeft", "movePointRight", "plus", "augend", "pow", "preAlign", "", "lhs", "padding", "(Lorg/gciatto/kt/math/BigDecimal;Lorg/gciatto/kt/math/BigDecimal;JLorg/gciatto/kt/math/MathContext;)[Lorg/gciatto/kt/math/BigDecimal;", "rem", "round", "scaleByPowerOfTen", "setScale", "newScale", "sqrt", "squareRootResultAssertions", "result", "squareRootZeroResultAssertions", "stripTrailingZeros", "times", "multiplicand", "toBigInteger", "toBigIntegerExact", "toByte", "", "toByteExact", "toChar", "", "toDouble", "toEngineeringString", "toFloat", "", "toInt", "toIntExact", "toLong", "toLongExact", "toPlainString", "toShort", "", "toShortExact", "toString", "ulp", "unaryMinus", "unaryPlus", "Companion", "LongOverflow", "StringBuilderHelper", "kt-math"})
public final class BigDecimal
implements Comparable<BigDecimal> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final BigInteger _intVal;
    private final int _scale;
    private int _precision;
    @Nullable
    private String _stringCache;
    private final long _intCompact;
    public static final long INFLATED = Long.MIN_VALUE;
    @NotNull
    private static final BigInteger INFLATED_BIGINT = BigInteger.Companion.of(Long.MIN_VALUE);
    private static final int MAX_COMPACT_DIGITS = 18;
    @NotNull
    private static final BigDecimal[] ZERO_THROUGH_TEN;
    @NotNull
    private static final BigDecimal[] ZERO_SCALED_BY;
    private static final long HALF_LONG_MAX_VALUE = 0x3FFFFFFFFFFFFFFFL;
    private static final long HALF_LONG_MIN_VALUE = -4611686018427387904L;
    @JvmField
    @NotNull
    public static final BigDecimal ZERO;
    @JvmField
    @NotNull
    public static final BigDecimal ONE;
    @JvmField
    @NotNull
    public static final BigDecimal TWO;
    @JvmField
    @NotNull
    public static final BigDecimal TEN;
    @JvmField
    @NotNull
    public static final BigDecimal ONE_TENTH;
    @JvmField
    @NotNull
    public static final BigDecimal ONE_HALF;
    @JvmField
    @NotNull
    public static final BigDecimal PI;
    @JvmField
    @NotNull
    public static final BigDecimal E;
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    @NotNull
    private static final double[] DOUBLE_10_POW;
    @NotNull
    private static final float[] FLOAT_10_POW;
    @NotNull
    private static final long[] LONG_TEN_POWERS_TABLE;
    @NotNull
    private static BigInteger[] BIG_TEN_POWERS_TABLE;
    private static final int BIG_TEN_POWERS_TABLE_INITLEN;
    private static final int BIG_TEN_POWERS_TABLE_MAX;
    @NotNull
    private static final long[] THRESHOLDS_TABLE;
    private static final long DIV_NUM_BASE = 0x100000000L;
    @NotNull
    private static final long[][] LONGLONG_TEN_POWERS_TABLE;

    private final boolean isPowerOfTen() {
        return Intrinsics.areEqual(BigInteger.ONE, this.getUnscaledValue());
    }

    public BigDecimal(@Nullable BigInteger intVal, long val, int scale, int prec) {
        this._scale = scale;
        this._precision = prec;
        this._intCompact = val;
        this._intVal = intVal;
    }

    public BigDecimal(@NotNull char[] in, int offset, int len, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter(in, "in");
        Intrinsics.checkNotNullParameter(mc, "mc");
        int offset2 = offset;
        int len2 = len;
        if (offset2 + len2 > in.length || offset2 < 0) {
            throw new NumberFormatException("Bad offset or len arguments for char[] input.");
        }
        int prec = 0;
        int scl = 0;
        long rs = 0L;
        BigInteger rb = null;
        try {
            int n;
            boolean isneg = false;
            if (in[offset2] == '-') {
                isneg = true;
                n = offset2;
                offset2 = n + 1;
                n = len2;
                len2 = n + -1;
            } else if (in[offset2] == '+') {
                n = offset2;
                offset2 = n + 1;
                n = len2;
                len2 = n + -1;
            }
            boolean dot = false;
            long exp = 0L;
            char c = '\u0000';
            boolean isCompact = len2 <= 18;
            int idx = 0;
            if (isCompact) {
                while (len2 > 0) {
                    int digit;
                    c = in[offset2];
                    if (c == '0') {
                        if (prec == 0) {
                            prec = 1;
                        } else if (rs != 0L) {
                            rs *= (long)10;
                            ++prec;
                        }
                        if (dot) {
                            ++scl;
                        }
                    } else {
                        boolean bl = '1' <= c ? c <= '9' : false;
                        if (bl) {
                            digit = c - 48;
                            if (prec != 1 || rs != 0L) {
                                ++prec;
                            }
                            rs = rs * (long)10 + (long)digit;
                            if (dot) {
                                ++scl;
                            }
                        } else if (c == '.') {
                            if (dot) {
                                throw new NumberFormatException("Character array contains more than one decimal point.");
                            }
                            dot = true;
                        } else if (Utils.isDigit(c)) {
                            digit = Utils.toDigit(c, 10);
                            if (digit == 0) {
                                if (prec == 0) {
                                    prec = 1;
                                } else if (rs != 0L) {
                                    rs *= (long)10;
                                    ++prec;
                                }
                            } else {
                                if (prec != 1 || rs != 0L) {
                                    ++prec;
                                }
                                rs = rs * (long)10 + (long)digit;
                            }
                            if (dot) {
                                ++scl;
                            }
                        } else {
                            if (c == 'e' || c == 'E') {
                                exp = BigDecimal.Companion.parseExp(in, offset2, len2);
                                if ((long)((int)exp) == exp) break;
                                throw new NumberFormatException("Exponent overflow.");
                            }
                            throw new NumberFormatException("Character " + c + " is neither a decimal digit number, decimal point, nor \"e\" notation exponential mark.");
                        }
                    }
                    digit = offset2;
                    offset2 = digit + 1;
                    digit = len2;
                    len2 = digit + -1;
                }
                if (prec == 0) {
                    throw new NumberFormatException("No digits found.");
                }
                if (exp != 0L) {
                    scl = this.adjustScale(scl, exp);
                }
                rs = isneg ? -rs : rs;
                int mcp = mc.getPrecision();
                int drop = prec - mcp;
                if (mcp > 0 && drop > 0) {
                    while (drop > 0) {
                        scl = BigDecimal.Companion.checkScaleNonZero((long)scl - (long)drop);
                        rs = BigDecimal.Companion.divideAndRound(rs, BigDecimal.LONG_TEN_POWERS_TABLE[drop], mc.getRoundingMode().getOldMode$kt_math());
                        prec = Companion.longDigitLength$kt_math(rs);
                        drop = prec - mcp;
                    }
                }
            } else {
                char[] coeff = new char[len2];
                while (len2 > 0) {
                    int drop;
                    c = in[offset2];
                    boolean bl = '0' <= c ? c <= '9' : false;
                    if (bl || Utils.isDigit(c)) {
                        if (c == '0' || Utils.toDigit(c, 10) == 0) {
                            if (prec == 0) {
                                coeff[idx] = c;
                                prec = 1;
                            } else if (idx != 0) {
                                drop = idx;
                                idx = drop + 1;
                                coeff[drop] = c;
                                ++prec;
                            }
                        } else {
                            if (prec != 1 || idx != 0) {
                                ++prec;
                            }
                            drop = idx;
                            idx = drop + 1;
                            coeff[drop] = c;
                        }
                        if (dot) {
                            ++scl;
                        }
                        drop = offset2;
                        offset2 = drop + 1;
                        drop = len2;
                        len2 = drop + -1;
                        continue;
                    }
                    if (c == '.') {
                        if (dot) {
                            throw new NumberFormatException("Character array contains more than one decimal point.");
                        }
                        dot = true;
                        drop = offset2;
                        offset2 = drop + 1;
                        drop = len2;
                        len2 = drop + -1;
                        continue;
                    }
                    if (c != 'e' && c != 'E') {
                        throw new NumberFormatException("Character array is missing \"e\" notation exponential mark.");
                    }
                    exp = BigDecimal.Companion.parseExp(in, offset2, len2);
                    if ((long)((int)exp) == exp) break;
                    throw new NumberFormatException("Exponent overflow.");
                }
                if (prec == 0) {
                    throw new NumberFormatException("No digits found.");
                }
                if (exp != 0L) {
                    scl = this.adjustScale(scl, exp);
                }
                rb = new BigInteger(coeff, isneg ? -1 : 1, prec);
                rs = BigDecimal.Companion.compactValFor(rb);
                int mcp = mc.getPrecision();
                boolean bl = 1 <= mcp ? mcp < prec : false;
                if (bl) {
                    int drop;
                    if (rs == Long.MIN_VALUE) {
                        drop = prec - mcp;
                        while (drop > 0) {
                            scl = BigDecimal.Companion.checkScaleNonZero((long)scl - (long)drop);
                            BigInteger bigInteger = rb;
                            Intrinsics.checkNotNull(bigInteger);
                            rb = BigDecimal.Companion.divideAndRoundByTenPow(bigInteger, drop, mc.getRoundingMode().getOldMode$kt_math());
                            rs = BigDecimal.Companion.compactValFor(rb);
                            if (rs != Long.MIN_VALUE) {
                                prec = Companion.longDigitLength$kt_math(rs);
                                break;
                            }
                            prec = BigDecimal.Companion.bigDigitLength(rb);
                            drop = prec - mcp;
                        }
                    }
                    if (rs != Long.MIN_VALUE) {
                        drop = prec - mcp;
                        while (drop > 0) {
                            scl = BigDecimal.Companion.checkScaleNonZero((long)scl - (long)drop);
                            rs = BigDecimal.Companion.divideAndRound(rs, BigDecimal.LONG_TEN_POWERS_TABLE[drop], mc.getRoundingMode().getOldMode$kt_math());
                            prec = Companion.longDigitLength$kt_math(rs);
                            drop = prec - mcp;
                        }
                        rb = null;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            NumberFormatException nfe = new NumberFormatException();
            throw nfe;
        }
        catch (RuntimeException e) {
            NumberFormatException nfe = new NumberFormatException();
            throw nfe;
        }
        this._scale = scl;
        this._precision = prec;
        this._intCompact = rs;
        this._intVal = rb;
    }

    public /* synthetic */ BigDecimal(char[] cArray, int n, int n2, MathContext mathContext, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = cArray.length;
        }
        if ((n3 & 8) != 0) {
            mathContext = MathContext.UNLIMITED;
        }
        this(cArray, n, n2, mathContext);
    }

    private final int adjustScale(int scl, long exp) {
        int scl2 = scl;
        long adjustedScale = (long)scl2 - exp;
        if (adjustedScale > Integer.MAX_VALUE || adjustedScale < Integer.MIN_VALUE) {
            throw new NumberFormatException("Scale out of range.");
        }
        scl2 = (int)adjustedScale;
        return scl2;
    }

    public BigDecimal(@NotNull char[] in, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter(in, "in");
        Intrinsics.checkNotNullParameter(mc, "mc");
        this(in, 0, in.length, mc);
    }

    public BigDecimal(@NotNull String val) {
        Intrinsics.checkNotNullParameter(val, "val");
        this(Utils.toCharArray(val), 0, val.length(), null, 8, null);
    }

    public BigDecimal(@NotNull String val, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter(val, "val");
        Intrinsics.checkNotNullParameter(mc, "mc");
        this(Utils.toCharArray(val), 0, val.length(), mc);
    }

    public BigDecimal(double val, @NotNull MathContext mc) {
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter(mc, "mc");
                double d = val;
                boolean bl = false;
                if (Double.isInfinite(d)) break block14;
                d = val;
                bl = false;
                if (!Double.isInfinite(d)) break block15;
            }
            throw new NumberFormatException("Infinite or NaN");
        }
        double d = val;
        boolean bl = false;
        long valBits = Double.doubleToLongBits(d);
        int sign = valBits >> 63 == 0L ? 1 : -1;
        int exponent = (int)(valBits >> 52 & 0x7FFL);
        long significand = exponent == 0 ? (valBits & 0xFFFFFFFFFFFFFL) << 1 : valBits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        exponent -= 1075;
        if (significand == 0L) {
            this._intVal = BigInteger.ZERO;
            this._scale = 0;
            this._intCompact = 0L;
            this._precision = 1;
            return;
        }
        while ((significand & 1L) == 0L) {
            significand >>= 1;
            int n = exponent;
            exponent = n + 1;
        }
        int scl = 0;
        BigInteger rb = null;
        long compactVal = (long)sign * significand;
        if (exponent == 0) {
            rb = compactVal == Long.MIN_VALUE ? INFLATED_BIGINT : null;
        } else {
            if (exponent < 0) {
                rb = BigInteger.Companion.of(5).pow(-exponent).timesLong$kt_math(compactVal);
                scl = -exponent;
            } else {
                rb = BigInteger.TWO.pow(exponent).timesLong$kt_math(compactVal);
            }
            compactVal = BigDecimal.Companion.compactValFor(rb);
        }
        int prec = 0;
        int mcp = mc.getPrecision();
        if (mcp > 0) {
            int mode = mc.getRoundingMode().getOldMode$kt_math();
            int drop = 0;
            if (compactVal == Long.MIN_VALUE) {
                BigInteger bigInteger = rb;
                Intrinsics.checkNotNull(bigInteger);
                prec = BigDecimal.Companion.bigDigitLength(bigInteger);
                drop = prec - mcp;
                while (drop > 0) {
                    scl = BigDecimal.Companion.checkScaleNonZero((long)scl - (long)drop);
                    BigInteger bigInteger2 = rb;
                    Intrinsics.checkNotNull(bigInteger2);
                    rb = BigDecimal.Companion.divideAndRoundByTenPow(bigInteger2, drop, mode);
                    compactVal = BigDecimal.Companion.compactValFor(rb);
                    if (compactVal != Long.MIN_VALUE) break;
                    prec = BigDecimal.Companion.bigDigitLength(rb);
                    drop = prec - mcp;
                }
            }
            if (compactVal != Long.MIN_VALUE) {
                prec = Companion.longDigitLength$kt_math(compactVal);
                drop = prec - mcp;
                while (drop > 0) {
                    scl = BigDecimal.Companion.checkScaleNonZero((long)scl - (long)drop);
                    compactVal = BigDecimal.Companion.divideAndRound(compactVal, BigDecimal.LONG_TEN_POWERS_TABLE[drop], mc.getRoundingMode().getOldMode$kt_math());
                    prec = Companion.longDigitLength$kt_math(compactVal);
                    drop = prec - mcp;
                }
                rb = null;
            }
        }
        this._intVal = rb;
        this._intCompact = compactVal;
        this._scale = scl;
        this._precision = prec;
    }

    public /* synthetic */ BigDecimal(double d, MathContext mathContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            mathContext = MathContext.UNLIMITED;
        }
        this(d, mathContext);
    }

    public BigDecimal(@NotNull BigInteger val) {
        Intrinsics.checkNotNullParameter(val, "val");
        this._scale = 0;
        this._intVal = val;
        this._intCompact = BigDecimal.Companion.compactValFor(val);
    }

    public BigDecimal(@NotNull BigInteger val, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter(val, "val");
        Intrinsics.checkNotNullParameter(mc, "mc");
        this(val, 0, mc);
    }

    public BigDecimal(@NotNull BigInteger unscaledVal, int scale) {
        Intrinsics.checkNotNullParameter(unscaledVal, "unscaledVal");
        this._intVal = unscaledVal;
        this._intCompact = BigDecimal.Companion.compactValFor(unscaledVal);
        this._scale = scale;
    }

    public BigDecimal(@Nullable BigInteger unscaledVal, int scale, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter(mc, "mc");
        BigInteger unscaledVal2 = unscaledVal;
        int scale2 = scale;
        BigInteger bigInteger = unscaledVal2;
        Intrinsics.checkNotNull(bigInteger);
        long compactVal = BigDecimal.Companion.compactValFor(bigInteger);
        int mcp = mc.getPrecision();
        int prec = 0;
        if (mcp > 0) {
            int drop;
            int mode = mc.getRoundingMode().getOldMode$kt_math();
            if (compactVal == Long.MIN_VALUE) {
                prec = BigDecimal.Companion.bigDigitLength(unscaledVal2);
                drop = prec - mcp;
                while (drop > 0) {
                    scale2 = BigDecimal.Companion.checkScaleNonZero((long)scale2 - (long)drop);
                    BigInteger bigInteger2 = unscaledVal2;
                    Intrinsics.checkNotNull(bigInteger2);
                    unscaledVal2 = BigDecimal.Companion.divideAndRoundByTenPow(bigInteger2, drop, mode);
                    compactVal = BigDecimal.Companion.compactValFor(unscaledVal2);
                    if (compactVal != Long.MIN_VALUE) break;
                    prec = BigDecimal.Companion.bigDigitLength(unscaledVal2);
                    drop = prec - mcp;
                }
            }
            if (compactVal != Long.MIN_VALUE) {
                prec = Companion.longDigitLength$kt_math(compactVal);
                drop = prec - mcp;
                while (drop > 0) {
                    scale2 = BigDecimal.Companion.checkScaleNonZero((long)scale2 - (long)drop);
                    compactVal = BigDecimal.Companion.divideAndRound(compactVal, BigDecimal.LONG_TEN_POWERS_TABLE[drop], mode);
                    prec = Companion.longDigitLength$kt_math(compactVal);
                    drop = prec - mcp;
                }
                unscaledVal2 = null;
            }
        }
        this._intVal = unscaledVal2;
        this._intCompact = compactVal;
        this._scale = scale2;
        this._precision = prec;
    }

    public BigDecimal(int val) {
        this._intCompact = val;
        this._scale = 0;
        this._intVal = null;
    }

    public BigDecimal(int val, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter(mc, "mc");
        int mcp = mc.getPrecision();
        long compactVal = val;
        int scl = 0;
        int prec = 0;
        if (mcp > 0) {
            prec = Companion.longDigitLength$kt_math(compactVal);
            int drop = prec - mcp;
            while (drop > 0) {
                scl = BigDecimal.Companion.checkScaleNonZero((long)scl - (long)drop);
                compactVal = BigDecimal.Companion.divideAndRound(compactVal, BigDecimal.LONG_TEN_POWERS_TABLE[drop], mc.getRoundingMode().getOldMode$kt_math());
                prec = Companion.longDigitLength$kt_math(compactVal);
                drop = prec - mcp;
            }
        }
        this._intVal = null;
        this._intCompact = compactVal;
        this._scale = scl;
        this._precision = prec;
    }

    public BigDecimal(long val) {
        this._intCompact = val;
        this._intVal = val == Long.MIN_VALUE ? INFLATED_BIGINT : null;
        this._scale = 0;
    }

    public BigDecimal(long val, @NotNull MathContext mc) {
        BigInteger rb;
        Intrinsics.checkNotNullParameter(mc, "mc");
        long val2 = val;
        int mcp = mc.getPrecision();
        int mode = mc.getRoundingMode().getOldMode$kt_math();
        int prec = 0;
        int scl = 0;
        BigInteger bigInteger = rb = val2 == Long.MIN_VALUE ? INFLATED_BIGINT : null;
        if (mcp > 0) {
            int drop;
            if (val2 == Long.MIN_VALUE) {
                prec = 19;
                drop = prec - mcp;
                while (drop > 0) {
                    scl = BigDecimal.Companion.checkScaleNonZero((long)scl - (long)drop);
                    BigInteger bigInteger2 = rb;
                    Intrinsics.checkNotNull(bigInteger2);
                    rb = BigDecimal.Companion.divideAndRoundByTenPow(bigInteger2, drop, mode);
                    val2 = BigDecimal.Companion.compactValFor(rb);
                    if (val2 != Long.MIN_VALUE) break;
                    prec = BigDecimal.Companion.bigDigitLength(rb);
                    drop = prec - mcp;
                }
            }
            if (val2 != Long.MIN_VALUE) {
                prec = Companion.longDigitLength$kt_math(val2);
                drop = prec - mcp;
                while (drop > 0) {
                    scl = BigDecimal.Companion.checkScaleNonZero((long)scl - (long)drop);
                    val2 = BigDecimal.Companion.divideAndRound(val2, BigDecimal.LONG_TEN_POWERS_TABLE[drop], mc.getRoundingMode().getOldMode$kt_math());
                    prec = Companion.longDigitLength$kt_math(val2);
                    drop = prec - mcp;
                }
                rb = null;
            }
        }
        this._intVal = rb;
        this._intCompact = val2;
        this._scale = scl;
        this._precision = prec;
    }

    @NotNull
    public final BigDecimal plus(@Nullable BigDecimal augend) {
        BigDecimal bigDecimal;
        if (this._intCompact != Long.MIN_VALUE) {
            BigDecimal bigDecimal2 = augend;
            Intrinsics.checkNotNull(bigDecimal2);
            if (bigDecimal2._intCompact != Long.MIN_VALUE) {
                bigDecimal = BigDecimal.Companion.sum(this._intCompact, this._scale, augend._intCompact, augend._scale);
            } else {
                BigInteger bigInteger = augend._intVal;
                Intrinsics.checkNotNull(bigInteger);
                bigDecimal = BigDecimal.Companion.sum(this._intCompact, this._scale, bigInteger, augend._scale);
            }
        } else {
            BigDecimal bigDecimal3 = augend;
            Intrinsics.checkNotNull(bigDecimal3);
            if (bigDecimal3._intCompact != Long.MIN_VALUE) {
                long l = augend._intCompact;
                int n = augend._scale;
                BigInteger bigInteger = this._intVal;
                Intrinsics.checkNotNull(bigInteger);
                bigDecimal = BigDecimal.Companion.sum(l, n, bigInteger, this._scale);
            } else {
                bigDecimal = BigDecimal.Companion.sum(this._intVal, this._scale, augend._intVal, augend._scale);
            }
        }
        return bigDecimal;
    }

    @NotNull
    public final BigDecimal plus(@Nullable BigDecimal augend, @NotNull MathContext mc) {
        boolean augendIsZero;
        Intrinsics.checkNotNullParameter(mc, "mc");
        BigDecimal augend2 = null;
        augend2 = augend;
        if (mc.getPrecision() == 0) {
            return this.plus(augend2);
        }
        BigDecimal lhs = null;
        lhs = this;
        BigDecimal bigDecimal = this;
        boolean bl = false;
        boolean bl2 = false;
        BigDecimal $this$plus_u24lambda_u2d0 = bigDecimal;
        boolean bl3 = false;
        boolean lhsIsZero = lhs.getSignum() == 0;
        BigDecimal bigDecimal2 = augend2;
        Intrinsics.checkNotNull(bigDecimal2);
        boolean bl4 = augendIsZero = bigDecimal2.getSignum() == 0;
        if (lhsIsZero || augendIsZero) {
            int scaleDiff;
            BigDecimal result2;
            int n = lhs.getScale();
            int n2 = augend2.getScale();
            boolean bl5 = false;
            int preferredScale = Math.max(n, n2);
            BigDecimal bigDecimal3 = result2 = lhsIsZero ? BigDecimal.Companion.doRound(augend2, mc) : BigDecimal.Companion.doRound(lhs, mc);
            if (lhsIsZero && augendIsZero) {
                return Companion.zeroValueOf$kt_math(preferredScale);
            }
            BigDecimal bigDecimal4 = result2;
            Intrinsics.checkNotNull(bigDecimal4);
            if (bigDecimal4.getScale() == preferredScale) {
                return result2;
            }
            if (result2.getScale() > preferredScale) {
                return BigDecimal.Companion.stripZerosToMatchScale(result2._intVal, result2._intCompact, result2._scale, preferredScale);
            }
            int precisionDiff = mc.getPrecision() - result2.getPrecision();
            return precisionDiff >= (scaleDiff = preferredScale - result2.getScale()) ? result2.setScale(preferredScale) : result2.setScale(result2.getScale() + precisionDiff);
        }
        long padding = (long)lhs._scale - (long)augend2._scale;
        if (padding != 0L) {
            BigDecimal[] arg = this.preAlign(lhs, augend2, padding, mc);
            BigDecimal.Companion.matchScale(arg);
            lhs = arg[0];
            augend2 = arg[1];
        }
        return BigDecimal.Companion.doRound(lhs.inflated().plus(augend2.inflated()), lhs._scale, mc);
    }

    private final BigDecimal[] preAlign(BigDecimal lhs, BigDecimal augend, long padding, MathContext mc) {
        boolean bl = padding != 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        BigDecimal big = null;
        BigDecimal small = null;
        if (padding < 0L) {
            big = lhs;
            small = augend;
        } else {
            big = augend;
            small = lhs;
        }
        long estResultUlpScale = (long)big._scale - (long)big.getPrecision() + (long)mc.getPrecision();
        long smallHighDigitPos = (long)small._scale - (long)small.getPrecision() + 1L;
        if (smallHighDigitPos > (long)(big._scale + 2) && smallHighDigitPos > estResultUlpScale + (long)2) {
            long l = big._scale;
            boolean bl6 = false;
            small = Companion.of((long)small.getSignum(), this.checkScale(Math.max(l, estResultUlpScale) + (long)3));
        }
        BigDecimal[] bigDecimalArray = new BigDecimal[]{big, small};
        return bigDecimalArray;
    }

    @NotNull
    public final BigDecimal minus(@NotNull BigDecimal subtrahend) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter(subtrahend, "subtrahend");
        if (this._intCompact != Long.MIN_VALUE) {
            if (subtrahend._intCompact != Long.MIN_VALUE) {
                bigDecimal = BigDecimal.Companion.sum(this._intCompact, this._scale, -subtrahend._intCompact, subtrahend._scale);
            } else {
                BigInteger bigInteger = subtrahend._intVal;
                Intrinsics.checkNotNull(bigInteger);
                bigDecimal = BigDecimal.Companion.sum(this._intCompact, this._scale, bigInteger.unaryMinus(), subtrahend._scale);
            }
        } else if (subtrahend._intCompact != Long.MIN_VALUE) {
            long l = -subtrahend._intCompact;
            int n = subtrahend._scale;
            BigInteger bigInteger = this._intVal;
            Intrinsics.checkNotNull(bigInteger);
            bigDecimal = BigDecimal.Companion.sum(l, n, bigInteger, this._scale);
        } else {
            BigInteger bigInteger = subtrahend._intVal;
            Intrinsics.checkNotNull(bigInteger);
            bigDecimal = BigDecimal.Companion.sum(this._intVal, this._scale, bigInteger.unaryMinus(), subtrahend._scale);
        }
        return bigDecimal;
    }

    @NotNull
    public final BigDecimal minus(@NotNull BigDecimal subtrahend, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter(subtrahend, "subtrahend");
        Intrinsics.checkNotNullParameter(mc, "mc");
        return mc.getPrecision() == 0 ? this.minus(subtrahend) : this.plus(subtrahend.unaryMinus(), mc);
    }

    @NotNull
    public final BigDecimal times(@Nullable BigDecimal multiplicand) {
        BigDecimal bigDecimal;
        long l = this._scale;
        BigDecimal bigDecimal2 = multiplicand;
        Intrinsics.checkNotNull(bigDecimal2);
        int productScale = this.checkScale(l + (long)bigDecimal2._scale);
        if (this._intCompact != Long.MIN_VALUE) {
            bigDecimal = multiplicand._intCompact != Long.MIN_VALUE ? BigDecimal.Companion.multiply(this._intCompact, multiplicand._intCompact, productScale) : BigDecimal.Companion.multiply(this._intCompact, multiplicand._intVal, productScale);
        } else if (multiplicand._intCompact != Long.MIN_VALUE) {
            bigDecimal = BigDecimal.Companion.multiply(multiplicand._intCompact, this._intVal, productScale);
        } else {
            BigInteger bigInteger = this._intVal;
            Intrinsics.checkNotNull(bigInteger);
            bigDecimal = BigDecimal.Companion.multiply(bigInteger, multiplicand._intVal, productScale);
        }
        return bigDecimal;
    }

    @NotNull
    public final BigDecimal times(@NotNull BigDecimal multiplicand, @NotNull MathContext mc) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter(multiplicand, "multiplicand");
        Intrinsics.checkNotNullParameter(mc, "mc");
        if (mc.getPrecision() == 0) {
            return this.times(multiplicand);
        }
        int productScale = this.checkScale((long)this._scale + (long)multiplicand._scale);
        if (this._intCompact != Long.MIN_VALUE) {
            bigDecimal = multiplicand._intCompact != Long.MIN_VALUE ? BigDecimal.Companion.multiplyAndRound(this._intCompact, multiplicand._intCompact, productScale, mc) : BigDecimal.Companion.multiplyAndRound(this._intCompact, multiplicand._intVal, productScale, mc);
        } else if (multiplicand._intCompact != Long.MIN_VALUE) {
            bigDecimal = BigDecimal.Companion.multiplyAndRound(multiplicand._intCompact, this._intVal, productScale, mc);
        } else {
            BigInteger bigInteger = this._intVal;
            Intrinsics.checkNotNull(bigInteger);
            bigDecimal = BigDecimal.Companion.multiplyAndRound(bigInteger, multiplicand._intVal, productScale, mc);
        }
        return bigDecimal;
    }

    @Deprecated(message="The method {@link #div(BigDecimal, int, RoundingMode)}\n      should be used in preference to this legacy method.\n     \n      ")
    private final BigDecimal div(BigDecimal divisor, int scale, int roundingMode2) {
        if (roundingMode2 < 0 || roundingMode2 > 7) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        return this._intCompact != Long.MIN_VALUE ? (divisor._intCompact != Long.MIN_VALUE ? BigDecimal.Companion.divide(this._intCompact, this._scale, divisor._intCompact, divisor._scale, scale, roundingMode2) : BigDecimal.Companion.divide(this._intCompact, this._scale, divisor._intVal, divisor._scale, scale, roundingMode2)) : (divisor._intCompact != Long.MIN_VALUE ? BigDecimal.Companion.divide(this._intVal, this._scale, divisor._intCompact, divisor._scale, scale, roundingMode2) : BigDecimal.Companion.divide(this._intVal, this._scale, divisor._intVal, divisor._scale, scale, roundingMode2));
    }

    private final BigDecimal div(BigDecimal divisor, int scale, RoundingMode roundingMode2) {
        return this.div(divisor, scale, roundingMode2.getOldMode$kt_math());
    }

    @Deprecated(message="The method {@link #div(BigDecimal, RoundingMode)}\n      should be used in preference to this legacy method.\n     \n      ")
    private final BigDecimal div(BigDecimal divisor, int roundingMode2) {
        return this.div(divisor, this._scale, roundingMode2);
    }

    private final BigDecimal div(BigDecimal divisor, RoundingMode roundingMode2) {
        return this.div(divisor, this._scale, roundingMode2.getOldMode$kt_math());
    }

    @NotNull
    public final BigDecimal div(@NotNull BigDecimal divisor) {
        Intrinsics.checkNotNullParameter(divisor, "divisor");
        if (divisor.getSignum() == 0) {
            if (this.getSignum() == 0) {
                throw new ArithmeticException("Division undefined");
            }
            throw new ArithmeticException("Division by zero");
        }
        int preferredScale = BigDecimal.Companion.saturateLong((long)this._scale - (long)divisor._scale);
        if (this.getSignum() == 0) {
            return Companion.zeroValueOf$kt_math(preferredScale);
        }
        double d = 10.0 * (double)divisor.getPrecision() / 3.0;
        boolean bl = false;
        long l = (long)this.getPrecision() + (long)Math.ceil(d);
        long l2 = Integer.MAX_VALUE;
        boolean bl2 = false;
        MathContext mc = new MathContext((int)Math.min(l, l2), RoundingMode.UNNECESSARY);
        BigDecimal quotient = null;
        try {
            quotient = this.div(divisor, mc);
        }
        catch (ArithmeticException e) {
            throw new ArithmeticException("Non-terminating decimal expansion; no exact representable decimal result.");
        }
        BigDecimal bigDecimal = quotient;
        Intrinsics.checkNotNull(bigDecimal);
        int quotientScale = bigDecimal.getScale();
        return preferredScale > quotientScale ? quotient.setScale(preferredScale, 7) : quotient;
    }

    @Nullable
    public final BigDecimal div(@NotNull BigDecimal divisor, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter(divisor, "divisor");
        Intrinsics.checkNotNullParameter(mc, "mc");
        int mcp = mc.getPrecision();
        if (mcp == 0) {
            return this.div(divisor);
        }
        BigDecimal dividend = this;
        long preferredScale = (long)dividend._scale - (long)divisor._scale;
        if (divisor.getSignum() == 0) {
            if (dividend.getSignum() == 0) {
                throw new ArithmeticException("Division undefined");
            }
            throw new ArithmeticException("Division by zero");
        }
        if (dividend.getSignum() == 0) {
            return Companion.zeroValueOf$kt_math(BigDecimal.Companion.saturateLong(preferredScale));
        }
        int xscale = dividend.getPrecision();
        int yscale = divisor.getPrecision();
        return dividend._intCompact != Long.MIN_VALUE ? (divisor._intCompact != Long.MIN_VALUE ? BigDecimal.Companion.divide(dividend._intCompact, xscale, divisor._intCompact, yscale, preferredScale, mc) : BigDecimal.Companion.divide(dividend._intCompact, xscale, divisor._intVal, yscale, preferredScale, mc)) : (divisor._intCompact != Long.MIN_VALUE ? BigDecimal.Companion.divide(dividend._intVal, xscale, divisor._intCompact, yscale, preferredScale, mc) : BigDecimal.Companion.divide(dividend._intVal, xscale, divisor._intVal, yscale, preferredScale, mc));
    }

    @Nullable
    public final BigDecimal divideToIntegralValue(@NotNull BigDecimal divisor) {
        BigDecimal quotient;
        Intrinsics.checkNotNullParameter(divisor, "divisor");
        int preferredScale = BigDecimal.Companion.saturateLong((long)this._scale - (long)divisor._scale);
        if (this.compareMagnitude(divisor) < 0) {
            return Companion.zeroValueOf$kt_math(preferredScale);
        }
        if (this.getSignum() == 0 && divisor.getSignum() != 0) {
            return this.setScale(preferredScale, 7);
        }
        double d = 10.0 * (double)divisor.getPrecision() / 3.0;
        boolean bl = false;
        long l = (long)this.getScale() - (long)divisor.getScale();
        bl = false;
        l = (long)this.getPrecision() + (long)Math.ceil(d) + Math.abs(l) + (long)2;
        long l2 = Integer.MAX_VALUE;
        boolean bl2 = false;
        int maxDigits = (int)Math.min(l, l2);
        BigDecimal bigDecimal = quotient = this.div(divisor, new MathContext(maxDigits, RoundingMode.DOWN));
        Intrinsics.checkNotNull(bigDecimal);
        if (bigDecimal._scale > 0) {
            quotient = quotient.setScale(0, RoundingMode.DOWN);
            quotient = BigDecimal.Companion.stripZerosToMatchScale(quotient._intVal, quotient._intCompact, quotient._scale, preferredScale);
        }
        if (quotient._scale < preferredScale) {
            quotient = quotient.setScale(preferredScale, 7);
        }
        return quotient;
    }

    @Nullable
    public final BigDecimal divideToIntegralValue(@NotNull BigDecimal divisor, @NotNull MathContext mc) {
        BigDecimal result2;
        Intrinsics.checkNotNullParameter(divisor, "divisor");
        Intrinsics.checkNotNullParameter(mc, "mc");
        if (mc.getPrecision() == 0 || this.compareMagnitude(divisor) < 0) {
            return this.divideToIntegralValue(divisor);
        }
        int preferredScale = BigDecimal.Companion.saturateLong((long)this._scale - (long)divisor._scale);
        BigDecimal bigDecimal = result2 = this.div(divisor, new MathContext(mc.getPrecision(), RoundingMode.DOWN));
        Intrinsics.checkNotNull(bigDecimal);
        if (bigDecimal.getScale() < 0) {
            BigDecimal product2 = result2.times(divisor);
            if (this.minus(product2).compareMagnitude(divisor) >= 0) {
                throw new ArithmeticException("Division impossible");
            }
        } else if (result2.getScale() > 0) {
            result2 = result2.setScale(0, RoundingMode.DOWN);
        }
        int precisionDiff = 0;
        if (preferredScale > result2.getScale() && (precisionDiff = mc.getPrecision() - result2.getPrecision()) > 0) {
            int n = preferredScale - result2._scale;
            boolean bl = false;
            return result2.setScale(result2.getScale() + Math.min(precisionDiff, n));
        }
        return BigDecimal.Companion.stripZerosToMatchScale(result2._intVal, result2._intCompact, result2._scale, preferredScale);
    }

    @NotNull
    public final BigDecimal rem(@NotNull BigDecimal divisor) {
        Intrinsics.checkNotNullParameter(divisor, "divisor");
        Pair<BigDecimal, BigDecimal> divrem = this.divideAndRemainder(divisor);
        return divrem.getSecond();
    }

    @NotNull
    public final BigDecimal rem(@NotNull BigDecimal divisor, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter(divisor, "divisor");
        Intrinsics.checkNotNullParameter(mc, "mc");
        Pair<BigDecimal, BigDecimal> divrem = this.divideAndRemainder(divisor, mc);
        return divrem.getSecond();
    }

    @NotNull
    public final Pair<BigDecimal, BigDecimal> divideAndRemainder(@NotNull BigDecimal divisor) {
        Intrinsics.checkNotNullParameter(divisor, "divisor");
        BigDecimal bigDecimal = this.divideToIntegralValue(divisor);
        Intrinsics.checkNotNull(bigDecimal);
        BigDecimal temp = bigDecimal;
        return new Pair<BigDecimal, BigDecimal>(temp, temp.times(divisor));
    }

    @NotNull
    public final Pair<BigDecimal, BigDecimal> divideAndRemainder(@NotNull BigDecimal divisor, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter(divisor, "divisor");
        Intrinsics.checkNotNullParameter(mc, "mc");
        if (mc.getPrecision() == 0) {
            return this.divideAndRemainder(divisor);
        }
        BigDecimal lhs = this;
        BigDecimal bigDecimal = lhs.divideToIntegralValue(divisor, mc);
        Intrinsics.checkNotNull(bigDecimal);
        BigDecimal temp = bigDecimal;
        return new Pair<BigDecimal, BigDecimal>(temp, lhs.minus(temp.times(divisor)));
    }

    @NotNull
    public final BigDecimal sqrt(@NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter(mc, "mc");
        int signum = this.getSignum();
        if (signum == 1) {
            int preferredScale = this.getScale() / 2;
            BigDecimal zeroWithFinalPreferredScale = Companion.of(0L, preferredScale);
            BigDecimal stripped = this.stripTrailingZeros();
            int strippedScale = stripped.getScale();
            if (stripped.isPowerOfTen() && strippedScale % 2 == 0) {
                BigDecimal result2 = Companion.of(1L, strippedScale / 2);
                if (result2.getScale() != preferredScale) {
                    result2 = result2.plus(zeroWithFinalPreferredScale, mc);
                }
                return result2;
            }
            int scaleAdjust = 0;
            int scale = stripped.getScale() - stripped.getPrecision() + 1;
            scaleAdjust = scale % 2 == 0 ? scale : scale - 1;
            BigDecimal working = stripped.scaleByPowerOfTen(scaleAdjust);
            boolean bl = ONE_TENTH.compareTo(working) <= 0 && working.compareTo(TEN) < 0;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            double d = working.toDouble();
            bl4 = false;
            BigDecimal guess = new BigDecimal(Math.sqrt(d), null, 2, null);
            int guessPrecision = 15;
            int originalPrecision = mc.getPrecision();
            int targetPrecision = 0;
            targetPrecision = originalPrecision == 0 ? stripped.getPrecision() / 2 + 1 : originalPrecision;
            BigDecimal approx = guess;
            int workingPrecision = working.getPrecision();
            do {
                int n = targetPrecision + 2;
                boolean bl6 = false;
                n = Math.max(guessPrecision, n);
                bl6 = false;
                int tmpPrecision = Math.max(n, workingPrecision);
                MathContext mcTmp = new MathContext(tmpPrecision, RoundingMode.HALF_EVEN);
                approx = ONE_HALF.times(approx.plus(working.div(approx, mcTmp), mcTmp));
            } while ((guessPrecision *= 2) < targetPrecision + 2);
            BigDecimal result3 = null;
            RoundingMode targetRm = mc.getRoundingMode();
            if (targetRm == RoundingMode.UNNECESSARY || originalPrecision == 0) {
                RoundingMode tmpRm = targetRm == RoundingMode.UNNECESSARY ? RoundingMode.DOWN : targetRm;
                MathContext mcTmp = new MathContext(targetPrecision, tmpRm);
                BigDecimal bigDecimal = result3 = approx.scaleByPowerOfTen(-scaleAdjust / 2).round(mcTmp);
                Intrinsics.checkNotNull(bigDecimal);
                if (this.minus(bigDecimal.times(result3)).compareTo(ZERO) != 0) {
                    throw new ArithmeticException("Computed square root not exact.");
                }
            } else {
                result3 = approx.scaleByPowerOfTen(-scaleAdjust / 2).round(mc);
            }
            BigDecimal bigDecimal = result3;
            Intrinsics.checkNotNull(bigDecimal);
            if (bigDecimal.getScale() != preferredScale) {
                result3 = result3.stripTrailingZeros().plus(zeroWithFinalPreferredScale, new MathContext(originalPrecision, RoundingMode.UNNECESSARY));
            }
            boolean bl7 = this.squareRootResultAssertions(result3, mc);
            boolean bl8 = false;
            boolean bl9 = false;
            bl9 = false;
            boolean bl10 = false;
            if (!bl7) {
                boolean bl11 = false;
                String string3 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            return result3;
        }
        int n = signum;
        switch (n) {
            case -1: {
                throw new ArithmeticException("Attempted square root of negative BigDecimal");
            }
            case 0: {
                return Companion.of(0L, this.getScale() / 2);
            }
        }
        throw new AssertionError((Object)"Bad value from _signum");
    }

    public static /* synthetic */ BigDecimal sqrt$default(BigDecimal bigDecimal, MathContext mathContext, int n, Object object) {
        if ((n & 1) != 0) {
            mathContext = new MathContext();
        }
        return bigDecimal.sqrt(mathContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean squareRootResultAssertions(BigDecimal result2, MathContext mc) {
        if (result2.getSignum() == 0) {
            return this.squareRootZeroResultAssertions(result2, mc);
        }
        RoundingMode rm = mc.getRoundingMode();
        BigDecimal ulp = result2.ulp();
        BigDecimal neighborUp = result2.plus(ulp);
        if (this.isPowerOfTen()) {
            ulp = ulp.div(TEN);
        }
        BigDecimal neighborDown = result2.minus(ulp);
        if (result2.getSignum() != 1) return false;
        if (this.getSignum() != 1) {
            return false;
        }
        RoundingMode roundingMode2 = rm;
        int n = WhenMappings.$EnumSwitchMapping$0[roundingMode2.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                if (result2.times(result2).compareTo(this) > 0) return false;
                if (neighborUp.times(neighborUp).compareTo(this) <= 0) return false;
                return true;
            }
            case 3: 
            case 4: {
                if (result2.times(result2).compareTo(this) < 0) return false;
                if (neighborDown.times(neighborDown).compareTo(this) >= 0) return false;
                return true;
            }
            case 5: 
            case 6: 
            case 7: {
                boolean bl;
                BigDecimal err = result2.times(result2).minus(this).getAbsoluteValue();
                BigDecimal errUp = neighborUp.times(neighborUp).minus(this);
                BigDecimal errDown = this.minus(neighborDown.times(neighborDown));
                int err_comp_errUp = err.compareTo(errUp);
                int err_comp_errDown = err.compareTo(errDown);
                if (errUp.getSignum() != 1) return false;
                if (errDown.getSignum() != 1) return false;
                if (err_comp_errUp > 0) return false;
                if (err_comp_errDown > 0) return false;
                if (err_comp_errUp == 0) {
                    if (err_comp_errDown >= 0) return false;
                    bl = true;
                } else {
                    bl = true;
                }
                if (!bl) return false;
                if (err_comp_errDown != 0) return true;
                if (err_comp_errUp >= 0) return false;
                return true;
            }
        }
        return true;
    }

    private final boolean squareRootZeroResultAssertions(BigDecimal result2, MathContext mc) {
        return this.compareTo(ZERO) == 0;
    }

    @NotNull
    public final BigDecimal pow(int n) {
        if (n < 0 || n > 999999999) {
            throw new ArithmeticException("Invalid operation");
        }
        int newScale = this.checkScale((long)this._scale * (long)n);
        return new BigDecimal(this.inflated().pow(n), newScale);
    }

    @Nullable
    public final BigDecimal pow(int n, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter(mc, "mc");
        if (mc.getPrecision() == 0) {
            return this.pow(n);
        }
        if (n < -999999999 || n > 999999999) {
            throw new ArithmeticException("Invalid operation");
        }
        if (n == 0) {
            return ONE;
        }
        BigDecimal lhs = this;
        MathContext workmc = mc;
        boolean bl = false;
        int mag = Math.abs(n);
        if (mc.getPrecision() > 0) {
            int elength = Companion.longDigitLength$kt_math(mag);
            if (elength > mc.getPrecision()) {
                throw new ArithmeticException("Invalid operation");
            }
            workmc = new MathContext(mc.getPrecision() + elength + 1, mc.getRoundingMode());
        }
        BigDecimal acc = ONE;
        boolean seenbit = false;
        int i = 1;
        while (true) {
            if ((mag += mag) < 0) {
                seenbit = true;
                acc = acc.times(lhs, workmc);
            }
            if (i == 31) break;
            if (seenbit) {
                acc = acc.times(acc, workmc);
            }
            int n2 = i;
            i = n2 + 1;
        }
        if (n < 0) {
            BigDecimal bigDecimal = ONE.div(acc, workmc);
            Intrinsics.checkNotNull(bigDecimal);
            acc = bigDecimal;
        }
        return BigDecimal.Companion.doRound(acc, mc);
    }

    @NotNull
    public final BigDecimal getAbsoluteValue() {
        return this.getSignum() < 0 ? this.unaryMinus() : this;
    }

    @Nullable
    public final BigDecimal absoluteValue(@NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter(mc, "mc");
        return this.getSignum() < 0 ? this.unaryMinus(mc) : this.unaryPlus(mc);
    }

    @NotNull
    public final BigDecimal unaryMinus() {
        BigDecimal bigDecimal;
        if (this._intCompact == Long.MIN_VALUE) {
            BigInteger bigInteger = this._intVal;
            Intrinsics.checkNotNull(bigInteger);
            bigDecimal = new BigDecimal(bigInteger.unaryMinus(), Long.MIN_VALUE, this._scale, this._precision);
        } else {
            bigDecimal = Companion.of(-this._intCompact, this._scale, this._precision);
        }
        return bigDecimal;
    }

    @Nullable
    public final BigDecimal unaryMinus(@NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter(mc, "mc");
        return this.unaryMinus().unaryPlus(mc);
    }

    @NotNull
    public final BigDecimal unaryPlus() {
        return this;
    }

    @Nullable
    public final BigDecimal unaryPlus(@NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter(mc, "mc");
        return mc.getPrecision() == 0 ? this : BigDecimal.Companion.doRound(this, mc);
    }

    public final int getSignum() {
        int n;
        if (this._intCompact != Long.MIN_VALUE) {
            n = MathKt.getSign(this._intCompact);
        } else {
            BigInteger bigInteger = this._intVal;
            Intrinsics.checkNotNull(bigInteger);
            n = bigInteger.getSignum();
        }
        return n;
    }

    public final int getScale() {
        return this._scale;
    }

    public final int getPrecision() {
        int result2 = this._precision;
        if (result2 == 0) {
            long s = this._intCompact;
            if (s != Long.MIN_VALUE) {
                result2 = Companion.longDigitLength$kt_math(s);
            } else {
                BigInteger bigInteger = this._intVal;
                Intrinsics.checkNotNull(bigInteger);
                result2 = BigDecimal.Companion.bigDigitLength(bigInteger);
            }
            this._precision = result2;
        }
        return result2;
    }

    @NotNull
    public final BigInteger getUnscaledValue() {
        return this.inflated();
    }

    @Nullable
    public final BigDecimal round(@NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter(mc, "mc");
        return this.unaryPlus(mc);
    }

    @NotNull
    public final BigDecimal setScale(int newScale, @NotNull RoundingMode roundingMode2) {
        Intrinsics.checkNotNullParameter((Object)roundingMode2, "roundingMode");
        return this.setScale(newScale, roundingMode2.getOldMode$kt_math());
    }

    @Deprecated(message="The method {@link #setScale(int, RoundingMode)} should\n      be used in preference to this legacy method.\n     \n      ")
    private final BigDecimal setScale(int newScale, int roundingMode2) {
        BigDecimal bigDecimal;
        if (roundingMode2 < 0 || roundingMode2 > 7) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        int oldScale = this._scale;
        if (newScale == oldScale) {
            return this;
        }
        if (this.getSignum() == 0) {
            return Companion.zeroValueOf$kt_math(newScale);
        }
        if (this._intCompact != Long.MIN_VALUE) {
            long rs = this._intCompact;
            if (newScale > oldScale) {
                int raise = this.checkScale((long)newScale - (long)oldScale);
                if ((rs = BigDecimal.Companion.longMultiplyPowerTen(rs, raise)) != Long.MIN_VALUE) {
                    return Companion.of(rs, newScale);
                }
                BigInteger rb = this.bigMultiplyPowerTen(raise);
                return new BigDecimal(rb, Long.MIN_VALUE, newScale, this._precision > 0 ? this._precision + raise : 0);
            }
            int drop = this.checkScale((long)oldScale - (long)newScale);
            return drop < LONG_TEN_POWERS_TABLE.length ? BigDecimal.Companion.divideAndRound(rs, BigDecimal.LONG_TEN_POWERS_TABLE[drop], newScale, roundingMode2, newScale) : BigDecimal.Companion.divideAndRound(this.inflated(), BigDecimal.Companion.bigTenToThe(drop), newScale, roundingMode2, newScale);
        }
        if (newScale > oldScale) {
            BigInteger rb;
            int raise = this.checkScale((long)newScale - (long)oldScale);
            BigInteger bigInteger = rb = BigDecimal.Companion.bigMultiplyPowerTen(this._intVal, raise);
            Intrinsics.checkNotNull(bigInteger);
            return new BigDecimal(bigInteger, Long.MIN_VALUE, newScale, this._precision > 0 ? this._precision + raise : 0);
        }
        int drop = this.checkScale((long)oldScale - (long)newScale);
        if (drop < LONG_TEN_POWERS_TABLE.length) {
            BigInteger bigInteger = this._intVal;
            Intrinsics.checkNotNull(bigInteger);
            bigDecimal = BigDecimal.Companion.divideAndRound(bigInteger, BigDecimal.LONG_TEN_POWERS_TABLE[drop], newScale, roundingMode2, newScale);
        } else {
            BigInteger bigInteger = this._intVal;
            Intrinsics.checkNotNull(bigInteger);
            bigDecimal = BigDecimal.Companion.divideAndRound(bigInteger, BigDecimal.Companion.bigTenToThe(drop), newScale, roundingMode2, newScale);
        }
        return bigDecimal;
    }

    @NotNull
    public final BigDecimal setScale(int newScale) {
        return this.setScale(newScale, 7);
    }

    @NotNull
    public final BigDecimal movePointLeft(int n) {
        int newScale = this.checkScale((long)this._scale + (long)n);
        BigInteger bigInteger = this._intVal;
        Intrinsics.checkNotNull(bigInteger);
        BigDecimal num = new BigDecimal(bigInteger, this._intCompact, newScale, 0);
        return num._scale < 0 ? num.setScale(0, 7) : num;
    }

    @NotNull
    public final BigDecimal movePointRight(int n) {
        int newScale = this.checkScale((long)this._scale - (long)n);
        BigInteger bigInteger = this._intVal;
        Intrinsics.checkNotNull(bigInteger);
        BigDecimal num = new BigDecimal(bigInteger, this._intCompact, newScale, 0);
        return num._scale < 0 ? num.setScale(0, 7) : num;
    }

    @NotNull
    public final BigDecimal scaleByPowerOfTen(int n) {
        return new BigDecimal(this._intVal, this._intCompact, this.checkScale((long)this._scale - (long)n), this._precision);
    }

    @NotNull
    public final BigDecimal stripTrailingZeros() {
        BigDecimal bigDecimal;
        if (this._intCompact == 0L || this._intVal != null && this._intVal.getSignum() == 0) {
            bigDecimal = ZERO;
        } else if (this._intCompact != Long.MIN_VALUE) {
            bigDecimal = BigDecimal.Companion.createAndStripZerosToMatchScale(this._intCompact, this._scale, Long.MIN_VALUE);
        } else {
            BigInteger bigInteger = this._intVal;
            Intrinsics.checkNotNull(bigInteger);
            bigDecimal = BigDecimal.Companion.createAndStripZerosToMatchScale(bigInteger, this._scale, Long.MIN_VALUE);
        }
        return bigDecimal;
    }

    @Override
    public int compareTo(@NotNull BigDecimal other) {
        int ysign;
        int xsign;
        Intrinsics.checkNotNullParameter(other, "other");
        if (this._scale == other._scale) {
            long xs = this._intCompact;
            long ys = other._intCompact;
            if (xs != Long.MIN_VALUE && ys != Long.MIN_VALUE) {
                return xs != ys ? (xs > ys ? 1 : -1) : 0;
            }
        }
        if ((xsign = this.getSignum()) != (ysign = other.getSignum())) {
            return xsign > ysign ? 1 : -1;
        }
        if (xsign == 0) {
            return 0;
        }
        int cmp = this.compareMagnitude(other);
        return xsign > 0 ? cmp : -cmp;
    }

    private final int compareMagnitude(BigDecimal val) {
        int n;
        long xs;
        long ys;
        block17: {
            Comparable<BigDecimal> rb2;
            long sdiff;
            block20: {
                block18: {
                    block19: {
                        long yae;
                        ys = 0L;
                        ys = val._intCompact;
                        xs = 0L;
                        xs = this._intCompact;
                        if (xs == 0L) {
                            return ys == 0L ? 0 : -1;
                        }
                        if (ys == 0L) {
                            return 1;
                        }
                        sdiff = (long)this._scale - (long)val._scale;
                        if (sdiff == 0L) break block17;
                        long xae = (long)this.getPrecision() - (long)this._scale;
                        if (xae < (yae = (long)val.getPrecision() - (long)val._scale)) {
                            return -1;
                        }
                        if (xae > yae) {
                            return 1;
                        }
                        if (sdiff >= 0L) break block18;
                        if (sdiff <= Integer.MIN_VALUE) break block17;
                        if (xs == Long.MIN_VALUE) break block19;
                        BigDecimal bigDecimal = this;
                        boolean bl = false;
                        boolean bl2 = false;
                        BigDecimal $this$compareMagnitude_u24lambda_u2d1 = bigDecimal;
                        boolean bl3 = false;
                        xs = BigDecimal.Companion.longMultiplyPowerTen(xs, (int)(-sdiff));
                        if (xs != Long.MIN_VALUE) break block17;
                    }
                    if (ys == Long.MIN_VALUE) {
                        BigInteger rb2 = this.bigMultiplyPowerTen((int)(-sdiff));
                        BigInteger bigInteger = val._intVal;
                        Intrinsics.checkNotNull(bigInteger);
                        return rb2.compareMagnitude$kt_math(bigInteger);
                    }
                    break block17;
                }
                if (sdiff > Integer.MAX_VALUE) break block17;
                if (ys == Long.MIN_VALUE) break block20;
                rb2 = this;
                boolean bl = false;
                boolean bl4 = false;
                BigDecimal $this$compareMagnitude_u24lambda_u2d2 = rb2;
                boolean bl5 = false;
                ys = BigDecimal.Companion.longMultiplyPowerTen(ys, (int)sdiff);
                if (ys != Long.MIN_VALUE) break block17;
            }
            if (xs == Long.MIN_VALUE) {
                rb2 = val.bigMultiplyPowerTen((int)sdiff);
                BigInteger bigInteger = this._intVal;
                Intrinsics.checkNotNull(bigInteger);
                return bigInteger.compareMagnitude$kt_math((BigInteger)rb2);
            }
        }
        if (xs != Long.MIN_VALUE) {
            n = ys != Long.MIN_VALUE ? BigDecimal.Companion.longCompareMagnitude(xs, ys) : -1;
        } else if (ys != Long.MIN_VALUE) {
            n = 1;
        } else {
            BigInteger bigInteger = this._intVal;
            Intrinsics.checkNotNull(bigInteger);
            BigInteger bigInteger2 = val._intVal;
            Intrinsics.checkNotNull(bigInteger2);
            n = bigInteger.compareMagnitude$kt_math(bigInteger2);
        }
        return n;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof BigDecimal)) {
            return false;
        }
        BigDecimal xDec = (BigDecimal)other;
        if (other == this) {
            return true;
        }
        if (this._scale != xDec._scale) {
            return false;
        }
        long s = this._intCompact;
        long xs = xDec._intCompact;
        if (s != Long.MIN_VALUE) {
            if (xs == Long.MIN_VALUE) {
                BigInteger bigInteger = xDec._intVal;
                Intrinsics.checkNotNull(bigInteger);
                xs = BigDecimal.Companion.compactValFor(bigInteger);
            }
            return xs == s;
        }
        if (xs != Long.MIN_VALUE) {
            BigInteger bigInteger = this._intVal;
            Intrinsics.checkNotNull(bigInteger);
            return xs == BigDecimal.Companion.compactValFor(bigInteger);
        }
        return Intrinsics.areEqual(this.inflated(), xDec.inflated());
    }

    @NotNull
    public final BigDecimal min(@NotNull BigDecimal val) {
        Intrinsics.checkNotNullParameter(val, "val");
        return this.compareTo(val) <= 0 ? this : val;
    }

    @NotNull
    public final BigDecimal max(@NotNull BigDecimal val) {
        Intrinsics.checkNotNullParameter(val, "val");
        return this.compareTo(val) >= 0 ? this : val;
    }

    public int hashCode() {
        if (this._intCompact != Long.MIN_VALUE) {
            long val2 = this._intCompact < 0L ? -this._intCompact : this._intCompact;
            int temp = (int)((long)((int)(val2 >>> 32) * 31) + (val2 & 0xFFFFFFFFL));
            return 31 * (this._intCompact < 0L ? -temp : temp) + this._scale;
        }
        BigInteger bigInteger = this._intVal;
        Intrinsics.checkNotNull(bigInteger);
        return 31 * bigInteger.hashCode() + this._scale;
    }

    @NotNull
    public String toString() {
        String sc = this._stringCache;
        if (sc == null) {
            this._stringCache = sc = this.layoutChars(true);
        }
        return sc;
    }

    @NotNull
    public final String toEngineeringString() {
        return this.layoutChars(false);
    }

    @NotNull
    public final String toPlainString() {
        if (this._scale == 0) {
            String string2;
            if (this._intCompact != Long.MIN_VALUE) {
                string2 = String.valueOf(this._intCompact);
            } else {
                BigInteger bigInteger = this._intVal;
                Intrinsics.checkNotNull(bigInteger);
                string2 = bigInteger.toString();
            }
            return string2;
        }
        if (this._scale < 0) {
            if (this.getSignum() == 0) {
                return "0";
            }
            int trailingZeros = BigDecimal.Companion.checkScaleNonZero(-((long)this._scale));
            StringBuilder buf = null;
            if (this._intCompact != Long.MIN_VALUE) {
                buf = new StringBuilder(20 + trailingZeros);
                buf.append(this._intCompact);
            } else {
                BigInteger bigInteger = this._intVal;
                Intrinsics.checkNotNull(bigInteger);
                String str2 = bigInteger.toString();
                buf = new StringBuilder(str2.length() + trailingZeros);
                buf.append(str2);
            }
            int n = 0;
            if (n < trailingZeros) {
                do {
                    int i = n++;
                    buf.append('0');
                } while (n < trailingZeros);
            }
            String string3 = buf.toString();
            Intrinsics.checkNotNullExpressionValue(string3, "buf.toString()");
            return string3;
        }
        String str3 = null;
        if (this._intCompact != Long.MIN_VALUE) {
            long l = this._intCompact;
            boolean bl = false;
            str3 = String.valueOf(Math.abs(l));
        } else {
            BigInteger bigInteger = this._intVal;
            Intrinsics.checkNotNull(bigInteger);
            str3 = bigInteger.getAbsoluteValue().toString();
        }
        return this.getValueString(this.getSignum(), str3, this._scale);
    }

    private final String getValueString(int signum, String intString, int scale) {
        StringBuilder buf = null;
        int insertionPoint = intString.length() - scale;
        if (insertionPoint == 0) {
            return Intrinsics.stringPlus(signum < 0 ? "-0." : "0.", intString);
        }
        if (insertionPoint > 0) {
            buf = new StringBuilder(intString);
            Utils.insertChar(buf, insertionPoint, '.');
            if (signum < 0) {
                Utils.insertChar(buf, 0, '-');
            }
        } else {
            buf = new StringBuilder(3 - insertionPoint + intString.length());
            buf.append(signum < 0 ? "-0." : "0.");
            int n = 0;
            int n2 = -insertionPoint;
            if (n < n2) {
                do {
                    int i = n++;
                    buf.append('0');
                } while (n < n2);
            }
            buf.append(intString);
        }
        String string2 = buf.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "buf.toString()");
        return string2;
    }

    @NotNull
    public final BigInteger toBigInteger() {
        return this.setScale(0, 1).inflated();
    }

    @NotNull
    public final BigInteger toBigIntegerExact() {
        return this.setScale(0, 7).inflated();
    }

    public final long toLong() {
        return this._intCompact != Long.MIN_VALUE && this._scale == 0 ? this._intCompact : this.toBigInteger().toLong();
    }

    public final long toLongExact() {
        if (this._intCompact != Long.MIN_VALUE && this._scale == 0) {
            return this._intCompact;
        }
        if (this.getPrecision() - this._scale > 19) {
            throw new ArithmeticException("Overflow");
        }
        if (this.getSignum() == 0) {
            return 0L;
        }
        if (this.getPrecision() - this._scale <= 0) {
            throw new ArithmeticException("Rounding necessary");
        }
        BigDecimal num = this.setScale(0, 7);
        if (num.getPrecision() >= 19) {
            LongOverflow.INSTANCE.check(num);
        }
        return num.inflated().toLong();
    }

    public final int toInt() {
        return this._intCompact != Long.MIN_VALUE && this._scale == 0 ? (int)this._intCompact : this.toBigInteger().toInt();
    }

    public final byte toByte() {
        return (byte)this.toInt();
    }

    public final char toChar() {
        return (char)this.toInt();
    }

    public final short toShort() {
        return (short)this.toInt();
    }

    public final int toIntExact() {
        long num = this.toLongExact();
        if ((long)((int)num) != num) {
            throw new ArithmeticException("Overflow");
        }
        return (int)num;
    }

    public final short toShortExact() {
        long num = this.toLongExact();
        if ((long)((short)num) != num) {
            throw new ArithmeticException("Overflow");
        }
        return (short)num;
    }

    public final byte toByteExact() {
        long num = this.toLongExact();
        if ((long)((byte)num) != num) {
            throw new ArithmeticException("Overflow");
        }
        return (byte)num;
    }

    public final float toFloat() {
        if (this._intCompact != Long.MIN_VALUE) {
            if (this._scale == 0) {
                return this._intCompact;
            }
            long l = this._intCompact;
            boolean bl = false;
            if (Math.abs(l) < 0x400000L) {
                if (this._scale > 0 && this._scale < FLOAT_10_POW.length) {
                    return (float)this._intCompact / FLOAT_10_POW[this._scale];
                }
                if (this._scale < 0 && this._scale > -FLOAT_10_POW.length) {
                    return (float)this._intCompact * FLOAT_10_POW[-this._scale];
                }
            }
        }
        String string2 = this.toString();
        boolean bl = false;
        return Float.parseFloat(string2);
    }

    public final double toDouble() {
        if (this._intCompact != Long.MIN_VALUE) {
            if (this._scale == 0) {
                return this._intCompact;
            }
            long l = this._intCompact;
            boolean bl = false;
            if (Math.abs(l) < 0x10000000000000L) {
                if (this._scale > 0 && this._scale < DOUBLE_10_POW.length) {
                    return (double)this._intCompact / DOUBLE_10_POW[this._scale];
                }
                if (this._scale < 0 && this._scale > -DOUBLE_10_POW.length) {
                    return (double)this._intCompact * DOUBLE_10_POW[-this._scale];
                }
            }
        }
        String string2 = this.toString();
        boolean bl = false;
        return Double.parseDouble(string2);
    }

    @NotNull
    public final BigDecimal ulp() {
        return Companion.of(1L, this.getScale(), 1);
    }

    private final String layoutChars(boolean sci) {
        StringBuilder buf;
        block24: {
            long adjusted;
            block26: {
                int n;
                int sig;
                int coeffLen;
                int offset;
                char[] coeff;
                block27: {
                    block25: {
                        block23: {
                            if (this._scale == 0) {
                                String string2;
                                if (this._intCompact != Long.MIN_VALUE) {
                                    string2 = String.valueOf(this._intCompact);
                                } else {
                                    BigInteger bigInteger = this._intVal;
                                    Intrinsics.checkNotNull(bigInteger);
                                    string2 = bigInteger.toString();
                                }
                                return string2;
                            }
                            if (this._scale == 2 && this._intCompact >= 0L && this._intCompact < Integer.MAX_VALUE) {
                                int lowInt = (int)this._intCompact % 100;
                                int highInt = (int)this._intCompact / 100;
                                return "" + highInt + '.' + StringBuilderHelper.Companion.getDIGIT_TENS()[lowInt] + StringBuilderHelper.Companion.getDIGIT_ONES()[lowInt];
                            }
                            StringBuilderHelper sbHelper = new StringBuilderHelper(null, null, 3, null);
                            coeff = null;
                            offset = 0;
                            if (this._intCompact != Long.MIN_VALUE) {
                                long l = this._intCompact;
                                boolean bl = false;
                                offset = sbHelper.putIntCompact(Math.abs(l));
                                coeff = sbHelper.getCompactCharArray();
                            } else {
                                offset = 0;
                                BigInteger bigInteger = this._intVal;
                                Intrinsics.checkNotNull(bigInteger);
                                coeff = Utils.toCharArray(bigInteger.getAbsoluteValue().toString());
                            }
                            buf = sbHelper.getStringBuilder();
                            if (this.getSignum() < 0) {
                                buf.append('-');
                            }
                            coeffLen = coeff.length - offset;
                            adjusted = -((long)this._scale) + (long)(coeffLen - 1);
                            if (this._scale < 0 || adjusted < -6L) break block23;
                            int pad = this._scale - coeffLen;
                            if (pad >= 0) {
                                buf.append('0');
                                buf.append('.');
                                while (pad > 0) {
                                    buf.append('0');
                                    int n2 = pad;
                                    pad = n2 + -1;
                                }
                                Utils.appendCharArray(buf, coeff, offset, coeffLen);
                            } else {
                                Utils.appendCharArray(buf, coeff, offset, -pad);
                                buf.append('.');
                                Utils.appendCharArray(buf, coeff, -pad + offset, this._scale);
                            }
                            break block24;
                        }
                        if (!sci) break block25;
                        buf.append(coeff[offset]);
                        if (coeffLen > 1) {
                            buf.append('.');
                            Utils.appendCharArray(buf, coeff, offset + 1, coeffLen - 1);
                        }
                        break block26;
                    }
                    sig = (int)(adjusted % (long)3);
                    if (sig < 0) {
                        sig += 3;
                    }
                    adjusted -= (long)sig;
                    n = sig;
                    sig = n + 1;
                    if (this.getSignum() != 0) break block27;
                    n = sig;
                    switch (n) {
                        case 1: {
                            buf.append('0');
                            break block26;
                        }
                        case 2: {
                            buf.append("0.00");
                            adjusted += (long)3;
                            break block26;
                        }
                        case 3: {
                            buf.append("0.0");
                            adjusted += (long)3;
                            break block26;
                        }
                        default: {
                            throw new AssertionError((Object)Intrinsics.stringPlus("Unexpected sig value ", sig));
                        }
                    }
                }
                if (sig >= coeffLen) {
                    Utils.appendCharArray(buf, coeff, offset, coeffLen);
                    n = sig - coeffLen;
                    if (1 <= n) {
                        do {
                            int i = n--;
                            buf.append('0');
                        } while (1 <= n);
                    }
                } else {
                    Utils.appendCharArray(buf, coeff, offset, sig);
                    buf.append('.');
                    Utils.appendCharArray(buf, coeff, offset + sig, coeffLen - sig);
                }
            }
            if (adjusted != 0L) {
                buf.append('E');
                if (adjusted > 0L) {
                    buf.append('+');
                }
                buf.append(adjusted);
            }
        }
        String string3 = buf.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "buf.toString()");
        return string3;
    }

    private final BigInteger bigMultiplyPowerTen(int n) {
        BigInteger bigInteger;
        if (n <= 0) {
            return this.inflated();
        }
        if (this._intCompact != Long.MIN_VALUE) {
            bigInteger = BigDecimal.Companion.bigTenToThe(n).timesLong$kt_math(this._intCompact);
        } else {
            BigInteger bigInteger2 = this._intVal;
            Intrinsics.checkNotNull(bigInteger2);
            bigInteger = bigInteger2.times(BigDecimal.Companion.bigTenToThe(n));
        }
        return bigInteger;
    }

    private final BigInteger inflated() {
        BigInteger bigInteger = this._intVal;
        return bigInteger == null ? BigInteger.Companion.of(this._intCompact) : bigInteger;
    }

    private final int checkScale(long val) {
        int asInt;
        block2: {
            block3: {
                asInt = (int)val;
                if ((long)asInt == val) break block2;
                asInt = val > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                BigInteger b = null;
                if (this._intCompact == 0L) break block2;
                BigDecimal bigDecimal = this;
                boolean bl = false;
                boolean bl2 = false;
                BigDecimal $this$checkScale_u24lambda_u2d3 = bigDecimal;
                boolean bl3 = false;
                b = $this$checkScale_u24lambda_u2d3._intVal;
                if (b == null) break block3;
                BigInteger bigInteger = b;
                Intrinsics.checkNotNull(bigInteger);
                if (bigInteger.getSignum() == 0) break block2;
            }
            throw new ArithmeticException(asInt > 0 ? "Underflow" : "Overflow");
        }
        return asInt;
    }

    private final BigDecimal audit() {
        if (this._intCompact == Long.MIN_VALUE) {
            if (this._intVal == null) {
                BigDecimal.Companion.print("audit", this);
                throw new AssertionError((Object)"null _intVal");
            }
            if (this._precision > 0 && this._precision != BigDecimal.Companion.bigDigitLength(this._intVal)) {
                BigDecimal.Companion.print("audit", this);
                throw new AssertionError((Object)"_precision mismatch");
            }
        } else {
            long val;
            if (this._intVal != null && (val = this._intVal.toLong()) != this._intCompact) {
                BigDecimal.Companion.print("audit", this);
                throw new AssertionError((Object)("Inconsistent state, _intCompact=" + this._intCompact + "\t _intVal=" + val));
            }
            if (this._precision > 0 && this._precision != Companion.longDigitLength$kt_math(this._intCompact)) {
                BigDecimal.Companion.print("audit", this);
                throw new AssertionError((Object)"_precision mismatch");
            }
        }
        return this;
    }

    @JvmStatic
    @NotNull
    public static final BigDecimal of(long unscaledVal, int scale) {
        return Companion.of(unscaledVal, scale);
    }

    @JvmStatic
    @NotNull
    public static final BigDecimal of(long unscaledVal, int scale, int prec) {
        return Companion.of(unscaledVal, scale, prec);
    }

    @JvmStatic
    @NotNull
    public static final BigDecimal of(int val) {
        return Companion.of(val);
    }

    @JvmStatic
    @NotNull
    public static final BigDecimal of(long val) {
        return Companion.of(val);
    }

    @JvmStatic
    @NotNull
    public static final BigDecimal of(@NotNull BigInteger intVal, int scale, int prec) {
        return Companion.of(intVal, scale, prec);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final BigDecimal of(double val, @NotNull MathContext ctx) {
        return Companion.of(val, ctx);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final BigDecimal of(float val, @NotNull MathContext ctx) {
        return Companion.of(val, ctx);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final BigDecimal of(@NotNull String val, @Nullable MathContext ctx) {
        return Companion.of(val, ctx);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final BigDecimal of(@NotNull BigInteger val, @Nullable MathContext ctx) {
        return Companion.of(val, ctx);
    }

    @JvmStatic
    @NotNull
    public static final BigDecimal of(int val, @NotNull MathContext ctx) {
        return Companion.of(val, ctx);
    }

    @JvmStatic
    @NotNull
    public static final BigDecimal of(long val, @NotNull MathContext ctx) {
        return Companion.of(val, ctx);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final BigDecimal of(double val) {
        return Companion.of(val);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final BigDecimal of(float val) {
        return Companion.of(val);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final BigDecimal of(@NotNull String val) {
        return Companion.of(val);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final BigDecimal of(@NotNull BigInteger val) {
        return Companion.of(val);
    }

    static {
        Object object = new BigDecimal[]{new BigDecimal(BigInteger.ZERO, 0L, 0, 1), new BigDecimal(BigInteger.ONE, 1L, 0, 1), new BigDecimal(BigInteger.TWO, 2L, 0, 1), new BigDecimal(BigInteger.Companion.of(3), 3L, 0, 1), new BigDecimal(BigInteger.Companion.of(4), 4L, 0, 1), new BigDecimal(BigInteger.Companion.of(5), 5L, 0, 1), new BigDecimal(BigInteger.Companion.of(6), 6L, 0, 1), new BigDecimal(BigInteger.Companion.of(7), 7L, 0, 1), new BigDecimal(BigInteger.Companion.of(8), 8L, 0, 1), new BigDecimal(BigInteger.Companion.of(9), 9L, 0, 1), new BigDecimal(BigInteger.TEN, 10L, 0, 2)};
        ZERO_THROUGH_TEN = object;
        object = new BigDecimal[]{ZERO_THROUGH_TEN[0], new BigDecimal(BigInteger.ZERO, 0L, 1, 1), new BigDecimal(BigInteger.ZERO, 0L, 2, 1), new BigDecimal(BigInteger.ZERO, 0L, 3, 1), new BigDecimal(BigInteger.ZERO, 0L, 4, 1), new BigDecimal(BigInteger.ZERO, 0L, 5, 1), new BigDecimal(BigInteger.ZERO, 0L, 6, 1), new BigDecimal(BigInteger.ZERO, 0L, 7, 1), new BigDecimal(BigInteger.ZERO, 0L, 8, 1), new BigDecimal(BigInteger.ZERO, 0L, 9, 1), new BigDecimal(BigInteger.ZERO, 0L, 10, 1), new BigDecimal(BigInteger.ZERO, 0L, 11, 1), new BigDecimal(BigInteger.ZERO, 0L, 12, 1), new BigDecimal(BigInteger.ZERO, 0L, 13, 1), new BigDecimal(BigInteger.ZERO, 0L, 14, 1), new BigDecimal(BigInteger.ZERO, 0L, 15, 1)};
        ZERO_SCALED_BY = object;
        ZERO = ZERO_THROUGH_TEN[0];
        ONE = ZERO_THROUGH_TEN[1];
        TWO = ZERO_THROUGH_TEN[2];
        TEN = ZERO_THROUGH_TEN[10];
        ONE_TENTH = Companion.of(1L, 1);
        ONE_HALF = Companion.of(5L, 1);
        PI = org.gciatto.kt.math.BigDecimal$Companion.of$default(Companion, "3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117067982148086513282306647093844609550582231725359408128481117450284102701938521105559644622948954930381964428810975665933446128475648233786783165271201909145648", null, 2, null);
        E = org.gciatto.kt.math.BigDecimal$Companion.of$default(Companion, "2.718281828459045235360287471352662497757247093699959574966967627724076630353547594571382178525166427427466391932003059921817413596629043572900334295260595630738132328627943490763233829880753195251019011573834187930702154089149934884167509244761460668082264", null, 2, null);
        object = new double[23];
        object[0] = (BigDecimal)1.0;
        object[1] = (BigDecimal)10.0;
        object[2] = (BigDecimal)100.0;
        object[3] = (BigDecimal)1000.0;
        object[4] = (BigDecimal)10000.0;
        object[5] = (BigDecimal)100000.0;
        object[6] = (BigDecimal)1000000.0;
        object[7] = (BigDecimal)1.0E7;
        object[8] = (BigDecimal)1.0E8;
        object[9] = (BigDecimal)1.0E9;
        object[10] = (BigDecimal)1.0E10;
        object[11] = (BigDecimal)1.0E11;
        object[12] = (BigDecimal)1.0E12;
        object[13] = (BigDecimal)1.0E13;
        object[14] = (BigDecimal)1.0E14;
        object[15] = (BigDecimal)1.0E15;
        object[16] = (BigDecimal)1.0E16;
        object[17] = (BigDecimal)1.0E17;
        object[18] = (BigDecimal)1.0E18;
        object[19] = (BigDecimal)1.0E19;
        object[20] = (BigDecimal)1.0E20;
        object[21] = (BigDecimal)1.0E21;
        object[22] = (BigDecimal)1.0E22;
        DOUBLE_10_POW = (double[])object;
        object = new float[11];
        object[0] = (BigDecimal)1.0f;
        object[1] = (BigDecimal)10.0f;
        object[2] = (BigDecimal)100.0f;
        object[3] = (BigDecimal)1000.0f;
        object[4] = (BigDecimal)10000.0f;
        object[5] = (BigDecimal)100000.0f;
        object[6] = (BigDecimal)1000000.0f;
        object[7] = (BigDecimal)1.0E7f;
        object[8] = (BigDecimal)1.0E8f;
        object[9] = (BigDecimal)1.0E9f;
        object[10] = (BigDecimal)1.0E10f;
        FLOAT_10_POW = (float[])object;
        object = new long[19];
        object[0] = (BigDecimal)1L;
        object[1] = (BigDecimal)10L;
        object[2] = (BigDecimal)100L;
        object[3] = (BigDecimal)1000L;
        object[4] = (BigDecimal)10000L;
        object[5] = (BigDecimal)100000L;
        object[6] = (BigDecimal)1000000L;
        object[7] = (BigDecimal)10000000L;
        object[8] = (BigDecimal)100000000L;
        object[9] = (BigDecimal)1000000000L;
        object[10] = (BigDecimal)10000000000L;
        object[11] = (BigDecimal)100000000000L;
        object[12] = (BigDecimal)1000000000000L;
        object[13] = (BigDecimal)10000000000000L;
        object[14] = (BigDecimal)100000000000000L;
        object[15] = (BigDecimal)1000000000000000L;
        object[16] = (BigDecimal)10000000000000000L;
        object[17] = (BigDecimal)100000000000000000L;
        object[18] = (BigDecimal)1000000000000000000L;
        LONG_TEN_POWERS_TABLE = (long[])object;
        object = new BigInteger[]{BigInteger.ONE, BigInteger.Companion.of(10), BigInteger.Companion.of(100), BigInteger.Companion.of(1000), BigInteger.Companion.of(10000), BigInteger.Companion.of(100000), BigInteger.Companion.of(1000000), BigInteger.Companion.of(10000000), BigInteger.Companion.of(100000000), BigInteger.Companion.of(1000000000), BigInteger.Companion.of(10000000000L), BigInteger.Companion.of(100000000000L), BigInteger.Companion.of(1000000000000L), BigInteger.Companion.of(10000000000000L), BigInteger.Companion.of(100000000000000L), BigInteger.Companion.of(1000000000000000L), BigInteger.Companion.of(10000000000000000L), BigInteger.Companion.of(100000000000000000L), BigInteger.Companion.of(1000000000000000000L)};
        BIG_TEN_POWERS_TABLE = object;
        BIG_TEN_POWERS_TABLE_INITLEN = BIG_TEN_POWERS_TABLE.length;
        BIG_TEN_POWERS_TABLE_MAX = 16 * BIG_TEN_POWERS_TABLE_INITLEN;
        object = new long[19];
        object[0] = (BigDecimal)Long.MAX_VALUE;
        object[1] = (BigDecimal)0xCCCCCCCCCCCCCCCL;
        object[2] = (BigDecimal)92233720368547758L;
        object[3] = (BigDecimal)9223372036854775L;
        object[4] = (BigDecimal)922337203685477L;
        object[5] = (BigDecimal)92233720368547L;
        object[6] = (BigDecimal)9223372036854L;
        object[7] = (BigDecimal)922337203685L;
        object[8] = (BigDecimal)92233720368L;
        object[9] = (BigDecimal)9223372036L;
        object[10] = (BigDecimal)922337203L;
        object[11] = (BigDecimal)92233720L;
        object[12] = (BigDecimal)0x8CBCCCL;
        object[13] = (BigDecimal)922337L;
        object[14] = (BigDecimal)92233L;
        object[15] = (BigDecimal)9223L;
        object[16] = (BigDecimal)922L;
        object[17] = (BigDecimal)92L;
        object[18] = (BigDecimal)9L;
        THRESHOLDS_TABLE = (long[])object;
        object = new long[20][];
        long[] lArray = new long[]{0L, -8446744073709551616L};
        object[0] = lArray;
        lArray = new long[]{5L, 7766279631452241920L};
        object[1] = lArray;
        lArray = new long[]{54L, 3875820019684212736L};
        object[2] = lArray;
        lArray = new long[]{542L, 1864712049423024128L};
        object[3] = lArray;
        lArray = new long[]{5421L, 200376420520689664L};
        object[4] = lArray;
        lArray = new long[]{54210L, 2003764205206896640L};
        object[5] = lArray;
        lArray = new long[]{542101L, 1590897978359414784L};
        object[6] = lArray;
        lArray = new long[]{5421010L, -2537764290115403776L};
        object[7] = lArray;
        lArray = new long[]{54210108L, -6930898827444486144L};
        object[8] = lArray;
        lArray = new long[]{542101086L, 4477988020393345024L};
        object[9] = lArray;
        lArray = new long[]{5421010862L, 7886392056514347008L};
        object[10] = lArray;
        lArray = new long[]{54210108624L, 5076944270305263616L};
        object[11] = lArray;
        lArray = new long[]{542101086242L, -4570789518076018688L};
        object[12] = lArray;
        lArray = new long[]{5421010862427L, -8814407033341083648L};
        object[13] = lArray;
        lArray = new long[]{54210108624275L, 4089650035136921600L};
        object[14] = lArray;
        lArray = new long[]{542101086242752L, 4003012203950112768L};
        object[15] = lArray;
        lArray = new long[]{5421010862427522L, 3136633892082024448L};
        object[16] = lArray;
        lArray = new long[]{54210108624275221L, -5527149226598858752L};
        object[17] = lArray;
        lArray = new long[]{542101086242752217L, 68739955140067328L};
        object[18] = lArray;
        lArray = new long[]{5421010862427522170L, 687399551400673280L};
        object[19] = lArray;
        LONGLONG_TEN_POWERS_TABLE = (long[][])object;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gciatto/kt/math/BigDecimal$LongOverflow;", "", "()V", "LONGMAX", "Lorg/gciatto/kt/math/BigInteger;", "LONGMIN", "check", "", "num", "Lorg/gciatto/kt/math/BigDecimal;", "kt-math"})
    private static final class LongOverflow {
        @NotNull
        public static final LongOverflow INSTANCE = new LongOverflow();
        @NotNull
        private static final BigInteger LONGMIN = BigInteger.Companion.of(Long.MIN_VALUE);
        @NotNull
        private static final BigInteger LONGMAX = BigInteger.Companion.of(Long.MAX_VALUE);

        private LongOverflow() {
        }

        public final void check(@NotNull BigDecimal num) {
            Intrinsics.checkNotNullParameter(num, "num");
            BigInteger intVal = num.inflated();
            if (intVal.compareTo(LONGMIN) < 0 || intVal.compareTo(LONGMAX) > 0) {
                throw new ArithmeticException("Overflow");
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001d\u0012\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\f\u001a\u00060\u0003j\u0002`\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/gciatto/kt/math/BigDecimal$StringBuilderHelper;", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "compactCharArray", "", "(Ljava/lang/StringBuilder;[C)V", "getCompactCharArray", "()[C", "getSb", "()Ljava/lang/StringBuilder;", "stringBuilder", "getStringBuilder", "putIntCompact", "", "intCompact", "", "Companion", "kt-math"})
    public static final class StringBuilderHelper {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final StringBuilder sb;
        @NotNull
        private final char[] compactCharArray;
        @NotNull
        private static final char[] DIGIT_TENS;
        @NotNull
        private static final char[] DIGIT_ONES;

        public StringBuilderHelper(@NotNull StringBuilder sb, @NotNull char[] compactCharArray) {
            Intrinsics.checkNotNullParameter(sb, "sb");
            Intrinsics.checkNotNullParameter(compactCharArray, "compactCharArray");
            this.sb = sb;
            this.compactCharArray = compactCharArray;
        }

        public /* synthetic */ StringBuilderHelper(StringBuilder stringBuilder, char[] cArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                stringBuilder = new StringBuilder();
            }
            if ((n & 2) != 0) {
                cArray = new char[19];
            }
            this(stringBuilder, cArray);
        }

        @NotNull
        public final StringBuilder getSb() {
            return this.sb;
        }

        @NotNull
        public final char[] getCompactCharArray() {
            return this.compactCharArray;
        }

        @NotNull
        public final StringBuilder getStringBuilder() {
            StringsKt.removeRange(this.sb, 0, this.sb.length());
            return this.sb;
        }

        public final int putIntCompact(long intCompact) {
            long intCompact2 = intCompact;
            boolean bl = intCompact2 >= 0L;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            long q = 0L;
            int r = 0;
            int charPos = this.compactCharArray.length;
            while (intCompact2 > Integer.MAX_VALUE) {
                q = intCompact2 / (long)100;
                r = (int)(intCompact2 - q * (long)100);
                intCompact2 = q;
                this.compactCharArray[--charPos] = DIGIT_ONES[r];
                this.compactCharArray[--charPos] = DIGIT_TENS[r];
            }
            int q2 = 0;
            int i2 = (int)intCompact2;
            while (i2 >= 100) {
                q2 = i2 / 100;
                r = i2 - q2 * 100;
                i2 = q2;
                this.compactCharArray[--charPos] = DIGIT_ONES[r];
                this.compactCharArray[--charPos] = DIGIT_TENS[r];
            }
            this.compactCharArray[--charPos] = DIGIT_ONES[i2];
            if (i2 >= 10) {
                this.compactCharArray[--charPos] = DIGIT_TENS[i2];
            }
            return charPos;
        }

        public StringBuilderHelper() {
            this(null, null, 3, null);
        }

        static {
            char[] cArray = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
            DIGIT_TENS = cArray;
            cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
            DIGIT_ONES = cArray;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/gciatto/kt/math/BigDecimal$StringBuilderHelper$Companion;", "", "()V", "DIGIT_ONES", "", "getDIGIT_ONES", "()[C", "DIGIT_TENS", "getDIGIT_TENS", "kt-math"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final char[] getDIGIT_TENS() {
                return DIGIT_TENS;
            }

            @NotNull
            public final char[] getDIGIT_ONES() {
                return DIGIT_ONES;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b1\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0019\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010>\u001a\u00020\b2\u0006\u0010?\u001a\u00020\u0005H\u0002J\u0018\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020\bH\u0002J\u001c\u0010@\u001a\u0004\u0018\u00010\u00052\b\u0010A\u001a\u0004\u0018\u00010\u00052\u0006\u0010B\u001a\u00020\bH\u0002J\u0010\u0010C\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\bH\u0002J\u0018\u0010D\u001a\u00020\b2\u0006\u0010E\u001a\u00020\u000b2\u0006\u0010F\u001a\u00020\u000bH\u0002J\u001a\u0010D\u001a\u00020\b2\b\u0010G\u001a\u0004\u0018\u00010\u00052\u0006\u0010F\u001a\u00020\u000bH\u0002J\u0010\u0010H\u001a\u00020\b2\u0006\u0010F\u001a\u00020\u000bH\u0002J(\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\b2\u0006\u0010L\u001a\u00020\b2\u0006\u0010M\u001a\u00020\b2\u0006\u0010N\u001a\u00020JH\u0002J\u0010\u0010O\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020\u0005H\u0002J(\u0010P\u001a\u00020\b2\u0006\u0010Q\u001a\u00020\u000b2\u0006\u0010R\u001a\u00020\b2\u0006\u0010S\u001a\u00020\u000b2\u0006\u0010T\u001a\u00020\bH\u0002J*\u0010P\u001a\u00020\b2\u0006\u0010Q\u001a\u00020\u000b2\u0006\u0010R\u001a\u00020\b2\b\u0010S\u001a\u0004\u0018\u00010\u00052\u0006\u0010T\u001a\u00020\bH\u0002J,\u0010P\u001a\u00020\b2\b\u0010Q\u001a\u0004\u0018\u00010\u00052\u0006\u0010R\u001a\u00020\b2\b\u0010S\u001a\u0004\u0018\u00010\u00052\u0006\u0010T\u001a\u00020\bH\u0002J \u0010U\u001a\u00020\u000f2\u0006\u0010V\u001a\u00020\u000b2\u0006\u0010W\u001a\u00020\b2\u0006\u0010X\u001a\u00020\u000bH\u0002J \u0010U\u001a\u00020\u000f2\u0006\u0010G\u001a\u00020\u00052\u0006\u0010W\u001a\u00020\b2\u0006\u0010X\u001a\u00020\u000bH\u0002J\u0018\u0010Y\u001a\u00020\u00182\u0006\u0010B\u001a\u00020\u000b2\u0006\u0010Z\u001a\u00020\u000bH\u0002J8\u0010[\u001a\u00020\u000f2\u0006\u0010\\\u001a\u00020\u000b2\u0006\u0010]\u001a\u00020\b2\u0006\u0010^\u001a\u00020\u000b2\u0006\u0010_\u001a\u00020\b2\u0006\u0010W\u001a\u00020\b2\u0006\u0010K\u001a\u00020\bH\u0002J:\u0010[\u001a\u0004\u0018\u00010\u000f2\u0006\u0010Q\u001a\u00020\u000b2\u0006\u0010R\u001a\u00020\b2\u0006\u0010S\u001a\u00020\u000b2\u0006\u0010T\u001a\u00020\b2\u0006\u0010X\u001a\u00020\u000b2\u0006\u0010`\u001a\u00020aH\u0002J:\u0010[\u001a\u00020\u000f2\u0006\u0010\\\u001a\u00020\u000b2\u0006\u0010]\u001a\u00020\b2\b\u0010^\u001a\u0004\u0018\u00010\u00052\u0006\u0010_\u001a\u00020\b2\u0006\u0010W\u001a\u00020\b2\u0006\u0010K\u001a\u00020\bH\u0002J<\u0010[\u001a\u0004\u0018\u00010\u000f2\u0006\u0010Q\u001a\u00020\u000b2\u0006\u0010R\u001a\u00020\b2\b\u0010S\u001a\u0004\u0018\u00010\u00052\u0006\u0010T\u001a\u00020\b2\u0006\u0010X\u001a\u00020\u000b2\u0006\u0010`\u001a\u00020aH\u0002J:\u0010[\u001a\u00020\u000f2\b\u0010\\\u001a\u0004\u0018\u00010\u00052\u0006\u0010]\u001a\u00020\b2\u0006\u0010^\u001a\u00020\u000b2\u0006\u0010_\u001a\u00020\b2\u0006\u0010W\u001a\u00020\b2\u0006\u0010K\u001a\u00020\bH\u0002J<\u0010[\u001a\u0004\u0018\u00010\u000f2\b\u0010Q\u001a\u0004\u0018\u00010\u00052\u0006\u0010R\u001a\u00020\b2\u0006\u0010S\u001a\u00020\u000b2\u0006\u0010T\u001a\u00020\b2\u0006\u0010X\u001a\u00020\u000b2\u0006\u0010`\u001a\u00020aH\u0002J<\u0010[\u001a\u00020\u000f2\b\u0010\\\u001a\u0004\u0018\u00010\u00052\u0006\u0010]\u001a\u00020\b2\b\u0010^\u001a\u0004\u0018\u00010\u00052\u0006\u0010_\u001a\u00020\b2\u0006\u0010W\u001a\u00020\b2\u0006\u0010K\u001a\u00020\bH\u0002J>\u0010[\u001a\u0004\u0018\u00010\u000f2\b\u0010Q\u001a\u0004\u0018\u00010\u00052\u0006\u0010R\u001a\u00020\b2\b\u0010S\u001a\u0004\u0018\u00010\u00052\u0006\u0010T\u001a\u00020\b2\u0006\u0010X\u001a\u00020\u000b2\u0006\u0010`\u001a\u00020aH\u0002J \u0010b\u001a\u00020\u000b2\u0006\u0010c\u001a\u00020\u000b2\u0006\u0010d\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020\bH\u0002J0\u0010b\u001a\u00020\u000f2\u0006\u0010c\u001a\u00020\u000b2\u0006\u0010d\u001a\u00020\u000b2\u0006\u0010W\u001a\u00020\b2\u0006\u0010K\u001a\u00020\b2\u0006\u0010X\u001a\u00020\bH\u0002J \u0010b\u001a\u00020\u00052\u0006\u0010e\u001a\u00020\u00052\u0006\u0010d\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020\bH\u0002J0\u0010b\u001a\u00020\u000f2\u0006\u0010e\u001a\u00020\u00052\u0006\u0010d\u001a\u00020\u000b2\u0006\u0010W\u001a\u00020\b2\u0006\u0010K\u001a\u00020\b2\u0006\u0010X\u001a\u00020\bH\u0002J \u0010b\u001a\u00020\u00052\u0006\u0010e\u001a\u00020\u00052\u0006\u0010f\u001a\u00020\u00052\u0006\u0010K\u001a\u00020\bH\u0002J0\u0010b\u001a\u00020\u000f2\u0006\u0010e\u001a\u00020\u00052\u0006\u0010f\u001a\u00020\u00052\u0006\u0010W\u001a\u00020\b2\u0006\u0010K\u001a\u00020\b2\u0006\u0010X\u001a\u00020\bH\u0002JB\u0010g\u001a\u0004\u0018\u00010\u000f2\u0006\u0010h\u001a\u00020\u000b2\u0006\u0010i\u001a\u00020\u000b2\u0006\u0010^\u001a\u00020\u000b2\u0006\u0010j\u001a\u00020\b2\u0006\u0010W\u001a\u00020\b2\u0006\u0010K\u001a\u00020\b2\u0006\u0010X\u001a\u00020\bH\u0002J \u0010k\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u00052\u0006\u0010l\u001a\u00020\b2\u0006\u0010K\u001a\u00020\bH\u0002J:\u0010m\u001a\u0004\u0018\u00010\u000f2\u0006\u0010Q\u001a\u00020\u000b2\u0006\u0010R\u001a\u00020\b2\u0006\u0010S\u001a\u00020\u000b2\u0006\u0010T\u001a\u00020\b2\u0006\u0010X\u001a\u00020\u000b2\u0006\u0010`\u001a\u00020aH\u0002J \u0010n\u001a\u00020\u000f2\u0006\u0010V\u001a\u00020\u000b2\u0006\u0010W\u001a\u00020\b2\u0006\u0010`\u001a\u00020aH\u0002J\u001c\u0010n\u001a\u0004\u0018\u00010\u000f2\b\u0010F\u001a\u0004\u0018\u00010\u000f2\u0006\u0010`\u001a\u00020aH\u0002J \u0010n\u001a\u00020\u000f2\u0006\u0010G\u001a\u00020\u00052\u0006\u0010W\u001a\u00020\b2\u0006\u0010`\u001a\u00020aH\u0002J2\u0010o\u001a\u0004\u0018\u00010\u000f2\u0006\u0010p\u001a\u00020\u000b2\u0006\u0010q\u001a\u00020\u000b2\u0006\u0010j\u001a\u00020\b2\u0006\u0010W\u001a\u00020\b2\u0006\u0010`\u001a\u00020aH\u0002J\u0010\u0010r\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\bH\u0002J\u0018\u0010s\u001a\u00020\b2\u0006\u0010t\u001a\u00020\u000b2\u0006\u0010u\u001a\u00020\u000bH\u0002J\u0015\u0010v\u001a\u00020\b2\u0006\u0010t\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\bwJ(\u0010x\u001a\u00020J2\u0006\u0010y\u001a\u00020\u000b2\u0006\u0010z\u001a\u00020\u000b2\u0006\u0010{\u001a\u00020\u000b2\u0006\u0010|\u001a\u00020\u000bH\u0002J\u0018\u0010}\u001a\u00020\u000b2\u0006\u0010F\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020\bH\u0002J\u0018\u0010~\u001a\u00020\u000b2\u0006\u0010p\u001a\u00020\u000b2\u0006\u0010q\u001a\u00020\u000bH\u0002J\u001d\u0010\u007f\u001a\u00030\u0080\u00012\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004H\u0002\u00a2\u0006\u0003\u0010\u0081\u0001J6\u0010\u0082\u0001\u001a\u00020\u000b2\u0007\u0010\u0083\u0001\u001a\u00020\u000b2\u0007\u0010\u0084\u0001\u001a\u00020\u000b2\u0007\u0010\u0085\u0001\u001a\u00020\u000b2\u0007\u0010\u0086\u0001\u001a\u00020\u000b2\u0007\u0010\u0087\u0001\u001a\u00020\u000bH\u0002J\u0019\u0010\u0088\u0001\u001a\u00020\u000b2\u0006\u0010t\u001a\u00020\u000b2\u0006\u0010u\u001a\u00020\u000bH\u0002J!\u0010\u0088\u0001\u001a\u00020\u000f2\u0006\u0010t\u001a\u00020\u000b2\u0006\u0010u\u001a\u00020\u000b2\u0006\u0010W\u001a\u00020\bH\u0002J#\u0010\u0088\u0001\u001a\u00020\u000f2\u0006\u0010t\u001a\u00020\u000b2\b\u0010u\u001a\u0004\u0018\u00010\u00052\u0006\u0010W\u001a\u00020\bH\u0002J#\u0010\u0088\u0001\u001a\u00020\u000f2\u0006\u0010t\u001a\u00020\u00052\b\u0010u\u001a\u0004\u0018\u00010\u00052\u0006\u0010W\u001a\u00020\bH\u0002J)\u0010\u0089\u0001\u001a\u00020\u000f2\u0006\u0010t\u001a\u00020\u000b2\u0006\u0010u\u001a\u00020\u000b2\u0006\u0010W\u001a\u00020\b2\u0006\u0010`\u001a\u00020aH\u0002J+\u0010\u0089\u0001\u001a\u00020\u000f2\u0006\u0010t\u001a\u00020\u000b2\b\u0010u\u001a\u0004\u0018\u00010\u00052\u0006\u0010W\u001a\u00020\b2\u0006\u0010`\u001a\u00020aH\u0002J+\u0010\u0089\u0001\u001a\u00020\u000f2\u0006\u0010t\u001a\u00020\u00052\b\u0010u\u001a\u0004\u0018\u00010\u00052\u0006\u0010W\u001a\u00020\b2\u0006\u0010`\u001a\u00020aH\u0002J=\u0010\u008a\u0001\u001a\u0004\u0018\u00010\u000f2\u0007\u0010\u008b\u0001\u001a\u00020\u000b2\u0007\u0010\u008c\u0001\u001a\u00020\u000b2\u0006\u0010^\u001a\u00020\u000b2\u0006\u0010W\u001a\u00020\b2\u0006\u0010K\u001a\u00020\b2\u0006\u0010X\u001a\u00020\bH\u0002J3\u0010\u008d\u0001\u001a\u00020J2\u0006\u0010d\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020\b2\u0006\u0010L\u001a\u00020\b2\u0007\u0010\u008e\u0001\u001a\u00020\u000b2\u0007\u0010\u008f\u0001\u001a\u00020\u000bH\u0002J4\u0010\u008d\u0001\u001a\u00020J2\u0006\u0010d\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020\b2\u0006\u0010L\u001a\u00020\b2\b\u0010\u0090\u0001\u001a\u00030\u0091\u00012\u0007\u0010\u008f\u0001\u001a\u00020\u000bH\u0002J7\u0010\u008d\u0001\u001a\u00020J2\b\u0010\u0092\u0001\u001a\u00030\u0091\u00012\u0006\u0010K\u001a\u00020\b2\u0006\u0010L\u001a\u00020\b2\b\u0010\u0090\u0001\u001a\u00030\u0091\u00012\b\u0010\u0093\u0001\u001a\u00030\u0091\u0001H\u0002J\u001d\u0010\u0094\u0001\u001a\u00020\u000f2\u0007\u0010F\u001a\u00030\u0095\u00012\t\b\u0002\u0010\u0096\u0001\u001a\u00020aH\u0007J\u001d\u0010\u0094\u0001\u001a\u00020\u000f2\u0007\u0010F\u001a\u00030\u0097\u00012\t\b\u0002\u0010\u0096\u0001\u001a\u00020aH\u0007J\u0011\u0010\u0094\u0001\u001a\u00020\u000f2\u0006\u0010F\u001a\u00020\bH\u0007J\u001a\u0010\u0094\u0001\u001a\u00020\u000f2\u0006\u0010F\u001a\u00020\b2\u0007\u0010\u0096\u0001\u001a\u00020aH\u0007J\u0011\u0010\u0094\u0001\u001a\u00020\u000f2\u0006\u0010F\u001a\u00020\u000bH\u0007J\u001a\u0010\u0094\u0001\u001a\u00020\u000f2\u0007\u0010\u0098\u0001\u001a\u00020\u000b2\u0006\u0010W\u001a\u00020\bH\u0007J#\u0010\u0094\u0001\u001a\u00020\u000f2\u0007\u0010\u0098\u0001\u001a\u00020\u000b2\u0006\u0010W\u001a\u00020\b2\u0007\u0010\u0099\u0001\u001a\u00020\bH\u0007J\u001a\u0010\u0094\u0001\u001a\u00020\u000f2\u0006\u0010F\u001a\u00020\u000b2\u0007\u0010\u0096\u0001\u001a\u00020aH\u0007J\u001f\u0010\u0094\u0001\u001a\u00020\u000f2\u0007\u0010F\u001a\u00030\u009a\u00012\u000b\b\u0002\u0010\u0096\u0001\u001a\u0004\u0018\u00010aH\u0007J\"\u0010\u0094\u0001\u001a\u00020\u000f2\u0006\u0010G\u001a\u00020\u00052\u0006\u0010W\u001a\u00020\b2\u0007\u0010\u0099\u0001\u001a\u00020\bH\u0007J\u001e\u0010\u0094\u0001\u001a\u00020\u000f2\u0006\u0010F\u001a\u00020\u00052\u000b\b\u0002\u0010\u0096\u0001\u001a\u0004\u0018\u00010aH\u0007J%\u0010\u009b\u0001\u001a\u00020\u000b2\b\u0010\u009c\u0001\u001a\u00030\u009d\u00012\u0007\u0010\u009e\u0001\u001a\u00020\b2\u0007\u0010\u009f\u0001\u001a\u00020\bH\u0002J\u0019\u0010\u00a0\u0001\u001a\u00020\b2\u0006\u0010p\u001a\u00020\u000b2\u0006\u0010q\u001a\u00020\u000bH\u0002J\u001d\u0010\u00a1\u0001\u001a\u00030\u0080\u00012\b\u0010\u00a2\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00a3\u0001\u001a\u00020\u000fH\u0002J*\u0010\u00a4\u0001\u001a\u00020\u000f2\u0006\u0010L\u001a\u00020\b2\u0007\u0010\u00a5\u0001\u001a\u00020\b2\u0006\u0010W\u001a\u00020\b2\u0006\u0010X\u001a\u00020\bH\u0002J\u0012\u0010\u00a6\u0001\u001a\u00020\b2\u0007\u0010\u00a7\u0001\u001a\u00020\u000bH\u0002J'\u0010\u00a8\u0001\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020\b2\u0006\u0010j\u001a\u00020\b2\u0006\u0010W\u001a\u00020\bH\u0000\u00a2\u0006\u0003\b\u00a9\u0001J+\u0010\u00aa\u0001\u001a\u00020\u000f2\b\u0010G\u001a\u0004\u0018\u00010\u00052\u0006\u0010E\u001a\u00020\u000b2\u0006\u0010W\u001a\u00020\b2\u0006\u0010X\u001a\u00020\bH\u0002J+\u0010\u00ab\u0001\u001a\u00020\u000f2\u0006\u0010Q\u001a\u00020\u000b2\u0007\u0010\u00ac\u0001\u001a\u00020\b2\u0006\u0010S\u001a\u00020\u000b2\u0007\u0010\u00ad\u0001\u001a\u00020\bH\u0002J,\u0010\u00ab\u0001\u001a\u00020\u000f2\u0006\u0010Q\u001a\u00020\u000b2\u0007\u0010\u00ac\u0001\u001a\u00020\b2\u0007\u0010\u00ae\u0001\u001a\u00020\u00052\u0007\u0010\u00ad\u0001\u001a\u00020\bH\u0002J\u0019\u0010\u00ab\u0001\u001a\u00020\u000b2\u0006\u0010Q\u001a\u00020\u000b2\u0006\u0010S\u001a\u00020\u000bH\u0002J!\u0010\u00ab\u0001\u001a\u00020\u000f2\u0006\u0010Q\u001a\u00020\u000b2\u0006\u0010S\u001a\u00020\u000b2\u0006\u0010W\u001a\u00020\bH\u0002J1\u0010\u00ab\u0001\u001a\u00020\u000f2\t\u0010\u00af\u0001\u001a\u0004\u0018\u00010\u00052\u0007\u0010\u00ac\u0001\u001a\u00020\b2\t\u0010\u00ae\u0001\u001a\u0004\u0018\u00010\u00052\u0007\u0010\u00ad\u0001\u001a\u00020\bH\u0002J\u001b\u0010\u00b0\u0001\u001a\u00020J2\u0007\u0010\u00b1\u0001\u001a\u00020\u000b2\u0007\u0010\u00b2\u0001\u001a\u00020\u000bH\u0002J\u001b\u0010\u00b3\u0001\u001a\u00020J2\u0007\u0010\u00b1\u0001\u001a\u00020\u000b2\u0007\u0010\u00b2\u0001\u001a\u00020\u000bH\u0002J\u0017\u0010\u00b4\u0001\u001a\u00020\u000f2\u0006\u0010W\u001a\u00020\bH\u0000\u00a2\u0006\u0003\b\u00b5\u0001R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001d\u0010\u0002R\u0016\u0010\u001e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001f\u0010\u0002R\u0016\u0010 \u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b!\u0010\u0002R\u0016\u0010\"\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b#\u0010\u0002R\u0016\u0010$\u001a\u00020\b8\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b%\u0010\u0002R\u0016\u0010&\u001a\u00020\b8\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b'\u0010\u0002R\u0016\u0010(\u001a\u00020\b8\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b)\u0010\u0002R\u0016\u0010*\u001a\u00020\b8\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b+\u0010\u0002R\u0016\u0010,\u001a\u00020\b8\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b-\u0010\u0002R\u0016\u0010.\u001a\u00020\b8\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b/\u0010\u0002R\u0016\u00100\u001a\u00020\b8\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b1\u0010\u0002R\u0016\u00102\u001a\u00020\b8\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b3\u0010\u0002R\u0016\u00104\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b5\u0010\u0002R\u000e\u00106\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00107\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b8\u0010\u0002R\u0016\u00109\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b:\u0010\u0002R\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010<R\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010<\u00a8\u0006\u00b6\u0001"}, d2={"Lorg/gciatto/kt/math/BigDecimal$Companion;", "", "()V", "BIG_TEN_POWERS_TABLE", "", "Lorg/gciatto/kt/math/BigInteger;", "[Lorg/gciatto/kt/math/BigInteger;", "BIG_TEN_POWERS_TABLE_INITLEN", "", "BIG_TEN_POWERS_TABLE_MAX", "DIV_NUM_BASE", "", "DOUBLE_10_POW", "", "E", "Lorg/gciatto/kt/math/BigDecimal;", "getE$annotations", "FLOAT_10_POW", "", "HALF_LONG_MAX_VALUE", "HALF_LONG_MIN_VALUE", "INFLATED", "INFLATED_BIGINT", "LONGLONG_TEN_POWERS_TABLE", "", "[[J", "LONG_TEN_POWERS_TABLE", "MAX_COMPACT_DIGITS", "ONE", "getONE$annotations", "ONE_HALF", "getONE_HALF$annotations", "ONE_TENTH", "getONE_TENTH$annotations", "PI", "getPI$annotations", "ROUND_CEILING", "getROUND_CEILING$kt_math$annotations", "ROUND_DOWN", "getROUND_DOWN$kt_math$annotations", "ROUND_FLOOR", "getROUND_FLOOR$kt_math$annotations", "ROUND_HALF_DOWN", "getROUND_HALF_DOWN$kt_math$annotations", "ROUND_HALF_EVEN", "getROUND_HALF_EVEN$kt_math$annotations", "ROUND_HALF_UP", "getROUND_HALF_UP$kt_math$annotations", "ROUND_UNNECESSARY", "getROUND_UNNECESSARY$kt_math$annotations", "ROUND_UP", "getROUND_UP$kt_math$annotations", "TEN", "getTEN$annotations", "THRESHOLDS_TABLE", "TWO", "getTWO$annotations", "ZERO", "getZERO$annotations", "ZERO_SCALED_BY", "[Lorg/gciatto/kt/math/BigDecimal;", "ZERO_THROUGH_TEN", "bigDigitLength", "b", "bigMultiplyPowerTen", "value", "n", "bigTenToThe", "checkScale", "intCompact", "val", "intVal", "checkScaleNonZero", "commonNeedIncrement", "", "roundingMode", "qsign", "cmpFracHalf", "oddQuot", "compactValFor", "compareMagnitudeNormalized", "xs", "xscale", "ys", "yscale", "createAndStripZerosToMatchScale", "compactVal", "scale", "preferredScale", "divRemNegativeLong", "d", "divide", "dividend", "dividendScale", "divisor", "divisorScale", "mc", "Lorg/gciatto/kt/math/MathContext;", "divideAndRound", "ldividend", "ldivisor", "bdividend", "bdivisor", "divideAndRound128", "dividendHi", "dividendLo", "sign", "divideAndRoundByTenPow", "tenPow", "divideSmallFastPath", "doRound", "doRound128", "hi", "lo", "expandBigIntegerTenPowers", "longCompareMagnitude", "x", "y", "longDigitLength", "longDigitLength$kt_math", "longLongCompareMagnitude", "hi0", "lo0", "hi1", "lo1", "longMultiplyPowerTen", "make64", "matchScale", "", "([Lorg/gciatto/kt/math/BigDecimal;)V", "mulsub", "u1", "u0", "v1", "v0", "q0", "multiply", "multiplyAndRound", "multiplyDivideAndRound", "dividend0", "dividend1", "needIncrement", "q", "r", "mq", "Lorg/gciatto/kt/math/MutableBigInteger;", "mdivisor", "mr", "of", "", "ctx", "", "unscaledVal", "prec", "", "parseExp", "in", "", "offset", "len", "precision", "print", "name", "bd", "roundedTenPower", "raise", "saturateLong", "s", "scaledTenPow", "scaledTenPow$kt_math", "stripZerosToMatchScale", "sum", "scale1", "scale2", "snd", "fst", "unsignedLongCompare", "one", "two", "unsignedLongCompareEq", "zeroValueOf", "zeroValueOf$kt_math", "kt-math"})
    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ void getZERO$annotations() {
        }

        public static /* synthetic */ void getONE$annotations() {
        }

        public static /* synthetic */ void getTWO$annotations() {
        }

        public static /* synthetic */ void getTEN$annotations() {
        }

        public static /* synthetic */ void getONE_TENTH$annotations() {
        }

        public static /* synthetic */ void getONE_HALF$annotations() {
        }

        public static /* synthetic */ void getPI$annotations() {
        }

        public static /* synthetic */ void getE$annotations() {
        }

        private final long parseExp(char[] in, int offset, int len) {
            int n;
            boolean negexp;
            int offset2 = offset;
            int len2 = len;
            long exp = 0L;
            int n2 = offset2;
            offset2 = n2 + 1;
            char c = in[offset2];
            int n3 = len2;
            len2 = n3 + -1;
            boolean bl = negexp = c == '-';
            if (negexp || c == '+') {
                n = offset2;
                offset2 = n + 1;
                c = in[offset2];
                n = len2;
                len2 = n + -1;
            }
            if (len2 <= 0) {
                throw new NumberFormatException("No exponent digits.");
            }
            while (len2 > 10 && (c == '0' || Utils.toDigit(c, 10) == 0)) {
                n = offset2;
                offset2 = n + 1;
                c = in[offset2];
                n = len2;
                len2 = n + -1;
            }
            if (len2 > 10) {
                throw new NumberFormatException("Too many nonzero exponent digits.");
            }
            while (true) {
                int v = 0;
                boolean bl2 = '0' <= c ? c <= '9' : false;
                if (bl2) {
                    v = c - 48;
                } else {
                    v = Utils.toDigit(c, 10);
                    if (v < 0) {
                        throw new NumberFormatException("Not a digit.");
                    }
                }
                exp = exp * (long)10 + (long)v;
                if (len2 == 1) break;
                int n4 = offset2;
                offset2 = n4 + 1;
                c = in[offset2];
                n4 = len2;
                len2 = n4 + -1;
            }
            if (negexp) {
                exp = -exp;
            }
            return exp;
        }

        @JvmStatic
        @NotNull
        public final BigDecimal of(long unscaledVal, int scale) {
            if (scale == 0) {
                return this.of(unscaledVal);
            }
            if (unscaledVal == 0L) {
                return this.zeroValueOf$kt_math(scale);
            }
            return new BigDecimal(unscaledVal == Long.MIN_VALUE ? INFLATED_BIGINT : null, unscaledVal, scale, 0);
        }

        @JvmStatic
        @NotNull
        public final BigDecimal of(long unscaledVal, int scale, int prec) {
            return scale == 0 && unscaledVal >= 0L && unscaledVal < (long)ZERO_THROUGH_TEN.length ? ZERO_THROUGH_TEN[(int)unscaledVal] : (unscaledVal == 0L ? this.zeroValueOf$kt_math(scale) : new BigDecimal(unscaledVal == Long.MIN_VALUE ? INFLATED_BIGINT : null, unscaledVal, scale, prec));
        }

        @JvmStatic
        @NotNull
        public final BigDecimal of(int val) {
            return this.of((long)val);
        }

        @JvmStatic
        @NotNull
        public final BigDecimal of(long val) {
            return val >= 0L && val < (long)ZERO_THROUGH_TEN.length ? ZERO_THROUGH_TEN[(int)val] : (val != Long.MIN_VALUE ? new BigDecimal((BigInteger)null, val, 0, 0) : new BigDecimal(INFLATED_BIGINT, val, 0, 0));
        }

        @JvmStatic
        @NotNull
        public final BigDecimal of(@NotNull BigInteger intVal, int scale, int prec) {
            Intrinsics.checkNotNullParameter(intVal, "intVal");
            long val = this.compactValFor(intVal);
            if (val == 0L) {
                return this.zeroValueOf$kt_math(scale);
            }
            if (scale == 0 && val >= 0L && val < (long)ZERO_THROUGH_TEN.length) {
                return ZERO_THROUGH_TEN[(int)val];
            }
            return new BigDecimal(intVal, val, scale, prec);
        }

        @NotNull
        public final BigDecimal zeroValueOf$kt_math(int scale) {
            return scale >= 0 && scale < ZERO_SCALED_BY.length ? ZERO_SCALED_BY[scale] : new BigDecimal(BigInteger.ZERO, 0L, scale, 1);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final BigDecimal of(double val, @NotNull MathContext ctx) {
            Intrinsics.checkNotNullParameter(ctx, "ctx");
            return new BigDecimal(String.valueOf(val), ctx);
        }

        public static /* synthetic */ BigDecimal of$default(Companion companion, double d, MathContext mathContext, int n, Object object) {
            if ((n & 2) != 0) {
                mathContext = MathContext.UNLIMITED;
            }
            return companion.of(d, mathContext);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final BigDecimal of(float val, @NotNull MathContext ctx) {
            Intrinsics.checkNotNullParameter(ctx, "ctx");
            return this.of((double)val, ctx);
        }

        public static /* synthetic */ BigDecimal of$default(Companion companion, float f, MathContext mathContext, int n, Object object) {
            if ((n & 2) != 0) {
                mathContext = MathContext.UNLIMITED;
            }
            return companion.of(f, mathContext);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final BigDecimal of(@NotNull String val, @Nullable MathContext ctx) {
            Intrinsics.checkNotNullParameter(val, "val");
            return ctx == null ? new BigDecimal(val) : new BigDecimal(val, ctx);
        }

        public static /* synthetic */ BigDecimal of$default(Companion companion, String string2, MathContext mathContext, int n, Object object) {
            if ((n & 2) != 0) {
                mathContext = null;
            }
            return companion.of(string2, mathContext);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final BigDecimal of(@NotNull BigInteger val, @Nullable MathContext ctx) {
            Intrinsics.checkNotNullParameter(val, "val");
            return ctx == null ? new BigDecimal(val) : new BigDecimal(val, ctx);
        }

        public static /* synthetic */ BigDecimal of$default(Companion companion, BigInteger bigInteger, MathContext mathContext, int n, Object object) {
            if ((n & 2) != 0) {
                mathContext = null;
            }
            return companion.of(bigInteger, mathContext);
        }

        @JvmStatic
        @NotNull
        public final BigDecimal of(int val, @NotNull MathContext ctx) {
            Intrinsics.checkNotNullParameter(ctx, "ctx");
            return new BigDecimal((long)val, ctx);
        }

        @JvmStatic
        @NotNull
        public final BigDecimal of(long val, @NotNull MathContext ctx) {
            Intrinsics.checkNotNullParameter(ctx, "ctx");
            return new BigDecimal(val, ctx);
        }

        @Deprecated(message="Use {@link RoundingMode#UP} instead.")
        public static /* synthetic */ void getROUND_UP$kt_math$annotations() {
        }

        @Deprecated(message="Use {@link RoundingMode#DOWN} instead.")
        public static /* synthetic */ void getROUND_DOWN$kt_math$annotations() {
        }

        @Deprecated(message="Use {@link RoundingMode#CEILING} instead.")
        public static /* synthetic */ void getROUND_CEILING$kt_math$annotations() {
        }

        @Deprecated(message="Use {@link RoundingMode#FLOOR} instead.")
        public static /* synthetic */ void getROUND_FLOOR$kt_math$annotations() {
        }

        @Deprecated(message="Use {@link RoundingMode#HALF_UP} instead.")
        public static /* synthetic */ void getROUND_HALF_UP$kt_math$annotations() {
        }

        @Deprecated(message="Use {@link RoundingMode#HALF_DOWN} instead.")
        public static /* synthetic */ void getROUND_HALF_DOWN$kt_math$annotations() {
        }

        @Deprecated(message="Use {@link RoundingMode#HALF_EVEN} instead.")
        public static /* synthetic */ void getROUND_HALF_EVEN$kt_math$annotations() {
        }

        @Deprecated(message="Use {@link RoundingMode#UNNECESSARY} instead.")
        public static /* synthetic */ void getROUND_UNNECESSARY$kt_math$annotations() {
        }

        private final BigInteger bigTenToThe(int n) {
            if (n < 0) {
                return BigInteger.ZERO;
            }
            if (n < BIG_TEN_POWERS_TABLE_MAX) {
                BigInteger bigInteger;
                BigInteger[] pows = BIG_TEN_POWERS_TABLE;
                if (n < pows.length) {
                    BigInteger bigInteger2 = pows[n];
                    bigInteger = bigInteger2;
                    Intrinsics.checkNotNull(bigInteger2);
                } else {
                    bigInteger = this.expandBigIntegerTenPowers(n);
                }
                return bigInteger;
            }
            return BigInteger.TEN.pow(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final BigInteger expandBigIntegerTenPowers(int n) {
            boolean $i$f$lock = false;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (this) {
                boolean bl3 = false;
                BigInteger[] pows = BIG_TEN_POWERS_TABLE;
                int curLen = pows.length;
                if (curLen <= n) {
                    int newLen;
                    for (newLen = curLen << 1; newLen <= n; newLen <<= 1) {
                    }
                    BigInteger[] bigIntegerArray = pows;
                    boolean bl4 = false;
                    BigInteger[] bigIntegerArray2 = Arrays.copyOf(bigIntegerArray, newLen);
                    Intrinsics.checkNotNullExpressionValue(bigIntegerArray2, "java.util.Arrays.copyOf(this, newSize)");
                    pows = bigIntegerArray2;
                    int n2 = curLen;
                    if (n2 < newLen) {
                        do {
                            int i = n2++;
                            BigInteger bigInteger = pows[i - 1];
                            Intrinsics.checkNotNull(bigInteger);
                            pows[i] = bigInteger.times(BigInteger.TEN);
                        } while (n2 < newLen);
                    }
                    BIG_TEN_POWERS_TABLE = pows;
                }
                BigInteger bigInteger = pows[n];
                Intrinsics.checkNotNull(bigInteger);
                BigInteger bigInteger2 = bigInteger;
                return bigInteger2;
            }
        }

        private final long longMultiplyPowerTen(long val, int n) {
            if (val == 0L || n <= 0) {
                return val;
            }
            long[] tab = LONG_TEN_POWERS_TABLE;
            long[] bounds = THRESHOLDS_TABLE;
            if (n < tab.length && n < bounds.length) {
                long tenpower = tab[n];
                if (val == 1L) {
                    return tenpower;
                }
                boolean bl = false;
                if (Math.abs(val) <= bounds[n]) {
                    return val * tenpower;
                }
            }
            return Long.MIN_VALUE;
        }

        private final void matchScale(BigDecimal[] val) {
            if (val[0]._scale < val[1]._scale) {
                val[0] = val[0].setScale(val[1]._scale, 7);
            } else if (val[1]._scale < val[0]._scale) {
                val[1] = val[1].setScale(val[0]._scale, 7);
            }
        }

        public final int longDigitLength$kt_math(long x) {
            long[] tab;
            long x2 = x;
            boolean bl = x2 != Long.MIN_VALUE;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            if (x2 < 0L) {
                x2 = -x2;
            }
            if (x2 < 10L) {
                return 1;
            }
            int r = (64 - Utils.numberOfLeadingZeros(x2) + 1) * 1233 >>> 12;
            return r >= (tab = LONG_TEN_POWERS_TABLE).length || x2 < tab[r] ? r : r + 1;
        }

        private final int bigDigitLength(BigInteger b) {
            if (b.get_signum$kt_math() == 0) {
                return 1;
            }
            int r = (int)(((long)b.getBitLength() + 1L) * (long)646456993 >>> 31);
            return b.compareMagnitude$kt_math(this.bigTenToThe(r)) < 0 ? r : r + 1;
        }

        private final long compactValFor(BigInteger b) {
            int[] m = b.get_mag$kt_math();
            int len = m.length;
            if (len == 0) {
                return 0L;
            }
            int d = m[0];
            if (len > 2 || len == 2 && d < 0) {
                return Long.MIN_VALUE;
            }
            long u = len == 2 ? ((long)m[1] & 0xFFFFFFFFL) + ((long)d << 32) : (long)d & 0xFFFFFFFFL;
            return b.get_signum$kt_math() < 0 ? -u : u;
        }

        private final int longCompareMagnitude(long x, long y) {
            long x2 = x;
            long y2 = y;
            if (x2 < 0L) {
                x2 = -x2;
            }
            if (y2 < 0L) {
                y2 = -y2;
            }
            return x2 < y2 ? -1 : (x2 == y2 ? 0 : 1);
        }

        private final int saturateLong(long s) {
            int i = (int)s;
            return s == (long)i ? i : (s < 0L ? Integer.MIN_VALUE : Integer.MAX_VALUE);
        }

        private final void print(String name, BigDecimal bd) {
            String string2 = name + ":\t_intCompact " + bd._intCompact + "\t_intVal " + bd._intVal + "\t_scale " + bd._scale + "\t_precision " + bd._precision;
            boolean bl = false;
            System.out.println((Object)string2);
        }

        private final int checkScaleNonZero(long val) {
            int asInt = (int)val;
            if ((long)asInt != val) {
                throw new ArithmeticException(asInt > 0 ? "Underflow" : "Overflow");
            }
            return asInt;
        }

        private final int checkScale(long intCompact, long val) {
            int asInt = (int)val;
            if ((long)asInt != val) {
                int n = asInt = val > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                if (intCompact != 0L) {
                    throw new ArithmeticException(asInt > 0 ? "Underflow" : "Overflow");
                }
            }
            return asInt;
        }

        private final int checkScale(BigInteger intVal, long val) {
            int asInt = (int)val;
            if ((long)asInt != val) {
                asInt = val > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                BigInteger bigInteger = intVal;
                Intrinsics.checkNotNull(bigInteger);
                if (bigInteger.getSignum() != 0) {
                    throw new ArithmeticException(asInt > 0 ? "Underflow" : "Overflow");
                }
            }
            return asInt;
        }

        private final BigDecimal doRound(BigDecimal val, MathContext mc) {
            int mcp = mc.getPrecision();
            boolean wasDivided = false;
            if (mcp > 0) {
                BigDecimal bigDecimal = val;
                Intrinsics.checkNotNull(bigDecimal);
                BigInteger intVal = bigDecimal._intVal;
                long compactVal = val._intCompact;
                int scale = val._scale;
                int prec = val.getPrecision();
                int mode = mc.getRoundingMode().getOldMode$kt_math();
                int drop = 0;
                if (compactVal == Long.MIN_VALUE) {
                    drop = prec - mcp;
                    while (drop > 0) {
                        scale = this.checkScaleNonZero((long)scale - (long)drop);
                        BigInteger bigInteger = intVal;
                        Intrinsics.checkNotNull(bigInteger);
                        intVal = this.divideAndRoundByTenPow(bigInteger, drop, mode);
                        wasDivided = true;
                        compactVal = this.compactValFor(intVal);
                        if (compactVal != Long.MIN_VALUE) {
                            prec = this.longDigitLength$kt_math(compactVal);
                            break;
                        }
                        prec = this.bigDigitLength(intVal);
                        drop = prec - mcp;
                    }
                }
                if (compactVal != Long.MIN_VALUE) {
                    drop = prec - mcp;
                    while (drop > 0) {
                        scale = this.checkScaleNonZero((long)scale - (long)drop);
                        compactVal = this.divideAndRound(compactVal, LONG_TEN_POWERS_TABLE[drop], mc.getRoundingMode().getOldMode$kt_math());
                        wasDivided = true;
                        prec = this.longDigitLength$kt_math(compactVal);
                        drop = prec - mcp;
                        intVal = null;
                    }
                }
                return wasDivided ? new BigDecimal(intVal, compactVal, scale, prec) : val;
            }
            return val;
        }

        private final BigDecimal doRound(long compactVal, int scale, MathContext mc) {
            long compactVal2 = compactVal;
            int scale2 = scale;
            int mcp = mc.getPrecision();
            if (mcp > 0 && mcp < 19) {
                int prec = this.longDigitLength$kt_math(compactVal2);
                int drop = prec - mcp;
                while (drop > 0) {
                    scale2 = this.checkScaleNonZero((long)scale2 - (long)drop);
                    compactVal2 = this.divideAndRound(compactVal2, LONG_TEN_POWERS_TABLE[drop], mc.getRoundingMode().getOldMode$kt_math());
                    prec = this.longDigitLength$kt_math(compactVal2);
                    drop = prec - mcp;
                }
                return this.of(compactVal2, scale2, prec);
            }
            return this.of(compactVal2, scale2);
        }

        private final BigDecimal doRound(BigInteger intVal, int scale, MathContext mc) {
            BigInteger intVal2 = intVal;
            int scale2 = scale;
            int mcp = mc.getPrecision();
            int prec = 0;
            if (mcp > 0) {
                long compactVal = this.compactValFor(intVal2);
                int mode = mc.getRoundingMode().getOldMode$kt_math();
                int drop = 0;
                if (compactVal == Long.MIN_VALUE) {
                    prec = this.bigDigitLength(intVal2);
                    drop = prec - mcp;
                    while (drop > 0) {
                        scale2 = this.checkScaleNonZero((long)scale2 - (long)drop);
                        compactVal = this.compactValFor(intVal2 = this.divideAndRoundByTenPow(intVal2, drop, mode));
                        if (compactVal != Long.MIN_VALUE) break;
                        prec = this.bigDigitLength(intVal2);
                        drop = prec - mcp;
                    }
                }
                if (compactVal != Long.MIN_VALUE) {
                    prec = this.longDigitLength$kt_math(compactVal);
                    drop = prec - mcp;
                    while (drop > 0) {
                        scale2 = this.checkScaleNonZero((long)scale2 - (long)drop);
                        compactVal = this.divideAndRound(compactVal, LONG_TEN_POWERS_TABLE[drop], mc.getRoundingMode().getOldMode$kt_math());
                        prec = this.longDigitLength$kt_math(compactVal);
                        drop = prec - mcp;
                    }
                    return this.of(compactVal, scale2, prec);
                }
            }
            return new BigDecimal(intVal2, Long.MIN_VALUE, scale2, prec);
        }

        private final BigInteger divideAndRoundByTenPow(BigInteger intVal, int tenPow, int roundingMode2) {
            BigInteger intVal2 = intVal;
            intVal2 = tenPow < LONG_TEN_POWERS_TABLE.length ? this.divideAndRound(intVal2, LONG_TEN_POWERS_TABLE[tenPow], roundingMode2) : this.divideAndRound(intVal2, this.bigTenToThe(tenPow), roundingMode2);
            return intVal2;
        }

        private final BigDecimal divideAndRound(long ldividend, long ldivisor, int scale, int roundingMode2, int preferredScale) {
            int qsign = 0;
            long q = ldividend / ldivisor;
            if (roundingMode2 == 1 && scale == preferredScale) {
                return this.of(q, scale);
            }
            long r = ldividend % ldivisor;
            int n = qsign = ldividend < 0L == ldivisor < 0L ? 1 : -1;
            if (r != 0L) {
                boolean increment = this.needIncrement(ldivisor, roundingMode2, qsign, q, r);
                return this.of(increment ? q + (long)qsign : q, scale);
            }
            return preferredScale != scale ? this.createAndStripZerosToMatchScale(q, scale, (long)preferredScale) : this.of(q, scale);
        }

        private final long divideAndRound(long ldividend, long ldivisor, int roundingMode2) {
            int qsign = 0;
            long q = ldividend / ldivisor;
            if (roundingMode2 == 1) {
                return q;
            }
            long r = ldividend % ldivisor;
            int n = qsign = ldividend < 0L == ldivisor < 0L ? 1 : -1;
            if (r != 0L) {
                boolean increment = this.needIncrement(ldivisor, roundingMode2, qsign, q, r);
                return increment ? q + (long)qsign : q;
            }
            return q;
        }

        private final boolean commonNeedIncrement(int roundingMode2, int qsign, int cmpFracHalf, boolean oddQuot) {
            int n = roundingMode2;
            switch (n) {
                case 7: {
                    throw new ArithmeticException("Rounding necessary");
                }
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return qsign > 0;
                }
                case 3: {
                    return qsign < 0;
                }
            }
            int n2 = roundingMode2 >= 4 && roundingMode2 <= 6 ? 1 : 0;
            boolean bl = false;
            boolean bl2 = false;
            if (n2 == 0) {
                boolean bl3 = false;
                String string2 = Intrinsics.stringPlus("Unexpected rounding mode", (Object)RoundingMode.Companion.valueOf(roundingMode2));
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            if (cmpFracHalf < 0) {
                return false;
            }
            if (cmpFracHalf > 0) {
                return true;
            }
            n2 = cmpFracHalf == 0 ? 1 : 0;
            bl = false;
            bl2 = false;
            bl2 = false;
            boolean bl4 = false;
            if (n2 == 0) {
                boolean bl5 = false;
                String string3 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            n2 = roundingMode2;
            switch (n2) {
                case 5: {
                    return false;
                }
                case 4: {
                    return true;
                }
                case 6: {
                    return oddQuot;
                }
            }
            throw new AssertionError((Object)Intrinsics.stringPlus("Unexpected rounding mode", roundingMode2));
        }

        private final boolean needIncrement(long ldivisor, int roundingMode2, int qsign, long q, long r) {
            boolean bl = r != 0L;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            int cmpFracHalf = 0;
            cmpFracHalf = r <= -4611686018427387904L || r > 0x3FFFFFFFFFFFFFFFL ? 1 : this.longCompareMagnitude((long)2 * r, ldivisor);
            return this.commonNeedIncrement(roundingMode2, qsign, cmpFracHalf, (q & 1L) != 0L);
        }

        private final BigInteger divideAndRound(BigInteger bdividend, long ldivisor, int roundingMode2) {
            int qsign;
            MutableBigInteger mq;
            MutableBigInteger mdividend = new MutableBigInteger(bdividend.get_mag$kt_math());
            long r = mdividend.divide(ldivisor, mq = new MutableBigInteger());
            boolean isRemainderZero = r == 0L;
            int n = qsign = ldivisor < 0L ? -bdividend.get_signum$kt_math() : bdividend.get_signum$kt_math();
            if (!isRemainderZero && this.needIncrement(ldivisor, roundingMode2, qsign, mq, r)) {
                mq.add(MutableBigInteger.Companion.getONE());
            }
            return mq.toBigInteger(qsign);
        }

        private final BigDecimal divideAndRound(BigInteger bdividend, long ldivisor, int scale, int roundingMode2, int preferredScale) {
            int qsign;
            MutableBigInteger mq;
            MutableBigInteger mdividend = new MutableBigInteger(bdividend.get_mag$kt_math());
            long r = mdividend.divide(ldivisor, mq = new MutableBigInteger());
            boolean isRemainderZero = r == 0L;
            int n = qsign = ldivisor < 0L ? -bdividend.get_signum$kt_math() : bdividend.get_signum$kt_math();
            if (!isRemainderZero) {
                if (this.needIncrement(ldivisor, roundingMode2, qsign, mq, r)) {
                    mq.add(MutableBigInteger.Companion.getONE());
                }
                return mq.toBigDecimal(qsign, scale);
            }
            if (preferredScale != scale) {
                long compactVal = mq.toCompactValue(qsign);
                if (compactVal != Long.MIN_VALUE) {
                    return this.createAndStripZerosToMatchScale(compactVal, scale, (long)preferredScale);
                }
                BigInteger intVal = mq.toBigInteger(qsign);
                return this.createAndStripZerosToMatchScale(intVal, scale, (long)preferredScale);
            }
            return mq.toBigDecimal(qsign, scale);
        }

        private final boolean needIncrement(long ldivisor, int roundingMode2, int qsign, MutableBigInteger mq, long r) {
            boolean bl = r != 0L;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            int cmpFracHalf = 0;
            cmpFracHalf = r <= -4611686018427387904L || r > 0x3FFFFFFFFFFFFFFFL ? 1 : this.longCompareMagnitude((long)2 * r, ldivisor);
            return this.commonNeedIncrement(roundingMode2, qsign, cmpFracHalf, mq.isOdd());
        }

        private final BigInteger divideAndRound(BigInteger bdividend, BigInteger bdivisor, int roundingMode2) {
            MutableBigInteger mr;
            boolean isRemainderZero = false;
            int qsign = 0;
            MutableBigInteger mdividend = new MutableBigInteger(bdividend.get_mag$kt_math());
            MutableBigInteger mq = new MutableBigInteger();
            MutableBigInteger mdivisor = new MutableBigInteger(bdivisor.get_mag$kt_math());
            MutableBigInteger mutableBigInteger = mr = MutableBigInteger.divide$default(mdividend, mdivisor, mq, false, 4, null);
            Intrinsics.checkNotNull(mutableBigInteger);
            isRemainderZero = mutableBigInteger.isZero();
            int n = qsign = bdividend.get_signum$kt_math() != bdivisor.get_signum$kt_math() ? -1 : 1;
            if (!isRemainderZero && this.needIncrement(mdivisor, roundingMode2, qsign, mq, mr)) {
                mq.add(MutableBigInteger.Companion.getONE());
            }
            return mq.toBigInteger(qsign);
        }

        private final BigDecimal divideAndRound(BigInteger bdividend, BigInteger bdivisor, int scale, int roundingMode2, int preferredScale) {
            MutableBigInteger mr;
            boolean isRemainderZero = false;
            int qsign = 0;
            MutableBigInteger mdividend = new MutableBigInteger(bdividend.get_mag$kt_math());
            MutableBigInteger mq = new MutableBigInteger();
            MutableBigInteger mdivisor = new MutableBigInteger(bdivisor.get_mag$kt_math());
            MutableBigInteger mutableBigInteger = mr = MutableBigInteger.divide$default(mdividend, mdivisor, mq, false, 4, null);
            Intrinsics.checkNotNull(mutableBigInteger);
            isRemainderZero = mutableBigInteger.isZero();
            int n = qsign = bdividend.get_signum$kt_math() != bdivisor.get_signum$kt_math() ? -1 : 1;
            if (!isRemainderZero) {
                if (this.needIncrement(mdivisor, roundingMode2, qsign, mq, mr)) {
                    mq.add(MutableBigInteger.Companion.getONE());
                }
                return mq.toBigDecimal(qsign, scale);
            }
            if (preferredScale != scale) {
                long compactVal = mq.toCompactValue(qsign);
                if (compactVal != Long.MIN_VALUE) {
                    return this.createAndStripZerosToMatchScale(compactVal, scale, (long)preferredScale);
                }
                BigInteger intVal = mq.toBigInteger(qsign);
                return this.createAndStripZerosToMatchScale(intVal, scale, (long)preferredScale);
            }
            return mq.toBigDecimal(qsign, scale);
        }

        private final boolean needIncrement(MutableBigInteger mdivisor, int roundingMode2, int qsign, MutableBigInteger mq, MutableBigInteger mr) {
            boolean bl = !mr.isZero();
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            int cmpFracHalf = mr.compareHalf(mdivisor);
            return this.commonNeedIncrement(roundingMode2, qsign, cmpFracHalf, mq.isOdd());
        }

        private final BigDecimal createAndStripZerosToMatchScale(BigInteger intVal, int scale, long preferredScale) {
            BigInteger intVal2 = intVal;
            int scale2 = scale;
            BigInteger[] qr = null;
            while (intVal2.compareMagnitude$kt_math(BigInteger.TEN) >= 0 && (long)scale2 > preferredScale && !intVal2.testBit(0) && (qr = intVal2.divideAndRemainder(BigInteger.TEN))[1].getSignum() == 0) {
                intVal2 = qr[0];
                scale2 = this.checkScale(intVal2, (long)scale2 - 1L);
            }
            return this.of(intVal2, scale2, 0);
        }

        private final BigDecimal createAndStripZerosToMatchScale(long compactVal, int scale, long preferredScale) {
            long compactVal2 = compactVal;
            int scale2 = scale;
            while (true) {
                long r;
                boolean bl = false;
                if (Math.abs(compactVal2) < 10L || (long)scale2 <= preferredScale || (compactVal2 & 1L) != 0L || (r = compactVal2 % 10L) != 0L) break;
                scale2 = this.checkScale(compactVal2 /= (long)10, (long)scale2 - 1L);
            }
            return this.of(compactVal2, scale2);
        }

        private final BigDecimal stripZerosToMatchScale(BigInteger intVal, long intCompact, int scale, int preferredScale) {
            BigInteger bigInteger;
            return intCompact != Long.MIN_VALUE ? this.createAndStripZerosToMatchScale(intCompact, scale, (long)preferredScale) : this.createAndStripZerosToMatchScale((bigInteger = intVal) == null ? INFLATED_BIGINT : bigInteger, scale, (long)preferredScale);
        }

        private final long sum(long xs, long ys) {
            long sum = xs + ys;
            return ((sum ^ xs) & (sum ^ ys)) >= 0L ? sum : Long.MIN_VALUE;
        }

        private final BigDecimal sum(long xs, long ys, int scale) {
            long sum = this.sum(xs, ys);
            return sum != Long.MIN_VALUE ? Companion.of(sum, scale) : new BigDecimal(BigInteger.Companion.of(xs).plusLong$kt_math(ys), scale);
        }

        private final BigDecimal sum(long xs, int scale1, long ys, int scale2) {
            long sdiff = (long)scale1 - (long)scale2;
            if (sdiff == 0L) {
                return this.sum(xs, ys, scale1);
            }
            if (sdiff < 0L) {
                int raise = this.checkScale(xs, -sdiff);
                long scaledX = this.longMultiplyPowerTen(xs, raise);
                if (scaledX != Long.MIN_VALUE) {
                    return this.sum(scaledX, ys, scale2);
                }
                BigInteger bigsum = this.bigMultiplyPowerTen(xs, raise).plusLong$kt_math(ys);
                return (xs ^ ys) >= 0L ? new BigDecimal(bigsum, Long.MIN_VALUE, scale2, 0) : this.of(bigsum, scale2, 0);
            }
            int raise = this.checkScale(ys, sdiff);
            long scaledY = this.longMultiplyPowerTen(ys, raise);
            if (scaledY != Long.MIN_VALUE) {
                return this.sum(xs, scaledY, scale1);
            }
            BigInteger bigsum = this.bigMultiplyPowerTen(ys, raise).plusLong$kt_math(xs);
            return (xs ^ ys) >= 0L ? new BigDecimal(bigsum, Long.MIN_VALUE, scale1, 0) : this.of(bigsum, scale1, 0);
        }

        private final BigDecimal sum(long xs, int scale1, BigInteger snd, int scale2) {
            BigInteger snd2 = snd;
            int rscale = scale1;
            long sdiff = (long)rscale - (long)scale2;
            boolean sameSigns = MathKt.getSign(xs) == snd2.get_signum$kt_math();
            BigInteger sum = null;
            if (sdiff < 0L) {
                int raise = this.checkScale(xs, -sdiff);
                rscale = scale2;
                long scaledX = this.longMultiplyPowerTen(xs, raise);
                sum = scaledX == Long.MIN_VALUE ? snd2.plus(this.bigMultiplyPowerTen(xs, raise)) : snd2.plusLong$kt_math(scaledX);
            } else {
                int raise = this.checkScale(snd2, sdiff);
                BigInteger bigInteger = this.bigMultiplyPowerTen(snd2, raise);
                Intrinsics.checkNotNull(bigInteger);
                snd2 = bigInteger;
                sum = snd2.plusLong$kt_math(xs);
            }
            return sameSigns ? new BigDecimal(sum, Long.MIN_VALUE, rscale, 0) : this.of(sum, rscale, 0);
        }

        private final BigDecimal sum(BigInteger fst, int scale1, BigInteger snd, int scale2) {
            BigInteger fst2 = fst;
            BigInteger snd2 = snd;
            int rscale = scale1;
            long sdiff = (long)rscale - (long)scale2;
            if (sdiff != 0L) {
                int raise;
                if (sdiff < 0L) {
                    raise = this.checkScale(fst2, -sdiff);
                    rscale = scale2;
                    fst2 = this.bigMultiplyPowerTen(fst2, raise);
                } else {
                    raise = this.checkScale(snd2, sdiff);
                    snd2 = this.bigMultiplyPowerTen(snd2, raise);
                }
            }
            BigInteger bigInteger = fst2;
            Intrinsics.checkNotNull(bigInteger);
            BigInteger bigInteger2 = snd2;
            Intrinsics.checkNotNull(bigInteger2);
            BigInteger sum = bigInteger.plus(bigInteger2);
            return fst2.get_signum$kt_math() == snd2.get_signum$kt_math() ? new BigDecimal(sum, Long.MIN_VALUE, rscale, 0) : this.of(sum, rscale, 0);
        }

        private final BigInteger bigMultiplyPowerTen(long value, int n) {
            return n <= 0 ? BigInteger.Companion.of(value) : this.bigTenToThe(n).timesLong$kt_math(value);
        }

        private final BigInteger bigMultiplyPowerTen(BigInteger value, int n) {
            BigInteger bigInteger;
            if (n <= 0) {
                return value;
            }
            if (n < LONG_TEN_POWERS_TABLE.length) {
                BigInteger bigInteger2 = value;
                Intrinsics.checkNotNull(bigInteger2);
                bigInteger = bigInteger2.timesLong$kt_math(LONG_TEN_POWERS_TABLE[n]);
            } else {
                BigInteger bigInteger3 = value;
                Intrinsics.checkNotNull(bigInteger3);
                bigInteger = bigInteger3.times(this.bigTenToThe(n));
            }
            return bigInteger;
        }

        private final BigDecimal divideSmallFastPath(long xs, int xscale, long ys, int yscale, long preferredScale, MathContext mc) {
            int yscale2 = yscale;
            int mcp = mc.getPrecision();
            int roundingMode2 = mc.getRoundingMode().getOldMode$kt_math();
            boolean bl = xscale <= yscale2 && yscale2 < 18 && mcp < 18;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            int xraise = yscale2 - xscale;
            long scaledX = xraise == 0 ? xs : this.longMultiplyPowerTen(xs, xraise);
            BigDecimal quotient = null;
            int cmp = this.longCompareMagnitude(scaledX, ys);
            if (cmp > 0) {
                int scl = this.checkScaleNonZero(preferredScale + (long)(--yscale2) - (long)xscale + (long)mcp);
                if (this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale) > 0) {
                    int raise = this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale);
                    long scaledXs = 0L;
                    scaledXs = this.longMultiplyPowerTen(xs, raise);
                    if (scaledXs == Long.MIN_VALUE) {
                        quotient = null;
                        if (mcp - 1 >= 0 && mcp - 1 < LONG_TEN_POWERS_TABLE.length) {
                            quotient = this.multiplyDivideAndRound(LONG_TEN_POWERS_TABLE[mcp - 1], scaledX, ys, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
                        }
                        if (quotient == null) {
                            BigInteger rb = this.bigMultiplyPowerTen(scaledX, mcp - 1);
                            quotient = this.divideAndRound(rb, ys, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
                        }
                    } else {
                        quotient = this.divideAndRound(scaledXs, ys, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
                    }
                } else {
                    int newScale = this.checkScaleNonZero((long)xscale - (long)mcp);
                    if (newScale == yscale2) {
                        quotient = this.divideAndRound(xs, ys, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
                    } else {
                        int raise = this.checkScaleNonZero((long)newScale - (long)yscale2);
                        long scaledYs = this.longMultiplyPowerTen(ys, raise);
                        if (scaledYs == Long.MIN_VALUE) {
                            BigInteger rb = this.bigMultiplyPowerTen(ys, raise);
                            quotient = this.divideAndRound(BigInteger.Companion.of(xs), rb, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
                        } else {
                            quotient = this.divideAndRound(xs, scaledYs, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
                        }
                    }
                }
            } else {
                int scl = this.checkScaleNonZero(preferredScale + (long)yscale2 - (long)xscale + (long)mcp);
                if (cmp == 0) {
                    quotient = this.roundedTenPower(scaledX < 0L == ys < 0L ? 1 : -1, mcp, scl, this.checkScaleNonZero(preferredScale));
                } else {
                    long scaledXs = this.longMultiplyPowerTen(scaledX, mcp);
                    if (scaledXs == Long.MIN_VALUE) {
                        quotient = null;
                        if (mcp < LONG_TEN_POWERS_TABLE.length) {
                            quotient = this.multiplyDivideAndRound(LONG_TEN_POWERS_TABLE[mcp], scaledX, ys, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
                        }
                        if (quotient == null) {
                            BigInteger rb = this.bigMultiplyPowerTen(scaledX, mcp);
                            quotient = this.divideAndRound(rb, ys, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
                        }
                    } else {
                        quotient = this.divideAndRound(scaledXs, ys, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
                    }
                }
            }
            return this.doRound(quotient, mc);
        }

        private final BigDecimal divide(long xs, int xscale, long ys, int yscale, long preferredScale, MathContext mc) {
            int yscale2 = yscale;
            int mcp = mc.getPrecision();
            if (xscale <= yscale2 && yscale2 < 18 && mcp < 18) {
                return this.divideSmallFastPath(xs, xscale, ys, yscale2, preferredScale, mc);
            }
            if (this.compareMagnitudeNormalized(xs, xscale, ys, yscale2) > 0) {
                --yscale2;
            }
            int roundingMode2 = mc.getRoundingMode().getOldMode$kt_math();
            int scl = this.checkScaleNonZero(preferredScale + (long)yscale2 - (long)xscale + (long)mcp);
            BigDecimal quotient = null;
            if (this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale) > 0) {
                int raise = this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale);
                long scaledXs = this.longMultiplyPowerTen(xs, raise);
                if (scaledXs == Long.MIN_VALUE) {
                    BigInteger rb = this.bigMultiplyPowerTen(xs, raise);
                    quotient = this.divideAndRound(rb, ys, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
                } else {
                    quotient = this.divideAndRound(scaledXs, ys, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
                }
            } else {
                int newScale = this.checkScaleNonZero((long)xscale - (long)mcp);
                if (newScale == yscale2) {
                    quotient = this.divideAndRound(xs, ys, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
                } else {
                    int raise = this.checkScaleNonZero((long)newScale - (long)yscale2);
                    long scaledYs = this.longMultiplyPowerTen(ys, raise);
                    if (scaledYs == Long.MIN_VALUE) {
                        BigInteger rb = this.bigMultiplyPowerTen(ys, raise);
                        quotient = this.divideAndRound(BigInteger.Companion.of(xs), rb, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
                    } else {
                        quotient = this.divideAndRound(xs, scaledYs, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
                    }
                }
            }
            return this.doRound(quotient, mc);
        }

        private final BigDecimal divide(BigInteger xs, int xscale, long ys, int yscale, long preferredScale, MathContext mc) {
            int yscale2 = yscale;
            if (-this.compareMagnitudeNormalized(ys, yscale2, xs, xscale) > 0) {
                --yscale2;
            }
            int mcp = mc.getPrecision();
            int roundingMode2 = mc.getRoundingMode().getOldMode$kt_math();
            BigDecimal quotient = null;
            int scl = this.checkScaleNonZero(preferredScale + (long)yscale2 - (long)xscale + (long)mcp);
            if (this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale) > 0) {
                BigInteger rb;
                int raise = this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale);
                BigInteger bigInteger = rb = this.bigMultiplyPowerTen(xs, raise);
                Intrinsics.checkNotNull(bigInteger);
                quotient = this.divideAndRound(bigInteger, ys, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
            } else {
                int newScale = this.checkScaleNonZero((long)xscale - (long)mcp);
                if (newScale == yscale2) {
                    BigInteger bigInteger = xs;
                    Intrinsics.checkNotNull(bigInteger);
                    quotient = this.divideAndRound(bigInteger, ys, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
                } else {
                    int raise = this.checkScaleNonZero((long)newScale - (long)yscale2);
                    long scaledYs = this.longMultiplyPowerTen(ys, raise);
                    if (scaledYs == Long.MIN_VALUE) {
                        BigInteger rb = this.bigMultiplyPowerTen(ys, raise);
                        BigInteger bigInteger = xs;
                        Intrinsics.checkNotNull(bigInteger);
                        quotient = this.divideAndRound(bigInteger, rb, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
                    } else {
                        BigInteger bigInteger = xs;
                        Intrinsics.checkNotNull(bigInteger);
                        quotient = this.divideAndRound(bigInteger, scaledYs, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
                    }
                }
            }
            return this.doRound(quotient, mc);
        }

        private final BigDecimal divide(long xs, int xscale, BigInteger ys, int yscale, long preferredScale, MathContext mc) {
            int yscale2 = yscale;
            if (this.compareMagnitudeNormalized(xs, xscale, ys, yscale2) > 0) {
                --yscale2;
            }
            int mcp = mc.getPrecision();
            RoundingMode roundingMode2 = mc.getRoundingMode();
            boolean bl = false;
            boolean bl2 = false;
            RoundingMode it = roundingMode2;
            boolean bl3 = false;
            Utils.log((Function0<? extends Object>)new Function0<Object>(it){
                final /* synthetic */ RoundingMode $it;
                {
                    this.$it = $it;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return this.$it;
                }
            });
            int roundingMode3 = roundingMode2.getOldMode$kt_math();
            BigDecimal quotient = null;
            int scl = this.checkScaleNonZero(preferredScale + (long)yscale2 - (long)xscale + (long)mcp);
            if (this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale) > 0) {
                int raise = this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale);
                BigInteger rb = this.bigMultiplyPowerTen(xs, raise);
                BigInteger bigInteger = ys;
                Intrinsics.checkNotNull(bigInteger);
                quotient = this.divideAndRound(rb, bigInteger, scl, roundingMode3, this.checkScaleNonZero(preferredScale));
            } else {
                int newScale = this.checkScaleNonZero((long)xscale - (long)mcp);
                int raise = this.checkScaleNonZero((long)newScale - (long)yscale2);
                BigInteger rb = this.bigMultiplyPowerTen(ys, raise);
                BigInteger bigInteger = BigInteger.Companion.of(xs);
                BigInteger bigInteger2 = rb;
                Intrinsics.checkNotNull(bigInteger2);
                quotient = this.divideAndRound(bigInteger, bigInteger2, scl, roundingMode3, this.checkScaleNonZero(preferredScale));
            }
            return this.doRound(quotient, mc);
        }

        private final BigDecimal divide(BigInteger xs, int xscale, BigInteger ys, int yscale, long preferredScale, MathContext mc) {
            int yscale2 = yscale;
            if (this.compareMagnitudeNormalized(xs, xscale, ys, yscale2) > 0) {
                --yscale2;
            }
            int mcp = mc.getPrecision();
            int roundingMode2 = mc.getRoundingMode().getOldMode$kt_math();
            BigDecimal quotient = null;
            int scl = this.checkScaleNonZero(preferredScale + (long)yscale2 - (long)xscale + (long)mcp);
            if (this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale) > 0) {
                BigInteger rb;
                int raise = this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale);
                BigInteger bigInteger = rb = this.bigMultiplyPowerTen(xs, raise);
                Intrinsics.checkNotNull(bigInteger);
                BigInteger bigInteger2 = ys;
                Intrinsics.checkNotNull(bigInteger2);
                quotient = this.divideAndRound(bigInteger, bigInteger2, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
            } else {
                int newScale = this.checkScaleNonZero((long)xscale - (long)mcp);
                int raise = this.checkScaleNonZero((long)newScale - (long)yscale2);
                BigInteger rb = this.bigMultiplyPowerTen(ys, raise);
                BigInteger bigInteger = xs;
                Intrinsics.checkNotNull(bigInteger);
                BigInteger bigInteger3 = rb;
                Intrinsics.checkNotNull(bigInteger3);
                quotient = this.divideAndRound(bigInteger, bigInteger3, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
            }
            return this.doRound(quotient, mc);
        }

        private final BigDecimal multiplyDivideAndRound(long dividend0, long dividend1, long divisor, int scale, int roundingMode2, int preferredScale) {
            long dividend02 = dividend0;
            long dividend12 = dividend1;
            long divisor2 = divisor;
            int qsign = MathKt.getSign(dividend02) * MathKt.getSign(dividend12) * MathKt.getSign(divisor2);
            boolean bl = false;
            dividend02 = Math.abs(dividend02);
            bl = false;
            dividend12 = Math.abs(dividend12);
            bl = false;
            divisor2 = Math.abs(divisor2);
            long d0_hi = dividend02 >>> 32;
            long d0_lo = dividend02 & 0xFFFFFFFFL;
            long d1_hi = dividend12 >>> 32;
            long d1_lo = dividend12 & 0xFFFFFFFFL;
            long product2 = d0_lo * d1_lo;
            long d0 = product2 & 0xFFFFFFFFL;
            long d1 = product2 >>> 32;
            product2 = d0_hi * d1_lo + d1;
            d1 = product2 & 0xFFFFFFFFL;
            long d2 = product2 >>> 32;
            product2 = d0_lo * d1_hi + d1;
            d1 = product2 & 0xFFFFFFFFL;
            long d3 = (d2 += product2 >>> 32) >>> 32;
            product2 = d0_hi * d1_hi + (d2 &= 0xFFFFFFFFL);
            d2 = product2 & 0xFFFFFFFFL;
            d3 = (product2 >>> 32) + d3 & 0xFFFFFFFFL;
            long dividendHi = this.make64(d3, d2);
            long dividendLo = this.make64(d1, d0);
            return this.divideAndRound128(dividendHi, dividendLo, divisor2, qsign, scale, roundingMode2, preferredScale);
        }

        private final BigDecimal divideAndRound128(long dividendHi, long dividendLo, long divisor, int sign, int scale, int roundingMode2, int preferredScale) {
            long divisor2 = divisor;
            if (dividendHi >= divisor2) {
                return null;
            }
            int shift = Utils.numberOfLeadingZeros(divisor2);
            long v1 = (divisor2 <<= shift) >>> 32;
            long v0 = divisor2 & 0xFFFFFFFFL;
            long tmp = dividendLo << shift;
            long u1 = tmp >>> 32;
            long u0 = tmp & 0xFFFFFFFFL;
            tmp = dividendHi << shift | dividendLo >>> 64 - shift;
            long u2 = tmp & 0xFFFFFFFFL;
            long q1 = 0L;
            long r_tmp = 0L;
            if (v1 == 1L) {
                q1 = tmp;
                r_tmp = 0L;
            } else if (tmp >= 0L) {
                q1 = tmp / v1;
                r_tmp = tmp - q1 * v1;
            } else {
                long[] rq = this.divRemNegativeLong(tmp, v1);
                q1 = rq[1];
                r_tmp = rq[0];
            }
            while (q1 >= 0x100000000L || this.unsignedLongCompare(q1 * v0, this.make64(r_tmp, u1))) {
                long rq = q1;
                q1 = rq + -1L;
                if ((r_tmp += v1) < 0x100000000L) continue;
            }
            tmp = this.mulsub(u2, u1, v1, v0, q1);
            u1 = tmp & 0xFFFFFFFFL;
            long q0 = 0L;
            if (v1 == 1L) {
                q0 = tmp;
                r_tmp = 0L;
            } else if (tmp >= 0L) {
                q0 = tmp / v1;
                r_tmp = tmp - q0 * v1;
            } else {
                long[] rq = this.divRemNegativeLong(tmp, v1);
                q0 = rq[1];
                r_tmp = rq[0];
            }
            while (q0 >= 0x100000000L || this.unsignedLongCompare(q0 * v0, this.make64(r_tmp, u0))) {
                long rq = q0;
                q0 = rq + -1L;
                if ((r_tmp += v1) < 0x100000000L) continue;
            }
            if ((int)q1 < 0) {
                int[] nArray = new int[]{(int)q1, (int)q0};
                MutableBigInteger mq = new MutableBigInteger(nArray);
                if (roundingMode2 == 1 && scale == preferredScale) {
                    return mq.toBigDecimal(sign, scale);
                }
                long r = this.mulsub(u1, u0, v1, v0, q0) >>> shift;
                if (r != 0L) {
                    if (this.needIncrement(divisor2 >>> shift, roundingMode2, sign, mq, r)) {
                        mq.add(MutableBigInteger.Companion.getONE());
                    }
                    return mq.toBigDecimal(sign, scale);
                }
                if (preferredScale != scale) {
                    BigInteger intVal = mq.toBigInteger(sign);
                    return this.createAndStripZerosToMatchScale(intVal, scale, (long)preferredScale);
                }
                return mq.toBigDecimal(sign, scale);
            }
            long q = this.make64(q1, q0);
            q *= (long)sign;
            if (roundingMode2 == 1 && scale == preferredScale) {
                return this.of(q, scale);
            }
            long r = this.mulsub(u1, u0, v1, v0, q0) >>> shift;
            if (r != 0L) {
                boolean increment = this.needIncrement(divisor2 >>> shift, roundingMode2, sign, q, r);
                return this.of(increment ? q + (long)sign : q, scale);
            }
            return preferredScale != scale ? this.createAndStripZerosToMatchScale(q, scale, (long)preferredScale) : this.of(q, scale);
        }

        private final BigDecimal roundedTenPower(int qsign, int raise, int scale, int preferredScale) {
            if (scale > preferredScale) {
                int diff = scale - preferredScale;
                return diff < raise ? this.scaledTenPow$kt_math(raise - diff, qsign, preferredScale) : this.of((long)qsign, scale - raise);
            }
            return this.scaledTenPow$kt_math(raise, qsign, scale);
        }

        @NotNull
        public final BigDecimal scaledTenPow$kt_math(int n, int sign, int scale) {
            if (n < LONG_TEN_POWERS_TABLE.length) {
                return this.of((long)sign * LONG_TEN_POWERS_TABLE[n], scale);
            }
            BigInteger unscaledVal = this.bigTenToThe(n);
            if (sign == -1) {
                unscaledVal = unscaledVal.unaryMinus();
            }
            return new BigDecimal(unscaledVal, Long.MIN_VALUE, scale, n + 1);
        }

        private final long[] divRemNegativeLong(long n, long d) {
            long l;
            long r;
            boolean bl = n < 0L;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string2 = Intrinsics.stringPlus("Non-negative numerator ", n);
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            bl = d != 1L;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string3 = "Unity denominator";
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            long q = (n >>> 1) / (d >>> 1);
            for (r = n - q * d; r < 0L; r += d) {
                l = q;
                q = l + -1L;
            }
            while (r >= d) {
                r -= d;
                l = q;
                q = l + 1L;
            }
            long[] lArray = new long[]{r, q};
            return lArray;
        }

        private final long make64(long hi, long lo) {
            return hi << 32 | lo;
        }

        private final long mulsub(long u1, long u0, long v1, long v0, long q0) {
            long tmp = u0 - q0 * v0;
            return this.make64(u1 + (tmp >>> 32) - q0 * v1, tmp & 0xFFFFFFFFL);
        }

        private final boolean unsignedLongCompare(long one, long two) {
            return one + Long.MIN_VALUE > two + Long.MIN_VALUE;
        }

        private final boolean unsignedLongCompareEq(long one, long two) {
            return one + Long.MIN_VALUE >= two + Long.MIN_VALUE;
        }

        private final int compareMagnitudeNormalized(long xs, int xscale, long ys, int yscale) {
            long xs2 = xs;
            long ys2 = ys;
            int sdiff = xscale - yscale;
            if (sdiff != 0) {
                if (sdiff < 0) {
                    xs2 = this.longMultiplyPowerTen(xs2, -sdiff);
                } else {
                    ys2 = this.longMultiplyPowerTen(ys2, sdiff);
                }
            }
            return xs2 != Long.MIN_VALUE ? (ys2 != Long.MIN_VALUE ? this.longCompareMagnitude(xs2, ys2) : -1) : 1;
        }

        private final int compareMagnitudeNormalized(long xs, int xscale, BigInteger ys, int yscale) {
            if (xs == 0L) {
                return -1;
            }
            int sdiff = xscale - yscale;
            if (sdiff < 0 && this.longMultiplyPowerTen(xs, -sdiff) == Long.MIN_VALUE) {
                BigInteger bigInteger = this.bigMultiplyPowerTen(xs, -sdiff);
                BigInteger bigInteger2 = ys;
                Intrinsics.checkNotNull(bigInteger2);
                return bigInteger.compareMagnitude$kt_math(bigInteger2);
            }
            return -1;
        }

        private final int compareMagnitudeNormalized(BigInteger xs, int xscale, BigInteger ys, int yscale) {
            int n;
            int sdiff = xscale - yscale;
            if (sdiff < 0) {
                BigInteger bigInteger = this.bigMultiplyPowerTen(xs, -sdiff);
                Intrinsics.checkNotNull(bigInteger);
                BigInteger bigInteger2 = ys;
                Intrinsics.checkNotNull(bigInteger2);
                n = bigInteger.compareMagnitude$kt_math(bigInteger2);
            } else {
                BigInteger bigInteger = xs;
                Intrinsics.checkNotNull(bigInteger);
                BigInteger bigInteger3 = this.bigMultiplyPowerTen(ys, sdiff);
                Intrinsics.checkNotNull(bigInteger3);
                n = bigInteger.compareMagnitude$kt_math(bigInteger3);
            }
            return n;
        }

        private final long multiply(long x, long y) {
            long product2 = x * y;
            boolean bl = false;
            long ax = Math.abs(x);
            boolean bl2 = false;
            long ay = Math.abs(y);
            return (ax | ay) >>> 31 == 0L || y == 0L || product2 / y == x ? product2 : Long.MIN_VALUE;
        }

        private final BigDecimal multiply(long x, long y, int scale) {
            long product2 = this.multiply(x, y);
            return product2 != Long.MIN_VALUE ? this.of(product2, scale) : new BigDecimal(BigInteger.Companion.of(x).timesLong$kt_math(y), Long.MIN_VALUE, scale, 0);
        }

        private final BigDecimal multiply(long x, BigInteger y, int scale) {
            BigDecimal bigDecimal;
            if (x == 0L) {
                bigDecimal = this.zeroValueOf$kt_math(scale);
            } else {
                BigInteger bigInteger = y;
                Intrinsics.checkNotNull(bigInteger);
                bigDecimal = new BigDecimal(bigInteger.timesLong$kt_math(x), Long.MIN_VALUE, scale, 0);
            }
            return bigDecimal;
        }

        private final BigDecimal multiply(BigInteger x, BigInteger y, int scale) {
            BigInteger bigInteger = y;
            Intrinsics.checkNotNull(bigInteger);
            return new BigDecimal(x.times(bigInteger), Long.MIN_VALUE, scale, 0);
        }

        private final BigDecimal multiplyAndRound(long x, long y, int scale, MathContext mc) {
            long mLo;
            long x2 = x;
            long y2 = y;
            long product2 = this.multiply(x2, y2);
            if (product2 != Long.MIN_VALUE) {
                return this.doRound(product2, scale, mc);
            }
            int rsign = 1;
            if (x2 < 0L) {
                x2 = -x2;
                rsign = -1;
            }
            if (y2 < 0L) {
                y2 = -y2;
                rsign *= -1;
            }
            long m0_hi = x2 >>> 32;
            long m0_lo = x2 & 0xFFFFFFFFL;
            long m1_hi = y2 >>> 32;
            long m1_lo = y2 & 0xFFFFFFFFL;
            product2 = m0_lo * m1_lo;
            long m0 = product2 & 0xFFFFFFFFL;
            long m1 = product2 >>> 32;
            product2 = m0_hi * m1_lo + m1;
            m1 = product2 & 0xFFFFFFFFL;
            long m2 = product2 >>> 32;
            product2 = m0_lo * m1_hi + m1;
            m1 = product2 & 0xFFFFFFFFL;
            long m3 = (m2 += product2 >>> 32) >>> 32;
            m2 &= 0xFFFFFFFFL;
            product2 = m0_hi * m1_hi + m2;
            long mHi = this.make64(m3 = (product2 >>> 32) + m3 & 0xFFFFFFFFL, m2 = product2 & 0xFFFFFFFFL);
            BigDecimal res = this.doRound128(mHi, mLo = this.make64(m1, m0), rsign, scale, mc);
            if (res != null) {
                return res;
            }
            res = new BigDecimal(BigInteger.Companion.of(x2).timesLong$kt_math(y2 * (long)rsign), Long.MIN_VALUE, scale, 0);
            BigDecimal bigDecimal = this.doRound(res, mc);
            Intrinsics.checkNotNull(bigDecimal);
            return bigDecimal;
        }

        private final BigDecimal multiplyAndRound(long x, BigInteger y, int scale, MathContext mc) {
            BigDecimal bigDecimal;
            if (x == 0L) {
                bigDecimal = this.zeroValueOf$kt_math(scale);
            } else {
                BigInteger bigInteger = y;
                Intrinsics.checkNotNull(bigInteger);
                bigDecimal = this.doRound(bigInteger.timesLong$kt_math(x), scale, mc);
            }
            return bigDecimal;
        }

        private final BigDecimal multiplyAndRound(BigInteger x, BigInteger y, int scale, MathContext mc) {
            BigInteger bigInteger = y;
            Intrinsics.checkNotNull(bigInteger);
            return this.doRound(x.times(bigInteger), scale, mc);
        }

        private final BigDecimal doRound128(long hi, long lo, int sign, int scale, MathContext mc) {
            int scale2 = scale;
            int mcp = mc.getPrecision();
            int drop = this.precision(hi, lo) - mcp;
            BigDecimal res = null;
            if (drop > 0 && drop < LONG_TEN_POWERS_TABLE.length) {
                scale2 = this.checkScaleNonZero((long)scale2 - (long)drop);
                res = this.divideAndRound128(hi, lo, LONG_TEN_POWERS_TABLE[drop], sign, scale2, mc.getRoundingMode().getOldMode$kt_math(), scale2);
            }
            return res != null ? this.doRound(res, mc) : null;
        }

        private final int precision(long hi, long lo) {
            if (hi == 0L) {
                if (lo >= 0L) {
                    return this.longDigitLength$kt_math(lo);
                }
                return this.unsignedLongCompareEq(lo, LONGLONG_TEN_POWERS_TABLE[0][1]) ? 20 : 19;
            }
            int r = (128 - Utils.numberOfLeadingZeros(hi) + 1) * 1233 >>> 12;
            int idx = r - 19;
            return idx >= ((Object[])LONGLONG_TEN_POWERS_TABLE).length || this.longLongCompareMagnitude(hi, lo, LONGLONG_TEN_POWERS_TABLE[idx][0], LONGLONG_TEN_POWERS_TABLE[idx][1]) ? r : r + 1;
        }

        private final boolean longLongCompareMagnitude(long hi0, long lo0, long hi1, long lo1) {
            return hi0 != hi1 ? hi0 < hi1 : lo0 + Long.MIN_VALUE < lo1 + Long.MIN_VALUE;
        }

        private final BigDecimal divide(long dividend, int dividendScale, long divisor, int divisorScale, int scale, int roundingMode2) {
            if (this.checkScale(dividend, (long)scale + (long)divisorScale) > dividendScale) {
                int newScale = scale + divisorScale;
                int raise = newScale - dividendScale;
                if (raise < LONG_TEN_POWERS_TABLE.length) {
                    long xs = dividend;
                    if ((xs = this.longMultiplyPowerTen(xs, raise)) != Long.MIN_VALUE) {
                        return this.divideAndRound(xs, divisor, scale, roundingMode2, scale);
                    }
                    BigDecimal q = this.multiplyDivideAndRound(LONG_TEN_POWERS_TABLE[raise], dividend, divisor, scale, roundingMode2, scale);
                    if (q != null) {
                        return q;
                    }
                }
                BigInteger scaledDividend = this.bigMultiplyPowerTen(dividend, raise);
                return this.divideAndRound(scaledDividend, divisor, scale, roundingMode2, scale);
            }
            int newScale = this.checkScale(divisor, (long)dividendScale - (long)scale);
            int raise = newScale - divisorScale;
            if (raise < LONG_TEN_POWERS_TABLE.length) {
                long ys = divisor;
                if ((ys = this.longMultiplyPowerTen(ys, raise)) != Long.MIN_VALUE) {
                    return this.divideAndRound(dividend, ys, scale, roundingMode2, scale);
                }
            }
            BigInteger scaledDivisor = this.bigMultiplyPowerTen(divisor, raise);
            return this.divideAndRound(BigInteger.Companion.of(dividend), scaledDivisor, scale, roundingMode2, scale);
        }

        private final BigDecimal divide(BigInteger dividend, int dividendScale, long divisor, int divisorScale, int scale, int roundingMode2) {
            if (this.checkScale(dividend, (long)scale + (long)divisorScale) > dividendScale) {
                BigInteger scaledDividend;
                int newScale = scale + divisorScale;
                int raise = newScale - dividendScale;
                BigInteger bigInteger = scaledDividend = this.bigMultiplyPowerTen(dividend, raise);
                Intrinsics.checkNotNull(bigInteger);
                return this.divideAndRound(bigInteger, divisor, scale, roundingMode2, scale);
            }
            int newScale = this.checkScale(divisor, (long)dividendScale - (long)scale);
            int raise = newScale - divisorScale;
            if (raise < LONG_TEN_POWERS_TABLE.length) {
                long ys = divisor;
                if ((ys = this.longMultiplyPowerTen(ys, raise)) != Long.MIN_VALUE) {
                    BigInteger bigInteger = dividend;
                    Intrinsics.checkNotNull(bigInteger);
                    return this.divideAndRound(bigInteger, ys, scale, roundingMode2, scale);
                }
            }
            BigInteger scaledDivisor = this.bigMultiplyPowerTen(divisor, raise);
            BigInteger bigInteger = dividend;
            Intrinsics.checkNotNull(bigInteger);
            return this.divideAndRound(bigInteger, scaledDivisor, scale, roundingMode2, scale);
        }

        private final BigDecimal divide(long dividend, int dividendScale, BigInteger divisor, int divisorScale, int scale, int roundingMode2) {
            if (this.checkScale(dividend, (long)scale + (long)divisorScale) > dividendScale) {
                int newScale = scale + divisorScale;
                int raise = newScale - dividendScale;
                BigInteger scaledDividend = this.bigMultiplyPowerTen(dividend, raise);
                BigInteger bigInteger = divisor;
                Intrinsics.checkNotNull(bigInteger);
                return this.divideAndRound(scaledDividend, bigInteger, scale, roundingMode2, scale);
            }
            int newScale = this.checkScale(divisor, (long)dividendScale - (long)scale);
            int raise = newScale - divisorScale;
            BigInteger scaledDivisor = this.bigMultiplyPowerTen(divisor, raise);
            BigInteger bigInteger = BigInteger.Companion.of(dividend);
            BigInteger bigInteger2 = scaledDivisor;
            Intrinsics.checkNotNull(bigInteger2);
            return this.divideAndRound(bigInteger, bigInteger2, scale, roundingMode2, scale);
        }

        private final BigDecimal divide(BigInteger dividend, int dividendScale, BigInteger divisor, int divisorScale, int scale, int roundingMode2) {
            if (this.checkScale(dividend, (long)scale + (long)divisorScale) > dividendScale) {
                BigInteger scaledDividend;
                int newScale = scale + divisorScale;
                int raise = newScale - dividendScale;
                BigInteger bigInteger = scaledDividend = this.bigMultiplyPowerTen(dividend, raise);
                Intrinsics.checkNotNull(bigInteger);
                BigInteger bigInteger2 = divisor;
                Intrinsics.checkNotNull(bigInteger2);
                return this.divideAndRound(bigInteger, bigInteger2, scale, roundingMode2, scale);
            }
            int newScale = this.checkScale(divisor, (long)dividendScale - (long)scale);
            int raise = newScale - divisorScale;
            BigInteger scaledDivisor = this.bigMultiplyPowerTen(divisor, raise);
            BigInteger bigInteger = dividend;
            Intrinsics.checkNotNull(bigInteger);
            BigInteger bigInteger3 = scaledDivisor;
            Intrinsics.checkNotNull(bigInteger3);
            return this.divideAndRound(bigInteger, bigInteger3, scale, roundingMode2, scale);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final BigDecimal of(double val) {
            return org.gciatto.kt.math.BigDecimal$Companion.of$default(this, val, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final BigDecimal of(float val) {
            return org.gciatto.kt.math.BigDecimal$Companion.of$default(this, val, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final BigDecimal of(@NotNull String val) {
            Intrinsics.checkNotNullParameter(val, "val");
            return org.gciatto.kt.math.BigDecimal$Companion.of$default(this, val, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final BigDecimal of(@NotNull BigInteger val) {
            Intrinsics.checkNotNullParameter(val, "val");
            return org.gciatto.kt.math.BigDecimal$Companion.of$default(this, val, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RoundingMode.values().length];
            nArray[RoundingMode.DOWN.ordinal()] = 1;
            nArray[RoundingMode.FLOOR.ordinal()] = 2;
            nArray[RoundingMode.UP.ordinal()] = 3;
            nArray[RoundingMode.CEILING.ordinal()] = 4;
            nArray[RoundingMode.HALF_DOWN.ordinal()] = 5;
            nArray[RoundingMode.HALF_EVEN.ordinal()] = 6;
            nArray[RoundingMode.HALF_UP.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

