/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.wellbehaved.event;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.event.Event;
import javafx.event.EventType;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputHandler;
import org.fxmisc.wellbehaved.event.InputMapChain;
import org.fxmisc.wellbehaved.event.PatternActionMap;

@FunctionalInterface
public interface InputMap<E extends Event> {
    public static final InputMap<?> EMPTY = handlerConsumer -> {};

    public static <E extends Event> InputMap<E> empty() {
        return EMPTY;
    }

    public void forEachEventType(HandlerConsumer<? super E> var1);

    default public InputMap<E> orElse(InputMap<? extends E> that) {
        return InputMap.sequence(this, that);
    }

    default public InputMap<E> without(InputMap<?> that) {
        return this.equals(that) ? InputMap.empty() : this;
    }

    default public InputMap<E> ifConsumed(Consumer<? super E> postConsumption) {
        return InputMap.postResult(this, InputHandler.Result.CONSUME, postConsumption);
    }

    default public InputMap<E> ifIgnored(Consumer<? super E> postIgnore) {
        return InputMap.postResult(this, InputHandler.Result.IGNORE, postIgnore);
    }

    default public InputMap<E> ifProcessed(Consumer<? super E> postProceed) {
        return InputMap.postResult(this, InputHandler.Result.PROCEED, postProceed);
    }

    public static <E extends Event> InputMap<E> postResult(InputMap<? extends E> map2, final InputHandler.Result checkedResult, final Consumer<? super E> postDesiredResult) {
        return handlerConsumer -> map2.forEachEventType(new HandlerConsumer<E>(){

            @Override
            public <T extends E> void accept(EventType<? extends T> t, InputHandler<? super T> h) {
                InputHandler<Event> h2 = e -> {
                    InputHandler.Result res = h.process(e);
                    if (res == checkedResult) {
                        postDesiredResult.accept(e);
                    }
                    return res;
                };
                handlerConsumer.accept(t, h2);
            }
        });
    }

    public static <E extends Event> InputMap<E> upCast(InputMap<? extends E> inputMap) {
        InputMap<? extends E> res = inputMap;
        return res;
    }

    @SafeVarargs
    public static <E extends Event> InputMap<E> sequence(InputMap<? extends E> ... inputMaps) {
        return new InputMapChain<E>(inputMaps);
    }

    public static <T extends Event, U extends T> InputMap<U> process(EventPattern<? super T, ? extends U> eventPattern, Function<? super U, InputHandler.Result> action) {
        return new PatternActionMap<T, U>(eventPattern, action);
    }

    public static <T extends Event> InputMap<T> process(EventType<? extends T> eventType, Function<? super T, InputHandler.Result> action) {
        return InputMap.process(EventPattern.eventType(eventType), action);
    }

    public static <T extends Event, U extends T> InputMap<U> consume(EventPattern<? super T, ? extends U> eventPattern, Consumer<? super U> action) {
        return InputMap.process(eventPattern, (? super U u) -> {
            action.accept((Object)u);
            return InputHandler.Result.CONSUME;
        });
    }

    public static <T extends Event> InputMap<T> consume(EventType<? extends T> eventType, Consumer<? super T> action) {
        return InputMap.consume(EventPattern.eventType(eventType), action);
    }

    public static <T extends Event, U extends T> InputMap<U> consume(EventPattern<? super T, ? extends U> eventPattern) {
        return InputMap.process(eventPattern, (? super U u) -> InputHandler.Result.CONSUME);
    }

    public static <T extends Event> InputMap<T> consume(EventType<? extends T> eventType) {
        return InputMap.consume(EventPattern.eventType(eventType));
    }

    public static <T extends Event, U extends T> InputMap<U> consumeWhen(EventPattern<? super T, ? extends U> eventPattern, BooleanSupplier condition, Consumer<? super U> action) {
        return InputMap.process(eventPattern, (? super U u) -> {
            if (condition.getAsBoolean()) {
                action.accept((Object)u);
                return InputHandler.Result.CONSUME;
            }
            return InputHandler.Result.PROCEED;
        });
    }

    public static <T extends Event> InputMap<T> consumeWhen(EventType<? extends T> eventType, BooleanSupplier condition, Consumer<? super T> action) {
        return InputMap.consumeWhen(EventPattern.eventType(eventType), condition, action);
    }

    public static <T extends Event, U extends T> InputMap<U> consumeUnless(EventPattern<? super T, ? extends U> eventPattern, BooleanSupplier condition, Consumer<? super U> action) {
        return InputMap.consumeWhen(eventPattern, () -> !condition.getAsBoolean(), action);
    }

    public static <T extends Event> InputMap<T> consumeUnless(EventType<? extends T> eventType, BooleanSupplier condition, Consumer<? super T> action) {
        return InputMap.consumeUnless(EventPattern.eventType(eventType), condition, action);
    }

    public static <T extends Event, U extends T> InputMap<U> ignore(EventPattern<? super T, ? extends U> eventPattern) {
        return new PatternActionMap<T, Object>(eventPattern, PatternActionMap.CONST_IGNORE);
    }

    public static <T extends Event> InputMap<T> ignore(EventType<? extends T> eventType) {
        return InputMap.ignore(EventPattern.eventType(eventType));
    }

    public static <T extends Event> InputMap<T> when(final BooleanSupplier condition, final InputMap<T> im) {
        return new InputMap<T>(){

            @Override
            public void forEachEventType(final HandlerConsumer<? super T> f) {
                HandlerConsumer g = new HandlerConsumer<T>(){

                    @Override
                    public <F extends T> void accept(EventType<? extends F> t, InputHandler<? super F> h) {
                        f.accept(t, evt -> condition.getAsBoolean() ? h.process((Object)evt) : InputHandler.Result.PROCEED);
                    }
                };
                im.forEachEventType(g);
            }
        };
    }

    public static <T extends Event> InputMap<T> unless(BooleanSupplier condition, InputMap<T> im) {
        return InputMap.when(() -> !condition.getAsBoolean(), im);
    }

    @FunctionalInterface
    public static interface HandlerConsumer<E extends Event> {
        public <F extends E> void accept(EventType<? extends F> var1, InputHandler<? super F> var2);
    }
}

