/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import org.fxmisc.richtext.model.PlainTextChange;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TextChange;

public class RichTextChange<PS, SEG, S>
extends TextChange<StyledDocument<PS, SEG, S>, RichTextChange<PS, SEG, S>> {
    private static boolean skipStyleComparison = false;

    public RichTextChange(int position, StyledDocument<PS, SEG, S> removed, StyledDocument<PS, SEG, S> inserted) {
        super(position, removed, inserted);
    }

    @Override
    protected int removedLength() {
        return ((StyledDocument)this.removed).length();
    }

    @Override
    protected int insertedLength() {
        return ((StyledDocument)this.inserted).length();
    }

    @Override
    protected final StyledDocument<PS, SEG, S> concat(StyledDocument<PS, SEG, S> a, StyledDocument<PS, SEG, S> b) {
        return a.concat(b);
    }

    @Override
    protected final StyledDocument<PS, SEG, S> sub(StyledDocument<PS, SEG, S> doc, int from2, int to) {
        return doc.subSequence(from2, to);
    }

    @Override
    protected final RichTextChange<PS, SEG, S> create(int position, StyledDocument<PS, SEG, S> removed, StyledDocument<PS, SEG, S> inserted) {
        return new RichTextChange<PS, SEG, S>(position, removed, inserted);
    }

    public final PlainTextChange toPlainTextChange() {
        return new PlainTextChange(this.position, ((StyledDocument)this.removed).getText(), ((StyledDocument)this.inserted).getText());
    }

    public final boolean isPlainTextIdentity() {
        return ((StyledDocument)this.removed).getText().equals(((StyledDocument)this.inserted).getText());
    }

    public static void skipStyleComparison(boolean value) {
        skipStyleComparison = value;
    }

    @Override
    public boolean equals(Object other) {
        if (skipStyleComparison && other instanceof RichTextChange) {
            PlainTextChange otherChange = ((RichTextChange)other).toPlainTextChange();
            boolean matches = this.toPlainTextChange().equals(otherChange);
            if (!matches) {
                System.err.println("Plain text comparison mismatch caused by text change during undo manager suspension (styling ignored).");
            }
            return matches;
        }
        return super.equals(other);
    }
}

