/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.Objects;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;

public class Replacement<PS, SEG, S> {
    private final int start;
    private final int end;
    private final ReadOnlyStyledDocument<PS, SEG, S> document;

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    public final ReadOnlyStyledDocument<PS, SEG, S> getDocument() {
        return this.document;
    }

    public Replacement(int start2, int end, ReadOnlyStyledDocument<PS, SEG, S> document) {
        this.start = start2;
        this.end = end;
        this.document = document;
    }

    public int getNetLength() {
        return this.document.length() - (this.end - this.start);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Replacement) {
            Replacement that = (Replacement)obj;
            return Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end) && Objects.equals(this.document, that.document);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.document);
    }

    public String toString() {
        return String.format("Replacement(start=%s end=%s document=%s)", this.start, this.end, this.document);
    }
}

