/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.text.BreakIterator;
import org.fxmisc.richtext.TextEditingArea;

public interface NavigationActions<PS, SEG, S>
extends TextEditingArea<PS, SEG, S> {
    default public void moveTo(int pos) {
        this.getCaretSelectionBind().moveTo(pos);
    }

    default public void moveTo(int paragraphIndex, int columnIndex) {
        this.getCaretSelectionBind().moveTo(paragraphIndex, columnIndex);
    }

    default public void moveTo(int position, SelectionPolicy selectionPolicy) {
        this.getCaretSelectionBind().moveTo(position, selectionPolicy);
    }

    default public void moveTo(int paragraphIndex, int columnIndex, SelectionPolicy selectionPolicy) {
        this.getCaretSelectionBind().moveTo(paragraphIndex, columnIndex, selectionPolicy);
    }

    default public void previousChar(SelectionPolicy selectionPolicy) {
        this.getCaretSelectionBind().moveToPrevChar(selectionPolicy);
    }

    default public void nextChar(SelectionPolicy selectionPolicy) {
        this.getCaretSelectionBind().moveToNextChar(selectionPolicy);
    }

    default public void wordBreaksBackwards(int n, SelectionPolicy selectionPolicy) {
        if (this.getLength() == 0) {
            return;
        }
        BreakIterator wordBreakIterator = BreakIterator.getWordInstance(this.getLocale());
        wordBreakIterator.setText(this.getText());
        wordBreakIterator.preceding(this.getCaretPosition());
        for (int i = 1; i < n; ++i) {
            wordBreakIterator.previous();
        }
        this.moveTo(wordBreakIterator.current(), selectionPolicy);
    }

    default public void wordBreaksForwards(int n, SelectionPolicy selectionPolicy) {
        if (this.getLength() == 0) {
            return;
        }
        BreakIterator wordBreakIterator = BreakIterator.getWordInstance();
        wordBreakIterator.setText(this.getText());
        wordBreakIterator.following(this.getCaretPosition());
        for (int i = 1; i < n; ++i) {
            wordBreakIterator.next();
        }
        this.moveTo(wordBreakIterator.current(), selectionPolicy);
    }

    default public void selectWord() {
        this.getCaretSelectionBind().selectWord();
    }

    default public void paragraphStart(SelectionPolicy selectionPolicy) {
        this.getCaretSelectionBind().moveToParStart(selectionPolicy);
    }

    default public void paragraphEnd(SelectionPolicy selectionPolicy) {
        this.getCaretSelectionBind().moveToParEnd(selectionPolicy);
    }

    default public void start(SelectionPolicy selectionPolicy) {
        this.getCaretSelectionBind().moveToAreaStart(selectionPolicy);
    }

    default public void end(SelectionPolicy selectionPolicy) {
        this.getCaretSelectionBind().moveToAreaEnd(selectionPolicy);
    }

    default public void selectParagraph() {
        this.getCaretSelectionBind().selectParagraph();
    }

    default public void selectAll() {
        this.getCaretSelectionBind().selectAll();
    }

    default public void deselect() {
        this.getCaretSelectionBind().deselect();
    }

    public static enum SelectionPolicy {
        CLEAR,
        ADJUST,
        EXTEND;

    }
}

