/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceFile;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.IncompatibleVersionErrorData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerAbiStability;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerSource;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmPackagePartSource
implements DeserializedContainerSource {
    @NotNull
    private final JvmClassName className;
    @Nullable
    private final JvmClassName facadeClassName;
    @Nullable
    private final IncompatibleVersionErrorData<JvmMetadataVersion> incompatibility;
    private final boolean isPreReleaseInvisible;
    @NotNull
    private final DeserializedContainerAbiStability abiStability;
    @Nullable
    private final KotlinJvmBinaryClass knownJvmBinaryClass;
    @NotNull
    private final String moduleName;

    /*
     * WARNING - void declaration
     */
    public JvmPackagePartSource(@NotNull JvmClassName className, @Nullable JvmClassName facadeClassName, @NotNull ProtoBuf.Package packageProto, @NotNull NameResolver nameResolver, @Nullable IncompatibleVersionErrorData<JvmMetadataVersion> incompatibility, boolean isPreReleaseInvisible, @NotNull DeserializedContainerAbiStability abiStability, @Nullable KotlinJvmBinaryClass knownJvmBinaryClass) {
        Object object;
        Intrinsics.checkNotNullParameter(className, "className");
        Intrinsics.checkNotNullParameter(packageProto, "packageProto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        Intrinsics.checkNotNullParameter((Object)abiStability, "abiStability");
        this.className = className;
        this.facadeClassName = facadeClassName;
        this.incompatibility = incompatibility;
        this.isPreReleaseInvisible = isPreReleaseInvisible;
        this.abiStability = abiStability;
        this.knownJvmBinaryClass = knownJvmBinaryClass;
        JvmPackagePartSource jvmPackagePartSource = this;
        GeneratedMessageLite.ExtendableMessage extendableMessage = packageProto;
        Object object2 = JvmProtoBuf.packageModuleName;
        Intrinsics.checkNotNullExpressionValue(object2, "packageModuleName");
        Integer n = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, object2);
        if (n == null) {
            object = "main";
        } else {
            void p0;
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int n3 = ((Number)n2).intValue();
            JvmPackagePartSource jvmPackagePartSource2 = jvmPackagePartSource;
            boolean bl3 = false;
            String string2 = nameResolver.getString((int)p0);
            jvmPackagePartSource = jvmPackagePartSource2;
            object2 = string2;
            object = object2 == null ? "main" : object2;
        }
        jvmPackagePartSource.moduleName = object;
    }

    @Nullable
    public final JvmClassName getFacadeClassName() {
        return this.facadeClassName;
    }

    @Nullable
    public final KotlinJvmBinaryClass getKnownJvmBinaryClass() {
        return this.knownJvmBinaryClass;
    }

    /*
     * WARNING - void declaration
     */
    public JvmPackagePartSource(@NotNull KotlinJvmBinaryClass kotlinClass2, @NotNull ProtoBuf.Package packageProto, @NotNull NameResolver nameResolver, @Nullable IncompatibleVersionErrorData<JvmMetadataVersion> incompatibility, boolean isPreReleaseInvisible, @NotNull DeserializedContainerAbiStability abiStability) {
        JvmClassName jvmClassName;
        Intrinsics.checkNotNullParameter(kotlinClass2, "kotlinClass");
        Intrinsics.checkNotNullParameter(packageProto, "packageProto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        Intrinsics.checkNotNullParameter((Object)abiStability, "abiStability");
        JvmPackagePartSource jvmPackagePartSource = this;
        Object object = JvmClassName.byClassId(kotlinClass2.getClassId());
        Intrinsics.checkNotNullExpressionValue(object, "byClassId(kotlinClass.classId)");
        JvmClassName jvmClassName2 = object;
        object = kotlinClass2.getClassHeader().getMultifileClassName();
        if (object == null) {
            jvmClassName = null;
        } else {
            void it;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object object3 = object2;
            JvmClassName jvmClassName3 = jvmClassName2;
            JvmPackagePartSource jvmPackagePartSource2 = jvmPackagePartSource;
            boolean bl3 = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl4 = false;
            JvmClassName jvmClassName4 = charSequence.length() > 0 ? JvmClassName.byInternalName((String)it) : null;
            jvmPackagePartSource = jvmPackagePartSource2;
            jvmClassName2 = jvmClassName3;
            jvmClassName = jvmClassName4;
        }
        jvmPackagePartSource(jvmClassName2, jvmClassName, packageProto, nameResolver, incompatibility, isPreReleaseInvisible, abiStability, kotlinClass2);
    }

    @Override
    @NotNull
    public String getPresentableString() {
        return "Class '" + this.getClassId().asSingleFqName().asString() + '\'';
    }

    @NotNull
    public final Name getSimpleName() {
        String string2 = this.className.getInternalName();
        Intrinsics.checkNotNullExpressionValue(string2, "className.internalName");
        Name name = Name.identifier(StringsKt.substringAfterLast$default(string2, '/', null, 2, null));
        Intrinsics.checkNotNullExpressionValue(name, "identifier(className.int\u2026.substringAfterLast('/'))");
        return name;
    }

    @NotNull
    public final ClassId getClassId() {
        return new ClassId(this.className.getPackageFqName(), this.getSimpleName());
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.className;
    }

    @Override
    @NotNull
    public SourceFile getContainingFile() {
        SourceFile sourceFile = SourceFile.NO_SOURCE_FILE;
        Intrinsics.checkNotNullExpressionValue(sourceFile, "NO_SOURCE_FILE");
        return sourceFile;
    }
}

