/*
 * Decompiled with CFR 0.152.
 */
package javafx.css.converter;

import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public final class ColorConverter
extends StyleConverter<String, Color> {
    public static StyleConverter<String, Color> getInstance() {
        return Holder.COLOR_INSTANCE;
    }

    private ColorConverter() {
    }

    @Override
    public Color convert(ParsedValue<String, Color> parsedValue, Font font) {
        String string2 = parsedValue.getValue();
        if (string2 == null) {
            return null;
        }
        if (string2 instanceof Color) {
            return (Color)((Object)string2);
        }
        if (string2 instanceof String) {
            String string3 = string2;
            if (string3.isEmpty() || "null".equals(string3)) {
                return null;
            }
            try {
                return Color.web(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        System.err.println("not a color: " + parsedValue);
        return Color.BLACK;
    }

    public String toString() {
        return "ColorConverter";
    }

    private static class Holder {
        static final ColorConverter COLOR_INSTANCE = new ColorConverter();

        private Holder() {
        }
    }
}

