/*
 * Decompiled with CFR 0.152.
 */
package javafx.application;

import java.security.AccessController;
import javafx.application.Application;

public abstract class Preloader
extends Application {
    private static final String lineSeparator;

    public void handleProgressNotification(ProgressNotification progressNotification) {
    }

    public void handleStateChangeNotification(StateChangeNotification stateChangeNotification) {
    }

    public void handleApplicationNotification(PreloaderNotification preloaderNotification) {
    }

    public boolean handleErrorNotification(ErrorNotification errorNotification) {
        return false;
    }

    static {
        String string2 = AccessController.doPrivileged(() -> System.getProperty("line.separator"));
        lineSeparator = string2 != null ? string2 : "\n";
    }

    public static class StateChangeNotification
    implements PreloaderNotification {
        private final Type notificationType;
        private final Application application;

        public StateChangeNotification(Type type2) {
            this.notificationType = type2;
            this.application = null;
        }

        public StateChangeNotification(Type type2, Application application) {
            this.notificationType = type2;
            this.application = application;
        }

        public Type getType() {
            return this.notificationType;
        }

        public Application getApplication() {
            return this.application;
        }

        public static enum Type {
            BEFORE_LOAD,
            BEFORE_INIT,
            BEFORE_START;

        }
    }

    public static class ProgressNotification
    implements PreloaderNotification {
        private final double progress;
        private final String details;

        public ProgressNotification(double d) {
            this(d, "");
        }

        private ProgressNotification(double d, String string2) {
            this.progress = d;
            this.details = string2;
        }

        public double getProgress() {
            return this.progress;
        }

        private String getDetails() {
            return this.details;
        }
    }

    public static class ErrorNotification
    implements PreloaderNotification {
        private String location;
        private String details = "";
        private Throwable cause;

        public ErrorNotification(String string2, String string3, Throwable throwable) {
            if (string3 == null) {
                throw new NullPointerException();
            }
            this.location = string2;
            this.details = string3;
            this.cause = throwable;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDetails() {
            return this.details;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Preloader.ErrorNotification: ");
            stringBuilder.append(this.details);
            if (this.cause != null) {
                stringBuilder.append(lineSeparator).append("Caused by: ").append(this.cause.toString());
            }
            if (this.location != null) {
                stringBuilder.append(lineSeparator).append("Location: ").append(this.location);
            }
            return stringBuilder.toString();
        }
    }

    public static interface PreloaderNotification {
    }
}

