/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.ui.repl;

import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.output.TermUi;
import com.github.ajalt.clikt.parameters.options.FlagOptionKt;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.types.IntKt;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.parsing.ParseException;
import it.unibo.tuprolog.core.parsing.TermParserExtensions;
import it.unibo.tuprolog.solve.Solution;
import it.unibo.tuprolog.solve.Solver;
import it.unibo.tuprolog.solve.channel.OutputChannel;
import it.unibo.tuprolog.solve.classic.SolverExtensions;
import it.unibo.tuprolog.solve.library.AliasedLibrary;
import it.unibo.tuprolog.solve.library.Libraries;
import it.unibo.tuprolog.solve.libs.io.IOLib;
import it.unibo.tuprolog.solve.libs.oop.OOPLib;
import it.unibo.tuprolog.theory.Theory;
import it.unibo.tuprolog.ui.repl.PlatformSpecificUtilsKt;
import it.unibo.tuprolog.ui.repl.TuPrologCmd;
import it.unibo.tuprolog.ui.repl.TuPrologUtils;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0018\u001a\u00020\u0019J\n\u0010\u0015\u001a\u00060\u001aj\u0002`\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0002J\b\u0010!\u001a\u00020\u001fH\u0016R\u0018\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\r\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lit/unibo/tuprolog/ui/repl/TuPrologCmd;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "additionalLibraries", "", "Lit/unibo/tuprolog/solve/library/AliasedLibrary;", "([Lit/unibo/tuprolog/solve/library/AliasedLibrary;)V", "[Lit/unibo/tuprolog/solve/library/AliasedLibrary;", "files", "", "", "getFiles", "()Ljava/util/List;", "files$delegate", "Lkotlin/properties/ReadOnlyProperty;", "oop", "", "getOop", "()Z", "oop$delegate", "timeout", "", "getTimeout", "()I", "timeout$delegate", "getSolver", "Lit/unibo/tuprolog/solve/Solver;", "", "Lit/unibo/tuprolog/solve/TimeDuration;", "loadTheory", "Lit/unibo/tuprolog/theory/Theory;", "readEvalPrintLoop", "", "solver", "run", "Companion", "repl"})
public final class TuPrologCmd
extends CliktCommand {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final AliasedLibrary[] additionalLibraries;
    @NotNull
    private final ReadOnlyProperty files$delegate;
    @NotNull
    private final ReadOnlyProperty timeout$delegate;
    @NotNull
    private final ReadOnlyProperty oop$delegate;
    public static final int DEFAULT_TIMEOUT = 1000;

    public TuPrologCmd(AliasedLibrary ... additionalLibraries) {
        Intrinsics.checkNotNullParameter(additionalLibraries, "additionalLibraries");
        super("Start a Prolog Read-Eval-Print loop", null, "java -jar 2p-repl.jar", true, false, null, null, true, false, 370, null);
        this.additionalLibraries = additionalLibraries;
        String[] stringArray = new String[]{"-T", "--theory"};
        this.files$delegate = OptionWithValuesKt.multiple$default(OptionWithValuesKt.option$default(this, stringArray, "Path of theory file to be loaded", null, false, null, null, null, null, 252, null), null, false, 3, null).provideDelegate(this, $$delegatedProperties[0]);
        stringArray = new String[]{"-t", "--timeout"};
        this.timeout$delegate = OptionWithValuesKt.default$default(IntKt.int(OptionWithValuesKt.option$default(this, stringArray, "Maximum amount of time for computing a solution (default: 1000 ms)", null, false, null, null, null, null, 252, null)), 1000, null, 2, null).provideDelegate(this, $$delegatedProperties[1]);
        stringArray = new String[]{"--oop"};
        this.oop$delegate = FlagOptionKt.flag(OptionWithValuesKt.option$default(this, stringArray, "Loads the OOP library", null, false, null, null, null, null, 252, null), new String[0], false).provideDelegate(this, $$delegatedProperties[2]);
    }

    private final List<String> getFiles() {
        return (List)this.files$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final int getTimeout() {
        return ((Number)this.timeout$delegate.getValue(this, $$delegatedProperties[1])).intValue();
    }

    private final boolean getOop() {
        return (Boolean)this.oop$delegate.getValue(this, $$delegatedProperties[2]);
    }

    @Override
    public void run() {
        Solver solve2 = this.getSolver();
        CliktCommand subcommand = this.getCurrentContext().getInvokedSubcommand();
        if (subcommand == null) {
            this.readEvalPrintLoop(solve2);
        }
    }

    private final Theory loadTheory() {
        Theory theory2 = Theory.Companion.empty();
        for (String file : this.getFiles()) {
            if (!PlatformSpecificUtilsKt.isReadableFile(file)) continue;
            try {
                Theory t = PlatformSpecificUtilsKt.loadTheoryFromFile(file);
                TermUi.echo$default(TermUi.INSTANCE, "# Successfully loaded " + t.getSize() + " clauses from " + file, false, false, null, null, 30, null);
                theory2 = theory2.plus(t);
            }
            catch (ParseException e) {
                TermUi.echo$default(TermUi.INSTANCE, StringsKt.trimMargin$default("\n                        |# Error while parsing theory file: " + file + "\n                        |#     Message: " + e.getMessage() + "\n                        |#     Line   : " + e.getLine() + "\n                        |#     Column : " + e.getColumn() + "\n                        |#     Clause : " + e.getClauseIndex() + "\n                        ", null, 1, null), false, true, null, null, 26, null);
            }
        }
        TermUi.echo$default(TermUi.INSTANCE, "", false, false, null, null, 30, null);
        return theory2;
    }

    private final void readEvalPrintLoop(Solver solver2) {
        String query2 = TuPrologUtils.INSTANCE.readQuery();
        while (query2 != null) {
            try {
                Struct goal = TermParserExtensions.parse(Struct.Companion, query2, solver2.getOperators());
                Iterator<Solution> solutions2 = solver2.solve(goal, this.getTimeout()).iterator();
                TuPrologUtils.INSTANCE.printSolutions(solutions2, solver2.getOperators());
            }
            catch (ParseException e) {
                TuPrologUtils.INSTANCE.printParseException(e);
            }
            TermUi.echo$default(TermUi.INSTANCE, "", false, false, null, null, 30, null);
            query2 = TuPrologUtils.INSTANCE.readQuery();
        }
    }

    public final long getTimeout() {
        return this.getTimeout();
    }

    @NotNull
    public final Solver getSolver() {
        Libraries libraries2;
        Object object;
        TermUi.echo$default(TermUi.INSTANCE, "# 2P-Kt version 0.20.3", false, false, null, null, 30, null);
        Theory theory2 = this.loadTheory();
        OutputChannel outputChannel2 = OutputChannel.Companion.of(getSolver.outputChannel.1.INSTANCE);
        if (this.getOop()) {
            object = new SpreadBuilder(3);
            ((SpreadBuilder)object).add(IOLib.INSTANCE);
            ((SpreadBuilder)object).add(OOPLib.INSTANCE);
            ((SpreadBuilder)object).addSpread(this.additionalLibraries);
            libraries2 = Libraries.Companion.of((AliasedLibrary[])((SpreadBuilder)object).toArray(new AliasedLibrary[((SpreadBuilder)object).size()]));
        } else {
            object = new SpreadBuilder(2);
            ((SpreadBuilder)object).add(IOLib.INSTANCE);
            ((SpreadBuilder)object).addSpread(this.additionalLibraries);
            libraries2 = Libraries.Companion.of((AliasedLibrary[])((SpreadBuilder)object).toArray(new AliasedLibrary[((SpreadBuilder)object).size()]));
        }
        Libraries libraries3 = libraries2;
        object = SolverExtensions.classicWithDefaultBuiltins$default(Solver.Companion, libraries3, null, theory2, null, null, null, null, outputChannel2, 122, null);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        Object object2 = it.getLibraries();
        boolean bl4 = false;
        Iterator iterator2 = object2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object3 = object2 = iterator2.next();
            boolean bl5 = false;
            AliasedLibrary library = (AliasedLibrary)object3.getValue();
            TermUi.echo$default(TermUi.INSTANCE, "# Successfully loaded library `" + library.getAlias() + '`', false, false, null, null, 30, null);
        }
        TermUi.echo$default(TermUi.INSTANCE, "", false, false, null, null, 30, null);
        return object;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(TuPrologCmd.class, "files", "getFiles()Ljava/util/List;", 0)), Reflection.property1(new PropertyReference1Impl(TuPrologCmd.class, "timeout", "getTimeout()I", 0)), Reflection.property1(new PropertyReference1Impl(TuPrologCmd.class, "oop", "getOop()Z", 0))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lit/unibo/tuprolog/ui/repl/TuPrologCmd$Companion;", "", "()V", "DEFAULT_TIMEOUT", "", "repl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

