/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.ui.gui;

import it.unibo.tuprolog.core.operators.Operator;
import it.unibo.tuprolog.core.operators.OperatorSet;
import it.unibo.tuprolog.ui.gui.RegexExtensionsKt;
import it.unibo.tuprolog.ui.gui.SyntaxColoring;
import it.unibo.tuprolog.utils.Cached;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import javafx.application.Platform;
import javafx.concurrent.Task;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactfx.Subscription;
import org.reactfx.util.Try;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 )2\u00020\u0001:\u0001)B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u001c\u0010\u001e\u001a\u00020\u001d2\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0 H\u0002J\u0006\u0010#\u001a\u00020\u001dJ\u001c\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0 2\u0006\u0010%\u001a\u00020\"H\u0002J\u001a\u0010&\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0 0'H\u0002J\u0006\u0010(\u001a\u00020\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lit/unibo/tuprolog/ui/gui/SyntaxColoring;", "", "codeArea", "Lorg/fxmisc/richtext/CodeArea;", "delay", "Ljava/time/Duration;", "operators", "Lit/unibo/tuprolog/core/operators/OperatorSet;", "executor", "Ljava/util/concurrent/ExecutorService;", "(Lorg/fxmisc/richtext/CodeArea;Ljava/time/Duration;Lit/unibo/tuprolog/core/operators/OperatorSet;Ljava/util/concurrent/ExecutorService;)V", "value", "getDelay", "()Ljava/time/Duration;", "setDelay", "(Ljava/time/Duration;)V", "isActive", "", "()Z", "getOperators", "()Lit/unibo/tuprolog/core/operators/OperatorSet;", "setOperators", "(Lit/unibo/tuprolog/core/operators/OperatorSet;)V", "patternCache", "Lit/unibo/tuprolog/utils/Cached;", "Lkotlin/text/Regex;", "subscription", "Lorg/reactfx/Subscription;", "activate", "", "applyHighlighting", "highlighting", "Lorg/fxmisc/richtext/model/StyleSpans;", "", "", "applyHighlightingNow", "computeHighlighting", "text", "computeHighlightingAsync", "Ljavafx/concurrent/Task;", "deactivate", "Companion", "ide"})
public final class SyntaxColoring {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodeArea codeArea;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private volatile Duration delay;
    @NotNull
    private volatile OperatorSet operators;
    @Nullable
    private volatile Subscription subscription;
    @NotNull
    private final Cached<Regex> patternCache;
    private static final Duration DEFAULT_UPDATE_DELAY = Duration.ofMillis(100L);
    @NotNull
    private static final Regex PAREN_PATTERN = new Regex("[()]");
    @NotNull
    private static final Regex BRACE_PATTERN = new Regex("[{}]");
    @NotNull
    private static final Regex BRACKET_PATTERN = new Regex("[\\[\\]]");
    @NotNull
    private static final Regex FULLSTOP_PATTERN = new Regex("\\.\\s*([\\n\\r]+|$)");
    @NotNull
    private static final Regex SINGLE_QUOTED_STRING_PATTERN = new Regex("\"([^\"\\\\]|\\\\.)*\"");
    @NotNull
    private static final Regex DOUBLE_QUOTED_STRING_PATTERN = new Regex("'([^'\\\\]|\\\\.)*'");
    @NotNull
    private static final Regex STRING_PATTERN;
    @NotNull
    private static final Regex SINGLE_LINE_COMMENT_PATTERN;
    @NotNull
    private static final Regex MULTI_LINE_COMMENT_PATTERN;
    @NotNull
    private static final Regex COMMENT_PATTERN;
    @NotNull
    private static final Regex VARIABLE_PATTERN;
    @NotNull
    private static final Regex BASIC_ATOM_PATTERN;
    @NotNull
    private static final Regex ATOM_PATTERN;
    @NotNull
    private static final Regex FUNCTOR_PATTERN;
    @NotNull
    private static final Regex INTEGER_PATTERN;
    @NotNull
    private static final Regex HEX_PATTERN;
    @NotNull
    private static final Regex BIN_PATTERN;
    @NotNull
    private static final Regex OCT_PATTERN;
    @NotNull
    private static final Regex FLOAT_PATTERN;
    @NotNull
    private static final Regex CHAR_PATTERN;
    @NotNull
    private static final Regex NUMBER_PATTERN;
    @NotNull
    private static final String KEYWORD = "KEYWORD";
    @NotNull
    private static final String PAREN = "PAREN";
    @NotNull
    private static final String NUMBER = "NUMBER";
    @NotNull
    private static final String BRACE = "BRACE";
    @NotNull
    private static final String BRACKET = "BRACKET";
    @NotNull
    private static final String STRING = "STRING";
    @NotNull
    private static final String COMMENT = "COMMENT";
    @NotNull
    private static final String VARIABLE = "VARIABLE";
    @NotNull
    private static final String FUNCTOR = "FUNCTOR";
    @NotNull
    private static final String ATOM = "ATOM";
    @NotNull
    private static final String FULLSTOP = "FULLSTOP";

    public SyntaxColoring(@NotNull CodeArea codeArea, @NotNull Duration delay, @NotNull OperatorSet operators2, @NotNull ExecutorService executor) {
        Intrinsics.checkNotNullParameter(codeArea, "codeArea");
        Intrinsics.checkNotNullParameter(delay, "delay");
        Intrinsics.checkNotNullParameter(operators2, "operators");
        Intrinsics.checkNotNullParameter(executor, "executor");
        this.codeArea = codeArea;
        this.executor = executor;
        this.delay = delay;
        this.operators = operators2;
        this.patternCache = Cached.Companion.of((Function0)new Function0<Regex>(this){
            final /* synthetic */ SyntaxColoring this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Regex invoke() {
                return it.unibo.tuprolog.ui.gui.SyntaxColoring$Companion.access$pattern(SyntaxColoring.Companion, this.this$0.getOperators());
            }
        });
    }

    public /* synthetic */ SyntaxColoring(CodeArea codeArea, Duration duration, OperatorSet operatorSet2, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        Object object;
        if ((n & 2) != 0) {
            object = DEFAULT_UPDATE_DELAY;
            Intrinsics.checkNotNullExpressionValue(object, "DEFAULT_UPDATE_DELAY");
            duration = object;
        }
        if ((n & 4) != 0) {
            operatorSet2 = OperatorSet.DEFAULT;
        }
        if ((n & 8) != 0) {
            object = ForkJoinPool.commonPool();
            Intrinsics.checkNotNullExpressionValue(object, "commonPool()");
            executorService = (ExecutorService)object;
        }
        this(codeArea, duration, operatorSet2, executorService);
    }

    @NotNull
    public final synchronized Duration getDelay() {
        return this.delay;
    }

    public final synchronized void setDelay(@NotNull Duration value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.delay = value;
        if (this.isActive()) {
            this.activate();
            this.deactivate();
        }
    }

    @NotNull
    public final synchronized OperatorSet getOperators() {
        return this.operators;
    }

    public final synchronized void setOperators(@NotNull OperatorSet value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.operators = value;
        this.patternCache.invalidate();
    }

    private final Task<StyleSpans<Collection<String>>> computeHighlightingAsync() {
        Task task2 = new Task<StyleSpans<Collection<? extends String>>>(this){
            final /* synthetic */ SyntaxColoring this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            protected StyleSpans<Collection<String>> call() {
                String string2 = SyntaxColoring.access$getCodeArea$p(this.this$0).getText();
                Intrinsics.checkNotNullExpressionValue(string2, "codeArea.text");
                return SyntaxColoring.access$computeHighlighting(this.this$0, string2);
            }
        };
        this.executor.execute(task2);
        return task2;
    }

    private final void applyHighlighting(StyleSpans<Collection<String>> highlighting) {
        this.codeArea.setStyleSpans(0, highlighting);
    }

    public final void applyHighlightingNow() {
        Platform.runLater(() -> SyntaxColoring.applyHighlightingNow$lambda-0(this));
    }

    public final synchronized boolean isActive() {
        return this.subscription != null;
    }

    public final synchronized void activate() {
        if (this.subscription != null) {
            throw new IllegalStateException("Syntax coloring is already active");
        }
        this.subscription = this.codeArea.multiPlainChanges().successionEnds(this.delay).supplyTask(() -> SyntaxColoring.activate$lambda-1(this)).awaitLatest(this.codeArea.multiPlainChanges()).filterMap(SyntaxColoring::activate$lambda-2).subscribe(arg_0 -> SyntaxColoring.activate$lambda-3(this, arg_0));
    }

    public final synchronized void deactivate() {
        Subscription subscription = this.subscription;
        boolean bl = false;
        boolean bl2 = false;
        Subscription it = subscription;
        boolean bl3 = false;
        if (it == null) {
            throw new IllegalStateException("Syntax coloring is not active");
        }
        it.unsubscribe();
        this.subscription = null;
    }

    private final StyleSpans<Collection<String>> computeHighlighting(String text) {
        Sequence matches = Regex.findAll$default(this.patternCache.getValue(), text, 0, 2, null);
        int lastKwEnd = 0;
        StyleSpansBuilder<List<Object>> spansBuilder = new StyleSpansBuilder<List<Object>>();
        Object object = matches.iterator();
        while (object.hasNext()) {
            MatchResult match = (MatchResult)object.next();
            String styleClass = SyntaxColoring.Companion.getStyleClass(match);
            int from2 = match.getRange().getFirst();
            int to = match.getRange().getLast() + 1;
            int n = from2 - lastKwEnd;
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            if (it > 0) {
                spansBuilder.add(CollectionsKt.emptyList(), from2 - lastKwEnd);
            }
            spansBuilder.add(CollectionsKt.listOf(styleClass), to - from2);
            lastKwEnd = to;
        }
        spansBuilder.add(CollectionsKt.emptyList(), text.length() - lastKwEnd);
        object = spansBuilder.create();
        Intrinsics.checkNotNullExpressionValue(object, "spansBuilder.create()");
        return object;
    }

    private static final void applyHighlightingNow$lambda-0(SyntaxColoring this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        String string2 = this$0.codeArea.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "codeArea.text");
        this$0.applyHighlighting(this$0.computeHighlighting(string2));
    }

    private static final Task activate$lambda-1(SyntaxColoring this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.computeHighlightingAsync();
    }

    private static final Optional activate$lambda-2(Try it) {
        Optional optional2;
        if (it.isSuccess()) {
            optional2 = Optional.of(it.get());
        } else {
            it.getFailure().printStackTrace();
            optional2 = Optional.empty();
        }
        return optional2;
    }

    private static final void activate$lambda-3(SyntaxColoring this$0, StyleSpans it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullExpressionValue(it, "it");
        this$0.applyHighlighting(it);
    }

    public static final /* synthetic */ StyleSpans access$computeHighlighting(SyntaxColoring $this, String text) {
        return $this.computeHighlighting(text);
    }

    public static final /* synthetic */ CodeArea access$getCodeArea$p(SyntaxColoring $this) {
        return $this.codeArea;
    }

    static {
        Regex[] regexArray = new Regex[]{SINGLE_QUOTED_STRING_PATTERN, DOUBLE_QUOTED_STRING_PATTERN};
        STRING_PATTERN = RegexExtensionsKt.anyOf(regexArray);
        SINGLE_LINE_COMMENT_PATTERN = new Regex("%[^\\n]*");
        MULTI_LINE_COMMENT_PATTERN = new Regex("/\\*(.|\\R)*?\\*/");
        regexArray = new Regex[]{SINGLE_LINE_COMMENT_PATTERN, MULTI_LINE_COMMENT_PATTERN};
        COMMENT_PATTERN = RegexExtensionsKt.anyOf(regexArray);
        VARIABLE_PATTERN = RegexExtensionsKt.asWord(new Regex("[_A-Z][_A-Za-z0-9]*"));
        BASIC_ATOM_PATTERN = new Regex("[a-z][_A-Za-z0-9]*");
        ATOM_PATTERN = RegexExtensionsKt.asWord(BASIC_ATOM_PATTERN);
        FUNCTOR_PATTERN = RegexExtensionsKt.and(ATOM_PATTERN, new Regex("\\s*(?=[(])"));
        INTEGER_PATTERN = new Regex("[0-9]+");
        HEX_PATTERN = new Regex("0[xX][0-9A-Fa-f]+");
        BIN_PATTERN = new Regex("0[bB][0-1]+");
        OCT_PATTERN = new Regex("0[oO][0-7]+");
        FLOAT_PATTERN = new Regex("[0-9]+\\.[0-9]+([eE][-+]?[0-9]+)?");
        CHAR_PATTERN = new Regex("0'(\\\\[abfnrtv'`\"]|.)");
        regexArray = new Regex[]{FLOAT_PATTERN, INTEGER_PATTERN, HEX_PATTERN, BIN_PATTERN, OCT_PATTERN, CHAR_PATTERN};
        NUMBER_PATTERN = RegexExtensionsKt.asWord(RegexExtensionsKt.anyOf(regexArray));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u00062\u0006\u0010-\u001a\u00020.H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010(\u001a\u00020\u0004*\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00060"}, d2={"Lit/unibo/tuprolog/ui/gui/SyntaxColoring$Companion;", "", "()V", "ATOM", "", "ATOM_PATTERN", "Lkotlin/text/Regex;", "BASIC_ATOM_PATTERN", "BIN_PATTERN", "BRACE", "BRACE_PATTERN", "BRACKET", "BRACKET_PATTERN", "CHAR_PATTERN", "COMMENT", "COMMENT_PATTERN", "DEFAULT_UPDATE_DELAY", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "DOUBLE_QUOTED_STRING_PATTERN", "FLOAT_PATTERN", "FULLSTOP", "FULLSTOP_PATTERN", "FUNCTOR", "FUNCTOR_PATTERN", "HEX_PATTERN", "INTEGER_PATTERN", "KEYWORD", "MULTI_LINE_COMMENT_PATTERN", "NUMBER", "NUMBER_PATTERN", "OCT_PATTERN", "PAREN", "PAREN_PATTERN", "SINGLE_LINE_COMMENT_PATTERN", "SINGLE_QUOTED_STRING_PATTERN", "STRING", "STRING_PATTERN", "VARIABLE", "VARIABLE_PATTERN", "styleClass", "Lkotlin/text/MatchResult;", "getStyleClass", "(Lkotlin/text/MatchResult;)Ljava/lang/String;", "keywords", "operators", "Lit/unibo/tuprolog/core/operators/OperatorSet;", "pattern", "ide"})
    public static final class Companion {
        private Companion() {
        }

        private final Regex keywords(OperatorSet operators2) {
            String string2;
            String it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = operators2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Operator operator = (Operator)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                string2 = ((Operator)((Object)it)).getFunctor();
                collection.add(string2);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                CharSequence charSequence = it;
                Regex regex = BASIC_ATOM_PATTERN;
                boolean bl2 = false;
                string2 = regex.matches(charSequence) ? RegexExtensionsKt.wordify(it) : Regex.Companion.escape(it);
                collection.add(string2);
            }
            String string3 = CollectionsKt.joinToString$default((List)destination$iv$iv, "|", null, null, 0, null, keywords.3.INSTANCE, 30, null);
            boolean bl = false;
            return new Regex(string3);
        }

        private final Regex pattern(OperatorSet operators2) {
            Regex[] regexArray = new Regex[]{RegexExtensionsKt.asGroup(COMMENT_PATTERN, SyntaxColoring.COMMENT), RegexExtensionsKt.asGroup(this.keywords(operators2), SyntaxColoring.KEYWORD), RegexExtensionsKt.asGroup(PAREN_PATTERN, SyntaxColoring.PAREN), RegexExtensionsKt.asGroup(BRACE_PATTERN, SyntaxColoring.BRACE), RegexExtensionsKt.asGroup(BRACKET_PATTERN, SyntaxColoring.BRACKET), RegexExtensionsKt.asGroup(FUNCTOR_PATTERN, SyntaxColoring.FUNCTOR), RegexExtensionsKt.asGroup(ATOM_PATTERN, SyntaxColoring.ATOM), RegexExtensionsKt.asGroup(VARIABLE_PATTERN, SyntaxColoring.VARIABLE), RegexExtensionsKt.asGroup(NUMBER_PATTERN, SyntaxColoring.NUMBER), RegexExtensionsKt.asGroup(STRING_PATTERN, SyntaxColoring.STRING), RegexExtensionsKt.asGroup(FULLSTOP_PATTERN, SyntaxColoring.FULLSTOP)};
            return RegexExtensionsKt.anyOf(regexArray);
        }

        private final String getStyleClass(MatchResult $this$styleClass) {
            String string2;
            if (RegexExtensionsJDK8Kt.get($this$styleClass.getGroups(), SyntaxColoring.KEYWORD) != null) {
                String string3 = SyntaxColoring.KEYWORD;
                boolean bl = false;
                String string4 = string3.toLowerCase(Locale.ROOT);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            } else if (RegexExtensionsJDK8Kt.get($this$styleClass.getGroups(), SyntaxColoring.PAREN) != null) {
                String string5 = SyntaxColoring.PAREN;
                boolean bl = false;
                String string6 = string5.toLowerCase(Locale.ROOT);
                string2 = string6;
                Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            } else if (RegexExtensionsJDK8Kt.get($this$styleClass.getGroups(), SyntaxColoring.NUMBER) != null) {
                String string7 = SyntaxColoring.NUMBER;
                boolean bl = false;
                String string8 = string7.toLowerCase(Locale.ROOT);
                string2 = string8;
                Intrinsics.checkNotNullExpressionValue(string8, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            } else if (RegexExtensionsJDK8Kt.get($this$styleClass.getGroups(), SyntaxColoring.BRACE) != null) {
                String string9 = SyntaxColoring.BRACE;
                boolean bl = false;
                String string10 = string9.toLowerCase(Locale.ROOT);
                string2 = string10;
                Intrinsics.checkNotNullExpressionValue(string10, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            } else if (RegexExtensionsJDK8Kt.get($this$styleClass.getGroups(), SyntaxColoring.BRACKET) != null) {
                String string11 = SyntaxColoring.BRACKET;
                boolean bl = false;
                String string12 = string11.toLowerCase(Locale.ROOT);
                string2 = string12;
                Intrinsics.checkNotNullExpressionValue(string12, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            } else if (RegexExtensionsJDK8Kt.get($this$styleClass.getGroups(), SyntaxColoring.STRING) != null) {
                String string13 = SyntaxColoring.STRING;
                boolean bl = false;
                String string14 = string13.toLowerCase(Locale.ROOT);
                string2 = string14;
                Intrinsics.checkNotNullExpressionValue(string14, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            } else if (RegexExtensionsJDK8Kt.get($this$styleClass.getGroups(), SyntaxColoring.COMMENT) != null) {
                String string15 = SyntaxColoring.COMMENT;
                boolean bl = false;
                String string16 = string15.toLowerCase(Locale.ROOT);
                string2 = string16;
                Intrinsics.checkNotNullExpressionValue(string16, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            } else if (RegexExtensionsJDK8Kt.get($this$styleClass.getGroups(), SyntaxColoring.VARIABLE) != null) {
                String string17 = SyntaxColoring.VARIABLE;
                boolean bl = false;
                String string18 = string17.toLowerCase(Locale.ROOT);
                string2 = string18;
                Intrinsics.checkNotNullExpressionValue(string18, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            } else if (RegexExtensionsJDK8Kt.get($this$styleClass.getGroups(), SyntaxColoring.ATOM) != null) {
                String string19 = SyntaxColoring.ATOM;
                boolean bl = false;
                String string20 = string19.toLowerCase(Locale.ROOT);
                string2 = string20;
                Intrinsics.checkNotNullExpressionValue(string20, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            } else if (RegexExtensionsJDK8Kt.get($this$styleClass.getGroups(), SyntaxColoring.FUNCTOR) != null) {
                String string21 = SyntaxColoring.FUNCTOR;
                boolean bl = false;
                String string22 = string21.toLowerCase(Locale.ROOT);
                string2 = string22;
                Intrinsics.checkNotNullExpressionValue(string22, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            } else if (RegexExtensionsJDK8Kt.get($this$styleClass.getGroups(), SyntaxColoring.FULLSTOP) != null) {
                String string23 = SyntaxColoring.FULLSTOP;
                boolean bl = false;
                String string24 = string23.toLowerCase(Locale.ROOT);
                string2 = string24;
                Intrinsics.checkNotNullExpressionValue(string24, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            } else {
                string2 = "";
            }
            return string2;
        }

        public static final /* synthetic */ Regex access$pattern(Companion $this, OperatorSet operators2) {
            return $this.pattern(operators2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

