/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.ui.gui;

import it.unibo.tuprolog.solve.library.AliasedLibrary;
import it.unibo.tuprolog.ui.gui.LibraryView;
import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lit/unibo/tuprolog/ui/gui/LibraryView;", "Ljavafx/scene/control/TreeItem;", "", "library", "Lit/unibo/tuprolog/solve/library/AliasedLibrary;", "(Lit/unibo/tuprolog/solve/library/AliasedLibrary;)V", "ide"})
public final class LibraryView
extends TreeItem<String> {
    public LibraryView(@NotNull AliasedLibrary library) {
        Intrinsics.checkNotNullParameter(library, "library");
        super(library.getAlias());
        this.setExpanded(false);
        TreeItem<String> functionsChild = new TreeItem<String>("Functions");
        TreeItem<String> predicatesChild = new TreeItem<String>("Predicates");
        TreeItem<String> operatorsChild = new TreeItem<String>("Operators");
        TreeItem[] treeItemArray = new TreeItem[]{functionsChild, predicatesChild, operatorsChild};
        this.getChildren().addAll(treeItemArray);
        Sequence rules2 = SequencesKt.map(CollectionsKt.asSequence(library.getTheory().getRules()), rules.1.INSTANCE);
        Sequence primitives2 = SequencesKt.map(CollectionsKt.asSequence((Iterable)library.getPrimitives().keySet()), primitives.1.INSTANCE);
        Sequence predicates2 = SequencesKt.sorted(SequencesKt.map(SequencesKt.distinct(SequencesKt.plus(rules2, primitives2)), predicates.1.INSTANCE));
        ObservableList<TreeItem<String>> observableList = predicatesChild.getChildren();
        Intrinsics.checkNotNullExpressionValue(observableList, "predicatesChild.children");
        CollectionsKt.addAll((Collection)observableList, SequencesKt.map(predicates2, 1.INSTANCE));
        Sequence functions2 = SequencesKt.map(SequencesKt.map(CollectionsKt.asSequence((Iterable)library.getFunctions().keySet()), functions.1.INSTANCE), functions.2.INSTANCE);
        ObservableList<TreeItem<String>> observableList2 = functionsChild.getChildren();
        Intrinsics.checkNotNullExpressionValue(observableList2, "functionsChild.children");
        CollectionsKt.addAll((Collection)observableList2, SequencesKt.map(functions2, 2.INSTANCE));
        Sequence operators2 = SequencesKt.map(CollectionsKt.asSequence(library.getOperators()), operators.1.INSTANCE);
        ObservableList<TreeItem<String>> observableList3 = operatorsChild.getChildren();
        Intrinsics.checkNotNullExpressionValue(observableList3, "operatorsChild.children");
        CollectionsKt.addAll((Collection)observableList3, SequencesKt.map(operators2, 3.INSTANCE));
    }
}

