/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve.directives;

import it.unibo.tuprolog.core.Atom;
import it.unibo.tuprolog.core.Clause;
import it.unibo.tuprolog.core.Directive;
import it.unibo.tuprolog.core.Fact;
import it.unibo.tuprolog.core.Indicator;
import it.unibo.tuprolog.core.Integer;
import it.unibo.tuprolog.core.Rule;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Substitution;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.operators.Operator;
import it.unibo.tuprolog.core.operators.OperatorSet;
import it.unibo.tuprolog.core.operators.Specifier;
import it.unibo.tuprolog.solve.Extensions;
import it.unibo.tuprolog.solve.Signature;
import it.unibo.tuprolog.solve.directives.ClausePartition;
import it.unibo.tuprolog.solve.directives.DirectiveSelector;
import it.unibo.tuprolog.solve.flags.FlagStore;
import it.unibo.tuprolog.theory.MutableTheory;
import it.unibo.tuprolog.theory.Theory;
import it.unibo.tuprolog.utils.DequeKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0005H\u0016J\u0010\u00105\u001a\u0002032\u0006\u00106\u001a\u000207H\u0016J \u00108\u001a\u0002032\u0006\u00106\u001a\u0002072\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J\u0018\u0010=\u001a\u0002032\u0006\u00106\u001a\u0002072\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u0002032\u0006\u0010A\u001a\u00020BH\u0016J\u0018\u0010C\u001a\u0002032\u0006\u00106\u001a\u0002072\u0006\u0010D\u001a\u00020:H\u0016J(\u0010E\u001a\u0002032\u0006\u00106\u001a\u0002072\u0006\u0010F\u001a\u00020:2\u0006\u0010G\u001a\u00020:2\u0006\u0010H\u001a\u00020:H\u0016J\u0010\u0010I\u001a\u0002032\u0006\u0010J\u001a\u00020KH\u0016J \u0010L\u001a\u0002032\u0006\u00106\u001a\u0002072\u0006\u0010H\u001a\u00020:2\u0006\u0010M\u001a\u00020:H\u0016J\u0018\u0010N\u001a\u0002032\u0006\u00106\u001a\u0002072\u0006\u0010D\u001a\u00020:H\u0016J\u0018\u0010O\u001a\u0002032\u0006\u00106\u001a\u0002072\u0006\u0010>\u001a\u00020?H\u0016J\b\u0010P\u001a\u000203H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u0014\u0010*\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u001dR\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lit/unibo/tuprolog/solve/directives/ClausePartitioner;", "Lit/unibo/tuprolog/solve/directives/ClausePartition;", "Lit/unibo/tuprolog/solve/directives/DirectiveSelector;", "source", "", "Lit/unibo/tuprolog/core/Clause;", "staticByDefault", "", "(Ljava/lang/Iterable;Z)V", "_dynamicClauses", "Lit/unibo/tuprolog/theory/MutableTheory;", "_flagStore", "Lit/unibo/tuprolog/solve/flags/FlagStore;", "_includes", "", "Lit/unibo/tuprolog/core/Atom;", "_initialGoals", "Lit/unibo/tuprolog/core/Struct;", "_operators", "Lit/unibo/tuprolog/core/operators/Operator;", "_staticClauses", "defaultClauses", "getDefaultClauses", "()Lit/unibo/tuprolog/theory/MutableTheory;", "defaultClauses$delegate", "Lkotlin/Lazy;", "dynamicClauses", "Lit/unibo/tuprolog/theory/Theory;", "getDynamicClauses", "()Lit/unibo/tuprolog/theory/Theory;", "dynamicSignatures", "", "Lit/unibo/tuprolog/solve/Signature;", "flagStore", "getFlagStore", "()Lit/unibo/tuprolog/solve/flags/FlagStore;", "includes", "", "getIncludes", "()Ljava/util/List;", "initialGoals", "getInitialGoals", "operators", "Lit/unibo/tuprolog/core/operators/OperatorSet;", "getOperators", "()Lit/unibo/tuprolog/core/operators/OperatorSet;", "partitioned", "staticClauses", "getStaticClauses", "staticSignatures", "onClause", "", "clause", "onDirective", "directive", "Lit/unibo/tuprolog/core/Directive;", "onDirectiveMatchingPattern", "pattern", "Lit/unibo/tuprolog/core/Term;", "unifier", "Lit/unibo/tuprolog/core/Substitution$Unifier;", "onDynamic", "indicator", "Lit/unibo/tuprolog/core/Indicator;", "onFact", "fact", "Lit/unibo/tuprolog/core/Fact;", "onLoad", "goal", "onOperator", "priority", "specifier", "name", "onRule", "rule", "Lit/unibo/tuprolog/core/Rule;", "onSetFlag", "value", "onSolve", "onStatic", "performPartition", "solve"})
public final class ClausePartitioner
implements ClausePartition,
DirectiveSelector {
    @NotNull
    private final Iterable<Clause> source;
    private final boolean staticByDefault;
    @NotNull
    private final MutableTheory _staticClauses;
    @NotNull
    private final MutableTheory _dynamicClauses;
    @NotNull
    private final List<Operator> _operators;
    @NotNull
    private final List<Struct> _initialGoals;
    @NotNull
    private final List<Atom> _includes;
    @NotNull
    private FlagStore _flagStore;
    @NotNull
    private final Set<Signature> dynamicSignatures;
    @NotNull
    private final Set<Signature> staticSignatures;
    private boolean partitioned;
    @NotNull
    private final Lazy defaultClauses$delegate;

    public ClausePartitioner(@NotNull Iterable<? extends Clause> source, boolean staticByDefault) {
        Intrinsics.checkNotNullParameter(source, "source");
        this.source = source;
        this.staticByDefault = staticByDefault;
        this._staticClauses = MutableTheory.Companion.emptyIndexed();
        this._dynamicClauses = MutableTheory.Companion.emptyIndexed();
        this._operators = DequeKt.dequeOf(new Operator[0]);
        this._initialGoals = DequeKt.dequeOf(new Struct[0]);
        this._includes = DequeKt.dequeOf(new Atom[0]);
        this._flagStore = FlagStore.EMPTY;
        boolean bl = false;
        this.dynamicSignatures = new LinkedHashSet();
        bl = false;
        this.staticSignatures = new LinkedHashSet();
        this.defaultClauses$delegate = LazyKt.lazy((Function0)new Function0<MutableTheory>(this){
            final /* synthetic */ ClausePartitioner this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MutableTheory invoke() {
                return ClausePartitioner.access$getStaticByDefault$p(this.this$0) ? ClausePartitioner.access$get_staticClauses$p(this.this$0) : ClausePartitioner.access$get_dynamicClauses$p(this.this$0);
            }
        });
    }

    public /* synthetic */ ClausePartitioner(Iterable iterable, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(iterable, bl);
    }

    @Override
    @NotNull
    public Theory getStaticClauses() {
        this.performPartition();
        return this._staticClauses;
    }

    @Override
    @NotNull
    public Theory getDynamicClauses() {
        this.performPartition();
        return this._dynamicClauses;
    }

    @Override
    @NotNull
    public OperatorSet getOperators() {
        this.performPartition();
        return new OperatorSet((Iterable<Operator>)this._operators);
    }

    @Override
    @NotNull
    public List<Struct> getInitialGoals() {
        this.performPartition();
        return this._initialGoals;
    }

    @Override
    @NotNull
    public List<Atom> getIncludes() {
        this.performPartition();
        return this._includes;
    }

    @Override
    @NotNull
    public FlagStore getFlagStore() {
        this.performPartition();
        return this._flagStore;
    }

    private final void performPartition() {
        if (!this.partitioned) {
            Iterable<Clause> $this$forEach$iv = this.source;
            boolean $i$f$forEach = false;
            Iterator<Clause> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Clause element$iv;
                Clause p0 = element$iv = iterator2.next();
                boolean bl = false;
                this.listen(p0);
            }
            this.partitioned = true;
        }
    }

    private final MutableTheory getDefaultClauses() {
        Lazy lazy = this.defaultClauses$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (MutableTheory)lazy.getValue();
    }

    @Override
    public void onSetFlag(@NotNull Directive directive, @NotNull Term name, @NotNull Term value) {
        Intrinsics.checkNotNullParameter(directive, "directive");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        this.onDirective(directive);
        if (name instanceof Atom) {
            ClausePartitioner clausePartitioner = this;
            clausePartitioner._flagStore = clausePartitioner._flagStore.plus(TuplesKt.to(((Atom)name).getValue(), value));
        }
    }

    @Override
    public void onOperator(@NotNull Directive directive, @NotNull Term priority, @NotNull Term specifier, @NotNull Term name) {
        Intrinsics.checkNotNullParameter(directive, "directive");
        Intrinsics.checkNotNullParameter(priority, "priority");
        Intrinsics.checkNotNullParameter(specifier, "specifier");
        Intrinsics.checkNotNullParameter(name, "name");
        this.onDirective(directive);
        if (priority instanceof Integer) {
            try {
                Specifier spec = Specifier.Companion.fromTerm(specifier);
                if (name instanceof Atom) {
                    ClausePartitioner clausePartitioner = this;
                    Collection collection = clausePartitioner._operators;
                    Operator operator = new Operator(((Atom)name).getValue(), spec, ((Integer)priority).getValue().toInt());
                    boolean bl = false;
                    collection.add(operator);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onLoad(@NotNull Directive directive, @NotNull Term goal) {
        Intrinsics.checkNotNullParameter(directive, "directive");
        Intrinsics.checkNotNullParameter(goal, "goal");
        this.onDirective(directive);
        if (goal instanceof Atom) {
            ClausePartitioner clausePartitioner = this;
            Collection collection = clausePartitioner._includes;
            Term term = goal;
            boolean bl = false;
            collection.add(term);
        }
    }

    @Override
    public void onSolve(@NotNull Directive directive, @NotNull Term goal) {
        Intrinsics.checkNotNullParameter(directive, "directive");
        Intrinsics.checkNotNullParameter(goal, "goal");
        this.onDirective(directive);
        if (goal instanceof Struct) {
            ClausePartitioner clausePartitioner = this;
            Collection collection = clausePartitioner._initialGoals;
            Term term = goal;
            boolean bl = false;
            collection.add(term);
        }
    }

    @Override
    public void onStatic(@NotNull Directive directive, @NotNull Indicator indicator) {
        Intrinsics.checkNotNullParameter(directive, "directive");
        Intrinsics.checkNotNullParameter(indicator, "indicator");
        this.onDirective(directive);
        if (indicator.isWellFormed()) {
            ClausePartitioner clausePartitioner = this;
            Collection collection = clausePartitioner.staticSignatures;
            Signature signature2 = Signature.Companion.fromIndicator(indicator);
            Intrinsics.checkNotNull(signature2);
            Signature signature3 = signature2;
            boolean bl = false;
            collection.add(signature3);
        }
    }

    @Override
    public void onDynamic(@NotNull Directive directive, @NotNull Indicator indicator) {
        Intrinsics.checkNotNullParameter(directive, "directive");
        Intrinsics.checkNotNullParameter(indicator, "indicator");
        this.onDirective(directive);
        if (indicator.isWellFormed()) {
            ClausePartitioner clausePartitioner = this;
            Collection collection = clausePartitioner.dynamicSignatures;
            Signature signature2 = Signature.Companion.fromIndicator(indicator);
            Intrinsics.checkNotNull(signature2);
            Signature signature3 = signature2;
            boolean bl = false;
            collection.add(signature3);
        }
    }

    @Override
    public void onDirectiveMatchingPattern(@NotNull Directive directive, @NotNull Term pattern, @NotNull Substitution.Unifier unifier) {
        Intrinsics.checkNotNullParameter(directive, "directive");
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        Intrinsics.checkNotNullParameter(unifier, "unifier");
        this.onDirective(directive);
    }

    @Override
    public void onDirective(@NotNull Directive directive) {
        Intrinsics.checkNotNullParameter(directive, "directive");
        this.onClause(directive);
    }

    @Override
    public void onRule(@NotNull Rule rule) {
        Intrinsics.checkNotNullParameter(rule, "rule");
        Signature signature2 = Extensions.extractSignature(rule.getHead());
        if (this.dynamicSignatures.contains(signature2)) {
            this._dynamicClauses.assertZ(rule);
        } else if (this.staticSignatures.contains(signature2)) {
            this._staticClauses.assertZ(rule);
        } else {
            this.getDefaultClauses().assertZ(rule);
        }
    }

    @Override
    public void onFact(@NotNull Fact fact) {
        Intrinsics.checkNotNullParameter(fact, "fact");
        this.onRule(fact);
    }

    @Override
    public void onClause(@NotNull Clause clause) {
        Intrinsics.checkNotNullParameter(clause, "clause");
        this.getDefaultClauses().assertZ(clause);
    }

    @Override
    public void listenDirective(@NotNull Directive directive) {
        DirectiveSelector.DefaultImpls.listenDirective(this, directive);
    }

    @Override
    @NotNull
    public ClausePartition plus(@NotNull ClausePartition other) {
        return ClausePartition.DefaultImpls.plus(this, other);
    }

    @Override
    public void listen(@NotNull Clause clause) {
        DirectiveSelector.DefaultImpls.listen(this, clause);
    }

    @Override
    public void listenDirectiveMatchingPattern(@NotNull Directive directive, @NotNull Term pattern, @NotNull Substitution.Unifier unifier) {
        DirectiveSelector.DefaultImpls.listenDirectiveMatchingPattern(this, directive, pattern, unifier);
    }

    @Override
    @NotNull
    public List<Term> getPatterns() {
        return DirectiveSelector.DefaultImpls.getPatterns(this);
    }

    public static final /* synthetic */ boolean access$getStaticByDefault$p(ClausePartitioner $this) {
        return $this.staticByDefault;
    }

    public static final /* synthetic */ MutableTheory access$get_staticClauses$p(ClausePartitioner $this) {
        return $this._staticClauses;
    }

    public static final /* synthetic */ MutableTheory access$get_dynamicClauses$p(ClausePartitioner $this) {
        return $this._dynamicClauses;
    }
}

