/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve;

import it.unibo.tuprolog.core.Atom;
import it.unibo.tuprolog.core.Indicator;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.TermConvertible;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u001cH\u0007J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0017\u0010 \u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0087\u0004R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\n\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lit/unibo/tuprolog/solve/Signature;", "Lit/unibo/tuprolog/core/TermConvertible;", "name", "", "arity", "", "vararg", "", "(Ljava/lang/String;IZ)V", "getArity$annotations", "()V", "getArity", "()I", "getName$annotations", "getName", "()Ljava/lang/String;", "getVararg$annotations", "getVararg", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toIndicator", "Lit/unibo/tuprolog/core/Indicator;", "toString", "toTerm", "Lit/unibo/tuprolog/core/Struct;", "withArgs", "arguments", "", "Lit/unibo/tuprolog/core/Term;", "Companion", "solve"})
public final class Signature
implements TermConvertible {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final int arity;
    private final boolean vararg;
    @NotNull
    private static final Atom varargAtom = Atom.Companion.of("vararg");
    @NotNull
    private static final String varargStructFunctor = "+";
    @NotNull
    public static final String FUNCTOR = "/";

    public Signature(@NotNull String name, int arity, boolean vararg) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.name = name;
        this.arity = arity;
        this.vararg = vararg;
        boolean bl = this.arity >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = Intrinsics.stringPlus("Signature arity should be greater than or equals to 0: ", this.getArity());
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
    }

    public /* synthetic */ Signature(String string2, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(string2, n, bl);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public static /* synthetic */ void getName$annotations() {
    }

    public final int getArity() {
        return this.arity;
    }

    public static /* synthetic */ void getArity$annotations() {
    }

    public final boolean getVararg() {
        return this.vararg;
    }

    public static /* synthetic */ void getVararg$annotations() {
    }

    @Override
    @NotNull
    public Struct toTerm() {
        Struct struct;
        if (this.vararg) {
            Term[] termArray = new Term[2];
            termArray[0] = Atom.Companion.of(this.name);
            Term[] termArray2 = new Term[]{it.unibo.tuprolog.core.Integer.Companion.of(this.arity), varargAtom};
            termArray[1] = Struct.Companion.of(varargStructFunctor, termArray2);
            struct = Struct.Companion.of(FUNCTOR, termArray);
        } else {
            Term[] termArray = new Term[]{Atom.Companion.of(this.name), it.unibo.tuprolog.core.Integer.Companion.of(this.arity)};
            struct = Struct.Companion.of(FUNCTOR, termArray);
        }
        return struct;
    }

    @NotNull
    public final Indicator toIndicator() {
        if (this.vararg) {
            String string2 = "Implement conversion to indicator in case of vararg signature";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
        }
        return Indicator.Companion.of(this.name, this.arity);
    }

    @NotNull
    public final Struct withArgs(@NotNull Iterable<? extends Term> arguments2) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        if (this.vararg) {
            bl3 = CollectionsKt.count(arguments2) >= this.arity;
            bl2 = false;
            bl = false;
            if (!bl3) {
                boolean bl4 = false;
                String string2 = "Trying to create Struct of signature `" + this + "` with not enough arguments " + CollectionsKt.toList(arguments2);
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
        } else {
            bl3 = CollectionsKt.count(arguments2) == this.arity;
            bl2 = false;
            bl = false;
            if (!bl3) {
                boolean bl5 = false;
                String string3 = "Trying to create Struct of signature `" + this + "` with wrong number of arguments " + CollectionsKt.toList(arguments2);
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
        }
        Unit unit = Unit.INSTANCE;
        bl2 = false;
        bl = false;
        Unit it = unit;
        boolean bl6 = false;
        return Struct.Companion.of(this.getName(), CollectionsKt.asSequence(arguments2));
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    public final int component2() {
        return this.arity;
    }

    public final boolean component3() {
        return this.vararg;
    }

    @NotNull
    public final Signature copy(@NotNull String name, int arity, boolean vararg) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new Signature(name, arity, vararg);
    }

    public static /* synthetic */ Signature copy$default(Signature signature2, String string2, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = signature2.name;
        }
        if ((n2 & 2) != 0) {
            n = signature2.arity;
        }
        if ((n2 & 4) != 0) {
            bl = signature2.vararg;
        }
        return signature2.copy(string2, n, bl);
    }

    @NotNull
    public String toString() {
        return "Signature(name=" + this.name + ", arity=" + this.arity + ", vararg=" + this.vararg + ')';
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.arity);
        int n = this.vararg ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Signature)) {
            return false;
        }
        Signature signature2 = (Signature)other;
        if (!Intrinsics.areEqual(this.name, signature2.name)) {
            return false;
        }
        if (this.arity != signature2.arity) {
            return false;
        }
        return this.vararg == signature2.vararg;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lit/unibo/tuprolog/solve/Signature$Companion;", "", "()V", "FUNCTOR", "", "varargAtom", "Lit/unibo/tuprolog/core/Atom;", "varargStructFunctor", "fromIndicator", "Lit/unibo/tuprolog/solve/Signature;", "indicator", "Lit/unibo/tuprolog/core/Indicator;", "fromSignatureTerm", "term", "Lit/unibo/tuprolog/core/Struct;", "Lit/unibo/tuprolog/core/Term;", "solve"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Signature fromSignatureTerm(@NotNull Struct term) {
            Signature signature2;
            Intrinsics.checkNotNullParameter(term, "term");
            try {
                Signature signature3;
                boolean bl = false;
                boolean bl2 = false;
                Struct $this$fromSignatureTerm_u24lambda_u2d1 = term;
                boolean bl3 = false;
                if (Intrinsics.areEqual($this$fromSignatureTerm_u24lambda_u2d1.getFunctor(), Signature.FUNCTOR) && $this$fromSignatureTerm_u24lambda_u2d1.getArity() == 2 && CollectionsKt.first($this$fromSignatureTerm_u24lambda_u2d1.getArgs()).isAtom()) {
                    if (CollectionsKt.last($this$fromSignatureTerm_u24lambda_u2d1.getArgs()).isInteger()) {
                        signature3 = new Signature(CollectionsKt.first($this$fromSignatureTerm_u24lambda_u2d1.getArgs()).castToAtom().getValue(), CollectionsKt.last($this$fromSignatureTerm_u24lambda_u2d1.getArgs()).castToInteger().getIntValue().toInt(), false, 4, null);
                    } else {
                        Term term2 = CollectionsKt.last($this$fromSignatureTerm_u24lambda_u2d1.getArgs());
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Term it = term2;
                        boolean bl6 = false;
                        signature3 = it instanceof Struct && Intrinsics.areEqual(((Struct)it).getFunctor(), Signature.varargStructFunctor) && ((Struct)it).getArity() == 2 && CollectionsKt.first(((Struct)it).getArgs()).isInteger() && Intrinsics.areEqual(CollectionsKt.last(((Struct)it).getArgs()), varargAtom) ? new Signature(CollectionsKt.first($this$fromSignatureTerm_u24lambda_u2d1.getArgs()).castToAtom().getValue(), CollectionsKt.last($this$fromSignatureTerm_u24lambda_u2d1.getArgs()).castToStruct().get(0).castToInteger().getIntValue().toInt(), true) : null;
                    }
                } else {
                    signature3 = null;
                }
                signature2 = signature3;
            }
            catch (IllegalArgumentException ex) {
                signature2 = null;
            }
            return signature2;
        }

        @Nullable
        public final Signature fromSignatureTerm(@NotNull Term term) {
            Intrinsics.checkNotNullParameter(term, "term");
            Term term2 = term;
            return term2 instanceof Struct ? this.fromSignatureTerm((Struct)term) : null;
        }

        @Nullable
        public final Signature fromIndicator(@NotNull Indicator indicator) {
            Signature signature2;
            Intrinsics.checkNotNullParameter(indicator, "indicator");
            if (indicator.isWellFormed()) {
                String string2 = indicator.getIndicatedName();
                Intrinsics.checkNotNull(string2);
                Integer n = indicator.getIndicatedArity();
                Intrinsics.checkNotNull(n);
                signature2 = new Signature(string2, n, false, 4, null);
            } else {
                signature2 = null;
            }
            return signature2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

