/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve;

import it.unibo.tuprolog.bdd.BinaryDecisionDiagram;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.solve.Solution;
import it.unibo.tuprolog.solve.SolveOptions;
import it.unibo.tuprolog.utils.Taggable;
import it.unibo.tuprolog.utils.TaggableExtensions;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u001a\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0002\u001a\f\u0010\u001b\u001a\u00020\u0012*\u00020\u0012H\u0007\u001a\u001c\u0010\u001c\u001a\u00020\u000b*\u00020\u000b2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u0007\u001a\u0014\u0010\u001e\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0003H\u0007\u001a3\u0010\u001f\u001a\u0002H\u0017\"\u000e\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150\u0016\"\b\b\u0001\u0010\u0017*\u0002H\u0015*\u0002H\u00172\u0006\u0010\u001d\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010 \"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001f\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u0003*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0015\u0010\u0011\u001a\u00020\u0003*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013\"/\u0010\u0014\u001a\u00020\u0005\"\u000e\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150\u0016\"\b\b\u0001\u0010\u0017*\u0002H\u0015*\u0002H\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006!"}, d2={"BINARY_DECISION_DIAGRAM_TAG", "", "DEFAULT_PROBABILISTIC_OPTION", "", "DEFAULT_PROBABILITY", "", "PROBABILISTIC_OPTION_TAG", "PROBABILITY_TAG", "binaryDecisionDiagram", "Lit/unibo/tuprolog/bdd/BinaryDecisionDiagram;", "Lit/unibo/tuprolog/core/Term;", "Lit/unibo/tuprolog/solve/Solution;", "getBinaryDecisionDiagram", "(Lit/unibo/tuprolog/solve/Solution;)Lit/unibo/tuprolog/bdd/BinaryDecisionDiagram;", "hasBinaryDecisionDiagram", "getHasBinaryDecisionDiagram", "(Lit/unibo/tuprolog/solve/Solution;)Z", "isProbabilistic", "Lit/unibo/tuprolog/solve/SolveOptions;", "(Lit/unibo/tuprolog/solve/SolveOptions;)Z", "probability", "T", "Lit/unibo/tuprolog/utils/Taggable;", "U", "getProbability", "(Lit/unibo/tuprolog/utils/Taggable;)D", "normalizeProbability", "probabilistic", "setBinaryDecisionDiagram", "value", "setProbabilistic", "setProbability", "(Lit/unibo/tuprolog/utils/Taggable;D)Lit/unibo/tuprolog/utils/Taggable;", "solve-plp"})
@JvmName(name="ProbExtensions")
public final class ProbExtensions {
    @NotNull
    private static final String PROBABILITY_TAG = "it.unibo.tuprolog.solve.probability";
    @NotNull
    private static final String BINARY_DECISION_DIAGRAM_TAG = "it.unibo.tuprolog.solve.bdd";
    @NotNull
    private static final String PROBABILISTIC_OPTION_TAG = "it.unibo.tuprolog.solve.options.probabilistic";
    public static final double DEFAULT_PROBABILITY = 1.0;
    public static final boolean DEFAULT_PROBABILISTIC_OPTION = false;

    private static final double normalizeProbability(double probability2) {
        double d = 1.0;
        boolean bl = false;
        d = Math.min(d, probability2);
        double d2 = 0.0;
        boolean bl2 = false;
        return Math.max(d, d2);
    }

    public static final <T extends Taggable<T>, U extends T> double getProbability(@NotNull U $this$probability) {
        Intrinsics.checkNotNullParameter($this$probability, "<this>");
        Double d = (Double)$this$probability.getTag(PROBABILITY_TAG);
        return d == null ? 1.0 : d;
    }

    @NotNull
    public static final <T extends Taggable<T>, U extends T> U setProbability(@NotNull U $this$setProbability, double value) {
        Intrinsics.checkNotNullParameter($this$setProbability, "<this>");
        return TaggableExtensions.setTag($this$setProbability, PROBABILITY_TAG, ProbExtensions.normalizeProbability(value));
    }

    public static final boolean isProbabilistic(@NotNull SolveOptions $this$isProbabilistic) {
        Intrinsics.checkNotNullParameter($this$isProbabilistic, "<this>");
        Boolean bl = (Boolean)$this$isProbabilistic.getCustomOptions().get(PROBABILISTIC_OPTION_TAG);
        return bl == null ? false : bl;
    }

    @NotNull
    public static final SolveOptions setProbabilistic(@NotNull SolveOptions $this$setProbabilistic, boolean value) {
        Intrinsics.checkNotNullParameter($this$setProbabilistic, "<this>");
        return $this$setProbabilistic.setOption(PROBABILISTIC_OPTION_TAG, value);
    }

    @NotNull
    public static final SolveOptions probabilistic(@NotNull SolveOptions $this$probabilistic) {
        Intrinsics.checkNotNullParameter($this$probabilistic, "<this>");
        return ProbExtensions.setProbabilistic($this$probabilistic, true);
    }

    public static final boolean getHasBinaryDecisionDiagram(@NotNull Solution $this$hasBinaryDecisionDiagram) {
        Intrinsics.checkNotNullParameter($this$hasBinaryDecisionDiagram, "<this>");
        return $this$hasBinaryDecisionDiagram.containsTag(BINARY_DECISION_DIAGRAM_TAG);
    }

    @Nullable
    public static final BinaryDecisionDiagram<? extends Term> getBinaryDecisionDiagram(@NotNull Solution $this$binaryDecisionDiagram) {
        Intrinsics.checkNotNullParameter($this$binaryDecisionDiagram, "<this>");
        return (BinaryDecisionDiagram)$this$binaryDecisionDiagram.getTag(BINARY_DECISION_DIAGRAM_TAG);
    }

    @NotNull
    public static final Solution setBinaryDecisionDiagram(@NotNull Solution $this$setBinaryDecisionDiagram, @NotNull BinaryDecisionDiagram<? extends Term> value) {
        Intrinsics.checkNotNullParameter($this$setBinaryDecisionDiagram, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        return (Solution)TaggableExtensions.setTag((Taggable)$this$setBinaryDecisionDiagram, BINARY_DECISION_DIAGRAM_TAG, value);
    }
}

